/*
 * Copyright (c) 2008 TAKAHASHI Tomoyuki. All rights reserved.
 */
package jp.sourceforge.sowba.dtd2java.dtd;

import java.util.LinkedHashMap;
import java.util.Map;

/**
 * Java\[XR[h̃ReLXgIuWFNgłB<br/>
 *
 * @author TAKAHASHI Tomoyuki
 *
 * <table border="1" cellpadding="3" cellspacing="0">
 * <tr bgcolor="#ccccff"><th>Ver.</th><th>t</th><th>ڍ</th></tr>
 * <tr><td>0.01</td><td>2008/01/05</td><td>VK쐬</td>
 * </table>
 */
public class ContextObject {

    private Map<String, ElementObject> m_elemmap = new LinkedHashMap<String, ElementObject>();

    /**
     * DTDŎIuWFNg𐶐t@NgNX(pbP[Wm_packageName)
     */
    private String m_factoryName;

    /**
     * vfƂ̃L[ƂȂtB[h̃}bvB<br>
     * KEY   : vf<br>
     * VALUE : <br>
     */
    private Map<String, String> m_keymap = new LinkedHashMap<String, String>();

    /**
     * DTDŜɑ΂pbP[W
     */
    private String m_packageName;

    public void addElement(String name, ElementObject elem) {
        m_elemmap.put(name, elem);
    }

    public void addKey(String elementName, String keyAttributeName) {
        m_keymap.put(elementName, keyAttributeName);
    }

    public ElementObject createElementObject(String name) {
        ElementObject elem = new ElementObject(name);
        String key = getKeyAttributeName(name);
        if (key != null) {
            elem.setKeyAttributeName(key);
        }
        return elem;
    }

    public ElementObject getElement(String name) {
        Object o = m_elemmap.get(name);
        if (o instanceof ElementObject) {
            return (ElementObject)o;
        } else {
            ElementObject newobj = createElementObject(name);
            addElement(name, newobj);
            return newobj;
        }
    }

    public ElementObject[] getElements() {
        ElementObject[] elements = new ElementObject[m_elemmap.size()];
        m_elemmap.values().toArray(elements);
        return elements;
    }

    public String getFactoryName() {
        return m_factoryName;
    }

    public String getKeyAttributeName(String elementName) {
        return (String)m_keymap.get(elementName);
    }

    public String getPackageName() {
        return m_packageName;
    }

    public boolean isKeyAttribute(String elementName, String attributeName) {
        Object o = m_keymap.get(elementName);
        if (o == null) {
            return false;
        }
        return ((String)o).equalsIgnoreCase(attributeName);
    }

    public void setFactoryName(String factoryName) {
        m_factoryName = factoryName;
    }

    public void setPackageName(String packageName) {
        m_packageName = packageName;
    }

}
