(* Id: $Id: scmUtil.ml,v 1.2 2004/02/07 20:57:23 fridolin Exp $ *)

let id x = x

(* create_hashtbl builds a hashtable from a (key,value) list. 
*)

let create_hashtbl l =
  (* a half filled hash table needs on average two guesses to find a value to a key *)
  let ht = Hashtbl.create (2*(List.length l)) in 
    List.iter (fun (k,v) -> Hashtbl.add ht k v) l;
    ht

(* gcd returns the greatest common divisor of two numbers *)
let gcd a b =
  let rec iter a b =
    let r = a mod b in
      if r = 0 then b
      else iter b r in
  let a = abs a and b = abs b in
    if a = 0 then b
    else if a = 0 then b
    else 
      if a > b then iter a b
      else iter b a

(* lcm returns the least common multiple *)
let lcm a b = (abs (a * b)) / (gcd a b)

(* find_rational takes f as input and returns (a,b) : int*int with a/b = f *)

let find_rational f =
  let rec iter numerator denominator =
    let inumerator = int_of_float numerator in
    if float_of_int inumerator = numerator then
      (inumerator,denominator)
    else
      iter (numerator *. 2.0) (denominator lsl 1)
  in let n, d = iter f 1 in
  let gcd = gcd n d in
    (n/gcd),(d/gcd)

let numerator f = fst (find_rational f)
let denominator f = snd (find_rational f)
  

  

