/**************************************************************************/
/*  Mana : A kana(romaji)-kanji conversion engine using ChaSen algorithm.    */
/*  Copyright (C) 2003, 2004, 2005  Yamagata Yoriyuki                     */
/*                                                                        */
/*  This program is free software; you can redistribute it and/or modify  */
/*  it under the terms of the GNU General Public License as published by  */
/*  the Free Software Foundation; either version 2 of the License, or (at  */
/*  your option) any later version.                                       */
/*                                                                        */
/*  This program is distributed in the hope that it will be useful, but   */
/*  WITHOUT ANY WARRANTY; without even the implied warranty of            */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     */
/*  General Public License for more details.                              */
/**************************************************************************/

/* Copyright 2004, Yamagata Yoriyuki */

#include <string.h>
#include <caml/mlvalues.h>
#include <caml/memory.h>
#include <caml/alloc.h>
#include "chadic.h"

value kform_gobi(value v){
  CAMLparam1(v);
  CAMLlocal1(string);
  kform_t *kform;

  kform = (kform_t*)v;
  string = alloc_string(kform->gobi_len);
  memcpy(String_val(string), kform->gobi, kform->gobi_len);
  CAMLreturn(string);
}

value kform_gobi_len(value kform){
 CAMLparam1(kform);
 CAMLreturn(Val_long(((kform_t*)kform)->gobi_len));
}

value kform_ygobi(value v){
  CAMLparam1(v);
  kform_t *kform;

  kform = (kform_t*)v;
  CAMLreturn(copy_string(kform->ygobi));
}

value kform_pgobi(value v){
  CAMLparam1(v);
  kform_t *kform;

  kform = (kform_t*)v;
  CAMLreturn(copy_string(kform->pgobi));
}

value get_kform(value inf_type, value basic){
  CAMLparam2(inf_type, basic);
  CAMLreturn((value)&Cha_form[Long_val(inf_type)][Long_val(basic)]);
}
