/* vim: set encoding=utf8:
 *
 * shiki.h
 *
 * This file is part of Shiki.
 *
 * Copyright(C)2006 WAKATSUKI toshihiro
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 * $Id: shiki.h,v 1.8 2006/11/27 12:01:50 aloha Exp $
 */

#ifndef SHIKI_H
#define SHIKI_H

#include<gauche.h>
#include<gtk/gtk.h>
#include<gdk/gdkkeysyms.h>

/* タブごとの情報を管理する構造体 */
typedef struct {
  const gchar       *locale;           /* バッファ内容のロケール */
  GtkScrolledWindow *tabpage;          /* タブ */
  gchar             *tabpage_label;    /* タブのタイトル */
  gchar             *name;             /* ベース (ファイル名) のみ */
  GtkTextView       *text_view;        /* タブの表示 */
  GtkTextBuffer     *text_buffer;      /* タブのテキストバッファ */
  gchar             *filename;         /* ファイル名のフルパス */
  GList             *undoInfoList;     /* タブごとのバッファ変更履歴 */
  ScmObj            env;               /* タブごとに独立した Scheme 環境 */
  guint             delete_handler_id; /* トップレベルに登録したハンドラ ID */
} ShikiBuffer;

typedef struct {
  const gchar   *default_locale;
  GtkWidget     *editor_window;
  GtkClipboard  *clipboard;
  GtkNotebook   *notebook;
  GtkWidget     *statusbar;
  GtkWidget     *modeline_label;
  GList         *bufferList;
  gint          current_tabpage_num;
  ShikiBuffer  *current_tabpage_info;
} ShikiEditorType;

extern ShikiEditorType Shiki_editor;

/* シングルトンオブジェクトの定義 */
#define Shiki_EDITOR_DEFAULT_LOCALE  Shiki_editor.default_locale
#define Shiki_EDITOR_WINDOW          Shiki_editor.editor_window
#define Shiki_EDITOR_CLIPBOARD       Shiki_editor.clipboard
#define Shiki_EDITOR_NOTEBOOK        Shiki_editor.notebook
#define Shiki_EDITOR_STATUSBAR       Shiki_editor.statusbar
#define Shiki_EDITOR_MODELINE_LABEL  Shiki_editor.modeline_label
#define Shiki_EDITOR_BUFFER_LIST     Shiki_editor.bufferList

/* 現在表示されているタブに対するアクセス用各種キャッシュ情報 */
#define Shiki_CURRENT_TAB_NUM        Shiki_editor.current_tabpage_num
#define Shiki_CURRENT_TAB_INFO       Shiki_editor.current_tabpage_info
#define Shiki_CURRENT_CES         (Shiki_editor.current_tabpage_info)->locale
#define Shiki_CURRENT_UNDO_INFO_LIST (Shiki_editor.current_tabpage_info)->undoInfoList
#define Shiki_CURRENT_TAB            (Shiki_editor.current_tabpage_info)->tabpage
#define Shiki_CURRENT_TAB_TITLE      (Shiki_editor.current_tabpage_info)->tabpage_label
#define Shiki_CURRENT_TEXT_VIEW      (Shiki_editor.current_tabpage_info)->text_view
#define Shiki_CURRENT_TEXT_BUFFER    (Shiki_editor.current_tabpage_info)->text_buffer
#define Shiki_CURRENT_BASENAME      (Shiki_editor.current_tabpage_info)->name
#define Shiki_CURRENT_FILENAME       (Shiki_editor.current_tabpage_info)->filename
#define Shiki_CURRENT_BUFFER_ENV     (Shiki_editor.current_tabpage_info)->env

/* Undo/Redo のための情報 */
typedef enum {SHIKI_UNDO_INSERT, SHIKI_UNDO_DELETE} ShikiAction;

typedef struct {
  ShikiAction action;
  gchar       *str;
  gint        strlen;
  gint        start;
  gint        end;
} ShikiUndoInfo;

extern ScmClass *ShikiBufferClass;

#define SHIKI_BUFFER_P(obj)      SCM_XTYPEP(obj, ShikiBufferClass)
#define SHIKI_BUFFER_UNBOX(obj)  SCM_FOREIGN_POINTER_REF(GtkTextBuffer*, obj)
#define SHIKI_BUFFER_BOX(ptr)    Scm_MakeForeignPointer(ShikiBufferClass, ptr)

/* C API */
GtkTextBuffer *Shiki_new_buffer_create(gchar *filename);
gchar *Shiki_buffer_substring(gint start, gint end);
void Shiki_delete_region(gint start, gint end);
gint Shiki_point();
gint Shiki_point_max();
gint Shiki_point_min();
void Shiki_goto_char(gint offset);
void Shiki_forward_char();
void Shiki_backward_char();
void Shiki_goto_line(gint line);
void Shiki_goto_bol();
void Shiki_goto_eol();
void Shiki_forward_line(gint count);
const gchar *Shiki_buffer_name(GtkTextBuffer *buffer);
GtkTextBuffer *Shiki_get_next_buffer(GtkTextBuffer *buffer);
GtkTextBuffer *Shiki_get_previous_buffer(GtkTextBuffer *buffer);
ScmObj Shiki_buffer_list();
gboolean Shiki_deleted_buffer_p(GtkTextBuffer *buffer);
void Shiki_erase_buffer(GtkTextBuffer *buffer);
void Shiki_delete_buffer(GtkTextBuffer *buffer);
GtkTextBuffer *Shiki_find_buffer(const gchar *name);
const gchar *Shiki_file_name_dialog(const gchar *msg);
gboolean Shiki_yes_or_no_p(const gchar *msg);


#endif
