/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.java.ui;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.mylyn.context.core.IInteractionContext;
import org.eclipse.mylyn.internal.java.ui.AbstractJavaContextComputationStrategy;
import org.eclipse.mylyn.internal.java.ui.JavaUiBridgePlugin;
import org.eclipse.mylyn.internal.java.ui.Messages;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaStackTraceContextComputationStrategy
extends AbstractJavaContextComputationStrategy {
    private static final String PACKAGE_PART = "([a-z][a-z0-9]*)";
    private static final String CLASS_PART = "[A-Za-z][a-zA-Z0-9_$]*";
    private static final String FQN_PART = "((([a-z][a-z0-9]*)\\.)*[A-Za-z][a-zA-Z0-9_$]*)";
    private static final Pattern STACK_TRACE_PATTERN = Pattern.compile("\\s*((((Caused by:\\s+)|(at\\s+))?((([a-z][a-z0-9]*)\\.)*[A-Za-z][a-zA-Z0-9_$]*)((:\\s+\\w.*)|(\\.((\\<(?:cl)?init\\>)|([a-zA-Z0-9_$]+))\\(.*?\\)))?)|(\\.\\.\\.\\s\\d+\\smore))");
    private final SortedSet<String> filteredPrefixes = new TreeSet<String>(Arrays.asList("java", "javax", "junit.framework", "sun.reflect"));
    private final int maxElements = 10;

    public List<Object> computeContext(IInteractionContext context, IAdaptable input, IProgressMonitor monitor) {
        String text = this.getText(input);
        if (text != null) {
            return this.computeContext(text, monitor);
        }
        return Collections.emptyList();
    }

    private String getText(IAdaptable input) {
        ITask task;
        String description;
        String text = (String)input.getAdapter(String.class);
        if (text != null) {
            return text;
        }
        TaskData taskData = (TaskData)input.getAdapter(TaskData.class);
        if (taskData != null) {
            TaskAttribute attribute = taskData.getRoot().getMappedAttribute("task.common.description");
            if (attribute != null && (description = attribute.getValue()) != null && description.length() > 0) {
                return description;
            }
            attribute = taskData.getRoot().getMappedAttribute("task.common.comment.new");
            if (attribute != null && (description = attribute.getValue()) != null && description.length() > 0) {
                return description;
            }
        }
        if ((task = (ITask)input.getAdapter(ITask.class)) instanceof AbstractTask && (description = ((AbstractTask)task).getNotes()) != null && description.length() > 0) {
            return description;
        }
        return null;
    }

    public List<Object> computeContext(String description, IProgressMonitor monitor) {
        block14: {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor);
            try {
                List<Element> elements = this.computeElements(description);
                if (elements.isEmpty()) break block14;
                progress.beginTask(Messages.JavaStackTraceContextComputationStrategy_Finding_Java_Context_Element_Progress_Label, elements.size());
                ArrayList<Object> javaElements = new ArrayList<Object>();
                try {
                    for (Element element : elements) {
                        if (progress.isCanceled()) {
                            break;
                        }
                        SortedSet<String> prefix = this.filteredPrefixes.headSet(element.fqn);
                        if (prefix.isEmpty() || !element.fqn.startsWith(prefix.last())) {
                            try {
                                IType type = this.findTypeInWorkspace(element.fqn);
                                if (type != null) {
                                    javaElements.add(type);
                                    if (element.methodName != null) {
                                        IMethod[] methods;
                                        IMethod[] iMethodArray = methods = type.getMethods();
                                        int n = methods.length;
                                        int n2 = 0;
                                        while (n2 < n) {
                                            IMethod method = iMethodArray[n2];
                                            if (method.getElementName().equals(element.methodName)) {
                                                javaElements.add(method);
                                            }
                                            ++n2;
                                        }
                                    }
                                }
                            }
                            catch (CoreException e) {
                                JavaUiBridgePlugin.getDefault().getLog().log(e.getStatus());
                            }
                        }
                        progress.worked(1);
                    }
                }
                finally {
                    progress.done();
                }
                return javaElements;
            }
            catch (IOException iOException) {}
        }
        return Collections.emptyList();
    }

    public List<Element> computeElements(String description) throws IOException {
        ArrayList<Element> elements = new ArrayList<Element>();
        BufferedReader reader = new BufferedReader(new StringReader(description));
        String line = reader.readLine();
        while (line != null && elements.size() < 10) {
            String fqn;
            Matcher matcher = STACK_TRACE_PATTERN.matcher(line);
            if (matcher.matches() && (fqn = matcher.group(6)) != null) {
                Element element = new Element(fqn, matcher.group(12));
                elements.add(element);
            }
            line = reader.readLine();
        }
        return elements;
    }

    public static class Element {
        String fqn;
        String methodName;

        public Element(String fqn, String methodName) {
            Assert.isNotNull((Object)fqn);
            this.fqn = fqn;
            this.methodName = methodName;
        }

        public Element() {
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Element [fqn=");
            builder.append(this.fqn);
            builder.append(", methodName=");
            builder.append(this.methodName);
            builder.append("]");
            return builder.toString();
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.fqn == null ? 0 : this.fqn.hashCode());
            result = 31 * result + (this.methodName == null ? 0 : this.methodName.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Element other = (Element)obj;
            if (this.fqn == null ? other.fqn != null : !this.fqn.equals(other.fqn)) {
                return false;
            }
            return !(this.methodName == null ? other.methodName != null : !this.methodName.equals(other.methodName));
        }
    }
}

