/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.internal.resource.java.source;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jpt.common.core.internal.utility.jdt.ASTTools;
import org.eclipse.jpt.common.core.internal.utility.jdt.AnnotatedElementAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.ElementAnnotationAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.SimpleTypeStringExpressionConverter;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.Attribute;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.ExpressionConverter;
import org.eclipse.jpt.jaxb.core.internal.resource.java.source.SourceAnnotation;
import org.eclipse.jpt.jaxb.core.resource.java.JavaResourceMember;
import org.eclipse.jpt.jaxb.core.resource.java.XmlAnyElementAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SourceXmlAnyElementAnnotation
extends SourceAnnotation<Attribute>
implements XmlAnyElementAnnotation {
    public static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("javax.xml.bind.annotation.XmlAnyElement");
    private final DeclarationAnnotationElementAdapter<Boolean> laxDeclarationAdapter;
    private final AnnotationElementAdapter<Boolean> laxAdapter;
    private Boolean lax;
    private final DeclarationAnnotationElementAdapter<String> valueDeclarationAdapter;
    private final AnnotationElementAdapter<String> valueAdapter;
    private String value;
    private String fullyQualifiedValueClassName;

    public SourceXmlAnyElementAnnotation(JavaResourceMember parent, Attribute attribute) {
        this(parent, attribute, DECLARATION_ANNOTATION_ADAPTER, (AnnotationAdapter)new ElementAnnotationAdapter((AnnotatedElement)attribute, DECLARATION_ANNOTATION_ADAPTER));
    }

    public SourceXmlAnyElementAnnotation(JavaResourceMember parent, Attribute attribute, DeclarationAnnotationAdapter daa, AnnotationAdapter annotationAdapter) {
        super(parent, attribute, daa, annotationAdapter);
        this.laxDeclarationAdapter = this.buildLaxAdapter(daa);
        this.laxAdapter = this.buildShortCircuitBooleanElementAdapter(this.laxDeclarationAdapter);
        this.valueDeclarationAdapter = this.buildValueAdapter(daa);
        this.valueAdapter = this.buildAnnotationElementAdapter(this.valueDeclarationAdapter);
    }

    private DeclarationAnnotationElementAdapter<Boolean> buildLaxAdapter(DeclarationAnnotationAdapter daa) {
        return ConversionDeclarationAnnotationElementAdapter.forBooleans((DeclarationAnnotationAdapter)daa, (String)"lax");
    }

    private DeclarationAnnotationElementAdapter<String> buildValueAdapter(DeclarationAnnotationAdapter daa) {
        return this.buildAnnotationElementAdapter(daa, "value", (ExpressionConverter<String>)SimpleTypeStringExpressionConverter.instance());
    }

    private DeclarationAnnotationElementAdapter<String> buildAnnotationElementAdapter(DeclarationAnnotationAdapter annotationAdapter, String elementName, ExpressionConverter<String> converter) {
        return new ConversionDeclarationAnnotationElementAdapter(annotationAdapter, elementName, converter);
    }

    private AnnotationElementAdapter<String> buildAnnotationElementAdapter(DeclarationAnnotationElementAdapter<String> daea) {
        return new AnnotatedElementAnnotationElementAdapter(this.annotatedElement, daea);
    }

    private AnnotationElementAdapter<Boolean> buildShortCircuitBooleanElementAdapter(DeclarationAnnotationElementAdapter<Boolean> daea) {
        return new AnnotatedElementAnnotationElementAdapter(this.annotatedElement, daea);
    }

    @Override
    public String getAnnotationName() {
        return "javax.xml.bind.annotation.XmlAnyElement";
    }

    @Override
    public void initialize(CompilationUnit astRoot) {
        this.lax = this.buildLax(astRoot);
        this.value = this.buildValue(astRoot);
        this.fullyQualifiedValueClassName = this.buildFullyQualifiedValueClassName(astRoot);
    }

    @Override
    public void synchronizeWith(CompilationUnit astRoot) {
        this.syncLax(this.buildLax(astRoot));
        this.syncValue(this.buildValue(astRoot));
        this.syncFullyQualifiedValueClassName(this.buildFullyQualifiedValueClassName(astRoot));
    }

    public void toString(StringBuilder sb) {
        sb.append(this.value);
    }

    @Override
    public Boolean getLax() {
        return this.lax;
    }

    @Override
    public void setLax(Boolean lax) {
        if (this.attributeValueHasChanged(this.lax, lax)) {
            this.lax = lax;
            this.laxAdapter.setValue((Object)lax);
        }
    }

    private void syncLax(Boolean astLax) {
        Boolean old = this.lax;
        this.lax = astLax;
        this.firePropertyChanged("lax", old, astLax);
    }

    private Boolean buildLax(CompilationUnit astRoot) {
        return (Boolean)this.laxAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getLaxTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.laxDeclarationAdapter, astRoot);
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public void setValue(String value) {
        if (this.attributeValueHasChanged(this.value, value)) {
            this.value = value;
            this.valueAdapter.setValue((Object)value);
        }
    }

    private void syncValue(String astValue) {
        String old = this.value;
        this.value = astValue;
        this.firePropertyChanged("value", old, astValue);
    }

    private String buildValue(CompilationUnit astRoot) {
        return (String)this.valueAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getValueTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.valueDeclarationAdapter, astRoot);
    }

    @Override
    public String getFullyQualifiedValueClassName() {
        return this.fullyQualifiedValueClassName;
    }

    private void syncFullyQualifiedValueClassName(String name) {
        String old = this.fullyQualifiedValueClassName;
        this.fullyQualifiedValueClassName = name;
        this.firePropertyChanged("fullyQualifiedValueClassName", old, name);
    }

    private String buildFullyQualifiedValueClassName(CompilationUnit astRoot) {
        return this.value == null ? null : ASTTools.resolveFullyQualifiedName((Expression)this.valueAdapter.getExpression(astRoot));
    }
}

