/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.internal.context.java;

import java.util.List;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.Filter;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyIterable;
import org.eclipse.jpt.jaxb.core.context.JaxbContextNode;
import org.eclipse.jpt.jaxb.core.context.JaxbPackage;
import org.eclipse.jpt.jaxb.core.context.XmlSchemaType;
import org.eclipse.jpt.jaxb.core.internal.context.java.AbstractJavaContextNode;
import org.eclipse.jpt.jaxb.core.resource.java.XmlSchemaTypeAnnotation;
import org.eclipse.jpt.jaxb.core.xsd.XsdSchema;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GenericJavaXmlSchemaType
extends AbstractJavaContextNode
implements XmlSchemaType {
    protected final XmlSchemaTypeAnnotation xmlSchemaTypeAnnotation;
    protected String name;
    protected String specifiedNamespace;
    protected String type;

    protected GenericJavaXmlSchemaType(JaxbContextNode parent, XmlSchemaTypeAnnotation xmlSchemaTypeAnnotation) {
        super(parent);
        this.xmlSchemaTypeAnnotation = xmlSchemaTypeAnnotation;
        this.name = this.getResourceName();
        this.specifiedNamespace = this.getResourceNamespace();
        this.type = this.getResourceTypeString();
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setName_(this.getResourceName());
        this.setNamespace_(this.getResourceNamespace());
        this.setType_(this.getResourceTypeString());
    }

    @Override
    public XmlSchemaTypeAnnotation getResourceXmlSchemaType() {
        return this.xmlSchemaTypeAnnotation;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.xmlSchemaTypeAnnotation.setName(name);
        this.setName_(name);
    }

    protected void setName_(String name) {
        String old = this.name;
        this.name = name;
        this.firePropertyChanged("name", old, name);
    }

    protected String getResourceName() {
        return this.xmlSchemaTypeAnnotation.getName();
    }

    @Override
    public String getNamespace() {
        return this.getSpecifiedNamespace() == null ? this.getDefaultNamespace() : this.getSpecifiedNamespace();
    }

    @Override
    public String getDefaultNamespace() {
        return "http://www.w3.org/2001/XMLSchema";
    }

    @Override
    public String getSpecifiedNamespace() {
        return this.specifiedNamespace;
    }

    @Override
    public void setSpecifiedNamespace(String location) {
        this.xmlSchemaTypeAnnotation.setNamespace(location);
        this.setNamespace_(location);
    }

    protected void setNamespace_(String namespace) {
        String old = this.specifiedNamespace;
        this.specifiedNamespace = namespace;
        this.firePropertyChanged("namespace", old, namespace);
    }

    protected String getResourceNamespace() {
        return this.xmlSchemaTypeAnnotation.getNamespace();
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public void setType(String location) {
        this.xmlSchemaTypeAnnotation.setType(location);
        this.setType_(location);
    }

    protected void setType_(String type) {
        String old = this.type;
        this.type = type;
        this.firePropertyChanged("type", old, type);
    }

    protected String getResourceTypeString() {
        return this.xmlSchemaTypeAnnotation.getType();
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        super.validate(messages, reporter, astRoot);
    }

    @Override
    public TextRange getValidationTextRange(CompilationUnit astRoot) {
        return this.xmlSchemaTypeAnnotation.getTextRange(astRoot);
    }

    @Override
    public Iterable<String> getJavaCompletionProposals(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterable<String> result = super.getJavaCompletionProposals(pos, filter, astRoot);
        if (!CollectionTools.isEmpty(result)) {
            return result;
        }
        if (this.namespaceTouches(pos, astRoot)) {
            return this.getNamespaceProposals(filter);
        }
        if (this.nameTouches(pos, astRoot)) {
            return this.getNameProposals(filter);
        }
        return EmptyIterable.instance();
    }

    protected boolean namespaceTouches(int pos, CompilationUnit astRoot) {
        return this.getResourceXmlSchemaType().namespaceTouches(pos, astRoot);
    }

    protected Iterable<String> getNamespaceProposals(Filter<String> filter) {
        XsdSchema schema = this.getJaxbPackage().getXsdSchema();
        if (schema == null) {
            return EmptyIterable.instance();
        }
        return schema.getNamespaceProposals(filter);
    }

    protected boolean nameTouches(int pos, CompilationUnit astRoot) {
        return this.getResourceXmlSchemaType().nameTouches(pos, astRoot);
    }

    protected Iterable<String> getNameProposals(Filter<String> filter) {
        XsdSchema schema = this.getJaxbPackage().getXsdSchema();
        if (schema == null) {
            return EmptyIterable.instance();
        }
        return schema.getSimpleTypeNameProposals(this.getNamespace(), filter);
    }

    protected abstract JaxbPackage getJaxbPackage();
}

