/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.apt.core.internal.declaration;

import com.sun.mirror.declaration.ClassDeclaration;
import com.sun.mirror.declaration.ConstructorDeclaration;
import com.sun.mirror.declaration.MethodDeclaration;
import com.sun.mirror.type.ClassType;
import com.sun.mirror.util.DeclarationVisitor;
import com.sun.mirror.util.TypeVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.apt.core.internal.declaration.EclipseDeclarationImpl;
import org.eclipse.jdt.apt.core.internal.declaration.EclipseMirrorObject;
import org.eclipse.jdt.apt.core.internal.declaration.TypeDeclarationImpl;
import org.eclipse.jdt.apt.core.internal.env.BaseProcessorEnv;
import org.eclipse.jdt.apt.core.internal.util.Factory;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassDeclarationImpl
extends TypeDeclarationImpl
implements ClassDeclaration,
ClassType {
    public ClassDeclarationImpl(ITypeBinding binding, BaseProcessorEnv env) {
        super(binding, env);
        assert (!binding.isInterface());
    }

    @Override
    public void accept(DeclarationVisitor visitor) {
        visitor.visitClassDeclaration(this);
    }

    private void getASTConstructor(AbstractTypeDeclaration typeDecl, List<ConstructorDeclaration> results) {
        List bodyDecls = typeDecl.bodyDeclarations();
        IFile file = null;
        int i = 0;
        int len = bodyDecls.size();
        while (i < len) {
            IMethodBinding methodBinding;
            org.eclipse.jdt.core.dom.MethodDeclaration methodDecl;
            BodyDeclaration bodyDecl = (BodyDeclaration)bodyDecls.get(i);
            if (bodyDecl.getNodeType() == 31 && (methodDecl = (org.eclipse.jdt.core.dom.MethodDeclaration)bodyDecl).isConstructor() && (methodBinding = methodDecl.resolveBinding()) == null) {
                ConstructorDeclaration mirrorDecl;
                if (file == null) {
                    file = this.getResource();
                }
                if ((mirrorDecl = (ConstructorDeclaration)((Object)Factory.createDeclaration((ASTNode)methodDecl, file, this._env))) != null) {
                    results.add(mirrorDecl);
                }
            }
            ++i;
        }
    }

    @Override
    public Collection<ConstructorDeclaration> getConstructors() {
        IMethodBinding[] methods;
        ITypeBinding typeBinding;
        ASTNode node;
        ArrayList<ConstructorDeclaration> results = new ArrayList<ConstructorDeclaration>();
        if (this.isFromSource() && (node = this._env.getASTNodeForBinding((IBinding)(typeBinding = this.getDeclarationBinding()))) != null) {
            switch (node.getNodeType()) {
                case 55: 
                case 71: 
                case 81: {
                    AbstractTypeDeclaration typeDecl = (AbstractTypeDeclaration)node;
                    this.getASTConstructor(typeDecl, results);
                    break;
                }
                default: {
                    throw new IllegalStateException("expecting a AbstractTypeDeclaration but got " + node.getClass().getName());
                }
            }
        }
        IMethodBinding[] iMethodBindingArray = methods = this.getDeclarationBinding().getDeclaredMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            EclipseDeclarationImpl mirrorDecl;
            IMethodBinding method = iMethodBindingArray[n2];
            if (!method.isSynthetic() && method.isConstructor() && (mirrorDecl = Factory.createDeclaration((IBinding)method, this._env)) != null) {
                results.add((ConstructorDeclaration)((Object)mirrorDecl));
            }
            ++n2;
        }
        return results;
    }

    @Override
    public Collection<MethodDeclaration> getMethods() {
        return this._getMethods();
    }

    @Override
    public void accept(TypeVisitor visitor) {
        visitor.visitClassType(this);
    }

    @Override
    public ClassType getSuperclass() {
        ITypeBinding superClass = this.getDeclarationBinding().getSuperclass();
        if (superClass == null) {
            return null;
        }
        if (superClass.isClass() && !superClass.isRecovered()) {
            return (ClassType)((Object)Factory.createReferenceType(superClass, this._env));
        }
        return Factory.createErrorClassType(superClass);
    }

    @Override
    public ClassDeclaration getDeclaration() {
        return (ClassDeclaration)super.getDeclaration();
    }

    @Override
    public EclipseMirrorObject.MirrorKind kind() {
        return EclipseMirrorObject.MirrorKind.TYPE_CLASS;
    }
}

