/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.wizards;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.internal.ui.util.CoreUtility;
import org.eclipse.jdt.ui.actions.AbstractOpenWizardAction;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jpt.jpa.ui.JptJpaUiPlugin;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowPulldownDelegate2;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class NewEntityDropDownAction
extends Action
implements IMenuCreator,
IWorkbenchWindowPulldownDelegate2 {
    private static final String TAG_WIZARD = "wizard";
    private static final String ATT_JPTARTIFACT = "jptartifact";
    private static final String TAG_PARAMETER = "parameter";
    private static final String TAG_NAME = "name";
    private static final String TAG_VALUE = "value";
    protected static final String ATT_MENUINDEX = "menuIndex";
    private static final String PL_NEW = "newWizards";
    private static final String TAG_CLASS = "class";
    private Menu fMenu = null;
    private Shell fWizardShell;

    public NewEntityDropDownAction() {
        this.setMenuCreator(this);
    }

    public void dispose() {
        if (this.fMenu != null) {
            this.fMenu.dispose();
            this.fMenu = null;
        }
    }

    public Menu getMenu(Menu parent) {
        return null;
    }

    public Menu getMenu(Control parent) {
        if (this.fMenu == null) {
            this.fMenu = new Menu(parent);
            OpenJptWizardAction[] actions = NewEntityDropDownAction.getActionFromDescriptors();
            int i = 0;
            while (i < actions.length) {
                OpenJptWizardAction curr = actions[i];
                curr.setShell(this.fWizardShell);
                ActionContributionItem item = new ActionContributionItem((IAction)curr);
                item.fill(this.fMenu, -1);
                ++i;
            }
        }
        return this.fMenu;
    }

    public void run() {
        this.getDefaultAction().run();
    }

    public Action getDefaultAction() {
        OpenJptWizardAction[] actions = NewEntityDropDownAction.getActionFromDescriptors();
        if (actions.length > 0) {
            return actions[0];
        }
        return null;
    }

    public static OpenJptWizardAction[] getActionFromDescriptors() {
        ArrayList<OpenJptWizardAction> containers = new ArrayList<OpenJptWizardAction>();
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.ui", PL_NEW);
        if (extensionPoint != null) {
            IConfigurationElement[] elements = extensionPoint.getConfigurationElements();
            int i = 0;
            while (i < elements.length) {
                IConfigurationElement element = elements[i];
                if (element.getName().equals(TAG_WIZARD) && NewEntityDropDownAction.isJptArtifactWizard(element)) {
                    containers.add(new OpenJptWizardAction(element));
                }
                ++i;
            }
        }
        Object[] actions = containers.toArray(new OpenJptWizardAction[containers.size()]);
        Arrays.sort(actions);
        return actions;
    }

    private static boolean isJptArtifactWizard(IConfigurationElement element) {
        IConfigurationElement[] classElements = element.getChildren(TAG_CLASS);
        if (classElements.length > 0) {
            int i = 0;
            while (i < classElements.length) {
                IConfigurationElement[] paramElements = classElements[i].getChildren(TAG_PARAMETER);
                int k = 0;
                while (k < paramElements.length) {
                    IConfigurationElement curr = paramElements[k];
                    if (ATT_JPTARTIFACT.equals(curr.getAttribute(TAG_NAME))) {
                        return Boolean.valueOf(curr.getAttribute(TAG_VALUE));
                    }
                    ++k;
                }
                ++i;
            }
        }
        return false;
    }

    public void init(IWorkbenchWindow window) {
        this.fWizardShell = window.getShell();
    }

    public void run(IAction action) {
        this.run();
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class OpenJptWizardAction
    extends AbstractOpenWizardAction
    implements Comparable<Object> {
        private static final String ATT_NAME = "name";
        private static final String ATT_CLASS = "class";
        private static final String ATT_ICON = "icon";
        private static final String TAG_DESCRIPTION = "description";
        private IConfigurationElement fConfigurationElement;
        private int menuIndex;

        public OpenJptWizardAction(IConfigurationElement element) {
            this.fConfigurationElement = element;
            this.setText(element.getAttribute("name"));
            String description = this.getDescriptionFromConfig(this.fConfigurationElement);
            this.setDescription(description);
            this.setToolTipText(description);
            this.setImageDescriptor(this.getIconFromConfig(this.fConfigurationElement));
            this.setMenuIndex(this.getMenuIndexFromConfig(this.fConfigurationElement));
        }

        private String getDescriptionFromConfig(IConfigurationElement config) {
            IConfigurationElement[] children = config.getChildren(TAG_DESCRIPTION);
            if (children.length >= 1) {
                return children[0].getValue();
            }
            return "";
        }

        private ImageDescriptor getIconFromConfig(IConfigurationElement config) {
            String iconName = config.getAttribute(ATT_ICON);
            if (iconName != null) {
                return AbstractUIPlugin.imageDescriptorFromPlugin((String)config.getContributor().getName(), (String)iconName);
            }
            return null;
        }

        private int getMenuIndexFromConfig(IConfigurationElement config) {
            IConfigurationElement[] classElements = config.getChildren("class");
            if (classElements.length > 0) {
                IConfigurationElement[] iConfigurationElementArray = classElements;
                int n = classElements.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement[] paramElements;
                    IConfigurationElement classElement = iConfigurationElementArray[n2];
                    IConfigurationElement[] iConfigurationElementArray2 = paramElements = classElement.getChildren(NewEntityDropDownAction.TAG_PARAMETER);
                    int n3 = paramElements.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IConfigurationElement paramElement = iConfigurationElementArray2[n4];
                        if (NewEntityDropDownAction.ATT_MENUINDEX.equals(paramElement.getAttribute("name"))) {
                            return Integer.parseInt(paramElement.getAttribute(NewEntityDropDownAction.TAG_VALUE));
                        }
                        ++n4;
                    }
                    ++n2;
                }
            }
            return Integer.MAX_VALUE;
        }

        public void run() {
            Shell shell = this.getShell();
            try {
                INewWizard wizard = this.createWizard();
                wizard.init(PlatformUI.getWorkbench(), this.getSelection());
                WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
                PixelConverter converter = new PixelConverter(JFaceResources.getDialogFont());
                dialog.setMinimumPageSize(converter.convertWidthInCharsToPixels(70), converter.convertHeightInCharsToPixels(20));
                dialog.create();
                int res = dialog.open();
                this.notifyResult(res == 0);
            }
            catch (CoreException e) {
                JptJpaUiPlugin.log(e);
            }
        }

        protected INewWizard createWizard() throws CoreException {
            return (INewWizard)CoreUtility.createExtension((IConfigurationElement)this.fConfigurationElement, (String)"class");
        }

        public int getMenuIndex() {
            return this.menuIndex;
        }

        public void setMenuIndex(int menuIndex) {
            this.menuIndex = menuIndex;
        }

        @Override
        public int compareTo(Object o) {
            OpenJptWizardAction action = (OpenJptWizardAction)o;
            return this.getMenuIndex() - action.getMenuIndex();
        }
    }
}

