/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.jpql;

import java.text.MessageFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionInfo;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.jface.bindings.Binding;
import org.eclipse.jface.bindings.Trigger;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.bindings.keys.SWTKeySupport;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.internal.text.html.HTMLTextPresenter;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.DefaultTextHover;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.DefaultAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jpt.common.ui.internal.listeners.SWTPropertyChangeListenerWrapper;
import org.eclipse.jpt.common.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.common.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.WritablePropertyValueModel;
import org.eclipse.jpt.jpa.core.JptJpaCorePlugin;
import org.eclipse.jpt.jpa.core.context.NamedQuery;
import org.eclipse.jpt.jpa.ui.internal.JptUiMessages;
import org.eclipse.jpt.jpa.ui.internal.jpql.JpqlCompletionProposal;
import org.eclipse.jpt.jpa.ui.internal.jpql.JpqlCompletionProposalComputer;
import org.eclipse.jpt.jpa.ui.internal.jpql.TextTransferHandler;
import org.eclipse.osgi.util.NLS;
import org.eclipse.persistence.jpa.jpql.JPQLQueryProblem;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.ui.keys.IBindingService;
import org.eclipse.ui.swt.IFocusService;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.DefaultMarkerAnnotationAccess;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JpaJpqlContentProposalProvider
extends JpqlCompletionProposalComputer<ICompletionProposal> {
    private AnnotationModel annotationModel;
    private SourceViewerDecorationSupport decorationSupport;
    private IHandlerActivation handlerActivation;
    private int position;
    private PropertyValueModel<? extends NamedQuery> queryHolder;
    private ResourceBundle resourceBundle;
    private SourceViewer sourceViewer;
    private JpqlSourceViewerConfiguration sourceViewerConfiguration;
    private StyledText styledText;
    private PropertyChangeListener subjectChangeListener;
    private WritablePropertyValueModel<String> textHolder;
    private PropertyChangeListener textListener;
    private static final String CONTROL_ID = "jpql.focus.control";
    private static final String ERROR_TYPE = "org.eclipse.jdt.ui.error";

    public JpaJpqlContentProposalProvider(Composite parent, PropertyValueModel<? extends NamedQuery> queryHolder, WritablePropertyValueModel<String> textHolder) {
        this.initialize(parent, queryHolder, textHolder);
    }

    private void activateHandler() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IFocusService focusService = (IFocusService)workbench.getService(IFocusService.class);
        IHandlerService handlerService = (IHandlerService)workbench.getService(IHandlerService.class);
        if (focusService != null && handlerService != null) {
            focusService.addFocusTracker((Control)this.styledText, CONTROL_ID + this.hashCode());
            Expression expression = this.buildExpression();
            IHandler handler = this.buildHandler();
            this.handlerActivation = handlerService.activateHandler("org.eclipse.ui.edit.text.contentAssist.proposals", handler, expression);
            this.handlerActivation = handlerService.activateHandler(ActionFactory.UNDO.getCommandId(), handler, expression);
            this.handlerActivation = handlerService.activateHandler(ActionFactory.REDO.getCommandId(), handler, expression);
        }
    }

    private List<AnnotationPreference> annotationPreferences() {
        return EditorsPlugin.getDefault().getMarkerAnnotationPreferences().getAnnotationPreferences();
    }

    private DisposeListener buildDisposeListener() {
        return new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                JpaJpqlContentProposalProvider.this.dispose();
            }
        };
    }

    private IDocumentListener buildDocumentListener() {
        return new IDocumentListener(){

            public void documentAboutToBeChanged(DocumentEvent event) {
            }

            public void documentChanged(DocumentEvent event) {
                try {
                    IDocument document = event.getDocument();
                    String text = document.get(0, document.getLength());
                    JpaJpqlContentProposalProvider.this.textHolder.setValue((Object)text);
                }
                catch (BadLocationException badLocationException) {}
            }
        };
    }

    private Expression buildExpression() {
        return new Expression(){

            public void collectExpressionInfo(ExpressionInfo info) {
                info.addVariableNameAccess("activeFocusControl");
            }

            public EvaluationResult evaluate(IEvaluationContext context) {
                Object variable = context.getVariable("activeFocusControl");
                return variable == JpaJpqlContentProposalProvider.this.styledText ? EvaluationResult.TRUE : EvaluationResult.FALSE;
            }
        };
    }

    private FocusListener buildFocusListener() {
        return new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                if (!((JpaJpqlContentProposalProvider)JpaJpqlContentProposalProvider.this).sourceViewerConfiguration.contentAssistant.hasProposalPopupFocus()) {
                    JpaJpqlContentProposalProvider.this.disposeQueryHelper();
                }
            }
        };
    }

    private IHandler buildHandler() {
        return new AbstractHandler(){

            public Object execute(ExecutionEvent event) throws ExecutionException {
                String commandId = event.getCommand().getId();
                if ("org.eclipse.ui.edit.text.contentAssist.proposals".equals(commandId)) {
                    JpaJpqlContentProposalProvider.this.sourceViewer.doOperation(13);
                } else if (ActionFactory.UNDO.getCommandId().equals(commandId)) {
                    if (JpaJpqlContentProposalProvider.this.sourceViewer.getUndoManager().undoable()) {
                        JpaJpqlContentProposalProvider.this.sourceViewer.getUndoManager().undo();
                    }
                } else if (ActionFactory.REDO.getCommandId().equals(commandId) && JpaJpqlContentProposalProvider.this.sourceViewer.getUndoManager().redoable()) {
                    JpaJpqlContentProposalProvider.this.sourceViewer.getUndoManager().redo();
                }
                return null;
            }
        };
    }

    private String buildMessage(JPQLQueryProblem problem) {
        String message = this.resourceBundle().getString(problem.getMessageKey());
        message = MessageFormat.format(message, problem.getMessageArguments());
        return message;
    }

    private ModifyListener buildModifyListener() {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JpaJpqlContentProposalProvider.this.validate();
            }
        };
    }

    private Comparator<JPQLQueryProblem> buildProblemComparator() {
        return new Comparator<JPQLQueryProblem>(){

            @Override
            public int compare(JPQLQueryProblem problem1, JPQLQueryProblem problem2) {
                int result = problem1.getStartPosition() - problem2.getStartPosition();
                if (result == 0) {
                    result = problem1.getEndPosition() - problem2.getEndPosition();
                }
                return result;
            }
        };
    }

    @Override
    ICompletionProposal buildProposal(String proposal, String displayString, String additionalInfo, Image image, int cursorOffset) {
        return new JpqlCompletionProposal(this.contentAssistProposals, proposal, displayString, additionalInfo, image, this.namedQuery, this.actualQuery, this.jpqlQuery, this.offset, this.position, cursorOffset, false);
    }

    private PropertyChangeListener buildSubjectChangeListener() {
        return new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent e) {
                JpaJpqlContentProposalProvider.this.subjectChanged(e);
            }
        };
    }

    private PropertyChangeListener buildTextListener() {
        return new SWTPropertyChangeListenerWrapper(new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent event) {
                String text = (String)event.getNewValue();
                if (text == null) {
                    text = "";
                }
                if (!JpaJpqlContentProposalProvider.this.styledText.getText().equals(text)) {
                    JpaJpqlContentProposalProvider.this.sourceViewer.getDocument().set(text);
                }
            }
        });
    }

    private Image contentAssistImage() {
        FieldDecorationRegistry registry = FieldDecorationRegistry.getDefault();
        return registry.getFieldDecoration("DEC_CONTENT_PROPOSAL").getImage();
    }

    private void dispose() {
        this.sessionEnded();
        this.decorationSupport.dispose();
        this.textHolder.removePropertyChangeListener("value", this.textListener);
        this.queryHolder.removePropertyChangeListener("value", this.subjectChangeListener);
        IWorkbench workbench = PlatformUI.getWorkbench();
        IHandlerService handlerService = (IHandlerService)workbench.getService(IHandlerService.class);
        handlerService.deactivateHandler(this.handlerActivation);
    }

    private void disposeQueryHelper() {
        this.queryHelper.dispose();
        this.queryHelper.disposeProvider();
    }

    private KeyStroke findContentAssistTrigger() {
        IBindingService bindingService = (IBindingService)PlatformUI.getWorkbench().getService(IBindingService.class);
        Binding[] bindingArray = bindingService.getBindings();
        int n = bindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            Trigger[] triggers;
            Binding binding = bindingArray[n2];
            if (this.isContentAssistBinding(binding) && (triggers = binding.getTriggerSequence().getTriggers()) != null && triggers.length > 0) {
                return (KeyStroke)triggers[0];
            }
            ++n2;
        }
        return KeyStroke.getInstance((int)262144, (int)32);
    }

    public StyledText getStyledText() {
        return this.styledText;
    }

    private void initialize(Composite parent, PropertyValueModel<? extends NamedQuery> queryHolder, WritablePropertyValueModel<String> textHolder) {
        this.queryHolder = queryHolder;
        this.annotationModel = new AnnotationModel();
        this.textHolder = textHolder;
        this.textListener = this.buildTextListener();
        textHolder.addPropertyChangeListener("value", this.textListener);
        this.subjectChangeListener = this.buildSubjectChangeListener();
        queryHolder.addPropertyChangeListener("value", this.subjectChangeListener);
        this.sourceViewer = new SourceViewer(parent, null, 8391490);
        this.sourceViewerConfiguration = new JpqlSourceViewerConfiguration();
        this.sourceViewer.configure((SourceViewerConfiguration)this.sourceViewerConfiguration);
        this.sourceViewer.setDocument((IDocument)new Document(), (IAnnotationModel)this.annotationModel);
        this.sourceViewer.getDocument().addDocumentListener(this.buildDocumentListener());
        this.styledText = this.sourceViewer.getTextWidget();
        this.styledText.addFocusListener(this.buildFocusListener());
        this.styledText.addModifyListener(this.buildModifyListener());
        this.styledText.addDisposeListener(this.buildDisposeListener());
        this.installDecorationSupport();
        this.activateHandler();
        TextTransferHandler.installContextMenu(this.styledText, this.sourceViewer.getUndoManager());
    }

    public void installControlDecoration() {
        KeyStroke contentAssistTrigger = this.findContentAssistTrigger();
        String key = SWTKeySupport.getKeyFormatterForPlatform().format(contentAssistTrigger);
        ControlDecoration decoration = new ControlDecoration((Control)this.styledText, 16512);
        decoration.setDescriptionText(NLS.bind((String)JptUiMessages.JpqlContentProposalProvider_Description, (Object)key));
        decoration.setImage(this.contentAssistImage());
        decoration.setShowOnlyOnFocus(true);
    }

    private void installDecorationSupport() {
        this.decorationSupport = new SourceViewerDecorationSupport((ISourceViewer)this.sourceViewer, null, (IAnnotationAccess)new DefaultMarkerAnnotationAccess(), EditorsPlugin.getDefault().getSharedTextColors());
        for (AnnotationPreference preference : this.annotationPreferences()) {
            this.decorationSupport.setAnnotationPreference(preference);
        }
        this.decorationSupport.install(EditorsPlugin.getDefault().getPreferenceStore());
    }

    private boolean isContentAssistBinding(Binding binding) {
        ParameterizedCommand command = binding.getParameterizedCommand();
        return command != null && command.getCommand() != null && command.getCommand().getId().equals("org.eclipse.ui.edit.text.contentAssist.proposals");
    }

    private NamedQuery query() {
        return (NamedQuery)this.queryHolder.getValue();
    }

    private ResourceBundle resourceBundle() {
        if (this.resourceBundle == null) {
            this.resourceBundle = ResourceBundle.getBundle("jpa_jpql_validation", Locale.getDefault(), JptJpaCorePlugin.class.getClassLoader());
        }
        return this.resourceBundle;
    }

    private List<JPQLQueryProblem> sortProblems(List<JPQLQueryProblem> problems) {
        Collections.sort(problems, this.buildProblemComparator());
        return problems;
    }

    private void subjectChanged(PropertyChangeEvent e) {
        this.disposeQueryHelper();
        if (e.getNewValue() != null) {
            this.sourceViewer.getUndoManager().reset();
            this.validate();
        } else {
            this.annotationModel.removeAllAnnotations();
        }
    }

    private void validate() {
        NamedQuery query = this.query();
        this.annotationModel.removeAllAnnotations();
        if (query != null && !this.styledText.isDisposed()) {
            try {
                String jpqlQuery = this.styledText.getText();
                this.queryHelper.setQuery(query, jpqlQuery);
                String parsedJpqlQuery = this.queryHelper.getParsedJPQLQuery();
                for (JPQLQueryProblem problem : this.sortProblems(this.queryHelper.validate())) {
                    int[] positions = this.queryHelper.buildPositions(problem, parsedJpqlQuery, jpqlQuery);
                    Annotation annotation = new Annotation(ERROR_TYPE, true, this.buildMessage(problem));
                    this.annotationModel.addAnnotation(annotation, new Position(positions[0], positions[1] - positions[0]));
                }
            }
            finally {
                this.queryHelper.dispose();
            }
        }
    }

    private class ContentAssistProcessor
    implements IContentAssistProcessor {
        private ContentAssistProcessor() {
        }

        public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
            JpaJpqlContentProposalProvider.this.position = offset;
            String jpqlQuery = viewer.getDocument().get();
            List<ICompletionProposal> proposals = JpaJpqlContentProposalProvider.this.buildProposals(JpaJpqlContentProposalProvider.this.query(), jpqlQuery, 0, JpaJpqlContentProposalProvider.this.position);
            return proposals.toArray(new ICompletionProposal[proposals.size()]);
        }

        public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
            return null;
        }

        public char[] getCompletionProposalAutoActivationCharacters() {
            return null;
        }

        public char[] getContextInformationAutoActivationCharacters() {
            return null;
        }

        public IContextInformationValidator getContextInformationValidator() {
            return null;
        }

        public String getErrorMessage() {
            return null;
        }
    }

    private class JpqlSourceViewerConfiguration
    extends SourceViewerConfiguration {
        ContentAssistant contentAssistant;

        private JpqlSourceViewerConfiguration() {
        }

        private IInformationControlCreator buildInformationControlCreator() {
            return new IInformationControlCreator(){

                public IInformationControl createInformationControl(Shell parent) {
                    return new DefaultInformationControl(parent, EditorsUI.getTooltipAffordanceString(), (DefaultInformationControl.IInformationPresenter)new HTMLTextPresenter(true));
                }
            };
        }

        public IAnnotationHover getAnnotationHover(ISourceViewer sourceViewer) {
            return new DefaultAnnotationHover();
        }

        public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
            this.contentAssistant = new ContentAssistant();
            this.contentAssistant.setContentAssistProcessor((IContentAssistProcessor)new ContentAssistProcessor(), "__dftl_partition_content_type");
            this.contentAssistant.setInformationControlCreator(this.buildInformationControlCreator());
            return this.contentAssistant;
        }

        public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType) {
            return new DefaultTextHover(sourceViewer);
        }

        public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType, int stateMask) {
            return new DefaultTextHover(sourceViewer);
        }
    }
}

