/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.search;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.api.tools.internal.problems.ApiProblem;
import org.eclipse.pde.api.tools.internal.provisional.Factory;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IComponentDescriptor;
import org.eclipse.pde.api.tools.internal.search.MissingRefReportConverter;
import org.eclipse.pde.api.tools.internal.search.SearchMessages;
import org.eclipse.pde.api.tools.internal.search.UseScanParser;
import org.eclipse.pde.api.tools.internal.util.Util;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class MissingRefParser
extends UseScanParser {
    static final FileFilter filter = new FileFilter(){

        public boolean accept(File pathname) {
            return pathname.isFile() && pathname.getName().endsWith(".xml");
        }
    };

    MissingRefParser() {
    }

    public void parse(String xmlLocation, MissingRefReportConverter.MissingRefVisitor visitor) throws Exception {
        if (xmlLocation == null) {
            throw new Exception(SearchMessages.missing_xml_files_location);
        }
        File reportsRoot = new File(xmlLocation);
        if (!reportsRoot.exists() || !reportsRoot.isDirectory()) {
            throw new Exception(NLS.bind((String)SearchMessages.invalid_directory_name, (Object)xmlLocation));
        }
        File[] components = this.getDirectories(reportsRoot);
        components = this.sort(components);
        visitor.visitScan();
        SAXParser parser = this.getParser();
        int i = 0;
        while (i < components.length) {
            String[] idv;
            IComponentDescriptor targetComponent;
            if (components[i].isDirectory() && visitor.visitComponent(targetComponent = Factory.componentDescriptor((idv = this.getIdVersion(components[i].getName()))[0], idv[1]))) {
                File[] xmlfiles = Util.getAllFiles(components[i], filter);
                if (xmlfiles != null && xmlfiles.length > 0) {
                    xmlfiles = this.sort(xmlfiles);
                    int k = 0;
                    while (k < xmlfiles.length) {
                        try {
                            MissingRefProblemHandler handler = new MissingRefProblemHandler();
                            parser.parse(xmlfiles[k], (DefaultHandler)handler);
                            List apiProblems = handler.getProblems();
                            visitor.addToCurrentReport(apiProblems);
                        }
                        catch (SAXException sAXException) {
                        }
                        catch (IOException iOException) {}
                        ++k;
                    }
                }
                visitor.endVisitComponent();
            }
            ++i;
        }
    }

    class MissingRefProblemHandler
    extends DefaultHandler {
        List problems = new ArrayList();
        private String typename;
        private int linenumber;
        private int charstart;
        private int charend;
        private int id;
        private List messageargs = new ArrayList();
        private Map extraargs = new HashMap();

        MissingRefProblemHandler() {
        }

        public void startDocument() throws SAXException {
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if ("api_problem".equalsIgnoreCase(qName)) {
                this.typename = attributes.getValue("typeName");
                this.linenumber = Integer.parseInt(attributes.getValue("linenumber"));
                this.charstart = Integer.parseInt(attributes.getValue("charstart"));
                this.charend = Integer.parseInt(attributes.getValue("charend"));
                this.id = Integer.parseInt(attributes.getValue("id"));
            } else if ("message_arguments".equalsIgnoreCase(qName)) {
                this.messageargs.clear();
            } else if ("message_argument".equalsIgnoreCase(qName)) {
                this.messageargs.add(attributes.getValue("value"));
            } else if ("extra_arguments".equalsIgnoreCase(qName)) {
                this.extraargs.clear();
            } else if ("extra_argument".equalsIgnoreCase(qName)) {
                this.extraargs.put(attributes.getValue("id"), attributes.getValue("value"));
            }
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            if ("api_problem".equalsIgnoreCase(qName)) {
                String[] argumentids = new String[this.extraargs.size()];
                Object[] arguments = new Object[this.extraargs.size()];
                int i = 0;
                Iterator iterator = this.extraargs.keySet().iterator();
                while (iterator.hasNext()) {
                    argumentids[i] = (String)iterator.next();
                    arguments[i] = this.extraargs.get(argumentids[i]);
                    ++i;
                }
                ApiProblem problem = new ApiProblem(null, this.typename, this.messageargs.toArray(new String[this.messageargs.size()]), argumentids, arguments, this.linenumber, this.charstart, this.charend, this.id);
                this.problems.add(problem);
            }
        }

        public void endDocument() throws SAXException {
        }

        public List getProblems() {
            return this.problems;
        }
    }
}

