/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.jpa1.context.orm;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jpt.common.core.utility.BodySourceWriter;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.ClassName;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.Tools;
import org.eclipse.jpt.common.utility.internal.iterables.ChainIterable;
import org.eclipse.jpt.common.utility.internal.iterables.CompositeIterable;
import org.eclipse.jpt.common.utility.internal.iterables.CompositeListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterables.FilteringIterable;
import org.eclipse.jpt.common.utility.internal.iterables.ListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.LiveCloneListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.SingleElementIterable;
import org.eclipse.jpt.common.utility.internal.iterables.SnapshotCloneIterable;
import org.eclipse.jpt.common.utility.internal.iterables.SuperListIterableWrapper;
import org.eclipse.jpt.common.utility.internal.iterables.TransformationIterable;
import org.eclipse.jpt.common.utility.internal.iterators.EmptyListIterator;
import org.eclipse.jpt.jpa.core.JpaStructureNode;
import org.eclipse.jpt.jpa.core.JptJpaCorePlugin;
import org.eclipse.jpt.jpa.core.context.AccessType;
import org.eclipse.jpt.jpa.core.context.JpaContextNode;
import org.eclipse.jpt.jpa.core.context.PersistentType;
import org.eclipse.jpt.jpa.core.context.ReadOnlyPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentType;
import org.eclipse.jpt.jpa.core.context.orm.EntityMappings;
import org.eclipse.jpt.jpa.core.context.orm.OrmAttributeMapping;
import org.eclipse.jpt.jpa.core.context.orm.OrmAttributeMappingDefinition;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.jpa.core.context.orm.OrmReadOnlyPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.orm.OrmTypeMapping;
import org.eclipse.jpt.jpa.core.context.orm.OrmTypeMappingDefinition;
import org.eclipse.jpt.jpa.core.internal.context.ContextContainerTools;
import org.eclipse.jpt.jpa.core.internal.context.orm.AbstractOrmXmlContextNode;
import org.eclipse.jpt.jpa.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.jpa.core.jpa2.context.MetamodelSourceType;
import org.eclipse.jpt.jpa.core.jpa2.context.java.JavaPersistentType2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.orm.OrmPersistentType2_0;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.jpa.core.resource.orm.Attributes;
import org.eclipse.jpt.jpa.core.resource.orm.OrmPackage;
import org.eclipse.jpt.jpa.core.resource.orm.XmlAttributeMapping;
import org.eclipse.jpt.jpa.core.resource.orm.XmlTypeMapping;
import org.eclipse.jpt.jpa.core.resource.xml.EmfTools;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericOrmPersistentType
extends AbstractOrmXmlContextNode
implements OrmPersistentType2_0 {
    protected OrmTypeMapping mapping;
    protected JavaPersistentType javaPersistentType;
    protected AccessType specifiedAccess;
    protected AccessType defaultAccess;
    protected final Vector<OrmPersistentAttribute> specifiedAttributes = new Vector();
    protected final SpecifiedAttributeContainerAdapter specifiedAttributeContainerAdapter = new SpecifiedAttributeContainerAdapter();
    protected final Vector<OrmReadOnlyPersistentAttribute> virtualAttributes = new Vector();
    protected final VirtualAttributeContainerAdapter virtualAttributeContainerAdapter = new VirtualAttributeContainerAdapter();
    protected PersistentType superPersistentType;
    protected String declaringTypeName;
    protected final MetamodelSourceType.Synchronizer metamodelSynchronizer;
    protected static final Comparator<OrmPersistentAttribute> ATTRIBUTE_COMPARATOR = new Comparator<OrmPersistentAttribute>(){

        @Override
        public int compare(OrmPersistentAttribute attribute1, OrmPersistentAttribute attribute2) {
            int seq2;
            int seq1 = attribute1.getMapping().getXmlSequence();
            return seq1 == (seq2 = attribute2.getMapping().getXmlSequence()) ? 0 : (seq1 < seq2 ? -1 : 1);
        }
    };

    public GenericOrmPersistentType(EntityMappings parent, XmlTypeMapping xmlTypeMapping) {
        super(parent);
        this.mapping = this.buildMapping(xmlTypeMapping);
        this.specifiedAccess = this.buildSpecifiedAccess();
        this.defaultAccess = AccessType.FIELD;
        this.initializeSpecifiedAttributes();
        this.metamodelSynchronizer = this.buildMetamodelSynchronizer();
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.mapping.synchronizeWithResourceModel();
        this.syncJavaPersistentType();
        this.setSpecifiedAccess_(this.buildSpecifiedAccess());
        this.syncSpecifiedAttributes();
        this.synchronizeNodesWithResourceModel((Iterable<? extends JpaContextNode>)this.getVirtualAttributes());
    }

    @Override
    public void update() {
        super.update();
        this.mapping.update();
        this.updateJavaPersistentType();
        this.setDefaultAccess(this.buildDefaultAccess());
        this.updateNodes((Iterable<? extends JpaContextNode>)this.getSpecifiedAttributes());
        this.updateVirtualAttributes();
        this.setSuperPersistentType(this.buildSuperPersistentType());
        this.setDeclaringTypeName(this.buildDeclaringTypeName());
    }

    @Override
    public OrmTypeMapping getMapping() {
        return this.mapping;
    }

    @Override
    public String getMappingKey() {
        return this.mapping.getKey();
    }

    @Override
    public void setMappingKey(String mappingKey) {
        if (this.valuesAreDifferent(this.getMappingKey(), mappingKey)) {
            this.setMappingKey_(mappingKey);
        }
    }

    protected void setMappingKey_(String mappingKey) {
        OrmTypeMapping old = this.mapping;
        OrmTypeMappingDefinition mappingDefinition = this.getMappingFileDefinition().getTypeMappingDefinition(mappingKey);
        XmlTypeMapping xmlTypeMapping = mappingDefinition.buildResourceMapping(this.getResourceNodeFactory());
        this.mapping = this.buildMapping(xmlTypeMapping);
        this.getEntityMappings().changeMapping(this, old, this.mapping);
        this.firePropertyChanged("mapping", old, this.mapping);
    }

    protected OrmTypeMapping buildMapping(XmlTypeMapping xmlTypeMapping) {
        OrmTypeMappingDefinition md = this.getMappingFileDefinition().getTypeMappingDefinition(xmlTypeMapping.getMappingKey());
        return md.buildContextMapping(this, xmlTypeMapping, this.getContextNodeFactory());
    }

    protected XmlTypeMapping getXmlTypeMapping() {
        return this.mapping.getXmlTypeMapping();
    }

    @Override
    public boolean isMapped() {
        return true;
    }

    @Override
    public String getName() {
        return this.javaPersistentType != null ? this.javaPersistentType.getName() : this.convertMappingClassName(this.mapping.getClass_());
    }

    @Override
    public String getSimpleName() {
        String className = this.getName();
        return StringTools.stringIsEmpty((String)className) ? null : ClassName.getSimpleName((String)className);
    }

    @Override
    public void mappingClassChanged(String oldClass, String newClass) {
        this.firePropertyChanged("name", this.convertMappingClassName(oldClass), this.convertMappingClassName(newClass));
        if (this.javaPersistentType != null) {
            this.javaPersistentType.dispose();
            this.setJavaPersistentType(null);
        }
    }

    protected String convertMappingClassName(String name) {
        return name == null ? null : name.replace('$', '.');
    }

    @Override
    public JavaPersistentType getJavaPersistentType() {
        return this.javaPersistentType;
    }

    protected void setJavaPersistentType(JavaPersistentType javaPersistentType) {
        JavaPersistentType old = this.javaPersistentType;
        this.javaPersistentType = javaPersistentType;
        this.firePropertyChanged("javaPersistentType", old, javaPersistentType);
    }

    protected void syncJavaPersistentType() {
        if (this.javaPersistentType != null) {
            this.javaPersistentType.synchronizeWithResourceModel();
        }
    }

    protected void updateJavaPersistentType() {
        JavaResourcePersistentType resourceType = this.resolveJavaResourcePersistentType();
        if (resourceType == null) {
            if (this.javaPersistentType != null) {
                this.javaPersistentType.dispose();
                this.setJavaPersistentType(null);
            }
        } else if (this.javaPersistentType == null) {
            this.setJavaPersistentType(this.buildJavaPersistentType(resourceType));
        } else if (this.javaPersistentType.getResourcePersistentType() == resourceType) {
            this.javaPersistentType.update();
        } else {
            this.javaPersistentType.dispose();
            this.setJavaPersistentType(this.buildJavaPersistentType(resourceType));
        }
    }

    protected JavaResourcePersistentType resolveJavaResourcePersistentType() {
        return this.getEntityMappings().resolveJavaResourcePersistentType(this.getName());
    }

    protected JavaPersistentType buildJavaPersistentType(JavaResourcePersistentType jrpt) {
        return this.getJpaFactory().buildJavaPersistentType(this, jrpt);
    }

    @Override
    public AccessType getAccess() {
        return this.specifiedAccess != null ? this.specifiedAccess : this.defaultAccess;
    }

    @Override
    public AccessType getSpecifiedAccess() {
        return this.specifiedAccess;
    }

    @Override
    public void setSpecifiedAccess(AccessType access) {
        this.setSpecifiedAccess_(access);
        this.getXmlTypeMapping().setAccess(AccessType.toOrmResourceModel(access));
    }

    protected void setSpecifiedAccess_(AccessType access) {
        AccessType old = this.specifiedAccess;
        this.specifiedAccess = access;
        this.firePropertyChanged("specifiedAccess", (Object)old, (Object)access);
    }

    protected AccessType buildSpecifiedAccess() {
        return AccessType.fromOrmResourceModel(this.getXmlTypeMapping().getAccess());
    }

    @Override
    public AccessType getDefaultAccess() {
        return this.defaultAccess;
    }

    protected void setDefaultAccess(AccessType access) {
        AccessType old = this.defaultAccess;
        this.defaultAccess = access;
        this.firePropertyChanged("defaultAccess", (Object)old, (Object)access);
    }

    protected AccessType buildDefaultAccess() {
        AccessType access;
        if (!this.mapping.isMetadataComplete() && this.javaPersistentType != null) {
            if (this.javaPersistentTypeHasSpecifiedAccess()) {
                return this.javaPersistentType.getAccess();
            }
            if (this.superPersistentType != null) {
                return this.superPersistentType.getAccess();
            }
        }
        return (access = this.getMappingFileRoot().getAccess()) != null ? access : AccessType.FIELD;
    }

    protected boolean javaPersistentTypeHasSpecifiedAccess() {
        return this.javaPersistentType.getSpecifiedAccess() != null || this.javaPersistentType.hasAnyAnnotatedAttributes();
    }

    @Override
    public AccessType getOwnerOverrideAccess() {
        return this.getEntityMappings().getOverridePersistentTypeAccess();
    }

    @Override
    public AccessType getOwnerDefaultAccess() {
        return this.getEntityMappings().getDefaultPersistentTypeAccess();
    }

    @Override
    public ListIterator<OrmReadOnlyPersistentAttribute> attributes() {
        return this.getAttributes().iterator();
    }

    public ListIterable<OrmReadOnlyPersistentAttribute> getAttributes() {
        return new CompositeListIterable(new ListIterable[]{this.getReadOnlySpecifiedAttributes(), this.getVirtualAttributes()});
    }

    @Override
    public int attributesSize() {
        return this.specifiedAttributesSize() + this.virtualAttributesSize();
    }

    @Override
    public Iterator<String> attributeNames() {
        return this.getAttributeNames().iterator();
    }

    public Iterable<String> getAttributeNames() {
        return this.convertToNames((Iterable<? extends ReadOnlyPersistentAttribute>)this.getAttributes());
    }

    @Override
    public OrmReadOnlyPersistentAttribute getAttributeNamed(String attributeName) {
        Iterator<OrmReadOnlyPersistentAttribute> stream = this.getAttributesNamed(attributeName).iterator();
        return stream.hasNext() ? stream.next() : null;
    }

    @Override
    public Iterator<ReadOnlyPersistentAttribute> allAttributes() {
        return this.getAllAttributes().iterator();
    }

    public Iterable<ReadOnlyPersistentAttribute> getAllAttributes() {
        return new CompositeIterable((Iterable)new TransformationIterable<PersistentType, Iterable<ReadOnlyPersistentAttribute>>(this.getInheritanceHierarchy()){

            protected Iterable<ReadOnlyPersistentAttribute> transform(PersistentType pt) {
                return new SnapshotCloneIterable(pt.attributes());
            }
        });
    }

    @Override
    public Iterator<String> allAttributeNames() {
        return this.getAllAttributeNames().iterator();
    }

    public Iterable<String> getAllAttributeNames() {
        return this.convertToNames(this.getAllAttributes());
    }

    protected Iterable<OrmReadOnlyPersistentAttribute> getAttributesNamed(final String attributeName) {
        return new FilteringIterable<OrmReadOnlyPersistentAttribute>(this.getAttributes()){

            protected boolean accept(OrmReadOnlyPersistentAttribute attribute) {
                return Tools.valuesAreEqual((Object)attributeName, (Object)attribute.getName());
            }
        };
    }

    @Override
    public ReadOnlyPersistentAttribute resolveAttribute(String attributeName) {
        Iterator<OrmReadOnlyPersistentAttribute> attributes = this.getAttributesNamed(attributeName).iterator();
        if (attributes.hasNext()) {
            OrmReadOnlyPersistentAttribute attribute = attributes.next();
            return attributes.hasNext() ? null : attribute;
        }
        return this.superPersistentType == null ? null : this.superPersistentType.resolveAttribute(attributeName);
    }

    protected Iterable<String> convertToNames(Iterable<? extends ReadOnlyPersistentAttribute> attributes) {
        return new TransformationIterable<ReadOnlyPersistentAttribute, String>(attributes){

            protected String transform(ReadOnlyPersistentAttribute attribute) {
                return attribute.getName();
            }
        };
    }

    @Override
    public OrmPersistentAttribute convertAttributeToSpecified(OrmReadOnlyPersistentAttribute virtualAttribute) {
        return this.convertAttributeToSpecified(virtualAttribute, virtualAttribute.getMappingKey());
    }

    @Override
    public OrmPersistentAttribute convertAttributeToSpecified(OrmReadOnlyPersistentAttribute virtualAttribute, String mappingKey) {
        if (!virtualAttribute.isVirtual()) {
            throw new IllegalArgumentException("Attribute is already specified: " + virtualAttribute);
        }
        if (mappingKey == null) {
            throw new IllegalArgumentException("Use convertAttributeToSpecified(OrmReadOnlyPersistentAttribute, String) instead and specify a mapping key");
        }
        return this.convertAttributeToSpecified_(virtualAttribute, mappingKey);
    }

    protected OrmPersistentAttribute convertAttributeToSpecified_(OrmReadOnlyPersistentAttribute virtualAttribute, String mappingKey) {
        int virtualIndex = this.virtualAttributes.indexOf(virtualAttribute);
        this.virtualAttributes.remove(virtualIndex);
        virtualAttribute.dispose();
        OrmAttributeMappingDefinition md = this.getMappingFileDefinition().getAttributeMappingDefinition(mappingKey);
        XmlAttributeMapping xmlMapping = md.buildResourceMapping(this.getResourceNodeFactory());
        OrmPersistentAttribute specifiedAttribute = this.buildSpecifiedAttribute(xmlMapping);
        int specifiedIndex = this.getSpecifiedAttributeInsertionIndex(specifiedAttribute);
        this.specifiedAttributes.add(specifiedIndex, specifiedAttribute);
        specifiedAttribute.getMapping().setName(virtualAttribute.getName());
        this.fireItemRemoved("virtualAttributes", virtualIndex, virtualAttribute);
        this.fireItemAdded("specifiedAttributes", specifiedIndex, specifiedAttribute);
        Attributes xmlAttributes = this.getXmlAttributesForUpdate();
        specifiedAttribute.getMapping().addXmlAttributeMappingTo(xmlAttributes);
        this.getXmlTypeMapping().setAttributes(xmlAttributes);
        AccessType oldAccess = virtualAttribute.getJavaPersistentAttribute().getSpecifiedAccess();
        if (oldAccess != null) {
            specifiedAttribute.setSpecifiedAccess(oldAccess);
        }
        return specifiedAttribute;
    }

    @Override
    public OrmPersistentAttribute addSpecifiedAttribute(String mappingKey, String attributeName) {
        Attributes xmlAttributes = this.getXmlAttributesForUpdate();
        this.getXmlTypeMapping().setAttributes(xmlAttributes);
        OrmAttributeMappingDefinition md = this.getMappingFileDefinition().getAttributeMappingDefinition(mappingKey);
        XmlAttributeMapping xmlMapping = md.buildResourceMapping(this.getResourceNodeFactory());
        OrmPersistentAttribute specifiedAttribute = this.buildSpecifiedAttribute(xmlMapping);
        int specifiedIndex = this.getSpecifiedAttributeInsertionIndex(specifiedAttribute);
        this.addItemToList(specifiedIndex, specifiedAttribute, this.specifiedAttributes, "specifiedAttributes");
        specifiedAttribute.getMapping().addXmlAttributeMappingTo(xmlAttributes);
        specifiedAttribute.getMapping().setName(attributeName);
        return specifiedAttribute;
    }

    protected int getSpecifiedAttributeInsertionIndex(OrmPersistentAttribute attribute) {
        return CollectionTools.insertionIndexOf(this.specifiedAttributes, (Object)attribute, this.getAttributeComparator());
    }

    protected Comparator<OrmPersistentAttribute> getAttributeComparator() {
        return ATTRIBUTE_COMPARATOR;
    }

    @Override
    public OrmReadOnlyPersistentAttribute convertAttributeToVirtual(OrmPersistentAttribute specifiedAttribute) {
        if (specifiedAttribute.isVirtual()) {
            throw new IllegalArgumentException("Attribute is already virtual: " + specifiedAttribute);
        }
        int virtualIndex = this.virtualAttributes.size();
        OrmReadOnlyPersistentAttribute virtualAttribute = null;
        JavaResourcePersistentAttribute javaResourceAttribute = specifiedAttribute.getJavaResourcePersistentAttribute();
        if (javaResourceAttribute != null && this.javaResourceAttributeWillBeVirtual(javaResourceAttribute, specifiedAttribute)) {
            virtualAttribute = this.buildVirtualAttribute(javaResourceAttribute);
            this.virtualAttributes.add(virtualIndex, virtualAttribute);
        }
        this.removeSpecifiedAttribute(specifiedAttribute);
        if (virtualAttribute != null) {
            this.fireItemAdded("virtualAttributes", virtualIndex, virtualAttribute);
        }
        return virtualAttribute;
    }

    protected boolean javaResourceAttributeWillBeVirtual(JavaResourcePersistentAttribute javaResourceAttribute, OrmPersistentAttribute specifiedAttributeToBeRemoved) {
        return CollectionTools.contains(this.getJavaResourceAttributes(), (Object)javaResourceAttribute) && this.getSpecifiedAttributeFor(javaResourceAttribute, specifiedAttributeToBeRemoved) == null;
    }

    protected Attributes getXmlAttributes() {
        return this.getXmlTypeMapping().getAttributes();
    }

    protected Attributes getXmlAttributesForUpdate() {
        Attributes xmlAttributes = this.getXmlAttributes();
        return xmlAttributes != null ? xmlAttributes : this.buildXmlAttributes();
    }

    protected Attributes buildXmlAttributes() {
        return EmfTools.create(this.getResourceNodeFactory(), OrmPackage.eINSTANCE.getAttributes(), Attributes.class);
    }

    protected void removeXmlAttributesIfUnset() {
        if (this.getXmlAttributes().isUnset()) {
            this.getXmlTypeMapping().setAttributes(null);
        }
    }

    @Override
    public ListIterator<OrmPersistentAttribute> specifiedAttributes() {
        return this.getSpecifiedAttributes().iterator();
    }

    protected ListIterable<OrmPersistentAttribute> getSpecifiedAttributes() {
        return new LiveCloneListIterable(this.specifiedAttributes);
    }

    protected ListIterable<OrmReadOnlyPersistentAttribute> getReadOnlySpecifiedAttributes() {
        return new SuperListIterableWrapper(this.getSpecifiedAttributes());
    }

    @Override
    public int specifiedAttributesSize() {
        return this.specifiedAttributes.size();
    }

    protected void removeSpecifiedAttribute(OrmPersistentAttribute attribute) {
        this.removeSpecifiedAttribute_(attribute);
        attribute.getMapping().removeXmlAttributeMappingFrom(this.getXmlAttributes());
        this.removeXmlAttributesIfUnset();
    }

    @Override
    public void changeMapping(OrmPersistentAttribute attribute, OrmAttributeMapping oldMapping, OrmAttributeMapping newMapping) {
        int sourceIndex = this.specifiedAttributes.indexOf(attribute);
        this.specifiedAttributes.remove(sourceIndex);
        oldMapping.removeXmlAttributeMappingFrom(this.getXmlAttributes());
        int targetIndex = this.getSpecifiedAttributeInsertionIndex(attribute);
        this.specifiedAttributes.add(targetIndex, attribute);
        newMapping.addXmlAttributeMappingTo(this.getXmlAttributes());
        oldMapping.initializeOn(newMapping);
        this.fireItemMoved("specifiedAttributes", targetIndex, sourceIndex);
    }

    protected void initializeSpecifiedAttributes() {
        for (XmlAttributeMapping xmlMapping : this.getXmlAttributeMappings()) {
            this.specifiedAttributes.add(this.buildSpecifiedAttribute(xmlMapping));
        }
    }

    protected Iterable<XmlAttributeMapping> getXmlAttributeMappings() {
        Attributes xmlAttributes = this.getXmlAttributes();
        return xmlAttributes != null ? xmlAttributes.getAttributeMappings() : EmptyIterable.instance();
    }

    protected OrmPersistentAttribute buildSpecifiedAttribute(XmlAttributeMapping xmlMapping) {
        return this.getContextNodeFactory().buildOrmPersistentAttribute(this, xmlMapping);
    }

    protected void syncSpecifiedAttributes() {
        ContextContainerTools.synchronizeWithResourceModel(this.specifiedAttributeContainerAdapter);
    }

    protected void moveSpecifiedAttribute_(int index, OrmPersistentAttribute attribute) {
        this.moveItemInList(index, attribute, this.specifiedAttributes, "specifiedAttributes");
    }

    protected void addSpecifiedAttribute_(int index, XmlAttributeMapping xmlMapping) {
        OrmPersistentAttribute attribute = this.buildSpecifiedAttribute(xmlMapping);
        this.addItemToList(index, attribute, this.specifiedAttributes, "specifiedAttributes");
    }

    protected void removeSpecifiedAttribute_(OrmPersistentAttribute attribute) {
        this.removeItemFromList(attribute, this.specifiedAttributes, "specifiedAttributes");
    }

    @Override
    public ListIterator<OrmReadOnlyPersistentAttribute> virtualAttributes() {
        return this.getVirtualAttributes().iterator();
    }

    public ListIterable<OrmReadOnlyPersistentAttribute> getVirtualAttributes() {
        return new LiveCloneListIterable(this.virtualAttributes);
    }

    @Override
    public int virtualAttributesSize() {
        return this.virtualAttributes.size();
    }

    protected void updateVirtualAttributes() {
        ContextContainerTools.update(this.virtualAttributeContainerAdapter);
    }

    protected Iterable<JavaResourcePersistentAttribute> getVirtualJavaResourceAttributes() {
        return new FilteringIterable<JavaResourcePersistentAttribute>(this.getJavaResourceAttributes()){

            protected boolean accept(JavaResourcePersistentAttribute javaResourceAttribute) {
                return GenericOrmPersistentType.this.javaResourceAttributeIsVirtual(javaResourceAttribute);
            }
        };
    }

    protected Iterable<JavaResourcePersistentAttribute> getJavaResourceAttributes() {
        return CollectionTools.iterable(this.javaResourceAttributes());
    }

    protected Iterator<JavaResourcePersistentAttribute> javaResourceAttributes() {
        JavaResourcePersistentType javaResourceType = this.getJavaResourceType();
        return javaResourceType != null ? javaResourceType.persistableAttributes(this.getVirtualJavaAccess().getJavaAccessType()) : EmptyListIterator.instance();
    }

    protected JavaResourcePersistentType getJavaResourceType() {
        return this.javaPersistentType == null ? null : this.javaPersistentType.getResourcePersistentType();
    }

    protected AccessType getVirtualJavaAccess() {
        if (this.specifiedAccess != null) {
            return this.specifiedAccess;
        }
        if (this.mapping.isMetadataComplete()) {
            return this.defaultAccess;
        }
        AccessType javaAccess = this.javaPersistentType.getSpecifiedAccess();
        return javaAccess != null ? javaAccess : this.defaultAccess;
    }

    protected boolean javaResourceAttributeIsVirtual(JavaResourcePersistentAttribute javaResourceAttribute) {
        return this.getSpecifiedAttributeFor(javaResourceAttribute) == null;
    }

    protected OrmPersistentAttribute getSpecifiedAttributeFor(JavaResourcePersistentAttribute javaResourceAttribute) {
        return this.getSpecifiedAttributeFor(javaResourceAttribute, null);
    }

    protected OrmPersistentAttribute getSpecifiedAttributeFor(JavaResourcePersistentAttribute javaResourceAttribute, OrmPersistentAttribute exclude) {
        for (OrmPersistentAttribute ormAttribute : this.getSpecifiedAttributes()) {
            if (ormAttribute == exclude || ormAttribute.getJavaResourcePersistentAttribute() != javaResourceAttribute) continue;
            return ormAttribute;
        }
        return null;
    }

    protected void moveVirtualAttribute(int index, OrmReadOnlyPersistentAttribute virtualAttribute) {
        this.moveItemInList(index, virtualAttribute, this.virtualAttributes, "virtualAttributes");
    }

    protected void addVirtualAttribute(int index, JavaResourcePersistentAttribute javaResourceAttribute) {
        OrmReadOnlyPersistentAttribute virtualAttribute = this.buildVirtualAttribute(javaResourceAttribute);
        this.addItemToList(index, virtualAttribute, this.virtualAttributes, "virtualAttributes");
    }

    protected OrmReadOnlyPersistentAttribute buildVirtualAttribute(JavaResourcePersistentAttribute javaResourceAttribute) {
        return this.getContextNodeFactory().buildVirtualOrmPersistentAttribute(this, javaResourceAttribute);
    }

    protected void removeVirtualAttribute(OrmReadOnlyPersistentAttribute virtualAttribute) {
        virtualAttribute.dispose();
        this.removeItemFromList(virtualAttribute, this.virtualAttributes, "virtualAttributes");
    }

    @Override
    public PersistentType getSuperPersistentType() {
        return this.superPersistentType;
    }

    protected void setSuperPersistentType(PersistentType persistentType) {
        PersistentType old = this.superPersistentType;
        this.superPersistentType = persistentType;
        this.firePropertyChanged("superPersistentType", old, persistentType);
    }

    protected PersistentType buildSuperPersistentType() {
        PersistentType spt = this.buildSuperPersistentType_();
        if (spt == null) {
            return null;
        }
        return CollectionTools.contains(spt.inheritanceHierarchy(), (Object)this) ? null : spt;
    }

    protected PersistentType buildSuperPersistentType_() {
        return this.javaPersistentType == null ? null : this.javaPersistentType.getSuperPersistentType();
    }

    @Override
    public Iterator<PersistentType> inheritanceHierarchy() {
        return this.getInheritanceHierarchy().iterator();
    }

    public Iterable<PersistentType> getInheritanceHierarchy() {
        return this.getInheritanceHierarchyOf(this);
    }

    @Override
    public Iterator<PersistentType> ancestors() {
        return this.getAncestors().iterator();
    }

    public Iterable<PersistentType> getAncestors() {
        return this.getInheritanceHierarchyOf(this.superPersistentType);
    }

    protected Iterable<PersistentType> getInheritanceHierarchyOf(PersistentType start) {
        return new ChainIterable<PersistentType>(start){

            protected PersistentType nextLink(PersistentType persistentType) {
                return persistentType.getSuperPersistentType();
            }
        };
    }

    @Override
    public String getDeclaringTypeName() {
        return this.declaringTypeName;
    }

    protected void setDeclaringTypeName(String name) {
        String old = this.declaringTypeName;
        this.declaringTypeName = name;
        this.firePropertyChanged("declaringTypeName", old, name);
    }

    protected String buildDeclaringTypeName() {
        return this.isJpa2_0Compatible() ? this.buildDeclaringTypeName_() : null;
    }

    protected String buildDeclaringTypeName_() {
        return this.javaPersistentType == null ? null : ((JavaPersistentType2_0)this.javaPersistentType).getDeclaringTypeName();
    }

    protected MetamodelSourceType.Synchronizer buildMetamodelSynchronizer() {
        return this.isJpa2_0Compatible() ? this.getJpaFactory2_0().buildMetamodelSynchronizer(this) : null;
    }

    @Override
    public IFile getMetamodelFile() {
        return this.javaPersistentType == null ? null : this.metamodelSynchronizer.getFile();
    }

    public void initializeMetamodel() {
    }

    @Override
    public boolean isManaged() {
        return true;
    }

    @Override
    public void synchronizeMetamodel(Map<String, Collection<MetamodelSourceType>> memberTypeTree) {
        if (this.javaPersistentType != null) {
            this.metamodelSynchronizer.synchronize(memberTypeTree);
        }
    }

    @Override
    public void printBodySourceOn(BodySourceWriter pw, Map<String, Collection<MetamodelSourceType>> memberTypeTree) {
        if (this.javaPersistentType != null) {
            this.metamodelSynchronizer.printBodySourceOn(pw, memberTypeTree);
        }
    }

    public void disposeMetamodel() {
    }

    @Override
    public String getId() {
        return "org.eclipse.jpt.jpa.core.orm.persistentType";
    }

    @Override
    public JpaStructureNode getStructureNode(int textOffset) {
        for (OrmPersistentAttribute attribute : this.getSpecifiedAttributes()) {
            if (!attribute.contains(textOffset)) continue;
            return attribute;
        }
        return this;
    }

    @Override
    public TextRange getSelectionTextRange() {
        return this.mapping.getSelectionTextRange();
    }

    @Override
    public void dispose() {
        if (this.javaPersistentType != null) {
            this.javaPersistentType.dispose();
        }
        for (OrmReadOnlyPersistentAttribute virtualAttribute : this.getVirtualAttributes()) {
            virtualAttribute.dispose();
        }
    }

    @Override
    public AccessType getOverridePersistentTypeAccess() {
        AccessType accessType;
        if (this.specifiedAccess != null) {
            return this.specifiedAccess;
        }
        if (this.superPersistentType instanceof OrmPersistentType && (accessType = ((OrmPersistentType)this.superPersistentType).getSpecifiedAccess()) != null) {
            return accessType;
        }
        if (this.mapping.isMetadataComplete() && (accessType = this.getOwnerDefaultAccess()) != null) {
            return accessType;
        }
        return null;
    }

    @Override
    public AccessType getDefaultPersistentTypeAccess() {
        AccessType accessType;
        if (this.superPersistentType instanceof OrmPersistentType && (accessType = ((OrmPersistentType)this.superPersistentType).getDefaultAccess()) != null) {
            return accessType;
        }
        return this.getOwnerDefaultAccess();
    }

    @Override
    public Iterable<DeleteEdit> createDeleteTypeEdits(IType type) {
        return this.isFor(type.getFullyQualifiedName('.')) ? new SingleElementIterable((Object)this.mapping.createDeleteEdit()) : EmptyIterable.instance();
    }

    @Override
    public Iterable<ReplaceEdit> createRenameTypeEdits(IType originalType, String newName) {
        return new CompositeIterable(new Iterable[]{this.mapping.createRenameTypeEdits(originalType, newName), this.createSpecifiedAttributesRenameTypeEdits(originalType, newName)});
    }

    protected Iterable<ReplaceEdit> createSpecifiedAttributesRenameTypeEdits(final IType originalType, final String newName) {
        return new CompositeIterable((Iterable)new TransformationIterable<OrmPersistentAttribute, Iterable<ReplaceEdit>>(this.getSpecifiedAttributes()){

            protected Iterable<ReplaceEdit> transform(OrmPersistentAttribute persistentAttribute) {
                return persistentAttribute.createRenameTypeEdits(originalType, newName);
            }
        });
    }

    @Override
    public Iterable<ReplaceEdit> createMoveTypeEdits(IType originalType, IPackageFragment newPackage) {
        return new CompositeIterable(new Iterable[]{this.mapping.createMoveTypeEdits(originalType, newPackage), this.createSpecifiedAttributesMoveTypeEdits(originalType, newPackage)});
    }

    protected Iterable<ReplaceEdit> createSpecifiedAttributesMoveTypeEdits(final IType originalType, final IPackageFragment newPackage) {
        return new CompositeIterable((Iterable)new TransformationIterable<OrmPersistentAttribute, Iterable<ReplaceEdit>>(this.getSpecifiedAttributes()){

            protected Iterable<ReplaceEdit> transform(OrmPersistentAttribute persistentAttribute) {
                return persistentAttribute.createMoveTypeEdits(originalType, newPackage);
            }
        });
    }

    @Override
    public Iterable<ReplaceEdit> createRenamePackageEdits(IPackageFragment originalPackage, String newName) {
        return new CompositeIterable(new Iterable[]{this.mapping.createRenamePackageEdits(originalPackage, newName), this.createSpecifiedAttributesRenamePackageEdits(originalPackage, newName)});
    }

    protected Iterable<ReplaceEdit> createSpecifiedAttributesRenamePackageEdits(final IPackageFragment originalPackage, final String newName) {
        return new CompositeIterable((Iterable)new TransformationIterable<OrmPersistentAttribute, Iterable<ReplaceEdit>>(this.getSpecifiedAttributes()){

            protected Iterable<ReplaceEdit> transform(OrmPersistentAttribute persistentAttribute) {
                return persistentAttribute.createRenamePackageEdits(originalPackage, newName);
            }
        });
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        this.validateClass(messages);
        this.validateMapping(messages, reporter);
        this.validateAttributes(messages, reporter);
    }

    protected void validateClass(List<IMessage> messages) {
        if (this.javaPersistentType == null) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "PERSISTENT_TYPE_UNRESOLVED_CLASS", new String[]{this.getName()}, this, this.mapping.getClassTextRange()));
        }
    }

    protected void validateMapping(List<IMessage> messages, IReporter reporter) {
        try {
            this.mapping.validate(messages, reporter);
        }
        catch (Throwable t) {
            JptJpaCorePlugin.log(t);
        }
    }

    protected void validateAttributes(List<IMessage> messages, IReporter reporter) {
        ListIterator<OrmReadOnlyPersistentAttribute> stream = this.attributes();
        while (stream.hasNext()) {
            this.validateAttribute((OrmReadOnlyPersistentAttribute)stream.next(), messages, reporter);
        }
    }

    protected void validateAttribute(OrmReadOnlyPersistentAttribute attribute, List<IMessage> messages, IReporter reporter) {
        try {
            attribute.validate(messages, reporter);
        }
        catch (Throwable t) {
            JptJpaCorePlugin.log(t);
        }
    }

    @Override
    public TextRange getValidationTextRange() {
        TextRange textRange = this.mapping.getValidationTextRange();
        return textRange != null ? textRange : this.getEntityMappings().getValidationTextRange();
    }

    @Override
    public EntityMappings getParent() {
        return (EntityMappings)super.getParent();
    }

    protected EntityMappings getEntityMappings() {
        return this.getParent();
    }

    @Override
    public String getDefaultPackage() {
        return this.getEntityMappings().getPackage();
    }

    @Override
    public boolean isFor(String typeName) {
        String name = this.getName();
        if (name == null) {
            return false;
        }
        if (name.equals(typeName)) {
            return true;
        }
        String defaultPackage = this.getDefaultPackage();
        if (defaultPackage == null) {
            return false;
        }
        return (String.valueOf(defaultPackage) + '.' + name).equals(typeName);
    }

    @Override
    public boolean isIn(IPackageFragment packageFragment) {
        String packageName = this.getPackageName();
        if (Tools.valuesAreEqual((Object)packageName, (Object)packageFragment.getElementName())) {
            return true;
        }
        String defaultPackage = this.getDefaultPackage();
        if (defaultPackage == null) {
            return false;
        }
        packageName = packageName == null ? defaultPackage : String.valueOf(defaultPackage) + '.' + packageName;
        return packageName.equals(packageFragment.getElementName());
    }

    protected String getPackageName() {
        String className = this.getName();
        if (className == null) {
            return null;
        }
        int lastPeriod = className.lastIndexOf(46);
        return lastPeriod == -1 ? null : className.substring(0, lastPeriod);
    }

    @Override
    public boolean contains(int textOffset) {
        return this.mapping.containsOffset(textOffset);
    }

    public void toString(StringBuilder sb) {
        sb.append(this.getName());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class SpecifiedAttributeContainerAdapter
    implements ContextContainerTools.Adapter<OrmPersistentAttribute, XmlAttributeMapping> {
        protected SpecifiedAttributeContainerAdapter() {
        }

        @Override
        public Iterable<OrmPersistentAttribute> getContextElements() {
            return GenericOrmPersistentType.this.getSpecifiedAttributes();
        }

        @Override
        public Iterable<XmlAttributeMapping> getResourceElements() {
            return GenericOrmPersistentType.this.getXmlAttributeMappings();
        }

        @Override
        public XmlAttributeMapping getResourceElement(OrmPersistentAttribute contextElement) {
            return contextElement.getMapping().getXmlAttributeMapping();
        }

        @Override
        public void moveContextElement(int index, OrmPersistentAttribute element) {
            GenericOrmPersistentType.this.moveSpecifiedAttribute_(index, element);
        }

        @Override
        public void addContextElement(int index, XmlAttributeMapping resourceElement) {
            GenericOrmPersistentType.this.addSpecifiedAttribute_(index, resourceElement);
        }

        @Override
        public void removeContextElement(OrmPersistentAttribute element) {
            GenericOrmPersistentType.this.removeSpecifiedAttribute_(element);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class VirtualAttributeContainerAdapter
    implements ContextContainerTools.Adapter<OrmReadOnlyPersistentAttribute, JavaResourcePersistentAttribute> {
        protected VirtualAttributeContainerAdapter() {
        }

        @Override
        public Iterable<OrmReadOnlyPersistentAttribute> getContextElements() {
            return GenericOrmPersistentType.this.getVirtualAttributes();
        }

        @Override
        public Iterable<JavaResourcePersistentAttribute> getResourceElements() {
            return GenericOrmPersistentType.this.getVirtualJavaResourceAttributes();
        }

        @Override
        public JavaResourcePersistentAttribute getResourceElement(OrmReadOnlyPersistentAttribute contextElement) {
            return contextElement.getJavaResourcePersistentAttribute();
        }

        @Override
        public void moveContextElement(int index, OrmReadOnlyPersistentAttribute element) {
            GenericOrmPersistentType.this.moveVirtualAttribute(index, element);
        }

        @Override
        public void addContextElement(int index, JavaResourcePersistentAttribute resourceElement) {
            GenericOrmPersistentType.this.addVirtualAttribute(index, resourceElement);
        }

        @Override
        public void removeContextElement(OrmReadOnlyPersistentAttribute element) {
            GenericOrmPersistentType.this.removeVirtualAttribute(element);
        }
    }
}

