/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.context.orm;

import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jpt.common.utility.internal.ArrayTools;
import org.eclipse.jpt.common.utility.internal.iterables.ArrayIterable;
import org.eclipse.jpt.common.utility.internal.iterables.CompositeIterable;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyIterable;
import org.eclipse.jpt.jpa.core.context.BaseColumn;
import org.eclipse.jpt.jpa.core.context.Converter;
import org.eclipse.jpt.jpa.core.context.NamedColumn;
import org.eclipse.jpt.jpa.core.context.PersistentAttribute;
import org.eclipse.jpt.jpa.core.context.orm.OrmAttributeMapping;
import org.eclipse.jpt.jpa.core.context.orm.OrmColumn;
import org.eclipse.jpt.jpa.core.context.orm.OrmColumnMapping;
import org.eclipse.jpt.jpa.core.context.orm.OrmConverter;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.orm.OrmTemporalConverter;
import org.eclipse.jpt.jpa.core.context.orm.OrmVersionMapping;
import org.eclipse.jpt.jpa.core.context.orm.OrmXmlContextNodeFactory;
import org.eclipse.jpt.jpa.core.internal.context.BaseColumnTextRangeResolver;
import org.eclipse.jpt.jpa.core.internal.context.JptValidator;
import org.eclipse.jpt.jpa.core.internal.context.NamedColumnTextRangeResolver;
import org.eclipse.jpt.jpa.core.internal.context.orm.AbstractOrmAttributeMapping;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.AbstractNamedColumnValidator;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.EntityTableDescriptionProvider;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.NamedColumnValidator;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.orm.NullOrmConverter;
import org.eclipse.jpt.jpa.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.jpa.core.resource.orm.Attributes;
import org.eclipse.jpt.jpa.core.resource.orm.OrmFactory;
import org.eclipse.jpt.jpa.core.resource.orm.XmlColumn;
import org.eclipse.jpt.jpa.core.resource.orm.XmlConvertibleMapping;
import org.eclipse.jpt.jpa.core.resource.orm.XmlVersion;
import org.eclipse.jpt.jpa.db.Table;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOrmVersionMapping<X extends XmlVersion>
extends AbstractOrmAttributeMapping<X>
implements OrmVersionMapping {
    protected final OrmColumn column = this.buildColumn();
    protected OrmConverter converter = this.buildConverter();
    protected static final OrmConverter.Adapter[] CONVERTER_ADAPTER_ARRAY = new OrmConverter.Adapter[]{OrmTemporalConverter.Adapter.instance()};
    protected static final Iterable<OrmConverter.Adapter> CONVERTER_ADAPTERS = new ArrayIterable((Object[])CONVERTER_ADAPTER_ARRAY);

    protected AbstractOrmVersionMapping(OrmPersistentAttribute parent, X xmlMapping) {
        super(parent, xmlMapping);
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.column.synchronizeWithResourceModel();
        this.syncConverter();
    }

    @Override
    public void update() {
        super.update();
        this.column.update();
        this.converter.update();
    }

    @Override
    public OrmColumn getColumn() {
        return this.column;
    }

    protected OrmColumn buildColumn() {
        return this.getContextNodeFactory().buildOrmColumn(this, this);
    }

    @Override
    public OrmConverter getConverter() {
        return this.converter;
    }

    @Override
    public void setConverter(Class<? extends Converter> converterType) {
        if (this.converter.getType() != converterType) {
            this.clearXmlConverterValues();
            OrmConverter.Adapter converterAdapter = this.getConverterAdapter(converterType);
            this.setConverter_(this.buildConverter(converterAdapter));
            this.converter.initialize();
        }
    }

    protected OrmConverter buildConverter(OrmConverter.Adapter converterAdapter) {
        return converterAdapter != null ? converterAdapter.buildNewConverter(this, this.getContextNodeFactory()) : this.buildNullConverter();
    }

    protected void setConverter_(OrmConverter converter) {
        OrmConverter old = this.converter;
        this.converter = converter;
        this.firePropertyChanged("converter", old, converter);
    }

    protected void clearXmlConverterValues() {
        for (OrmConverter.Adapter adapter : this.getConverterAdapters()) {
            adapter.clearXmlValue((XmlConvertibleMapping)((Object)this.xmlAttributeMapping));
        }
    }

    protected OrmConverter buildConverter() {
        OrmXmlContextNodeFactory factory = this.getContextNodeFactory();
        for (OrmConverter.Adapter adapter : this.getConverterAdapters()) {
            OrmConverter ormConverter = adapter.buildConverter(this, factory);
            if (ormConverter == null) continue;
            return ormConverter;
        }
        return this.buildNullConverter();
    }

    protected void syncConverter() {
        OrmConverter.Adapter adapter = this.getXmlConverterAdapter();
        if (adapter == null) {
            if (this.converter.getType() != null) {
                this.setConverter_(this.buildNullConverter());
            }
        } else if (this.converter.getType() == adapter.getConverterType()) {
            this.converter.synchronizeWithResourceModel();
        } else {
            this.setConverter_(adapter.buildNewConverter(this, this.getContextNodeFactory()));
        }
    }

    protected OrmConverter.Adapter getXmlConverterAdapter() {
        for (OrmConverter.Adapter adapter : this.getConverterAdapters()) {
            if (!adapter.isActive((XmlConvertibleMapping)((Object)this.xmlAttributeMapping))) continue;
            return adapter;
        }
        return null;
    }

    protected OrmConverter buildNullConverter() {
        return new NullOrmConverter(this);
    }

    protected OrmConverter.Adapter getConverterAdapter(Class<? extends Converter> converterType) {
        for (OrmConverter.Adapter adapter : this.getConverterAdapters()) {
            if (adapter.getConverterType() != converterType) continue;
            return adapter;
        }
        return null;
    }

    protected Iterable<OrmConverter.Adapter> getConverterAdapters() {
        return CONVERTER_ADAPTERS;
    }

    @Override
    public String getKey() {
        return "version";
    }

    @Override
    public int getXmlSequence() {
        return 30;
    }

    @Override
    public void initializeOn(OrmAttributeMapping newMapping) {
        newMapping.initializeFromOrmVersionMapping(this);
    }

    @Override
    protected void initializeFromOrmColumnMapping(OrmColumnMapping oldMapping) {
        super.initializeFromOrmColumnMapping(oldMapping);
        this.column.initializeFrom(oldMapping.getColumn());
    }

    @Override
    public void addXmlAttributeMappingTo(Attributes xmlAttributes) {
        xmlAttributes.getVersions().add((Object)((XmlVersion)this.xmlAttributeMapping));
    }

    @Override
    public void removeXmlAttributeMappingFrom(Attributes xmlAttributes) {
        xmlAttributes.getVersions().remove((Object)this.xmlAttributeMapping);
    }

    @Override
    public String getDefaultColumnName() {
        return this.name;
    }

    @Override
    public String getDefaultTableName() {
        return this.getTypeMapping().getPrimaryTableName();
    }

    @Override
    public Table resolveDbTable(String tableName) {
        return this.getTypeMapping().resolveDbTable(tableName);
    }

    @Override
    public boolean tableNameIsInvalid(String tableName) {
        return this.getTypeMapping().tableNameIsInvalid(tableName);
    }

    @Override
    public Iterator<String> candidateTableNames() {
        return this.getTypeMapping().allAssociatedTableNames();
    }

    @Override
    public XmlColumn getXmlColumn() {
        return ((XmlVersion)this.xmlAttributeMapping).getColumn();
    }

    @Override
    public XmlColumn buildXmlColumn() {
        XmlColumn xmlColumn = OrmFactory.eINSTANCE.createXmlColumn();
        ((XmlVersion)this.xmlAttributeMapping).setColumn(xmlColumn);
        return xmlColumn;
    }

    @Override
    public void removeXmlColumn() {
        ((XmlVersion)this.xmlAttributeMapping).setColumn(null);
    }

    @Override
    public Iterable<ReplaceEdit> createRenameTypeEdits(IType originalType, String newName) {
        return new CompositeIterable(new Iterable[]{super.createRenameTypeEdits(originalType, newName), this.createConverterRenameTypeEdits(originalType, newName)});
    }

    protected Iterable<ReplaceEdit> createConverterRenameTypeEdits(IType originalType, String newName) {
        return this.converter != null ? this.converter.createRenameTypeEdits(originalType, newName) : EmptyIterable.instance();
    }

    @Override
    public Iterable<ReplaceEdit> createMoveTypeEdits(IType originalType, IPackageFragment newPackage) {
        return new CompositeIterable(new Iterable[]{super.createMoveTypeEdits(originalType, newPackage), this.createConverterMoveTypeEdits(originalType, newPackage)});
    }

    protected Iterable<ReplaceEdit> createConverterMoveTypeEdits(IType originalType, IPackageFragment newPackage) {
        return this.converter != null ? this.converter.createMoveTypeEdits(originalType, newPackage) : EmptyIterable.instance();
    }

    @Override
    public Iterable<ReplaceEdit> createRenamePackageEdits(IPackageFragment originalPackage, String newName) {
        return new CompositeIterable(new Iterable[]{super.createRenamePackageEdits(originalPackage, newName), this.createConverterRenamePackageEdits(originalPackage, newName)});
    }

    protected Iterable<ReplaceEdit> createConverterRenamePackageEdits(IPackageFragment originalPackage, String newName) {
        return this.converter != null ? this.converter.createRenamePackageEdits(originalPackage, newName) : EmptyIterable.instance();
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        this.column.validate(messages, reporter);
        this.converter.validate(messages, reporter);
        this.validateAttributeType(messages);
    }

    protected void validateAttributeType(List<IMessage> messages) {
        if (!ArrayTools.contains((Object[])VERSION_MAPPING_SUPPORTED_TYPES, (Object)this.getPersistentAttribute().getTypeName())) {
            messages.add(DefaultJpaValidationMessages.buildMessage(2, "PERSISTENT_ATTRIBUTE_INVALID_VERSION_MAPPING_TYPE", new String[]{this.getName()}, this, this.getNameTextRange()));
        }
    }

    @Override
    public JptValidator buildColumnValidator(NamedColumn col, NamedColumnTextRangeResolver textRangeResolver) {
        return new NamedColumnValidator((PersistentAttribute)this.getPersistentAttribute(), (BaseColumn)col, (BaseColumnTextRangeResolver)textRangeResolver, (AbstractNamedColumnValidator.TableDescriptionProvider)new EntityTableDescriptionProvider());
    }
}

