/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.design.ui.designsession;

import java.io.File;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.design.DataSourceDesign;
import org.eclipse.datatools.connectivity.oda.design.DesignSessionRequest;
import org.eclipse.datatools.connectivity.oda.design.OdaDesignSession;
import org.eclipse.datatools.connectivity.oda.design.internal.designsession.DataSourceDesignSessionBase;
import org.eclipse.datatools.connectivity.oda.design.ui.designsession.DesignSessionUtil;
import org.eclipse.datatools.connectivity.oda.design.ui.nls.Messages;
import org.eclipse.datatools.connectivity.oda.design.ui.wizards.DataSourceEditorPage;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PropertyPage;

public class DataSourceDesignSession
extends DataSourceDesignSessionBase {
    public static DataSourceDesignSession startNewDesign(String odaDataSourceId, String newDataSourceName) throws OdaException {
        return DataSourceDesignSession.startNewDesign(odaDataSourceId, newDataSourceName, null, null);
    }

    public static DataSourceDesignSession startNewDesign(String odaDataSourceId, String newDataSourceName, ProfileReference profileRef, DesignSessionRequest request) throws OdaException {
        DataSourceDesignSession newSession = new DataSourceDesignSession(odaDataSourceId);
        newSession.initNewDesign(newDataSourceName, profileRef, request);
        return newSession;
    }

    public static DataSourceDesignSession startNewDesignFromProfile() {
        return DataSourceDesignSession.startNewDesignFromProfile(null);
    }

    private static DataSourceDesignSession startNewDesignFromProfile(DesignSessionRequest sessionRequest) {
        return new DataSourceDesignSession(sessionRequest);
    }

    public void restartNewDesign(String odaDataSourceId, String newDataSourceName, ProfileReference profileRef, DesignSessionRequest request) throws OdaException {
        if (!this.isInCreateMode()) {
            throw new OdaException(Messages.designSession_invalidNewDesignApiCall);
        }
        super.restartNewDesign(odaDataSourceId, newDataSourceName, profileRef, request);
    }

    public static DataSourceDesignSession startEditDesign(DesignSessionRequest request) throws OdaException {
        return DataSourceDesignSession.startEditDesign(request, null);
    }

    public static DataSourceDesignSession startEditDesign(DesignSessionRequest request, DataSourceEditorPage editorPage) throws OdaException {
        String odaDataSourceId = DesignSessionUtil.validateRequestSession(request);
        DataSourceDesignSession newSession = new DataSourceDesignSession(odaDataSourceId);
        newSession.initEditDesign(request, editorPage);
        return newSession;
    }

    public static OdaDesignSession createNewDesignFromProfile(String odaDataSourceId, String newDataSourceName, ProfileReference profileRef) throws OdaException {
        DataSourceDesignSession newSession = DataSourceDesignSession.startNewDesign(odaDataSourceId, newDataSourceName, profileRef, null);
        return newSession.finishNewDesignFromProfile(newDataSourceName, profileRef);
    }

    public static OdaDesignSession convertDesignToLinkedProfile(DesignSessionRequest request, String newProfileBaseName, boolean useProfileInDesign, boolean promptCreateProfileStore, Shell parentShell) throws OdaException {
        String odaDataSourceId = DesignSessionUtil.validateRequestSession(request);
        DataSourceDesign dataSourceDesign = request.getDataSourceDesign();
        if (dataSourceDesign.hasLinkToProfile()) {
            OdaException ex = new OdaException(Messages.bind((String)Messages.designSession_alreadyHasLinkedProfile, (Object)dataSourceDesign.getName()));
            ex.initCause((Throwable)new IllegalArgumentException());
            throw ex;
        }
        DataSourceDesignSession newSession = new DataSourceDesignSession(odaDataSourceId);
        return newSession.convertDesignToProfile(request, newProfileBaseName, useProfileInDesign, promptCreateProfileStore, parentShell);
    }

    private DataSourceDesignSession(String odaDataSourceId) {
        super(odaDataSourceId);
    }

    private DataSourceDesignSession() {
    }

    private DataSourceDesignSession(DesignSessionRequest sessionRequest) {
        super(sessionRequest);
    }

    public DesignSessionRequest getRequest() {
        return super.getRequest();
    }

    public OdaDesignSession finish() throws OdaException {
        return super.finish();
    }

    public OdaDesignSession cancel() {
        return super.cancel();
    }

    public void setUseProfileSelectionPage(boolean use) {
        super.setUseProfileSelectionPage(use);
    }

    public boolean setAndVerifyUseProfileSelectionPage() {
        return super.setAndVerifyUseProfileSelectionPage();
    }

    public void setDesignNameValidator(IDesignNameValidator validator) {
        super.setDesignNameValidator(validator);
    }

    public IWizard getNewWizard() throws OdaException {
        if (!this.isInCreateMode()) {
            throw new OdaException(Messages.designSession_invalidNewDesignApiCall);
        }
        return super.getNewWizard();
    }

    public IWizardPage getWizardStartingPage() throws OdaException {
        if (!this.isInCreateMode()) {
            throw new OdaException(Messages.designSession_invalidNewDesignApiCall);
        }
        return super.getWizardStartingPage();
    }

    public PropertyPage getProfileSelectionPropertyPage() throws OdaException {
        if (!this.isInEditMode()) {
            throw new OdaException(Messages.designSession_invalidEditApiCall);
        }
        return super.getProfileSelectionEditorPage();
    }

    public PropertyPage getEditorPage() throws OdaException {
        if (!this.isInEditMode()) {
            throw new OdaException(Messages.designSession_invalidEditApiCall);
        }
        return super.getEditorPage();
    }

    public IAdaptable getEditPropertyPageElement() throws OdaException {
        if (!this.isInEditMode()) {
            throw new OdaException(Messages.designSession_invalidEditApiCall);
        }
        return super.getEditPropertyPageElement();
    }

    public static interface IDesignNameValidator
    extends DataSourceDesignSessionBase.IDesignNameValidatorBase {
        public boolean isValid(String var1) throws OdaException;
    }

    public static class ProfileReference
    extends DataSourceDesignSessionBase.ProfileReferenceBase {
        public ProfileReference(String profileInstanceId, File storageFile, boolean maintainExternalLink) {
            super(profileInstanceId, storageFile, maintainExternalLink);
        }
    }
}

