/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.core.internal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.wst.server.core.IServerListener;
import org.eclipse.wst.server.core.ServerEvent;
import org.eclipse.wst.server.core.internal.Trace;

public class ServerNotificationManager {
    private List<ListenerEntry> listenerList = new ArrayList<ListenerEntry>();
    public static final int ALL_EVENTS = 65535;

    public void addListener(IServerListener curListener) {
        this.addListener(curListener, 65535);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(IServerListener curListener, int eventMask) {
        if (Trace.FINEST) {
            Trace.trace("/finest", "->- Adding server listener to notification manager: " + curListener + " " + eventMask + " ->-");
        }
        if (curListener == null) {
            return;
        }
        List<ListenerEntry> list = this.listenerList;
        synchronized (list) {
            this.listenerList.add(new ListenerEntry(curListener, eventMask));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void broadcastChange(ServerEvent event) {
        ListenerEntry[] listeners;
        int size;
        if (Trace.FINEST) {
            Trace.trace("/finest", "->- Broadcasting server event: " + event + " ->-");
        }
        if (event == null) {
            return;
        }
        int eventKind = event.getKind();
        if (Trace.FINEST) {
            Trace.trace("/finest", "  Server event kind: " + eventKind + " ->-");
        }
        List<ListenerEntry> list = this.listenerList;
        synchronized (list) {
            size = this.listenerList.size();
            listeners = this.listenerList.toArray(new ListenerEntry[size]);
        }
        int i = 0;
        while (i < size) {
            boolean isKindMatch;
            ListenerEntry curEntry = listeners[i];
            int mask = curEntry.getEventMask();
            boolean isTypeMatch = (mask & eventKind & 0x10) != 0 || (mask & eventKind & 0x20) != 0;
            boolean bl = isKindMatch = (mask & eventKind ^ 0x10 ^ 0x20) != 0;
            if (isTypeMatch && isKindMatch) {
                block14: {
                    if (Trace.FINEST) {
                        Trace.trace("/finest", "->- Firing server event to listener: " + curEntry.getListener() + " ->-");
                    }
                    try {
                        if (Trace.LISTENERS) {
                            Trace.trace("/listeners", "  Firing server event to listener: " + curEntry.getListener());
                        }
                        curEntry.getListener().serverChanged(event);
                    }
                    catch (Exception e) {
                        if (!Trace.SEVERE) break block14;
                        Trace.trace("/severe", "  Error firing server event: " + curEntry.getListener(), e);
                    }
                }
                if (Trace.LISTENERS) {
                    Trace.trace("/listeners", "-<- Done firing server event -<-");
                }
            }
            ++i;
        }
        if (Trace.FINEST) {
            Trace.trace("/finest", "-<- Done broadcasting server event -<-");
        }
    }

    protected boolean hasNoListeners() {
        return this.listenerList.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(IServerListener curListener) {
        if (Trace.FINEST) {
            Trace.trace("/finest", "->- Removing server listener from notification manager: " + curListener + " ->-");
        }
        if (curListener == null) {
            return;
        }
        List<ListenerEntry> list = this.listenerList;
        synchronized (list) {
            ListenerEntry matchedListenerEntry = null;
            Iterator<ListenerEntry> listenerIter = this.listenerList.iterator();
            while (matchedListenerEntry == null && listenerIter.hasNext()) {
                ListenerEntry curEntry = listenerIter.next();
                if (!curListener.equals(curEntry.getListener())) continue;
                matchedListenerEntry = curEntry;
            }
            if (matchedListenerEntry != null) {
                this.listenerList.remove(matchedListenerEntry);
            }
        }
    }

    private class ListenerEntry {
        private IServerListener listener;
        private int eventMask;

        protected ListenerEntry(IServerListener curListener, int curEventMask) {
            this.listener = curListener;
            this.eventMask = curEventMask;
        }

        protected IServerListener getListener() {
            return this.listener;
        }

        protected int getEventMask() {
            return this.eventMask;
        }
    }
}

