/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.ui.internal.platform;

import java.util.ArrayList;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jpt.common.core.internal.utility.XPointTools;
import org.eclipse.jpt.common.utility.internal.KeyedSet;
import org.eclipse.jpt.jaxb.core.JptJaxbCorePlugin;
import org.eclipse.jpt.jaxb.core.platform.JaxbPlatformDescription;
import org.eclipse.jpt.jaxb.ui.internal.platform.JaxbPlatformUiConfig;
import org.eclipse.jpt.jaxb.ui.platform.JaxbPlatformUi;
import org.eclipse.jpt.jaxb.ui.platform.JaxbPlatformUiManager;

public class JaxbPlatformUiManagerImpl
implements JaxbPlatformUiManager {
    static final String EXTENSION_POINT_ID = "jaxbPlatformUis";
    static final String QUALIFIED_EXTENSION_POINT_ID = "org.eclipse.jpt.jaxb.ui.jaxbPlatformUis";
    static final String PLATFORM_UI_ELEMENT = "jaxbPlatformUi";
    static final String ID_ATTRIBUTE = "id";
    static final String PLATFORM_ATTRIBUTE = "jaxbPlatform";
    static final String CLASS_ATTRIBUTE = "class";
    private static final JaxbPlatformUiManagerImpl INSTANCE = new JaxbPlatformUiManagerImpl();
    private KeyedSet<String, JaxbPlatformUiConfig> platformUiConfigs = new KeyedSet();
    private KeyedSet<JaxbPlatformDescription, JaxbPlatformUiConfig> platformToUiConfigs = new KeyedSet();

    public static JaxbPlatformUiManagerImpl instance() {
        return INSTANCE;
    }

    private JaxbPlatformUiManagerImpl() {
        this.readExtensions();
    }

    private void readExtensions() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint xpoint = registry.getExtensionPoint("org.eclipse.jpt.jaxb.ui", EXTENSION_POINT_ID);
        if (xpoint == null) {
            throw new IllegalStateException();
        }
        ArrayList<IConfigurationElement> platformUiConfigs = new ArrayList<IConfigurationElement>();
        IExtension[] iExtensionArray = xpoint.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement configElement = iConfigurationElementArray[n4];
                if (configElement.getName().equals(PLATFORM_UI_ELEMENT)) {
                    platformUiConfigs.add(configElement);
                }
                ++n4;
            }
            ++n2;
        }
        for (IConfigurationElement configElement : platformUiConfigs) {
            this.readPlatformUiExtension(configElement);
        }
    }

    private void readPlatformUiExtension(IConfigurationElement element) {
        try {
            JaxbPlatformUiConfig platformUiConfig = new JaxbPlatformUiConfig();
            platformUiConfig.setPluginId(element.getContributor().getName());
            platformUiConfig.setId(XPointTools.findRequiredAttribute((IConfigurationElement)element, (String)ID_ATTRIBUTE));
            if (this.platformUiConfigs.containsKey((Object)platformUiConfig.getId())) {
                XPointTools.logDuplicateExtension((String)QUALIFIED_EXTENSION_POINT_ID, (String)ID_ATTRIBUTE, (String)platformUiConfig.getId());
                throw new XPointTools.XPointException();
            }
            String jaxbPlatformId = XPointTools.findRequiredAttribute((IConfigurationElement)element, (String)PLATFORM_ATTRIBUTE);
            JaxbPlatformDescription jaxbPlatform = JptJaxbCorePlugin.getJaxbPlatformManager().getJaxbPlatform(jaxbPlatformId);
            if (jaxbPlatform == null) {
                XPointTools.logInvalidValue((IConfigurationElement)element, (String)PLATFORM_ATTRIBUTE, (String)jaxbPlatformId);
            }
            if (this.platformToUiConfigs.containsKey((Object)jaxbPlatform)) {
                XPointTools.logDuplicateExtension((String)QUALIFIED_EXTENSION_POINT_ID, (String)PLATFORM_ATTRIBUTE, (String)jaxbPlatformId);
                throw new XPointTools.XPointException();
            }
            platformUiConfig.setJaxbPlatform(jaxbPlatform);
            platformUiConfig.setClassName(XPointTools.findRequiredAttribute((IConfigurationElement)element, (String)CLASS_ATTRIBUTE));
            this.platformUiConfigs.addItem((Object)platformUiConfig.getId(), (Object)platformUiConfig);
            this.platformToUiConfigs.addItem((Object)jaxbPlatform, (Object)platformUiConfig);
        }
        catch (XPointTools.XPointException xPointException) {}
    }

    public JaxbPlatformUi getJaxbPlatformUi(JaxbPlatformDescription platformDesc) {
        JaxbPlatformUiConfig config = (JaxbPlatformUiConfig)this.platformToUiConfigs.getItem((Object)platformDesc);
        return config == null ? null : config.getPlatformUi();
    }
}

