/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.commons.repositories;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.equinox.security.storage.StorageException;
import org.eclipse.mylyn.commons.repositories.ILocationService;
import org.eclipse.mylyn.commons.repositories.auth.AuthenticationCredentials;
import org.eclipse.mylyn.commons.repositories.auth.AuthenticationType;
import org.eclipse.mylyn.commons.repositories.auth.ICredentialsStore;
import org.eclipse.mylyn.internal.commons.repositories.CredentialsFactory;
import org.eclipse.mylyn.internal.commons.repositories.InMemoryCredentialsStore;
import org.eclipse.mylyn.internal.commons.repositories.LocationService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryLocation
extends PlatformObject {
    private static final String AUTH_HTTP = "org.eclipse.mylyn.tasklist.repositories.httpauth";
    private static final String AUTH_PROXY = "org.eclipse.mylyn.tasklist.repositories.proxy";
    private static final String AUTH_REPOSITORY = "org.eclipse.mylyn.tasklist.repositories";
    private static final String ENABLED = ".enabled";
    private static final String ID_PLUGIN = "org.eclipse.mylyn.commons.repository";
    public static final String PROPERTY_CATEGORY = "category";
    public static final String PROPERTY_ENCODING = "encoding";
    public static final String PROPERTY_ID = "id";
    public static final String PROPERTY_LABEL = "label";
    public static final String PROPERTY_OFFLINE = "org.eclipse.mylyn.tasklist.repositories.offline";
    public static final String PROPERTY_TIMEZONE = "timezone";
    public static final String PROPERTY_URL = "url";
    public static final String PROPERTY_USERNAME = "org.eclipse.mylyn.repositories.username";
    public static final String PROPERTY_PROXY_HOST = "org.eclipse.mylyn.repositories.proxy.host";
    public static final String PROPERTY_PROXY_PORT = "org.eclipse.mylyn.repositories.proxy.port";
    public static final String PROPERTY_PROXY_USEDEFAULT = "org.eclipse.mylyn.repositories.proxy.usedefault";
    private static final String SAVE_PASSWORD = ".savePassword";
    private static final String USERNAME = ".username";
    private String cachedUserName;
    private ICredentialsStore credentialsStore;
    private IStatus errorStatus = null;
    private boolean isCachedUserName;
    private final Map<String, String> properties = new LinkedHashMap<String, String>();
    private final Set<PropertyChangeListener> propertyChangeListeners = new HashSet<PropertyChangeListener>();
    private ILocationService service;
    private boolean workingCopy;

    private static String getKeyPrefix(AuthenticationType type) {
        switch (type) {
            case HTTP: {
                return AUTH_HTTP;
            }
            case PROXY: {
                return AUTH_PROXY;
            }
            case REPOSITORY: {
                return AUTH_REPOSITORY;
            }
        }
        throw new IllegalArgumentException("Unknown authentication type: " + (Object)((Object)type));
    }

    public RepositoryLocation() {
        this.service = LocationService.getDefault();
    }

    public RepositoryLocation(Map<String, String> properties) {
        this.properties.putAll(properties);
        this.workingCopy = true;
        this.service = LocationService.getDefault();
    }

    public RepositoryLocation(RepositoryLocation source) {
        this.properties.putAll(source.properties);
        this.workingCopy = true;
        this.service = source.getService();
    }

    public void addChangeListener(PropertyChangeListener listener) {
        this.propertyChangeListeners.add(listener);
    }

    public void clearCredentials() {
        this.getCredentialsStore().clear();
    }

    public <T extends AuthenticationCredentials> T getCredentials(AuthenticationType authType, Class<T> credentialsKind) {
        String prefix = RepositoryLocation.getKeyPrefix(authType);
        if (this.getBooleanPropery(String.valueOf(prefix) + ENABLED)) {
            if (this.getId() == null) {
                return null;
            }
            try {
                return CredentialsFactory.create(credentialsKind, this.getCredentialsStore(), prefix);
            }
            catch (StorageException storageException) {}
        }
        return null;
    }

    public ICredentialsStore getCredentialsStore() {
        if (this.credentialsStore == null) {
            return this.getService().getCredentialsStore(this.getId());
        }
        return this.credentialsStore;
    }

    public String getId() {
        String id = this.getProperty(PROPERTY_ID);
        if (id == null) {
            throw new IllegalStateException("Repository ID is not set");
        }
        return id;
    }

    public Map<String, String> getProperties() {
        return new LinkedHashMap<String, String>(this.properties);
    }

    public String getProperty(String name) {
        return this.properties.get(name);
    }

    public String getLabel() {
        String label = this.properties.get(PROPERTY_LABEL);
        if (label != null && label.length() > 0) {
            return label;
        }
        return this.getUrl();
    }

    public boolean getSavePassword(AuthenticationType authType) {
        return this.getBooleanPropery(String.valueOf(RepositoryLocation.getKeyPrefix(authType)) + SAVE_PASSWORD);
    }

    public boolean getBooleanPropery(String key) {
        String value = this.getProperty(key);
        return value != null && Boolean.parseBoolean(value);
    }

    public ILocationService getService() {
        return this.service;
    }

    public IStatus getStatus() {
        return this.errorStatus;
    }

    public String getUrl() {
        return this.getProperty(PROPERTY_URL);
    }

    public String getUserName() {
        return this.getProperty(PROPERTY_USERNAME);
    }

    public void setUserName(String userName) {
        this.setProperty(PROPERTY_USERNAME, userName);
    }

    private void handlePropertyChange(String key, Object old, Object value) {
        if (PROPERTY_ID.equals(key)) {
            this.credentialsStore = null;
        }
        PropertyChangeEvent event = new PropertyChangeEvent((Object)this, key, old, value);
        for (PropertyChangeListener listener : this.propertyChangeListeners) {
            listener.propertyChange(event);
        }
    }

    private boolean hasChanged(Object oldValue, Object newValue) {
        return oldValue != null && !oldValue.equals(newValue) || oldValue == null && newValue != null;
    }

    public boolean hasProperty(String name) {
        String value = this.getProperty(name);
        return value != null && value.trim().length() > 0;
    }

    public boolean isOffline() {
        return Boolean.parseBoolean(this.getProperty(PROPERTY_OFFLINE));
    }

    public boolean isWorkingCopy() {
        return this.workingCopy;
    }

    public void removeChangeListener(PropertyChangeListener listener) {
        this.propertyChangeListeners.remove(listener);
    }

    public void removeProperty(String key) {
        this.setProperty(key, null);
    }

    public <T extends AuthenticationCredentials> void setCredentials(AuthenticationType authType, T credentials) {
        String prefix = RepositoryLocation.getKeyPrefix(authType);
        if (credentials == null) {
            if (authType == AuthenticationType.REPOSITORY) {
                this.cachedUserName = null;
            }
            this.setProperty(String.valueOf(prefix) + ENABLED, String.valueOf(false));
        } else {
            this.setProperty(String.valueOf(prefix) + ENABLED, String.valueOf(true));
            try {
                credentials.save(this.getCredentialsStore(), prefix);
            }
            catch (StorageException storageException) {}
        }
    }

    public void setCredentialsStore(ICredentialsStore credentialsStore) {
        this.credentialsStore = credentialsStore;
    }

    public void setLabel(String label) {
        this.setProperty(PROPERTY_LABEL, label);
    }

    public void setOffline(boolean offline) {
        this.properties.put(PROPERTY_OFFLINE, String.valueOf(offline));
    }

    public void setProperty(String key, String newValue) {
        Assert.isNotNull((Object)key);
        String oldValue = this.properties.get(key);
        if (this.hasChanged(oldValue, newValue)) {
            this.properties.put(key.intern(), newValue != null ? newValue.intern() : null);
            this.handlePropertyChange(key, oldValue, newValue);
        }
    }

    public void setService(ILocationService service) {
        this.service = service;
    }

    public void setStatus(IStatus errorStatus) {
        this.errorStatus = errorStatus;
    }

    public String toString() {
        return this.getLabel();
    }

    public void apply(RepositoryLocation location) {
        String oldId = this.getProperty(PROPERTY_ID);
        ICredentialsStore oldCredentialsStore = null;
        if (oldId != null) {
            oldCredentialsStore = this.getCredentialsStore();
        }
        HashSet<String> removed = new HashSet<String>(this.properties.keySet());
        removed.removeAll(location.properties.keySet());
        for (Map.Entry<String, String> entry : location.properties.entrySet()) {
            this.setProperty(entry.getKey(), entry.getValue());
        }
        for (String key : removed) {
            this.setProperty(key, null);
        }
        String newId = this.getProperty(PROPERTY_ID);
        if (newId != null) {
            ICredentialsStore newCredentialsStore = this.getCredentialsStore();
            if (!newId.equals(oldId) && oldCredentialsStore != null) {
                try {
                    oldCredentialsStore.copyTo(newCredentialsStore);
                    oldCredentialsStore.clear();
                }
                catch (StorageException storageException) {}
            }
            if (location.getCredentialsStore() instanceof InMemoryCredentialsStore) {
                try {
                    ((InMemoryCredentialsStore)location.getCredentialsStore()).copyTo(newCredentialsStore);
                }
                catch (StorageException storageException) {}
            }
        }
    }

    public void setIdPreservingCredentialsStore(String id) {
        ICredentialsStore store = this.getCredentialsStore();
        this.setProperty(PROPERTY_ID, id);
        if (this.credentialsStore == null) {
            this.setCredentialsStore(store);
        }
    }
}

