/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.ui.internal.listeners;

import org.eclipse.jpt.common.utility.model.event.StateChangeEvent;
import org.eclipse.jpt.common.utility.model.listener.StateChangeListener;
import org.eclipse.swt.widgets.Display;

public class SWTStateChangeListenerWrapper
implements StateChangeListener {
    private final StateChangeListener listener;

    public SWTStateChangeListenerWrapper(StateChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        this.listener = listener;
    }

    public void stateChanged(StateChangeEvent event) {
        if (this.isExecutingOnUIThread()) {
            this.stateChanged_(event);
        } else {
            this.executeOnUIThread(this.buildStateChangedRunnable(event));
        }
    }

    private Runnable buildStateChangedRunnable(final StateChangeEvent event) {
        return new Runnable(){

            public void run() {
                SWTStateChangeListenerWrapper.this.stateChanged_(event);
            }

            public String toString() {
                return "state changed runnable";
            }
        };
    }

    private boolean isExecutingOnUIThread() {
        return Display.getCurrent() != null;
    }

    private void executeOnUIThread(Runnable r) {
        Display.getDefault().asyncExec(r);
    }

    void stateChanged_(StateChangeEvent event) {
        this.listener.stateChanged(event);
    }

    public String toString() {
        return "SWT(" + this.listener.toString() + ')';
    }
}

