/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.eclipselink.core.internal.libval;

import java.util.HashSet;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jpt.common.core.internal.libval.LibValUtil;
import org.eclipse.jpt.common.core.libprov.JptLibraryProviderInstallOperationConfig;
import org.eclipse.jpt.common.core.libval.LibraryValidator;
import org.eclipse.jpt.common.eclipselink.core.internal.JptCommonEclipseLinkCoreMessages;
import org.eclipse.jpt.common.eclipselink.core.internal.libval.EclipseLinkLibValUtil;
import org.eclipse.jpt.common.utility.internal.iterables.TransformationIterable;
import org.eclipse.jpt.jaxb.core.internal.libprov.JaxbUserLibraryProviderInstallOperationConfig;
import org.eclipse.jpt.jaxb.core.platform.JaxbPlatformDescription;
import org.eclipse.jpt.jaxb.eclipselink.core.ELJaxbPlatform;
import org.eclipse.osgi.service.resolver.VersionRange;

public class ELJaxbUserLibraryValidator
implements LibraryValidator {
    public IStatus validate(JptLibraryProviderInstallOperationConfig config) {
        JaxbUserLibraryProviderInstallOperationConfig jaxbConfig = (JaxbUserLibraryProviderInstallOperationConfig)config;
        JaxbPlatformDescription platform = jaxbConfig.getJaxbPlatform();
        HashSet<VersionRange> versionRanges = new HashSet<VersionRange>();
        if (ELJaxbPlatform.VERSION_2_1.equals(platform)) {
            versionRanges.add(new VersionRange("[2.1, 3.0)"));
        } else if (ELJaxbPlatform.VERSION_2_2.equals(platform)) {
            versionRanges.add(new VersionRange("[2.2, 3.0)"));
        } else if (ELJaxbPlatform.VERSION_2_3.equals(platform)) {
            versionRanges.add(new VersionRange("[2.3, 3.0)"));
        }
        IStatus status = EclipseLinkLibValUtil.validate((Iterable)jaxbConfig.resolve(), versionRanges);
        if (!status.isOK()) {
            return status;
        }
        HashSet<String> classNames = new HashSet<String>();
        classNames.add("com.sun.tools.xjc.XJCFacade");
        classNames.add("com.sun.xml.bind.Util");
        TransformationIterable<IClasspathEntry, IPath> libraryPaths = new TransformationIterable<IClasspathEntry, IPath>((Iterable)jaxbConfig.resolve()){

            protected IPath transform(IClasspathEntry o) {
                return o.getPath();
            }
        };
        status = LibValUtil.validate((Iterable)libraryPaths, classNames);
        if (!status.isOK()) {
            return new Status(2, "org.eclipse.jpt.jaxb.core", JptCommonEclipseLinkCoreMessages.ELJaxbUserLibraryValidator_noXjcClasses);
        }
        return Status.OK_STATUS;
    }
}

