/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.repo;

import java.util.Properties;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFile;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteResource;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.util.KnownRepositories;
import org.eclipse.team.internal.ccvs.ui.CVSResourceTransfer;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.IRepositoryListener;
import org.eclipse.team.internal.ccvs.ui.WorkbenchUserAuthenticator;
import org.eclipse.team.internal.ccvs.ui.model.AllRootsElement;
import org.eclipse.team.internal.ccvs.ui.repo.RemoteViewPart;
import org.eclipse.team.internal.ccvs.ui.repo.RemoveDateTagAction;
import org.eclipse.team.internal.ccvs.ui.repo.RemoveRootAction;
import org.eclipse.team.internal.ccvs.ui.repo.RepositoriesFilter;
import org.eclipse.team.internal.ccvs.ui.repo.RepositoriesFilterAction;
import org.eclipse.team.internal.ccvs.ui.repo.RepositoriesSortingActionGroup;
import org.eclipse.team.internal.ccvs.ui.repo.RepositoryComparator;
import org.eclipse.team.internal.ccvs.ui.repo.RepositoryRoot;
import org.eclipse.team.internal.ccvs.ui.wizards.NewLocationWizard;
import org.eclipse.team.internal.core.TeamPlugin;
import org.eclipse.team.internal.ui.actions.TeamAction;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.dialogs.PropertyDialogAction;
import org.eclipse.ui.part.PluginTransfer;
import org.eclipse.ui.part.PluginTransferData;

public class RepositoriesView
extends RemoteViewPart {
    public static final String VIEW_ID = "org.eclipse.team.ccvs.ui.RepositoriesView";
    private AllRootsElement root;
    private IAction removeAction;
    private Action newAction;
    private Action newAnonAction;
    private PropertyDialogAction propertiesAction;
    private RemoveRootAction removeRootAction;
    private RemoveDateTagAction removeDateTagAction;
    private RepositoriesFilterAction repositoriesFilterAction;
    private IAction toggleFilterAction;
    private RepositoriesSortingActionGroup repositoriesSortingActionGroup;
    private IDialogSettings dialogSettings;
    private static final String SELECTED_ORDER_BY = "selectedOrderBy";
    private static final String SELECTED_SORTING_ORDER = "selectedSortingOrder";
    private RepositoryComparator savedComparator;
    private RepositoriesFilter repositoriesFilter;
    private static final String FILTER_SHOW_MODULES = "filterShowModules";
    IRepositoryListener listener = new IRepositoryListener(){

        public void repositoryAdded(ICVSRepositoryLocation root) {
            RepositoriesView.this.getViewer().getControl().getDisplay().asyncExec(new Runnable(this, root){
                final /* synthetic */ 1 this$1;
                private final /* synthetic */ ICVSRepositoryLocation val$root;
                {
                    this.this$1 = var1_1;
                    this.val$root = iCVSRepositoryLocation;
                }

                public void run() {
                    1.access$0(this.this$1).refreshViewer();
                    1.access$0(this.this$1).getViewer().setSelection((ISelection)new StructuredSelection((Object)this.val$root));
                }
            });
        }

        public void repositoriesChanged(ICVSRepositoryLocation[] roots) {
            this.refresh();
        }

        private void refresh() {
            Display display = RepositoriesView.this.getViewer().getControl().getDisplay();
            display.asyncExec(new Runnable(this){
                final /* synthetic */ 1 this$1;
                {
                    this.this$1 = var1_1;
                }

                public void run() {
                    1.access$0(this.this$1).refreshViewer();
                }
            });
        }

        static /* synthetic */ RepositoriesView access$0(1 var0) {
            return var0.RepositoriesView.this;
        }
    };
    RepositoryDragSourceListener repositoryDragSourceListener;
    static /* synthetic */ Class class$0;

    public RepositoriesView() {
        super(VIEW_ID);
        IDialogSettings workbenchSettings = CVSUIPlugin.getPlugin().getDialogSettings();
        this.dialogSettings = workbenchSettings.getSection(VIEW_ID);
        if (this.dialogSettings == null) {
            this.dialogSettings = workbenchSettings.addNewSection(VIEW_ID);
        }
        try {
            String selectedOrderBy = this.dialogSettings.get(SELECTED_ORDER_BY);
            String selectedSortingOrder = this.dialogSettings.get(SELECTED_SORTING_ORDER);
            int orderBy = Integer.parseInt(selectedOrderBy);
            boolean ascending = Boolean.valueOf(selectedSortingOrder);
            this.savedComparator = new RepositoryComparator(orderBy, ascending);
        }
        catch (NumberFormatException numberFormatException) {
            this.savedComparator = new RepositoryComparator(0, true);
        }
        if (this.dialogSettings.get(FILTER_SHOW_MODULES) != null && !this.dialogSettings.get(FILTER_SHOW_MODULES).equals("")) {
            this.repositoriesFilter = new RepositoriesFilter(this.dialogSettings.getBoolean(FILTER_SHOW_MODULES));
        }
    }

    protected void contributeActions() {
        final Shell shell = this.getShell();
        this.newAction = new Action(CVSUIMessages.RepositoriesView_new, CVSUIPlugin.getPlugin().getImageDescriptor("etool16/newlocation_wiz.gif")){

            public void run() {
                NewLocationWizard wizard = new NewLocationWizard();
                wizard.setSwitchPerspectives(false);
                WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
                dialog.open();
            }
        };
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this.newAction, "org.eclipse.team.cvs.ui.new_repository_location_action_context");
        if (this.includeAnonConnection()) {
            this.newAnonAction = new Action(CVSUIMessages.RepositoriesView_newAnonCVS, CVSUIPlugin.getPlugin().getImageDescriptor("etool16/newlocation_wiz.gif")){

                public void run() {
                    Properties p = new Properties();
                    p.setProperty("connection", "pserver");
                    p.setProperty("user", "anonymous");
                    p.setProperty("host", "dev.eclipse.org");
                    p.setProperty("root", "/cvsroot/eclipse");
                    NewLocationWizard wizard = new NewLocationWizard(p);
                    wizard.setSwitchPerspectives(false);
                    WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
                    dialog.open();
                }
            };
            PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this.newAnonAction, "org.eclipse.team.cvs.ui.new_dev_eclipse repository_location_action_context");
        }
        this.propertiesAction = new PropertyDialogAction(shell, (ISelectionProvider)this.getViewer());
        this.getViewSite().getActionBars().setGlobalActionHandler(ActionFactory.PROPERTIES.getId(), (IAction)this.propertiesAction);
        IStructuredSelection selection = (IStructuredSelection)this.getViewer().getSelection();
        if (selection.size() == 1 && selection.getFirstElement() instanceof RepositoryRoot) {
            this.propertiesAction.setEnabled(true);
        } else {
            this.propertiesAction.setEnabled(false);
        }
        this.getViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection ss = (IStructuredSelection)event.getSelection();
                boolean enabled = ss.size() == 1 && ss.getFirstElement() instanceof RepositoryRoot;
                RepositoriesView.this.propertiesAction.setEnabled(enabled);
            }
        });
        this.removeRootAction = new RemoveRootAction(this.viewer.getControl().getShell(), this);
        this.removeRootAction.selectionChanged(null);
        this.removeDateTagAction = new RemoveDateTagAction();
        this.removeDateTagAction.selectionChanged(null);
        this.removeAction = new Action(){

            public void run() {
                if (RepositoriesView.this.removeRootAction.isEnabled()) {
                    RepositoriesView.this.removeRootAction.run();
                }
                if (RepositoriesView.this.removeDateTagAction.isEnabled()) {
                    RepositoriesView.this.removeDateTagAction.run();
                }
            }
        };
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this.removeRootAction, "org.eclipse.team.cvs.ui.remove_root_action_context");
        IActionBars bars = this.getViewSite().getActionBars();
        bars.setGlobalActionHandler(ActionFactory.DELETE.getId(), this.removeAction);
        IPropertyChangeListener comparatorUpdater = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                String property = event.getProperty();
                if ("changeComparator".equals(property)) {
                    Object newValue = event.getNewValue();
                    RepositoriesView.this.getViewer().refresh();
                    RepositoriesView.this.saveSelectedComparator((RepositoryComparator)((Object)newValue));
                }
            }
        };
        this.setActionGroup(new RepositoriesSortingActionGroup(shell, comparatorUpdater));
        this.getRepositoriesSortingActionGroup().setSelectedComparator(this.savedComparator);
        super.contributeActions();
        this.toggleFilterAction = new Action(CVSUIMessages.RepositoriesView_NoFilter){

            public void run() {
                if (RepositoriesView.this.repositoriesFilter != null) {
                    RepositoriesView.this.getViewer().removeFilter((ViewerFilter)RepositoriesView.this.repositoriesFilter);
                }
                RepositoriesView.this.repositoriesFilter = null;
                RepositoriesView.this.toggleFilterAction.setEnabled(false);
                RepositoriesView.this.repositoriesFilterAction.setFilter(RepositoriesView.this.repositoriesFilter);
            }
        };
        this.toggleFilterAction.setEnabled(this.repositoriesFilter != null);
        this.repositoriesFilterAction = new RepositoriesFilterAction(this);
        this.repositoriesFilterAction.setText(CVSUIMessages.RepositoriesView_FilterOn);
        this.repositoriesFilterAction.init(this.getViewer());
        this.repositoriesFilterAction.setFilter(this.repositoriesFilter);
        this.repositoriesFilterAction.setToolTipText(CVSUIMessages.RepositoriesView_FilterRepositoriesTooltip);
        this.repositoriesFilterAction.setImageDescriptor(CVSUIPlugin.getPlugin().getImageDescriptor("elcl16/filter_history.gif"));
        IMenuManager actionBarsMenu = bars.getMenuManager();
        if (actionBarsMenu != null) {
            actionBarsMenu.add((IContributionItem)new Separator());
            actionBarsMenu.add((IAction)this.repositoriesFilterAction);
            actionBarsMenu.add(this.toggleFilterAction);
        }
    }

    private void saveSelectedComparator(RepositoryComparator selectedComparator) {
        if (this.dialogSettings != null) {
            this.dialogSettings.put(SELECTED_ORDER_BY, selectedComparator.getOrderBy());
            this.dialogSettings.put(SELECTED_SORTING_ORDER, selectedComparator.isAscending());
        }
    }

    private RepositoriesSortingActionGroup getRepositoriesSortingActionGroup() {
        return this.repositoriesSortingActionGroup;
    }

    private void setActionGroup(RepositoriesSortingActionGroup actionGroup) {
        this.repositoriesSortingActionGroup = actionGroup;
    }

    private boolean includeAnonConnection() {
        return System.getProperty("eclipse.cvs.anon") != null;
    }

    protected void addWorkbenchActions(IMenuManager manager) {
        MenuManager sub = new MenuManager(CVSUIMessages.RepositoriesView_newSubmenu, "group.add");
        manager.add((IContributionItem)sub);
        super.addWorkbenchActions(manager);
        IStructuredSelection selection = (IStructuredSelection)this.getViewer().getSelection();
        this.removeRootAction.selectionChanged(selection);
        this.removeDateTagAction.selectionChanged(selection);
        if (this.removeRootAction.isEnabled()) {
            manager.add((IAction)this.removeRootAction);
        }
        if (this.removeDateTagAction.isEnabled()) {
            manager.add((IAction)this.removeDateTagAction);
        }
        if (selection.size() == 1 && selection.getFirstElement() instanceof RepositoryRoot) {
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)this.propertiesAction);
        }
        sub.add((IAction)this.newAction);
        if (this.newAnonAction != null) {
            sub.add((IAction)this.newAnonAction);
        }
        sub.add((IContributionItem)new Separator("group1"));
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        CVSUIPlugin.getPlugin().getRepositoryManager().addRepositoryListener(this.listener);
        this.getViewer().setComparator((ViewerComparator)this.savedComparator);
        if (this.repositoriesFilter != null) {
            this.getViewer().addFilter((ViewerFilter)this.repositoriesFilter);
        }
        this.getRepositoriesSortingActionGroup().fillActionBars(this.getViewSite().getActionBars());
    }

    public void dispose() {
        if (this.repositoriesFilter != null) {
            this.dialogSettings.put(FILTER_SHOW_MODULES, this.repositoriesFilter.isShowModules());
        } else {
            this.dialogSettings.put(FILTER_SHOW_MODULES, null);
        }
        CVSUIPlugin.getPlugin().getRepositoryManager().removeRepositoryListener(this.listener);
        if (this.getRepositoriesSortingActionGroup() != null) {
            this.getRepositoriesSortingActionGroup().dispose();
        }
        super.dispose();
    }

    private void initialize() {
        this.root = new AllRootsElement();
    }

    protected void initializeListeners() {
        super.initializeListeners();
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)this.removeRootAction);
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)this.removeDateTagAction);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                RepositoriesView.this.handleChange(selection);
            }
        });
        this.repositoryDragSourceListener = new RepositoryDragSourceListener();
        this.viewer.addDragSupport(20, new Transfer[]{CVSResourceTransfer.getInstance(), PluginTransfer.getInstance()}, (DragSourceListener)this.repositoryDragSourceListener);
    }

    protected Object getTreeInput() {
        this.initialize();
        return this.root;
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        String msg = this.getStatusLineMessage(selection);
        this.getViewSite().getActionBars().getStatusLineManager().setMessage(msg);
    }

    private String getStatusLineMessage(ISelection selection) {
        Object element;
        if (selection == null || selection.isEmpty()) {
            return "";
        }
        if (!(selection instanceof IStructuredSelection)) {
            return "";
        }
        IStructuredSelection s = (IStructuredSelection)selection;
        if (s.size() > 1) {
            return NLS.bind((String)CVSUIMessages.RepositoriesView_NItemsSelected, (Object[])new String[]{String.valueOf(s.size())});
        }
        Object object = s.getFirstElement();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.team.internal.ccvs.core.ICVSResource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((element = TeamAction.getAdapter((Object)object, (Class)clazz)) instanceof ICVSRemoteResource) {
            String name;
            ICVSRemoteResource res = (ICVSRemoteResource)element;
            if (res.isContainer()) {
                name = res.getRepositoryRelativePath();
            } else {
                try {
                    name = String.valueOf(res.getRepositoryRelativePath()) + " " + ((ICVSRemoteFile)res).getRevision();
                }
                catch (TeamException e) {
                    TeamPlugin.log((int)4, (String)CVSUIMessages.RepositoriesView_CannotGetRevision, (Throwable)e);
                    name = res.getRepositoryRelativePath();
                }
            }
            return NLS.bind((String)CVSUIMessages.RepositoriesView_ResourceInRepository, (Object[])new String[]{name, res.getRepository().getLocation(true)});
        }
        return CVSUIMessages.RepositoriesView_OneItemSelected;
    }

    protected String getHelpContextId() {
        return "org.eclipse.team.cvs.ui.repositories_view_context";
    }

    protected KeyAdapter getKeyListener() {
        return new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.keyCode == 0x100000E) {
                    if (WorkbenchUserAuthenticator.USE_ALTERNATE_PROMPTER) {
                        ICVSRepositoryLocation[] locations = KnownRepositories.getInstance().getRepositories();
                        int i = 0;
                        while (i < locations.length) {
                            locations[i].flushUserInfo();
                            ++i;
                        }
                    } else {
                        RepositoriesView.this.refreshAll();
                    }
                } else if (event.keyCode == 0x1000012 && WorkbenchUserAuthenticator.USE_ALTERNATE_PROMPTER) {
                    RepositoriesView.this.refreshAll();
                }
            }
        };
    }

    private void handleChange(IStructuredSelection selection) {
        this.removeRootAction.updateSelection(selection);
        this.removeDateTagAction.updateSelection(selection);
        this.removeAction.setEnabled(this.removeRootAction.isEnabled() || this.removeDateTagAction.isEnabled());
        this.repositoryDragSourceListener.updateSelection(selection);
    }

    public void showFilter(RepositoriesFilter filter) {
        if (this.repositoriesFilter != null) {
            this.getViewer().removeFilter((ViewerFilter)this.repositoriesFilter);
        }
        this.repositoriesFilter = filter;
        this.getViewer().addFilter((ViewerFilter)filter);
        this.toggleFilterAction.setEnabled(true);
    }

    private static final class RepositoryDragSourceListener
    implements DragSourceListener {
        private IStructuredSelection selection;

        private RepositoryDragSourceListener() {
        }

        public void dragStart(DragSourceEvent event) {
            if (this.selection != null) {
                Object[] array = this.selection.toArray();
                int i = 0;
                while (i < array.length) {
                    if (array[i] instanceof ICVSRemoteFile) {
                        event.doit = true;
                        return;
                    }
                    ++i;
                }
                event.doit = false;
            }
        }

        public void dragSetData(DragSourceEvent event) {
            block5: {
                block4: {
                    if (this.selection == null || !CVSResourceTransfer.getInstance().isSupportedType(event.dataType)) break block4;
                    Object[] array = this.selection.toArray();
                    int i = 0;
                    while (i < array.length) {
                        if (array[i] instanceof ICVSRemoteFile) {
                            event.data = array[i];
                            return;
                        }
                        ++i;
                    }
                    break block5;
                }
                if (!PluginTransfer.getInstance().isSupportedType(event.dataType)) break block5;
                Object[] array = this.selection.toArray();
                int i = 0;
                while (i < array.length) {
                    if (array[i] instanceof ICVSRemoteFile) {
                        event.data = new PluginTransferData("org.eclipse.team.cvs.ui.cvsRemoteDrop", CVSResourceTransfer.getInstance().toByteArray((ICVSRemoteFile)array[i]));
                        return;
                    }
                    ++i;
                }
            }
        }

        public void dragFinished(DragSourceEvent event) {
        }

        public void updateSelection(IStructuredSelection selection) {
            this.selection = selection;
        }
    }
}

