/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm.mappings;

import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.queries.JoinedAttributeManager;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.foundation.AbstractCompositeDirectCollectionMapping;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.mappings.XMLMapping;
import org.eclipse.persistence.oxm.record.DOMRecord;
import org.eclipse.persistence.oxm.record.XMLRecord;
import org.eclipse.persistence.platform.xml.XMLPlatformFactory;
import org.eclipse.persistence.queries.ObjectBuildingQuery;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class XMLFragmentCollectionMapping
extends AbstractCompositeDirectCollectionMapping
implements XMLMapping {
    private boolean isWriteOnly;
    private boolean reuseContainer;

    public boolean isXMLMapping() {
        return true;
    }

    public void initialize(AbstractSession session) throws DescriptorException {
        super.initialize(session);
    }

    public void setXPath(String xpathString) {
        this.setField(new XMLField(xpathString));
    }

    public String getXPath() {
        return this.getFieldName();
    }

    public Object valueFromRow(AbstractRecord row, JoinedAttributeManager joinManager, ObjectBuildingQuery sourceQuery, CacheKey cacheKey, AbstractSession executionSession, boolean isTargetProtected, Boolean[] wasCacheUsed) throws DatabaseException {
        ContainerPolicy cp = this.getContainerPolicy();
        Object fieldValue = ((DOMRecord)row).getValuesIndicatingNoEntry(this.getField(), true);
        Vector nestedRows = null;
        if (fieldValue instanceof Vector) {
            nestedRows = (Vector)fieldValue;
        }
        if (nestedRows == null || nestedRows.isEmpty()) {
            if (this.reuseContainer) {
                Object currentObject = ((XMLRecord)row).getCurrentObject();
                Object container = this.getAttributeAccessor().getAttributeValueFromObject(currentObject);
                return container != null ? container : cp.containerInstance();
            }
            return cp.containerInstance();
        }
        Object result = null;
        if (this.reuseContainer) {
            Object currentObject = ((XMLRecord)row).getCurrentObject();
            Object container = this.getAttributeAccessor().getAttributeValueFromObject(currentObject);
            result = container != null ? container : cp.containerInstance();
        } else {
            result = cp.containerInstance();
        }
        Enumeration stream = nestedRows.elements();
        while (stream.hasMoreElements()) {
            Object next = stream.nextElement();
            if (next instanceof Element) {
                XMLPlatformFactory.getInstance().getXMLPlatform().namespaceQualifyFragment((Element)next);
            }
            cp.addInto(next, result, executionSession);
        }
        return result;
    }

    public void writeFromObjectIntoRow(Object object, AbstractRecord row, AbstractSession session, DatabaseMapping.WriteType writeType) {
        if (this.isReadOnly()) {
            return;
        }
        Object attributeValue = this.getAttributeValueFromObject(object);
        if (attributeValue == null) {
            row.put(this.getField(), (Object)null);
            return;
        }
        ContainerPolicy cp = this.getContainerPolicy();
        Vector<Object> elements = new Vector<Object>(cp.sizeFor(attributeValue));
        Object iter = cp.iteratorFor(attributeValue);
        while (cp.hasNext(iter)) {
            Object element = cp.next(iter, session);
            if (element == null) continue;
            elements.addElement(element);
        }
        Object fieldValue = null;
        if (!elements.isEmpty()) {
            fieldValue = this.getDescriptor().buildFieldValueFromDirectValues(elements, this.elementDataTypeName, session);
        }
        row.put(this.getField(), fieldValue);
    }

    public boolean isAbstractCompositeDirectCollectionMapping() {
        return false;
    }

    public void writeSingleValue(Object attributeValue, Object parent, XMLRecord row, AbstractSession session) {
        if (((XMLField)this.getField()).getLastXPathFragment().isAttribute()) {
            if (attributeValue instanceof Attr) {
                attributeValue = ((Attr)attributeValue).getValue();
            }
        } else if (((XMLField)this.getField()).getLastXPathFragment().nameIsText() && attributeValue instanceof Text) {
            attributeValue = ((Text)attributeValue).getNodeValue();
        }
        row.put(this.getField(), attributeValue);
    }

    public boolean isWriteOnly() {
        return this.isWriteOnly;
    }

    public void setIsWriteOnly(boolean b) {
        this.isWriteOnly = b;
    }

    public void preInitialize(AbstractSession session) throws DescriptorException {
        this.getAttributeAccessor().setIsWriteOnly(this.isWriteOnly());
        this.getAttributeAccessor().setIsReadOnly(this.isReadOnly());
        super.preInitialize(session);
    }

    public void setAttributeValueInObject(Object object, Object value) throws DescriptorException {
        if (this.isWriteOnly()) {
            return;
        }
        super.setAttributeValueInObject(object, value);
    }

    public boolean getReuseContainer() {
        return this.reuseContainer;
    }

    public void setReuseContainer(boolean reuseContainer) {
        this.reuseContainer = reuseContainer;
    }
}

