/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.helper;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.FetchGroupManager;
import org.eclipse.persistence.exceptions.ConcurrencyException;
import org.eclipse.persistence.internal.helper.ConcurrencyManager;
import org.eclipse.persistence.internal.helper.linkedlist.ExposedNodeLinkedList;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.localization.TraceLocalization;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.MergeManager;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.mappings.DatabaseMapping;

public class WriteLockManager {
    public static int MAXTRIES = 10000;
    public static int MAX_WAIT = 600000;
    protected ExposedNodeLinkedList prevailingQueue = new ExposedNodeLinkedList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map acquireLocksForClone(Object objectForClone, ClassDescriptor descriptor, CacheKey cacheKey, AbstractSession cloningSession) {
        IdentityHashMap lockedObjects;
        block14: {
            Iterator lockedList3;
            boolean successful = false;
            lockedObjects = new IdentityHashMap();
            IdentityHashMap<Object, Object> refreshedObjects = new IdentityHashMap<Object, Object>();
            try {
                CacheKey toWaitOn = this.acquireLockAndRelatedLocks(objectForClone, lockedObjects, refreshedObjects, cacheKey, descriptor, cloningSession);
                int tries = 0;
                while (toWaitOn != null) {
                    Object lockedList2 = lockedObjects.values().iterator();
                    while (lockedList2.hasNext()) {
                        ((CacheKey)lockedList2.next()).releaseReadLock();
                        lockedList2.remove();
                    }
                    lockedList2 = toWaitOn.getMutex();
                    synchronized (lockedList2) {
                        try {
                            if (toWaitOn.isAcquired()) {
                                toWaitOn.getMutex().wait();
                            }
                        }
                        catch (InterruptedException ex) {
                            // empty catch block
                        }
                    }
                    Object waitObject = toWaitOn.getObject();
                    if (waitObject != null) {
                        cloningSession.checkAndRefreshInvalidObject(waitObject, toWaitOn, cloningSession.getDescriptor(waitObject));
                        refreshedObjects.put(waitObject, waitObject);
                    }
                    if ((toWaitOn = this.acquireLockAndRelatedLocks(objectForClone, lockedObjects, refreshedObjects, cacheKey, descriptor, cloningSession)) == null || ++tries <= MAXTRIES) continue;
                    throw ConcurrencyException.maxTriesLockOnCloneExceded(objectForClone);
                }
                successful = true;
                Object var14_13 = null;
                if (successful) break block14;
                lockedList3 = lockedObjects.values().iterator();
            }
            catch (Throwable throwable) {
                Object var14_14 = null;
                if (!successful) {
                    Iterator lockedList3 = lockedObjects.values().iterator();
                    while (lockedList3.hasNext()) {
                        ((CacheKey)lockedList3.next()).releaseReadLock();
                        lockedList3.remove();
                    }
                }
                throw throwable;
            }
            while (lockedList3.hasNext()) {
                ((CacheKey)lockedList3.next()).releaseReadLock();
                lockedList3.remove();
            }
        }
        return lockedObjects;
    }

    public CacheKey acquireLockAndRelatedLocks(Object objectForClone, Map lockedObjects, Map refreshedObjects, CacheKey cacheKey, ClassDescriptor descriptor, AbstractSession cloningSession) {
        if (!refreshedObjects.containsKey(objectForClone) && cloningSession.isConsideredInvalid(objectForClone, cacheKey, descriptor)) {
            return cacheKey;
        }
        if (cacheKey.acquireReadLockNoWait()) {
            if (cacheKey.getObject() == null) {
                lockedObjects.put(objectForClone, cacheKey);
            } else {
                objectForClone = cacheKey.getObject();
                if (lockedObjects.containsKey(objectForClone)) {
                    cacheKey.releaseReadLock();
                    return null;
                }
                lockedObjects.put(objectForClone, cacheKey);
            }
            return this.traverseRelatedLocks(objectForClone, lockedObjects, refreshedObjects, descriptor, cloningSession);
        }
        return cacheKey;
    }

    public void transitionToDeferredLocks(MergeManager mergeManager) {
        try {
            if (mergeManager.isTransitionedToDeferredLocks()) {
                return;
            }
            for (CacheKey cacheKey : mergeManager.getAcquiredLocks()) {
                cacheKey.transitionToDeferredLock();
            }
            mergeManager.transitionToDeferredLocks();
        }
        catch (RuntimeException ex) {
            for (CacheKey cacheKey : mergeManager.getAcquiredLocks()) {
                cacheKey.release();
            }
            ConcurrencyManager.getDeferredLockManager(Thread.currentThread()).setIsThreadComplete(true);
            ConcurrencyManager.removeDeferredLockManager(Thread.currentThread());
            mergeManager.getAcquiredLocks().clear();
            throw ex;
        }
    }

    public CacheKey traverseRelatedLocks(Object objectForClone, Map lockedObjects, Map refreshedObjects, ClassDescriptor descriptor, AbstractSession cloningSession) {
        if (descriptor.shouldAcquireCascadedLocks()) {
            FetchGroupManager fetchGroupManager = descriptor.getFetchGroupManager();
            boolean isPartialObject = fetchGroupManager != null && fetchGroupManager.isPartialObject(objectForClone);
            for (DatabaseMapping mapping : descriptor.getLockableMappings()) {
                CacheKey toWaitOn;
                if (isPartialObject && !fetchGroupManager.isAttributeFetched(objectForClone, mapping.getAttributeName())) continue;
                Object objectToLock = mapping.getAttributeValueFromObject(objectForClone);
                if (mapping.isCollectionMapping()) {
                    if (objectToLock == null) continue;
                    ContainerPolicy cp = mapping.getContainerPolicy();
                    Object iterator = cp.iteratorFor(objectToLock);
                    while (cp.hasNext(iterator)) {
                        CacheKey toWaitOn2;
                        Object object = cp.next(iterator, cloningSession);
                        if (mapping.getReferenceDescriptor().hasWrapperPolicy()) {
                            object = mapping.getReferenceDescriptor().getWrapperPolicy().unwrapObject(object, cloningSession);
                        }
                        if ((toWaitOn2 = this.checkAndLockObject(object, lockedObjects, refreshedObjects, mapping, cloningSession)) == null) continue;
                        return toWaitOn2;
                    }
                    continue;
                }
                if (mapping.getReferenceDescriptor().hasWrapperPolicy()) {
                    objectToLock = mapping.getReferenceDescriptor().getWrapperPolicy().unwrapObject(objectToLock, cloningSession);
                }
                if ((toWaitOn = this.checkAndLockObject(objectToLock, lockedObjects, refreshedObjects, mapping, cloningSession)) == null) continue;
                return toWaitOn;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void acquireRequiredLocks(MergeManager mergeManager, UnitOfWorkChangeSet changeSet) {
        ExposedNodeLinkedList exposedNodeLinkedList;
        if (!MergeManager.LOCK_ON_MERGE) {
            return;
        }
        boolean locksToAcquire = true;
        try {
            try {
                mergeManager.setLockThread(Thread.currentThread());
                AbstractSession session = mergeManager.getSession();
                if (session.isUnitOfWork()) {
                    session = ((UnitOfWorkImpl)session).getParent();
                }
                block14: while (locksToAcquire) {
                    locksToAcquire = false;
                    ClassDescriptor descriptor = null;
                    for (ObjectChangeSet objectChangeSet : changeSet.getAllChangeSets().values()) {
                        if (objectChangeSet.getSynchronizationType() == 2 || objectChangeSet.getId() == null) continue;
                        descriptor = objectChangeSet.getDescriptor();
                        if (descriptor == null) {
                            descriptor = session.getDescriptor(objectChangeSet.getClassType(session));
                            objectChangeSet.setDescriptor(descriptor);
                        }
                        if (descriptor.shouldIsolateObjectsInUnitOfWork()) continue;
                        AbstractSession targetSession = session.getParentIdentityMapSession(descriptor, true, true);
                        CacheKey activeCacheKey = this.attemptToAcquireLock(descriptor, objectChangeSet.getId(), targetSession);
                        if (activeCacheKey == null) {
                            if (this.prevailingQueue.getFirst() == mergeManager) {
                                activeCacheKey = this.waitOnObjectLock(descriptor, objectChangeSet.getId(), targetSession, (int)Math.round(Math.random() * 500.0));
                            }
                            if (activeCacheKey == null) {
                                Object[] params;
                                this.releaseAllAcquiredLocks(mergeManager);
                                activeCacheKey = targetSession.getIdentityMapAccessorInstance().getCacheKeyForObjectForLock(objectChangeSet.getId(), descriptor.getJavaClass(), descriptor);
                                if (session.shouldLog(2, "cache")) {
                                    params = new Object[]{descriptor.getJavaClass(), objectChangeSet.getId(), Thread.currentThread().getName()};
                                    session.log(2, "cache", "dead_lock_encountered_on_write_no_cachekey", params, null);
                                }
                                if (mergeManager.getWriteLockQueued() == null) {
                                    params = this.prevailingQueue;
                                    synchronized (params) {
                                        mergeManager.setQueueNode(this.prevailingQueue.addLast(mergeManager));
                                    }
                                }
                                mergeManager.setWriteLockQueued(objectChangeSet.getId());
                                try {
                                    if (activeCacheKey != null) {
                                        params = activeCacheKey.getMutex();
                                        synchronized (params) {
                                            if (activeCacheKey.getMutex().isAcquired() && activeCacheKey.getMutex().getActiveThread() != Thread.currentThread()) {
                                                Thread thread = activeCacheKey.getMutex().getActiveThread();
                                                if (thread.isAlive()) {
                                                    long time = System.currentTimeMillis();
                                                    activeCacheKey.getMutex().wait(MAX_WAIT);
                                                    if (System.currentTimeMillis() - time >= (long)MAX_WAIT) {
                                                        StackTraceElement[] trace;
                                                        Object[] params2 = new Object[]{MAX_WAIT / 1000, descriptor.getJavaClassName(), activeCacheKey.getKey(), thread.getName()};
                                                        StringBuilder buffer = new StringBuilder(TraceLocalization.buildMessage("max_time_exceeded_for_acquirerequiredlocks_wait", params2));
                                                        for (StackTraceElement element : trace = thread.getStackTrace()) {
                                                            buffer.append("\t\tat");
                                                            buffer.append(element.toString());
                                                            buffer.append("\n");
                                                        }
                                                        session.log(7, "cache", buffer.toString());
                                                        session.getIdentityMapAccessor().printIdentityMapLocks();
                                                    }
                                                } else {
                                                    session.log(7, "cache", "releasing_invalid_lock", new Object[]{thread.getName(), descriptor.getJavaClass(), objectChangeSet.getId()});
                                                    while (activeCacheKey.isAcquired()) {
                                                        activeCacheKey.release();
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                                catch (InterruptedException exception) {
                                    throw ConcurrencyException.waitWasInterrupted(exception.getMessage());
                                }
                                locksToAcquire = true;
                                continue block14;
                            }
                            objectChangeSet.setActiveCacheKey(activeCacheKey);
                            mergeManager.getAcquiredLocks().add(activeCacheKey);
                            continue;
                        }
                        objectChangeSet.setActiveCacheKey(activeCacheKey);
                        mergeManager.getAcquiredLocks().add(activeCacheKey);
                    }
                }
                Object var23_23 = null;
            }
            catch (RuntimeException exception) {
                this.releaseAllAcquiredLocks(mergeManager);
                throw exception;
            }
            catch (Error error) {
                this.releaseAllAcquiredLocks(mergeManager);
                mergeManager.getSession().logThrowable(7, "transaction", error);
                throw error;
            }
            if (mergeManager.getWriteLockQueued() == null) return;
            exposedNodeLinkedList = this.prevailingQueue;
        }
        catch (Throwable throwable) {
            Object var23_24 = null;
            if (mergeManager.getWriteLockQueued() == null) throw throwable;
            ExposedNodeLinkedList exposedNodeLinkedList2 = this.prevailingQueue;
            synchronized (exposedNodeLinkedList2) {
                this.prevailingQueue.remove(mergeManager.getQueueNode());
            }
            mergeManager.setWriteLockQueued(null);
            throw throwable;
        }
        synchronized (exposedNodeLinkedList) {
            this.prevailingQueue.remove(mergeManager.getQueueNode());
        }
        mergeManager.setWriteLockQueued(null);
    }

    public CacheKey appendLock(Object primaryKey, Object objectToLock, ClassDescriptor descriptor, MergeManager mergeManager, AbstractSession session) {
        CacheKey lockedCacheKey = session.getIdentityMapAccessorInstance().acquireLockNoWait(primaryKey, descriptor.getJavaClass(), true, descriptor);
        if (lockedCacheKey == null) {
            session.getIdentityMapAccessorInstance().getWriteLockManager().transitionToDeferredLocks(mergeManager);
            lockedCacheKey = session.getIdentityMapAccessorInstance().acquireDeferredLock(primaryKey, descriptor.getJavaClass(), descriptor);
            Object cachedObject = lockedCacheKey.getObject();
            if (cachedObject == null) {
                cachedObject = lockedCacheKey.waitForObject();
            }
            lockedCacheKey.releaseDeferredLock();
            return lockedCacheKey;
        }
        if (lockedCacheKey.getObject() == null) {
            lockedCacheKey.setObject(objectToLock);
        }
        if (mergeManager.isTransitionedToDeferredLocks()) {
            lockedCacheKey.getMutex();
            ConcurrencyManager.getDeferredLockManager(Thread.currentThread()).getActiveLocks().add(lockedCacheKey.getMutex());
        } else {
            mergeManager.getAcquiredLocks().add(lockedCacheKey);
        }
        return lockedCacheKey;
    }

    protected CacheKey attemptToAcquireLock(ClassDescriptor descriptor, Object primaryKey, AbstractSession session) {
        return session.getIdentityMapAccessorInstance().acquireLockNoWait(primaryKey, descriptor.getJavaClass(), true, descriptor);
    }

    protected CacheKey checkAndLockObject(Object objectToLock, Map lockedObjects, Map refreshedObjects, DatabaseMapping mapping, AbstractSession cloningSession) {
        if (objectToLock != null && !lockedObjects.containsKey(objectToLock)) {
            Object primaryKeyToLock = null;
            ClassDescriptor referenceDescriptor = null;
            referenceDescriptor = mapping.getReferenceDescriptor().hasInheritance() || mapping.getReferenceDescriptor().isDescriptorForInterface() ? cloningSession.getDescriptor(objectToLock) : mapping.getReferenceDescriptor();
            if (referenceDescriptor.isDescriptorTypeAggregate()) {
                this.traverseRelatedLocks(objectToLock, lockedObjects, refreshedObjects, referenceDescriptor, cloningSession);
            } else {
                CacheKey toWaitOn;
                primaryKeyToLock = referenceDescriptor.getObjectBuilder().extractPrimaryKeyFromObject(objectToLock, cloningSession);
                CacheKey cacheKey = cloningSession.getIdentityMapAccessorInstance().getCacheKeyForObjectForLock(primaryKeyToLock, objectToLock.getClass(), referenceDescriptor);
                if (cacheKey == null) {
                    cacheKey = new CacheKey(primaryKeyToLock);
                    cacheKey.setReadTime(System.currentTimeMillis());
                }
                if ((toWaitOn = this.acquireLockAndRelatedLocks(objectToLock, lockedObjects, refreshedObjects, cacheKey, referenceDescriptor, cloningSession)) != null) {
                    return toWaitOn;
                }
            }
        }
        return null;
    }

    public void releaseAllAcquiredLocks(MergeManager mergeManager) {
        if (!MergeManager.LOCK_ON_MERGE) {
            return;
        }
        ArrayList<CacheKey> acquiredLocks = mergeManager.getAcquiredLocks();
        Iterator locks = acquiredLocks.iterator();
        RuntimeException exception = null;
        while (locks.hasNext()) {
            try {
                CacheKey cacheKeyToRemove = (CacheKey)locks.next();
                if (cacheKeyToRemove.getObject() == null) {
                    cacheKeyToRemove.removeFromOwningMap();
                }
                if (mergeManager.isTransitionedToDeferredLocks()) {
                    cacheKeyToRemove.releaseDeferredLock();
                    continue;
                }
                cacheKeyToRemove.release();
            }
            catch (RuntimeException e) {
                if (exception != null) continue;
                exception = e;
            }
        }
        acquiredLocks.clear();
        if (exception != null) {
            throw exception;
        }
    }

    protected CacheKey waitOnObjectLock(ClassDescriptor descriptor, Object primaryKey, AbstractSession session, int waitTime) {
        return session.getIdentityMapAccessorInstance().acquireLockWithWait(primaryKey, descriptor.getJavaClass(), true, descriptor, waitTime);
    }
}

