/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.cxf.creation.core.commands;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.xml.namespace.QName;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.ws.internal.cxf.core.CXFCorePlugin;
import org.eclipse.jst.ws.internal.cxf.core.context.WSDL2JavaPersistentContext;
import org.eclipse.jst.ws.internal.cxf.core.model.WSDL2JavaDataModel;
import org.eclipse.jst.ws.internal.cxf.core.resources.WebContentChangeListener;
import org.eclipse.jst.ws.internal.cxf.core.utils.FileUtils;
import org.eclipse.jst.ws.internal.cxf.creation.core.CXFCreationCorePlugin;
import org.eclipse.jst.ws.jaxws.core.utils.JDTUtils;
import org.eclipse.jst.ws.jaxws.core.utils.WSDLUtils;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.ws.internal.util.WSDLCopier;

public class WSDL2JavaDefaultingCommand
extends AbstractDataModelOperation {
    private WSDL2JavaDataModel model;
    private String projectName;
    private String inputURL;
    private WebContentChangeListener webContentChangeListener;

    public WSDL2JavaDefaultingCommand(WSDL2JavaDataModel model, String projectName, String inputURL) {
        this.model = model;
        this.projectName = projectName;
        this.inputURL = inputURL;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IStatus status = Status.OK_STATUS;
        this.webContentChangeListener = new WebContentChangeListener(this.projectName);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.webContentChangeListener, 1);
        WSDL2JavaPersistentContext context = CXFCorePlugin.getDefault().getWSDL2JavaContext();
        this.model.setDefaultRuntimeVersion(context.getDefaultRuntimeVersion());
        this.model.setDefaultRuntimeType(context.getDefaultRuntimeType());
        this.model.setGenerateImplementation(context.isGenerateImplementation());
        this.model.setGenerateServer(context.isGenerateServer());
        this.model.setDatabinding(context.getDatabinding());
        this.model.setFrontend(context.getFrontend());
        this.model.setWsdlVersion(context.getWsdlVersion());
        this.model.setGenerateAntBuildFile(context.isGenerateAntBuildFile());
        this.model.setIncludedNamespaces(new HashMap());
        this.model.setExcludedNamespaces(new HashMap());
        this.model.setXjcUseDefaultValues(context.isXjcUseDefaultValues());
        this.model.setXjcToString(context.isXjcToString());
        this.model.setXjcToStringMultiLine(context.isXjcToStringMultiLine());
        this.model.setXjcToStringSimple(context.isXjcToStringSimple());
        this.model.setXjcLocator(context.isXjcLocator());
        this.model.setXjcSyncMethods(context.isXjcSyncMethods());
        this.model.setXjcMarkGenerated(context.isXjcMarkGenerated());
        this.model.setValidate(context.isValidate());
        this.model.setProcessSOAPHeaders(context.isProcessSOAPHeaders());
        this.model.setLoadDefaultExcludesNamepsaceMapping(context.isLoadDefaultExcludesNamepsaceMapping());
        this.model.setLoadDefaultNamespacePackageNameMapping(context.isLoadDefaultNamespacePackageNameMapping());
        this.model.setUseDefaultValues(context.isUseDefaultValues());
        this.model.setAutoNameResolution(context.isAutoNameResolution());
        this.model.setNoAddressBinding(context.isNoAddressBinding());
        this.model.setUseSpringApplicationContext(context.isUseSpringApplicationContext());
        this.model.setJavaSourceFolder(JDTUtils.getJavaProjectSourceDirectoryPath((String)this.model.getProjectName()).toOSString());
        try {
            Definition definition = null;
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IProject project = workspace.getRoot().getProject(this.projectName);
            URL wsdlUrl = new URL(this.inputURL);
            this.model.setWsdlURL(wsdlUrl);
            if (wsdlUrl.getProtocol().equals("file")) {
                if (!FileUtils.isFileInWebContentFolder((IProject)project, (IPath)new Path(wsdlUrl.getPath()))) {
                    IFolder wsdlFolder = WSDLUtils.getWSDLFolder((IProject)project);
                    IPath wsdlFolderPath = wsdlFolder.getLocation();
                    File fileToCopy = new File(wsdlUrl.toURI());
                    WSDLCopier copier = new WSDLCopier();
                    copier.setSourceURI(wsdlUrl.toExternalForm());
                    copier.setTargetFolderURI(wsdlFolder.getLocationURI().toString());
                    workspace.run((IWorkspaceRunnable)copier, monitor);
                    wsdlFolder.refreshLocal(1, monitor);
                    File wsdlFile = wsdlFolderPath.addTrailingSeparator().append(fileToCopy.getName()).toFile();
                    this.model.setWsdlURL(wsdlFile.toURL());
                }
                if ((definition = WSDLUtils.readWSDL((URL)this.model.getWsdlURL())) != null) {
                    this.setTNSOnModel(definition);
                    this.setWSDLLocation(definition);
                }
            } else {
                String filename = "";
                definition = WSDLUtils.readWSDL((URL)wsdlUrl);
                if (definition != null) {
                    Map servicesMap = definition.getServices();
                    Set servicesSet = servicesMap.entrySet();
                    this.setTNSOnModel(definition);
                    this.setWSDLLocation(definition);
                    for (Map.Entry serviceEntry : servicesSet) {
                        Service service = (Service)serviceEntry.getValue();
                        Map portsMap = service.getPorts();
                        Set portsSet = portsMap.entrySet();
                        Iterator iterator = portsSet.iterator();
                        if (!iterator.hasNext()) continue;
                        Map.Entry portEntry = iterator.next();
                        Port port = (Port)portEntry.getValue();
                        PortType portType = port.getBinding().getPortType();
                        QName qName = portType.getQName();
                        filename = String.valueOf(qName.getLocalPart()) + ".wsdl";
                    }
                }
                IPath wsdlFolderPath = WSDLUtils.getWSDLFolder((IProject)project).getLocation();
                WSDLCopier copier = new WSDLCopier();
                copier.setSourceURI(wsdlUrl.toExternalForm());
                copier.setTargetFolderURI(wsdlFolderPath.toFile().toURI().toString());
                copier.setTargetFilename(filename);
                workspace.run((IWorkspaceRunnable)copier, monitor);
                File wsdlFile = wsdlFolderPath.addTrailingSeparator().append(filename).toFile();
                this.model.setWsdlURL(wsdlFile.toURI().toURL());
            }
            this.model.setWsdlFileName(this.getWSDLFileNameFromURL(this.model.getWsdlURL()));
            Path wsdlLocationPath = new Path(this.model.getWsdlURL().getPath());
            wsdlLocationPath = wsdlLocationPath.removeFirstSegments(WSDLUtils.getWebContentFolder((IProject)project).getLocation().matchingFirstSegments((IPath)wsdlLocationPath));
            if (wsdlLocationPath.getDevice() != null) {
                wsdlLocationPath = wsdlLocationPath.setDevice(null);
            }
            this.model.setWsdlDefinition(definition);
            this.model.setConfigWsdlLocation(wsdlLocationPath.toString());
        }
        catch (CoreException ce) {
            status = ce.getStatus();
            CXFCreationCorePlugin.log(status);
        }
        catch (URISyntaxException urise) {
            status = new Status(4, "org.eclipse.jst.ws.cxf.core", urise.getLocalizedMessage());
            CXFCreationCorePlugin.log(status);
        }
        catch (MalformedURLException murle) {
            status = new Status(4, "org.eclipse.jst.ws.cxf.core", murle.getLocalizedMessage());
            CXFCreationCorePlugin.log(murle);
        }
        catch (IOException ioe) {
            status = new Status(4, "org.eclipse.jst.ws.cxf.core", ioe.getLocalizedMessage());
            CXFCreationCorePlugin.log(ioe);
        }
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.webContentChangeListener);
        return status;
    }

    public String getWSDLFileNameFromURL(URL wsdlURL) {
        Path wsdlPath = new Path(wsdlURL.toExternalForm());
        return wsdlPath.lastSegment();
    }

    private void setWSDLLocation(Definition definition) throws MalformedURLException {
        String wsdlLocation = WSDLUtils.getWSDLLocation((Definition)definition);
        if (wsdlLocation != null) {
            this.model.setWsdlLocation(wsdlLocation);
        }
    }

    private void setTNSOnModel(Definition definition) {
        String targetNamespace = definition.getTargetNamespace();
        String packageName = WSDLUtils.getPackageNameFromNamespace((String)targetNamespace);
        this.model.setTargetNamespace(targetNamespace);
        this.model.getIncludedNamespaces().put(targetNamespace, packageName);
    }

    public WSDL2JavaDataModel getWSDL2JavaDataModel() {
        return this.model;
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IStatus status = Status.OK_STATUS;
        ArrayList changedResources = new ArrayList();
        changedResources.addAll(this.webContentChangeListener.getChangedResources());
        if (changedResources.size() > 0) {
            for (IResource resource : changedResources) {
                try {
                    resource.delete(true, monitor);
                }
                catch (CoreException ce) {
                    status = ce.getStatus();
                    CXFCreationCorePlugin.log(status);
                }
            }
        }
        this.model.getBindingFiles().clear();
        this.model.getIncludedNamespaces().clear();
        return status;
    }
}

