/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.ui.internal.persistence.options;

import com.ibm.icu.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import org.eclipse.jpt.common.ui.internal.JptCommonUiMessages;
import org.eclipse.jpt.common.ui.internal.util.SWTUtil;
import org.eclipse.jpt.common.ui.internal.widgets.Pane;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.StringConverter;
import org.eclipse.jpt.common.utility.internal.iterators.TransformationIterator;
import org.eclipse.jpt.common.utility.internal.model.value.CompositeListValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.PropertyListValueModelAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.SimpleCollectionValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.SortedListValueModelAdapter;
import org.eclipse.jpt.common.utility.model.value.CollectionValueModel;
import org.eclipse.jpt.common.utility.model.value.ListValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.WritablePropertyValueModel;
import org.eclipse.jpt.jpa.eclipselink.core.context.persistence.options.Options;
import org.eclipse.jpt.jpa.eclipselink.core.context.persistence.options.TargetDatabase;
import org.eclipse.jpt.jpa.eclipselink.ui.internal.EclipseLinkUiMessages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TargetDatabaseComposite
extends Pane<Options> {
    public TargetDatabaseComposite(Pane<? extends Options> parentPane, Composite parent) {
        super(parentPane, parent);
    }

    private PropertyValueModel<String> buildDefaultTargetDatabaseHolder() {
        return new PropertyAspectAdapter<Options, String>(this.getSubjectHolder(), new String[]{Options.DEFAULT_TARGET_DATABASE}){

            protected String buildValue_() {
                return TargetDatabaseComposite.this.getDefaultValue((Options)this.subject);
            }
        };
    }

    private ListValueModel<String> buildDefaultTargetDatabaseListHolder() {
        return new PropertyListValueModelAdapter(this.buildDefaultTargetDatabaseHolder());
    }

    private String buildDisplayString(String targetDatabaseName) {
        return SWTUtil.buildDisplayString(EclipseLinkUiMessages.class, ((Object)((Object)this)).getClass(), (Object)TargetDatabase.valueOf((String)targetDatabaseName));
    }

    private Comparator<String> buildTargetDatabaseComparator() {
        return new Comparator<String>(){

            @Override
            public int compare(String targetDatabase1, String targetDatabase2) {
                targetDatabase1 = TargetDatabaseComposite.this.buildDisplayString(targetDatabase1);
                targetDatabase2 = TargetDatabaseComposite.this.buildDisplayString(targetDatabase2);
                return Collator.getInstance().compare(targetDatabase1, targetDatabase2);
            }
        };
    }

    private StringConverter<String> buildTargetDatabaseConverter() {
        return new StringConverter<String>(){

            public String convertToString(String value) {
                try {
                    TargetDatabase.valueOf((String)value);
                    value = TargetDatabaseComposite.this.buildDisplayString(value);
                }
                catch (Exception exception) {}
                return value;
            }
        };
    }

    private WritablePropertyValueModel<String> buildTargetDatabaseHolder() {
        return new PropertyAspectAdapter<Options, String>(this.getSubjectHolder(), new String[]{"targetDatabase"}){

            protected String buildValue_() {
                String name = ((Options)this.subject).getTargetDatabase();
                if (name == null) {
                    name = TargetDatabaseComposite.this.getDefaultValue((Options)this.subject);
                }
                return name;
            }

            protected void setValue_(String value) {
                if (TargetDatabaseComposite.this.getDefaultValue((Options)this.subject).equals(value)) {
                    value = null;
                }
                ((Options)this.subject).setTargetDatabase(value);
            }
        };
    }

    private ListValueModel<String> buildTargetDatabaseListHolder() {
        ArrayList<ListValueModel<String>> holders = new ArrayList<ListValueModel<String>>(2);
        holders.add(this.buildDefaultTargetDatabaseListHolder());
        holders.add(this.buildTargetDatabasesListHolder());
        return new CompositeListValueModel(holders);
    }

    private Iterator<String> buildTargetDatabases() {
        return new TransformationIterator<TargetDatabase, String>(CollectionTools.iterator((Object[])TargetDatabase.values())){

            protected String transform(TargetDatabase next) {
                return next.name();
            }
        };
    }

    private CollectionValueModel<String> buildTargetDatabasesCollectionHolder() {
        return new SimpleCollectionValueModel((Collection)CollectionTools.collection(this.buildTargetDatabases()));
    }

    private ListValueModel<String> buildTargetDatabasesListHolder() {
        return new SortedListValueModelAdapter(this.buildTargetDatabasesCollectionHolder(), this.buildTargetDatabaseComparator());
    }

    private String getDefaultValue(Options subject) {
        String defaultValue = subject.getDefaultTargetDatabase();
        if (defaultValue != null) {
            return NLS.bind((String)JptCommonUiMessages.DefaultWithOneParam, (Object)defaultValue);
        }
        return JptCommonUiMessages.DefaultEmpty;
    }

    protected void initializeLayout(Composite container) {
        Combo combo = this.addLabeledEditableCombo(container, EclipseLinkUiMessages.PersistenceXmlOptionsTab_targetDatabaseLabel, this.buildTargetDatabaseListHolder(), this.buildTargetDatabaseHolder(), this.buildTargetDatabaseConverter(), "org.eclipse.jpt.jpa.ui.options_targetDatabase");
        SWTUtil.attachDefaultValueHandler((Combo)combo);
    }
}

