/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.pde.api.tools.internal.provisional.ISession;
import org.eclipse.pde.api.tools.internal.provisional.ISessionListener;
import org.eclipse.pde.api.tools.internal.provisional.ISessionManager;

public class SessionManager
implements ISessionManager {
    private List sessions = new ArrayList();
    private Set listeners = new HashSet();
    private ISession activeSession;

    public synchronized void addSession(ISession session, boolean activate) {
        if (session == null) {
            throw new IllegalArgumentException("The given session cannot be null");
        }
        if (!this.sessions.contains(session)) {
            this.sessions.add(session);
            this.fireSessionAdded(session);
        }
        if (activate) {
            this.activeSession = session;
            this.fireSessionActivated(session);
        }
    }

    public synchronized void removeSession(ISession session) {
        if (this.sessions.remove(session)) {
            if (session.equals(this.activeSession)) {
                this.activeSession = null;
                this.fireSessionActivated(null);
            }
            this.fireSessionRemoved(session);
        }
    }

    public synchronized void removeAllSessions() {
        ISession[] allSessions = this.sessions.toArray(new ISession[this.sessions.size()]);
        this.sessions.clear();
        this.activeSession = null;
        this.fireSessionActivated(null);
        int i = 0;
        while (i < allSessions.length) {
            ISession session = allSessions[i];
            this.fireSessionRemoved(session);
            ++i;
        }
    }

    public synchronized ISession[] getSessions() {
        return this.sessions.toArray(new ISession[this.sessions.size()]);
    }

    public synchronized void addSessionListener(ISessionListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("The given listener cannot be null");
        }
        this.listeners.add(listener);
    }

    public synchronized void removeSessionListener(ISessionListener listener) {
        this.listeners.remove(listener);
    }

    protected synchronized void fireSessionAdded(ISession session) {
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            ((ISessionListener)i.next()).sessionAdded(session);
        }
    }

    protected synchronized void fireSessionRemoved(ISession session) {
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            ((ISessionListener)i.next()).sessionRemoved(session);
        }
    }

    public ISession getActiveSession() {
        return this.activeSession;
    }

    protected synchronized void fireSessionActivated(ISession session) {
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            ((ISessionListener)i.next()).sessionActivated(session);
        }
    }

    public void activateSession(ISession session) {
        if (this.sessions.contains(session) && !session.equals(this.activeSession)) {
            this.activeSession = session;
            this.fireSessionActivated(session);
        }
    }
}

