/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.pde.internal.core.project.PDEProject;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.editor.ILauncherFormPageHelper;
import org.eclipse.pde.internal.ui.editor.MultiSourceEditor;
import org.eclipse.pde.internal.ui.editor.actions.ActionMenu;
import org.eclipse.ui.IEditorInput;

public abstract class PDELauncherFormEditor
extends MultiSourceEditor {
    Action[][] fActions = null;
    protected static final int RUN_LAUNCHER_INDEX = 0;
    protected static final int DEBUG_LAUNCHER_INDEX = 1;
    protected static final int PROFILE_LAUNCHER_INDEX = 2;
    static /* synthetic */ Class class$0;

    protected abstract ILauncherFormPageHelper getLauncherHelper();

    protected void contributeLaunchersToToolbar(IToolBarManager manager) {
        if (this.getLauncherHelper() != null) {
            ActionMenu runAction;
            Action[][] actions = this.getActions();
            if (actions[0].length > 0) {
                runAction = new ActionMenu(actions[0]);
                manager.add((IAction)runAction);
            }
            if (actions[1].length > 0) {
                runAction = new ActionMenu(actions[1]);
                manager.add((IAction)runAction);
            }
            if (actions[2].length > 0) {
                runAction = new ActionMenu(actions[2]);
                manager.add((IAction)runAction);
            }
        }
    }

    private Action[][] getActions() {
        if (this.fActions == null) {
            this.fActions = new Action[3][];
            IConfigurationElement[][] elements = this.getLaunchers(this.getLauncherHelper().isOSGi());
            this.fActions[0] = this.getLauncherActions(elements[0]);
            this.fActions[1] = this.getLauncherActions(elements[1]);
            this.fActions[2] = this.getLauncherActions(elements[2]);
        }
        return this.fActions;
    }

    private Action[] getLauncherActions(IConfigurationElement[] elements) {
        Action[] result = new Action[elements.length];
        int i = 0;
        while (i < elements.length) {
            String label = elements[i].getAttribute("label");
            final String thisLaunchShortcut = this.getLaunchString(elements[i]);
            Action thisAction = new Action(label){

                public void run() {
                    PDELauncherFormEditor.this.doSave(null);
                    PDELauncherFormEditor.this.launch(thisLaunchShortcut, PDELauncherFormEditor.this.getPreLaunchRunnable(), PDELauncherFormEditor.this.getLauncherHelper().getLaunchObject());
                }
            };
            thisAction.setToolTipText(label);
            thisAction.setImageDescriptor(this.getImageDescriptor(elements[i]));
            result[i] = thisAction;
            ++i;
        }
        return result;
    }

    protected Runnable getPreLaunchRunnable() {
        return new Runnable(){

            public void run() {
                PDELauncherFormEditor.this.getLauncherHelper().preLaunch();
            }
        };
    }

    public String getLaunchString(IConfigurationElement e) {
        StringBuffer sb = new StringBuffer("launchShortcut.");
        sb.append(e.getAttribute("mode"));
        sb.append(".");
        sb.append(e.getAttribute("id"));
        return sb.toString();
    }

    private ImageDescriptor getImageDescriptor(IConfigurationElement element) {
        String mode = element.getAttribute("mode");
        if (mode == null) {
            return null;
        }
        if (mode.equals("run")) {
            return PDEPluginImages.DESC_RUN_EXC;
        }
        if (mode.equals("debug")) {
            return PDEPluginImages.DESC_DEBUG_EXC;
        }
        if (mode.equals("profile")) {
            return PDEPluginImages.DESC_PROFILE_EXC;
        }
        return null;
    }

    public void launch(String launchShortcut, Runnable preLaunch, Object launchObject) {
        if (launchShortcut.startsWith("launchShortcut.")) {
            int index = (launchShortcut = launchShortcut.substring(15)).indexOf(46);
            if (index < 0) {
                return;
            }
            String mode = launchShortcut.substring(0, index);
            String id = launchShortcut.substring(index + 1);
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IConfigurationElement[] elements = registry.getConfigurationElementsFor("org.eclipse.debug.ui.launchShortcuts");
            int i = 0;
            while (i < elements.length) {
                if (id.equals(elements[i].getAttribute("id"))) {
                    try {
                        ILaunchShortcut shortcut = (ILaunchShortcut)elements[i].createExecutableExtension("class");
                        preLaunch.run();
                        shortcut.launch((ISelection)new StructuredSelection(launchObject), mode);
                    }
                    catch (CoreException coreException) {}
                }
                ++i;
            }
        }
    }

    protected IConfigurationElement[][] getLaunchers(boolean osgi) {
        String[] values;
        IProject project;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] elements = registry.getConfigurationElementsFor("org.eclipse.pde.ui.launchShortcuts");
        ArrayList<IConfigurationElement> runList = new ArrayList<IConfigurationElement>();
        ArrayList<IConfigurationElement> debugList = new ArrayList<IConfigurationElement>();
        ArrayList<IConfigurationElement> profileList = new ArrayList<IConfigurationElement>();
        IEditorInput iEditorInput = this.getEditorInput();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IResource resource = (IResource)iEditorInput.getAdapter((Class)clazz);
        HashSet<String> specificIds = null;
        if (resource != null && (project = resource.getProject()) != null && (values = PDEProject.getLaunchShortcuts((IProject)project)) != null) {
            specificIds = new HashSet<String>();
            int i = 0;
            while (i < values.length) {
                specificIds.add(values[i]);
                ++i;
            }
        }
        int i = 0;
        while (i < elements.length) {
            String mode = elements[i].getAttribute("mode");
            String id = elements[i].getAttribute("id");
            String projectSpecific = elements[i].getAttribute("projectSpecific");
            if (mode != null && elements[i].getAttribute("label") != null && id != null) {
                boolean include = false;
                if (specificIds != null) {
                    include = specificIds.contains(id);
                } else {
                    boolean bl = include = osgi == "true".equals(elements[i].getAttribute("osgi")) && !"true".equals(projectSpecific);
                }
                if (include) {
                    if (mode.equals("run")) {
                        runList.add(elements[i]);
                    } else if (mode.equals("debug")) {
                        debugList.add(elements[i]);
                    } else if (mode.equals("profile")) {
                        profileList.add(elements[i]);
                    }
                }
            }
            ++i;
        }
        IConfigurationElement[] runElements = runList.toArray(new IConfigurationElement[runList.size()]);
        IConfigurationElement[] debugElements = debugList.toArray(new IConfigurationElement[debugList.size()]);
        IConfigurationElement[] profileElements = profileList.toArray(new IConfigurationElement[profileList.size()]);
        Comparator comparator = new Comparator(){

            public int compare(Object arg0, Object arg1) {
                String label1 = ((IConfigurationElement)arg0).getAttribute("label");
                String label2 = ((IConfigurationElement)arg1).getAttribute("label");
                return label1.compareTo(label2);
            }
        };
        Arrays.sort(runElements, comparator);
        Arrays.sort(debugElements, comparator);
        Arrays.sort(profileElements, comparator);
        return new IConfigurationElement[][]{runElements, debugElements, profileElements};
    }
}

