/*
 * Copyright (C) 2005 - 2007 JasperSoft Corporation.  All rights reserved.
 * http://www.jaspersoft.com.
 *
 * Unless you have purchased a commercial license agreement from JasperSoft,
 * the following license terms apply:
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as published by
 * the Free Software Foundation.
 *
 * This program is distributed WITHOUT ANY WARRANTY; and without the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see http://www.gnu.org/licenses/gpl.txt
 * or write to:
 *
 * Free Software Foundation, Inc.,
 * 59 Temple Place - Suite 330,
 * Boston, MA  USA  02111-1307
 */
package com.jaspersoft.ireport.jasperserver.ui.inputcontrols.impl;

import java.util.Date;
import java.util.GregorianCalendar;

/**
 *
 * @author  gtoffoli
 */
public class DateTimeInputControlUI extends javax.swing.JPanel implements InputControlUI {
    
    /** Creates new form BasicInputControlUI */
    public DateTimeInputControlUI() {
        initComponents();
        jSpinnerH.setModel( new javax.swing.SpinnerNumberModel(0,0,23,1));
        jSpinnerM.setModel( new javax.swing.SpinnerNumberModel(0,0,59,1));
        jSpinnerS.setModel( new javax.swing.SpinnerNumberModel(0,0,59,1));

    }
    
    public Object getValue()
    {
        Date date = jXDatePicker1.getDate();
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(date);
        gc.set(GregorianCalendar.HOUR, ((Number)jSpinnerH.getValue()).intValue());
        gc.set(GregorianCalendar.MINUTE, ((Number)jSpinnerH.getValue()).intValue());
        gc.set(GregorianCalendar.SECOND, ((Number)jSpinnerH.getValue()).intValue());
        
        return gc.getTime();
    }
    
    public void setValue(Object v)
    {
        /*
        for (int i=0; i<getJComboBoxValue().getItemCount(); ++i)
        {
            Object val = getJComboBoxValue().getItemAt(i);
            if (val.equals( v))
            {
                getJComboBoxValue().setSelectedIndex(i);
                return;
            }
        }
        
        getJComboBoxValue().setSelectedItem(v);
        */
        if (v instanceof Date)
        {
            jXDatePicker1.setDate((Date)v);
            GregorianCalendar gc = new GregorianCalendar();
            gc.setTime((Date)v);
            jSpinnerH.setValue( gc.get(GregorianCalendar.HOUR));
            jSpinnerM.setValue( gc.get(GregorianCalendar.MINUTE));
            jSpinnerS.setValue( gc.get(GregorianCalendar.SECOND));


        }
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jLabelName = new javax.swing.JLabel();
        jXDatePicker1 = new org.jdesktop.swingx.JXDatePicker();
        jLabelH = new javax.swing.JLabel();
        jSpinnerH = new javax.swing.JSpinner();
        jLabelMin = new javax.swing.JLabel();
        jSpinnerM = new javax.swing.JSpinner();
        jLabelSec = new javax.swing.JLabel();
        jSpinnerS = new javax.swing.JSpinner();

        setPreferredSize(new java.awt.Dimension(250, 40));
        setLayout(new java.awt.GridBagLayout());

        jLabelName.setText("jLabel1");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 4, 0, 4);
        add(jLabelName, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(0, 14, 0, 4);
        add(jXDatePicker1, gridBagConstraints);

        jLabelH.setText("Time");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 0, 2);
        add(jLabelH, gridBagConstraints);

        jSpinnerH.setMinimumSize(new java.awt.Dimension(35, 18));
        jSpinnerH.setPreferredSize(new java.awt.Dimension(35, 18));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 1;
        add(jSpinnerH, gridBagConstraints);

        jLabelMin.setText(":");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new java.awt.Insets(0, 2, 0, 2);
        add(jLabelMin, gridBagConstraints);

        jSpinnerM.setMinimumSize(new java.awt.Dimension(35, 18));
        jSpinnerM.setPreferredSize(new java.awt.Dimension(35, 18));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 1;
        add(jSpinnerM, gridBagConstraints);

        jLabelSec.setText(":");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new java.awt.Insets(0, 2, 0, 2);
        add(jLabelSec, gridBagConstraints);

        jSpinnerS.setMinimumSize(new java.awt.Dimension(35, 18));
        jSpinnerS.setPreferredSize(new java.awt.Dimension(35, 18));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 1;
        add(jSpinnerS, gridBagConstraints);
    }// </editor-fold>//GEN-END:initComponents
    
    public void setLabel(String lbl)
    {
        this.jLabelName.setText(lbl);
    }
    
    public void setHistory(java.util.List values){

    }
    
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel jLabelH;
    private javax.swing.JLabel jLabelMin;
    private javax.swing.JLabel jLabelName;
    private javax.swing.JLabel jLabelSec;
    private javax.swing.JSpinner jSpinnerH;
    private javax.swing.JSpinner jSpinnerM;
    private javax.swing.JSpinner jSpinnerS;
    private org.jdesktop.swingx.JXDatePicker jXDatePicker1;
    // End of variables declaration//GEN-END:variables
    
    public void setReadOnly( boolean b )
    {
        jLabelName.setEnabled(!b);
        jXDatePicker1.setEnabled(!b);
    }
}
