/*
 * EJBQLConnectionEditor.java
 *
 * Created on March 27, 2007, 1:18 PM
 */

package com.jaspersoft.ireport.designer.connection.gui;

import com.jaspersoft.ireport.locale.I18n;
import com.jaspersoft.ireport.designer.IReportConnection;
import com.jaspersoft.ireport.designer.IReportConnectionEditor;
import com.jaspersoft.ireport.designer.connection.JRCustomDataSourceConnection;

/**
 *
 * @author  gtoffoli
 */
public class JRCustomDataSourceConnectionEditor extends javax.swing.JPanel implements IReportConnectionEditor {
    
    private IReportConnection iReportConnection = null;
    private boolean init = false;
    
    /** Creates new form EJBQLConnectionEditor */
    public JRCustomDataSourceConnectionEditor() {
        initComponents();
        //applyI18n();
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jPanelCustomDataSourceFactory = new javax.swing.JPanel();
        jLabel10 = new javax.swing.JLabel();
        jTextFieldJRCustomDataSourceFactoryClass = new javax.swing.JTextField();
        jLabel11 = new javax.swing.JLabel();
        jTextFieldJRCustomDataSourceMethod = new javax.swing.JTextField();

        setLayout(new java.awt.BorderLayout());

        jPanelCustomDataSourceFactory.setLayout(new java.awt.GridBagLayout());

        jLabel10.setText(I18n.getString("JRCustomDataSourceConnectionEditor.Label.FC")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(3, 5, 3, 3);
        jPanelCustomDataSourceFactory.add(jLabel10, gridBagConstraints);

        jTextFieldJRCustomDataSourceFactoryClass.setText("com.jaspersoft.ireport.examples.SampleJRDataSourceFactory");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(3, 5, 3, 3);
        jPanelCustomDataSourceFactory.add(jTextFieldJRCustomDataSourceFactoryClass, gridBagConstraints);

        jLabel11.setText(I18n.getString("JRCustomDataSourceConnectionEditor.Label.JRDataSource")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(3, 5, 3, 3);
        jPanelCustomDataSourceFactory.add(jLabel11, gridBagConstraints);

        jTextFieldJRCustomDataSourceMethod.setText("createDatasource");
        jTextFieldJRCustomDataSourceMethod.setPreferredSize(new java.awt.Dimension(314, 21));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(3, 5, 3, 3);
        jPanelCustomDataSourceFactory.add(jTextFieldJRCustomDataSourceMethod, gridBagConstraints);

        add(jPanelCustomDataSourceFactory, java.awt.BorderLayout.CENTER);
    }// </editor-fold>//GEN-END:initComponents
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel jLabel10;
    private javax.swing.JLabel jLabel11;
    private javax.swing.JPanel jPanelCustomDataSourceFactory;
    private javax.swing.JTextField jTextFieldJRCustomDataSourceFactoryClass;
    private javax.swing.JTextField jTextFieldJRCustomDataSourceMethod;
    // End of variables declaration//GEN-END:variables
    
    
    public void setIReportConnection(IReportConnection c) {
        
        this.iReportConnection = c;
        if (iReportConnection instanceof JRCustomDataSourceConnection)
        {
            JRCustomDataSourceConnection con = (JRCustomDataSourceConnection)iReportConnection;
            this.jTextFieldJRCustomDataSourceFactoryClass.setText( con.getFactoryClass());
            this.jTextFieldJRCustomDataSourceMethod.setText(con.getMethodToCall());
        }
    }

    public IReportConnection getIReportConnection() {
        
        IReportConnection irConn = new JRCustomDataSourceConnection();
        ((JRCustomDataSourceConnection)irConn).setFactoryClass( this.jTextFieldJRCustomDataSourceFactoryClass.getText().trim() );
        ((JRCustomDataSourceConnection)irConn).setMethodToCall( this.jTextFieldJRCustomDataSourceMethod.getText().trim() );
        iReportConnection = irConn;
        return iReportConnection;
    }
    
    /*
    public void applyI18n(){
                // Start autogenerated code ----------------------
                jLabel10.setText(I18n.getString("connectionDialog.label10","Factory class"));
                jLabel11.setText(I18n.getString("connectionDialog.label11","The static method to call to retrive the JRDataSource"));
                
    }
    */
    
    
}
