/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.outline.nodes;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.data.queryexecuters.QueryExecuterDef;
import com.jaspersoft.ireport.designer.menu.EditQueryAction;
import com.jaspersoft.ireport.designer.outline.nodes.DatasetChildren;
import com.jaspersoft.ireport.designer.outline.nodes.IRAbstractNode;
import com.jaspersoft.ireport.designer.sheet.Tag;
import com.jaspersoft.ireport.designer.sheet.editors.ComboBoxPropertyEditor;
import com.jaspersoft.ireport.designer.sheet.properties.FilterExpressionProperty;
import com.jaspersoft.ireport.designer.undo.DeleteDatasetUndoableEdit;
import com.jaspersoft.ireport.designer.undo.ObjectPropertyUndoableEdit;
import com.jaspersoft.ireport.locale.I18n;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import javax.swing.Action;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignQuery;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.openide.actions.DeleteAction;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.Lookup;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public class DatasetNode
extends IRAbstractNode
implements PropertyChangeListener {
    JasperDesign jd = null;
    JRDesignDataset dataset = null;

    public DatasetNode(JasperDesign jd, JRDesignDataset dataset, Lookup doLkp) {
        super((Children)new DatasetChildren(jd, dataset, doLkp), (Lookup)new ProxyLookup(new Lookup[]{doLkp, Lookups.singleton((Object)jd)}));
        this.jd = jd;
        this.dataset = dataset;
        this.setIconBaseWithExtension("com/jaspersoft/ireport/designer/resources/dataset-16.png");
        dataset.getEventSupport().addPropertyChangeListener((PropertyChangeListener)this);
    }

    public JRDesignDataset getDataset() {
        return this.dataset;
    }

    public String getDisplayName() {
        return this.dataset.getName();
    }

    protected Sheet createSheet() {
        Sheet sheet = super.createSheet();
        Sheet.Set datasetPropertySet = Sheet.createPropertiesSet();
        datasetPropertySet.setName("DATASET_PROPERTIES");
        datasetPropertySet.setDisplayName("Dataset properties");
        DatasetNode.fillDatasetPropertySet(datasetPropertySet, this.dataset, this.jd);
        sheet.put(datasetPropertySet);
        return sheet;
    }

    public static Sheet.Set fillDatasetPropertySet(Sheet.Set datasetPropertySet, JRDesignDataset dataset, JasperDesign jasperDesign) {
        if (!dataset.isMainDataset()) {
            datasetPropertySet.put((Node.Property)new NameProperty(dataset, jasperDesign));
        }
        datasetPropertySet.put((Node.Property)new ScriptletProperty(dataset));
        datasetPropertySet.put((Node.Property)new ResourceBundleProperty(dataset));
        datasetPropertySet.put((Node.Property)new WhenResourceMissingTypeProperty(dataset));
        datasetPropertySet.put((Node.Property)new QueryTextProperty(dataset));
        datasetPropertySet.put((Node.Property)new QueryLanguageProperty(dataset));
        datasetPropertySet.put((Node.Property)new FilterExpressionProperty(dataset));
        return datasetPropertySet;
    }

    public Action[] getActions(boolean context) {
        Action[] actions = super.getActions(context);
        ArrayList<Action> myactions = new ArrayList<Action>();
        for (int i = 0; i < actions.length; ++i) {
            myactions.add(actions[i]);
        }
        myactions.add((Action)SystemAction.get(EditQueryAction.class));
        myactions.add(null);
        myactions.add((Action)SystemAction.get(DeleteAction.class));
        return myactions.toArray(new Action[myactions.size()]);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        IReportManager.getInstance().notifyReportChange();
        if (evt.getPropertyName() == null) {
            return;
        }
        if (DatasetNode.acceptProperty(evt)) {
            this.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
            if (evt.getPropertyName().equals("name")) {
                this.fireDisplayNameChange(null, null);
            }
        }
        if (evt.getPropertyName().equals("query")) {
            this.firePropertyChange("text", evt.getOldValue(), evt.getNewValue());
            this.firePropertyChange("language", evt.getOldValue(), evt.getNewValue());
        }
    }

    public static boolean acceptProperty(PropertyChangeEvent evt) {
        if (evt.getPropertyName() == null) {
            return false;
        }
        return evt.getPropertyName().equals("name") || evt.getPropertyName().equals("resourceBundle") || evt.getPropertyName().equals("scriptletClass") || evt.getPropertyName().equals("filterExpression") || evt.getPropertyName().equals("WhenNoDataType") || evt.getPropertyName().equals("text") || evt.getPropertyName().equals("language");
    }

    public void destroy() throws IOException {
        int index = this.jd.getDatasetsList().indexOf(this.dataset);
        this.jd.removeDataset((JRDataset)this.dataset);
        DeleteDatasetUndoableEdit edit = new DeleteDatasetUndoableEdit(this.dataset, this.jd, index);
        IReportManager.getInstance().addUndoableEdit(edit, true);
        super.destroy();
    }

    public boolean canDestroy() {
        return true;
    }

    private static final class QueryTextProperty
    extends PropertySupport {
        private final JRDesignDataset dataset;

        public QueryTextProperty(JRDesignDataset dataset) {
            super("text", String.class, I18n.getString("DatasetNode.Property.QueryText"), I18n.getString("DatasetNode.Property.QueryTextdetail"), true, true);
            this.dataset = dataset;
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            if (this.dataset.getQuery() != null && this.dataset.getQuery().getText() != null) {
                return this.dataset.getQuery().getText();
            }
            return "";
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            JRDesignQuery oldValue = (JRDesignQuery)this.dataset.getQuery();
            String text = val == null ? "" : val + "";
            JRDesignQuery newValue = new JRDesignQuery();
            if (oldValue != null && oldValue.getLanguage() != null) {
                newValue.setLanguage(oldValue.getLanguage());
            } else {
                newValue.setLanguage("SQL");
            }
            newValue.setText(text);
            this.dataset.setQuery(newValue);
            ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.dataset, "Query", JRDesignQuery.class, oldValue, newValue);
            IReportManager.getInstance().addUndoableEdit(urob);
        }
    }

    private static final class QueryLanguageProperty
    extends PropertySupport {
        private final JRDesignDataset dataset;
        private ComboBoxPropertyEditor editor;

        public QueryLanguageProperty(JRDesignDataset dataset) {
            super("queryLanguage", String.class, I18n.getString("DatasetNode.Property.Query"), I18n.getString("DatasetNode.Property.Query"), true, true);
            this.dataset = dataset;
            this.setValue("suppressCustomEditor", Boolean.TRUE);
            this.setValue("oneline", Boolean.TRUE);
            this.setValue("canEditAsText", Boolean.TRUE);
        }

        public PropertyEditor getPropertyEditor() {
            if (this.editor == null) {
                ArrayList<Tag> list = new ArrayList<Tag>();
                list.add(new Tag("sql", "SQL"));
                list.add(new Tag("hql", "Hibernate Query Language (HQL)"));
                list.add(new Tag("xPath", "XPath"));
                list.add(new Tag("ejbql", "EJBQL"));
                list.add(new Tag("mdx", "MDX"));
                list.add(new Tag("xmla-mdx", "XMLA-MDX"));
                ArrayList<QueryExecuterDef> queryExecuters = IReportManager.getInstance().getQueryExecuters();
                for (QueryExecuterDef qe : queryExecuters) {
                    String s = qe.getLanguage();
                    boolean found = false;
                    for (int i = 0; i < list.size(); ++i) {
                        Tag t = (Tag)list.get(i);
                        if (!s.toLowerCase().equals((t.getValue() + "").toLowerCase())) continue;
                        found = true;
                    }
                    if (found) continue;
                    list.add(new Tag(qe.getLanguage()));
                }
                this.editor = new ComboBoxPropertyEditor(true, list);
            }
            return this.editor;
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            if (this.dataset.getQuery() != null && this.dataset.getQuery().getLanguage() != null) {
                return this.dataset.getQuery().getLanguage();
            }
            return "SQL";
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            String lang;
            JRDesignQuery oldValue = (JRDesignQuery)this.dataset.getQuery();
            String string = lang = val == null ? "SQL" : val + "";
            if (lang.trim().length() == 0) {
                lang = "SQL";
            }
            JRDesignQuery newValue = new JRDesignQuery();
            if (oldValue != null && oldValue.getText() != null) {
                newValue.setText(oldValue.getText());
            }
            newValue.setLanguage(lang);
            this.dataset.setQuery(newValue);
            ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.dataset, "Query", JRDesignQuery.class, oldValue, newValue);
            IReportManager.getInstance().addUndoableEdit(urob);
        }
    }

    private static final class WhenResourceMissingTypeProperty
    extends PropertySupport {
        private final JRDesignDataset dataset;
        private ComboBoxPropertyEditor editor;

        public WhenResourceMissingTypeProperty(JRDesignDataset dataset) {
            super("WhenResourceMissingType", Byte.class, I18n.getString("DatasetNode.Property.ResourceMissig"), I18n.getString("DatasetNode.Property.ResourceMissigdetail"), true, true);
            this.dataset = dataset;
            this.setValue("suppressCustomEditor", Boolean.TRUE);
        }

        public PropertyEditor getPropertyEditor() {
            if (this.editor == null) {
                ArrayList<Tag> l = new ArrayList<Tag>();
                l.add(new Tag(new Byte(2), I18n.getString("DatasetNode.Property.Empty")));
                l.add(new Tag(new Byte(4), I18n.getString("DatasetNode.Property.Error")));
                l.add(new Tag(new Byte(3), I18n.getString("DatasetNode.Property.Key")));
                l.add(new Tag(new Byte(1), I18n.getString("DatasetNode.Property.Null")));
                this.editor = new ComboBoxPropertyEditor(false, l);
            }
            return this.editor;
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return new Byte(this.dataset.getWhenResourceMissingType());
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (val instanceof Byte) {
                Byte oldValue = this.dataset.getWhenResourceMissingType();
                Byte newValue = (Byte)val;
                this.dataset.setWhenResourceMissingType(newValue.byteValue());
                ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.dataset, "WhenResourceMissingType", Byte.TYPE, oldValue, newValue);
                IReportManager.getInstance().addUndoableEdit(urob);
            }
        }
    }

    private static final class ResourceBundleProperty
    extends PropertySupport {
        private final JRDesignDataset dataset;

        public ResourceBundleProperty(JRDesignDataset dataset) {
            super("resourceBundle", String.class, "Resource bundle", "The base name of the resource bundle used to localize the report", true, true);
            this.dataset = dataset;
            this.setValue("oneline", Boolean.TRUE);
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.dataset.getResourceBundle() == null ? "" : this.dataset.getResourceBundle();
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (val instanceof String) {
                String oldValue = this.dataset.getResourceBundle();
                String newValue = val == null || ((String)val).trim().length() == 0 ? null : ((String)val).trim();
                this.dataset.setResourceBundle(newValue);
                ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.dataset, "ResourceBundle", String.class, oldValue, newValue);
                IReportManager.getInstance().addUndoableEdit(urob);
            }
        }
    }

    private static final class ScriptletProperty
    extends PropertySupport {
        private final JRDesignDataset dataset;

        public ScriptletProperty(JRDesignDataset dataset) {
            super("scriptletClass", String.class, "Scriptlet class", "The scriptlet class to use with the dataset", true, true);
            this.dataset = dataset;
            this.setValue("oneline", Boolean.TRUE);
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.dataset.getScriptletClass() == null ? "" : this.dataset.getScriptletClass();
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (val instanceof String) {
                String oldValue = this.dataset.getScriptletClass();
                String newValue = val == null || ((String)val).trim().length() == 0 ? null : ((String)val).trim();
                this.dataset.setScriptletClass(newValue);
                ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.dataset, "ScriptletClass", String.class, oldValue, newValue);
                IReportManager.getInstance().addUndoableEdit(urob);
            }
        }
    }

    private static final class NameProperty
    extends PropertySupport {
        private final JRDesignDataset dataset;
        private final JasperDesign jd;

        public NameProperty(JRDesignDataset dataset, JasperDesign jd) {
            super("name", String.class, "Dataset name", "The name of this dataset", true, true);
            this.dataset = dataset;
            this.jd = jd;
            this.setValue("oneline", Boolean.TRUE);
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.dataset.getName();
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (val instanceof String) {
                String oldValue = this.dataset.getName();
                String newValue = (String)val;
                this.dataset.setName(newValue);
                if (!this.dataset.isMainDataset()) {
                    this.jd.getDatasetMap().remove(oldValue);
                    this.jd.getDatasetMap().put(newValue, this.dataset);
                }
                ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.dataset, "Name", String.class, oldValue, newValue);
                IReportManager.getInstance().addUndoableEdit(urob);
            }
        }
    }
}

