/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.charts.multiaxis;

import com.jaspersoft.ireport.designer.charts.ChartSelectionJDialog;
import com.jaspersoft.ireport.designer.outline.nodes.ElementNode;
import com.jaspersoft.ireport.designer.utils.Misc;
import com.jaspersoft.ireport.locale.I18n;
import net.sf.jasperreports.charts.JRChartAxis;
import net.sf.jasperreports.charts.design.JRDesignChartAxis;
import net.sf.jasperreports.charts.design.JRDesignMultiAxisPlot;
import net.sf.jasperreports.engine.design.JRDesignChart;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.actions.NodeAction;

public final class AddAxisChartAction
extends NodeAction {
    private static AddAxisChartAction instance = null;

    public static synchronized AddAxisChartAction getInstance() {
        if (instance == null) {
            instance = new AddAxisChartAction();
        }
        return instance;
    }

    private AddAxisChartAction() {
    }

    public String getName() {
        return I18n.getString("AddAxisChart.Name");
    }

    protected void initialize() {
        super.initialize();
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }

    protected void performAction(Node[] activatedNodes) {
        JRDesignChart theChart = (JRDesignChart)((ElementNode)activatedNodes[0]).getElement();
        ChartSelectionJDialog cd = new ChartSelectionJDialog(Misc.getMainFrame(), true);
        cd.setMultiAxisMode(true);
        cd.setJasperDesign(((ElementNode)activatedNodes[0]).getJasperDesign());
        cd.setVisible(true);
        if (cd.getDialogResult() == 0) {
            JRDesignChart designChart = cd.getChart();
            JRDesignChartAxis axis = new JRDesignChartAxis(theChart);
            axis.setChart(designChart);
            ((JRDesignMultiAxisPlot)theChart.getPlot()).setChart(theChart);
            System.out.println("theChart in plot..." + ((JRDesignMultiAxisPlot)theChart.getPlot()).getChart());
            System.out.flush();
            System.out.println("axis.getChart..." + axis.getChart());
            System.out.flush();
            System.out.println("axis.getChart().getDataset..." + axis.getChart().getDataset());
            System.out.flush();
            ((JRDesignMultiAxisPlot)theChart.getPlot()).addAxis((JRChartAxis)axis);
        }
    }

    protected boolean enable(Node[] activatedNodes) {
        if (activatedNodes == null || activatedNodes.length != 1) {
            return false;
        }
        if (!(activatedNodes[0] instanceof ElementNode)) {
            return false;
        }
        ElementNode node = (ElementNode)activatedNodes[0];
        if (node.getElement() instanceof JRDesignChart) {
            return ((JRDesignChart)node.getElement()).getChartType() == 19;
        }
        return false;
    }
}

