/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.charts.themes;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Stroke;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.List;
import java.util.SortedSet;
import net.sf.jasperreports.charts.JRValueDisplay;
import net.sf.jasperreports.charts.fill.JRFillMeterPlot;
import net.sf.jasperreports.charts.fill.JRFillPie3DPlot;
import net.sf.jasperreports.charts.fill.JRFillPieDataset;
import net.sf.jasperreports.charts.fill.JRFillPiePlot;
import net.sf.jasperreports.charts.fill.JRFillThermometerPlot;
import net.sf.jasperreports.charts.themes.EyeCandySixtiesUtilities;
import net.sf.jasperreports.charts.themes.GradientBarRenderer3D;
import net.sf.jasperreports.charts.themes.GradientPaintDialPointer;
import net.sf.jasperreports.charts.themes.GradientXYBubbleRenderer;
import net.sf.jasperreports.charts.themes.ScaledDialValueIndicator;
import net.sf.jasperreports.charts.themes.SquareXYAreaRenderer;
import net.sf.jasperreports.charts.util.JRMeterInterval;
import net.sf.jasperreports.engine.JRChartPlot;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRStyleContainer;
import net.sf.jasperreports.engine.base.JRBaseFont;
import net.sf.jasperreports.engine.fill.DefaultChartTheme;
import net.sf.jasperreports.engine.fill.JRFillChart;
import net.sf.jasperreports.engine.util.JRFontUtil;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.Axis;
import org.jfree.chart.axis.CategoryAnchor;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.block.BlockBorder;
import org.jfree.chart.block.BlockFrame;
import org.jfree.chart.labels.PieSectionLabelGenerator;
import org.jfree.chart.labels.StandardPieSectionLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.DefaultDrawingSupplier;
import org.jfree.chart.plot.DrawingSupplier;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.plot.PiePlot3D;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.ThermometerPlot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.plot.dial.DialBackground;
import org.jfree.chart.plot.dial.DialCap;
import org.jfree.chart.plot.dial.DialFrame;
import org.jfree.chart.plot.dial.DialLayer;
import org.jfree.chart.plot.dial.DialPlot;
import org.jfree.chart.plot.dial.DialScale;
import org.jfree.chart.plot.dial.DialTextAnnotation;
import org.jfree.chart.plot.dial.StandardDialFrame;
import org.jfree.chart.plot.dial.StandardDialRange;
import org.jfree.chart.plot.dial.StandardDialScale;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.BarRenderer3D;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.chart.renderer.xy.CandlestickRenderer;
import org.jfree.chart.renderer.xy.XYAreaRenderer;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.chart.renderer.xy.XYBubbleRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLine3DRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.title.LegendTitle;
import org.jfree.chart.title.TextTitle;
import org.jfree.chart.title.Title;
import org.jfree.data.Range;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.data.general.ValueDataset;
import org.jfree.data.xy.DefaultHighLowDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.GradientPaintTransformType;
import org.jfree.ui.GradientPaintTransformer;
import org.jfree.ui.HorizontalAlignment;
import org.jfree.ui.RectangleAnchor;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RectangleInsets;
import org.jfree.ui.StandardGradientPaintTransformer;
import org.jfree.ui.TextAnchor;
import org.jfree.util.UnitType;

public class EyeCandySixtiesChartTheme
extends DefaultChartTheme {
    public static final Color[] COLORS = new Color[]{new Color(250, 97, 18), new Color(237, 38, 42), new Color(0, 111, 60), new Color(250, 223, 18), new Color(47, 137, 187), new Color(231, 133, 35), new Color(229, 1, 140), new Color(234, 171, 53)};
    public static final GradientPaint[] GRADIENT_PAINTS = new GradientPaint[]{new GradientPaint(0.0f, 0.0f, COLORS[0], 0.0f, 0.0f, COLORS[0].darker()), new GradientPaint(0.0f, 0.0f, COLORS[1], 0.0f, 0.0f, COLORS[1].darker()), new GradientPaint(0.0f, 0.0f, COLORS[2], 0.0f, 0.0f, COLORS[2].darker()), new GradientPaint(0.0f, 0.0f, COLORS[3], 0.0f, 0.0f, COLORS[3].darker()), new GradientPaint(0.0f, 0.0f, COLORS[4], 0.0f, 0.0f, COLORS[4].darker()), new GradientPaint(0.0f, 0.0f, COLORS[5], 0.0f, 0.0f, COLORS[5].darker()), new GradientPaint(0.0f, 0.0f, COLORS[6], 0.0f, 0.0f, COLORS[6].darker())};
    public static final Color GRIDLINE_COLOR = new Color(134, 134, 134);
    public static final Color BORDER_COLOR = new Color(27, 80, 108);
    public static final Color THERMOMETER_COLOR = Color.BLACK;

    protected void configureChart(JFreeChart jfreeChart, JRChartPlot jrPlot, byte evaluation) throws JRException {
        super.configureChart(jfreeChart, jrPlot, evaluation);
        JRFillChart chart = this.getChart();
        TextTitle title = jfreeChart.getTitle();
        float baseFontSize = chart.getLegendFont() != null ? (float)chart.getLegendFont().getFontSize() : 8.0f;
        double chartPadding = 10.0;
        if (title != null) {
            Font titleFont = title.getFont();
            if (chart.getTitleFont().isOwnBold() == null) {
                titleFont = titleFont.deriveFont(1);
            }
            if (chart.getTitleFont().getOwnFontSize() == null) {
                titleFont = titleFont.deriveFont(2.25f * baseFontSize);
            }
            title.setFont(titleFont);
            title.setHorizontalAlignment(HorizontalAlignment.CENTER);
            RectangleInsets padding = title.getPadding();
            title.setPadding(padding.getTop(), padding.getLeft(), padding.getBottom() + 15.0, padding.getRight());
        }
        for (int i = 0; i < jfreeChart.getSubtitleCount(); ++i) {
            TextTitle textSubtitle;
            Title subtitle = jfreeChart.getSubtitle(i);
            TextTitle textTitle = textSubtitle = subtitle instanceof TextTitle ? (TextTitle)subtitle : null;
            if (textSubtitle == null) continue;
            Font subtitleFont = textSubtitle.getFont();
            if (chart.getSubtitleFont().isOwnBold() == null) {
                subtitleFont = subtitleFont.deriveFont(0);
            }
            if (chart.getSubtitleFont().getOwnFontSize() == null) {
                subtitleFont = subtitleFont.deriveFont(baseFontSize);
            }
            textSubtitle.setFont(subtitleFont);
            textSubtitle.setHorizontalAlignment(HorizontalAlignment.LEFT);
            subtitle.setPosition(RectangleEdge.BOTTOM);
        }
        LegendTitle legend = jfreeChart.getLegend();
        if (legend != null) {
            Font legendFont = legend.getItemFont();
            if (chart.getLegendFont().isOwnBold() == null) {
                legendFont = legendFont.deriveFont(0);
            }
            if (chart.getLegendFont().getOwnFontSize() == null) {
                legendFont = legendFont.deriveFont(baseFontSize);
            }
            legend.setItemFont(legendFont);
            legend.setFrame((BlockFrame)BlockBorder.NONE);
            legend.setPosition(RectangleEdge.RIGHT);
            legend.setHorizontalAlignment(HorizontalAlignment.RIGHT);
        }
        jfreeChart.setBackgroundPaint((Paint)new GradientPaint(0.0f, 0.0f, new Color(41, 120, 162), 0.0f, (float)this.getChart().getHeight() * 0.7f, Color.WHITE, false));
        jfreeChart.setAntiAlias(true);
        JRLineBox lineBox = chart.getLineBox();
        if (lineBox.getLeftPen().getLineWidth().floatValue() == 0.0f && lineBox.getBottomPen().getLineWidth().floatValue() == 0.0f && lineBox.getRightPen().getLineWidth().floatValue() == 0.0f && lineBox.getTopPen().getLineWidth().floatValue() == 0.0f) {
            jfreeChart.setBorderStroke((Stroke)new BasicStroke(3.0f));
            jfreeChart.setBorderPaint((Paint)BORDER_COLOR);
            jfreeChart.setBorderVisible(true);
        }
        jfreeChart.setPadding(new RectangleInsets(UnitType.ABSOLUTE, chartPadding, chartPadding, chartPadding, chartPadding));
    }

    protected void configurePlot(Plot plot, JRChartPlot jrPlot) {
        super.configurePlot(plot, jrPlot);
        SortedSet seriesColors = this.getPlot().getSeriesColors();
        plot.setDrawingSupplier((DrawingSupplier)new DefaultDrawingSupplier((Paint[])COLORS, DefaultDrawingSupplier.DEFAULT_OUTLINE_PAINT_SEQUENCE, DefaultDrawingSupplier.DEFAULT_STROKE_SEQUENCE, DefaultDrawingSupplier.DEFAULT_OUTLINE_STROKE_SEQUENCE, DefaultDrawingSupplier.DEFAULT_SHAPE_SEQUENCE));
        if (plot instanceof CategoryPlot) {
            CategoryPlot categoryPlot = (CategoryPlot)plot;
            CategoryItemRenderer categoryRenderer = categoryPlot.getRenderer();
            CategoryDataset categoryDataset = categoryPlot.getDataset();
            for (int i = 0; i < categoryDataset.getRowCount(); ++i) {
                categoryRenderer.setSeriesOutlinePaint(i, (Paint)TRANSPARENT_PAINT);
            }
            categoryPlot.setRangeGridlinePaint((Paint)GRIDLINE_COLOR);
            categoryPlot.setRangeGridlineStroke((Stroke)new BasicStroke(1.0f));
            categoryPlot.setDomainGridlinesVisible(false);
            categoryPlot.getDomainAxis().setCategoryLabelPositions(CategoryLabelPositions.UP_45);
        } else if (plot instanceof XYPlot) {
            XYPlot xyPlot = (XYPlot)plot;
            XYDataset xyDataset = xyPlot.getDataset();
            XYItemRenderer xyItemRenderer = xyPlot.getRenderer();
            for (int i = 0; i < xyDataset.getSeriesCount(); ++i) {
                xyItemRenderer.setSeriesOutlinePaint(i, (Paint)TRANSPARENT_PAINT);
            }
            xyPlot.setRangeGridlinePaint((Paint)GRIDLINE_COLOR);
            xyPlot.setRangeGridlineStroke((Stroke)new BasicStroke(1.0f));
            xyPlot.setDomainGridlinesVisible(false);
        }
        plot.setForegroundAlpha(1.0f);
    }

    protected void configureAxis(Axis axis, JRFont labelFont, Color labelColor, JRFont tickLabelFont, Color tickLabelColor, String tickLabelMask, Color axisLineColor) {
        super.configureAxis(axis, labelFont, labelColor, tickLabelFont, tickLabelColor, tickLabelMask, axisLineColor);
        axis.setAxisLinePaint((Paint)GRIDLINE_COLOR);
        axis.setAxisLineStroke((Stroke)new BasicStroke(1.0f));
        axis.setTickMarkPaint((Paint)GRIDLINE_COLOR);
        if (labelFont.isOwnBold() == null) {
            axis.setLabelFont(axis.getLabelFont().deriveFont(1));
        }
        if (labelFont.getOwnFontSize() == null) {
            axis.setLabelFont(axis.getLabelFont().deriveFont((float)tickLabelFont.getFontSize()));
        }
        if (tickLabelFont.isOwnBold() == null) {
            axis.setTickLabelFont(axis.getTickLabelFont().deriveFont(0));
        }
    }

    protected JFreeChart createAreaChart(byte evaluation) throws JRException {
        JFreeChart jfreeChart = super.createAreaChart(evaluation);
        CategoryPlot categoryPlot = (CategoryPlot)jfreeChart.getPlot();
        this.calculateTickUnits((Axis)categoryPlot.getRangeAxis());
        return jfreeChart;
    }

    protected JFreeChart createStackedAreaChart(byte evaluation) throws JRException {
        JFreeChart jfreeChart = super.createStackedAreaChart(evaluation);
        CategoryPlot categoryPlot = (CategoryPlot)jfreeChart.getPlot();
        this.calculateTickUnits((Axis)categoryPlot.getRangeAxis());
        return jfreeChart;
    }

    protected JFreeChart createXyAreaChart(byte evaluation) throws JRException {
        JFreeChart jfreeChart = super.createXyAreaChart(evaluation);
        XYPlot xyPlot = (XYPlot)jfreeChart.getPlot();
        SquareXYAreaRenderer squareXyAreaRenderer = new SquareXYAreaRenderer((XYAreaRenderer)xyPlot.getRenderer());
        xyPlot.setRenderer((XYItemRenderer)squareXyAreaRenderer);
        this.calculateTickUnits((Axis)xyPlot.getDomainAxis());
        this.calculateTickUnits((Axis)xyPlot.getRangeAxis());
        return jfreeChart;
    }

    protected JFreeChart createPieChart(byte evaluation) throws JRException {
        JFreeChart jfreeChart = super.createPieChart(evaluation);
        PiePlot piePlot = (PiePlot)jfreeChart.getPlot();
        piePlot.setLabelBackgroundPaint((Paint)TRANSPARENT_PAINT);
        piePlot.setLabelShadowPaint((Paint)TRANSPARENT_PAINT);
        piePlot.setLabelOutlinePaint((Paint)TRANSPARENT_PAINT);
        piePlot.setShadowXOffset(5.0);
        piePlot.setShadowYOffset(10.0);
        piePlot.setShadowPaint((Paint)new GradientPaint(0.0f, this.getChart().getHeight() / 2, new Color(41, 120, 162), 0.0f, this.getChart().getHeight(), Color.white));
        PieDataset pieDataset = piePlot.getDataset();
        for (int i = 0; i < pieDataset.getItemCount(); ++i) {
            piePlot.setSectionOutlinePaint(pieDataset.getKey(i), (Paint)TRANSPARENT_PAINT);
        }
        if (((JRFillPieDataset)this.getDataset()).getLabelGenerator() == null && ((JRFillPiePlot)this.getPlot()).getLabelFormat() == null) {
            piePlot.setLabelGenerator(null);
        }
        if (((JRFillPiePlot)this.getPlot()).getLegendLabelFormat() == null) {
            piePlot.setLegendLabelGenerator((PieSectionLabelGenerator)new StandardPieSectionLabelGenerator("{0}"));
        }
        piePlot.setCircular(true);
        return jfreeChart;
    }

    protected JFreeChart createPie3DChart(byte evaluation) throws JRException {
        JFreeChart jfreeChart = super.createPie3DChart(evaluation);
        PiePlot3D piePlot3D = (PiePlot3D)jfreeChart.getPlot();
        piePlot3D.setLabelBackgroundPaint((Paint)TRANSPARENT_PAINT);
        piePlot3D.setLabelShadowPaint((Paint)TRANSPARENT_PAINT);
        piePlot3D.setLabelOutlinePaint((Paint)TRANSPARENT_PAINT);
        piePlot3D.setDarkerSides(true);
        piePlot3D.setDepthFactor(0.1);
        PieDataset pieDataset = piePlot3D.getDataset();
        for (int i = 0; i < pieDataset.getItemCount(); ++i) {
            piePlot3D.setSectionOutlinePaint(pieDataset.getKey(i), (Paint)TRANSPARENT_PAINT);
        }
        if (((JRFillPieDataset)this.getDataset()).getLabelGenerator() == null && ((JRFillPie3DPlot)this.getPlot()).getLabelFormat() == null) {
            piePlot3D.setLabelGenerator(null);
        }
        if (((JRFillPie3DPlot)this.getPlot()).getLegendLabelFormat() == null) {
            piePlot3D.setLegendLabelGenerator((PieSectionLabelGenerator)new StandardPieSectionLabelGenerator("{0}"));
        }
        piePlot3D.setCircular(true);
        return jfreeChart;
    }

    protected JFreeChart createBarChart(byte evaluation) throws JRException {
        JFreeChart jfreeChart = super.createBarChart(evaluation);
        CategoryPlot categoryPlot = (CategoryPlot)jfreeChart.getPlot();
        BarRenderer barRenderer = (BarRenderer)categoryPlot.getRenderer();
        CategoryDataset categoryDataset = categoryPlot.getDataset();
        barRenderer.setItemMargin(0.0);
        barRenderer.setGradientPaintTransformer((GradientPaintTransformer)new StandardGradientPaintTransformer(GradientPaintTransformType.HORIZONTAL));
        for (int i = 0; i < categoryDataset.getRowCount(); ++i) {
            barRenderer.setSeriesPaint(i, (Paint)GRADIENT_PAINTS[i]);
        }
        this.calculateTickUnits((Axis)categoryPlot.getRangeAxis());
        return jfreeChart;
    }

    protected JFreeChart createStackedBarChart(byte evaluation) throws JRException {
        JFreeChart jfreeChart = super.createStackedBarChart(evaluation);
        CategoryPlot categoryPlot = (CategoryPlot)jfreeChart.getPlot();
        BarRenderer barRenderer = (BarRenderer)categoryPlot.getRenderer();
        CategoryDataset categoryDataset = categoryPlot.getDataset();
        barRenderer.setItemMargin(0.0);
        barRenderer.setGradientPaintTransformer((GradientPaintTransformer)new StandardGradientPaintTransformer(GradientPaintTransformType.HORIZONTAL));
        for (int i = 0; i < categoryDataset.getRowCount(); ++i) {
            barRenderer.setSeriesPaint(i, (Paint)GRADIENT_PAINTS[i]);
        }
        this.calculateTickUnits((Axis)categoryPlot.getRangeAxis());
        return jfreeChart;
    }

    protected JFreeChart createBar3DChart(byte evaluation) throws JRException {
        JFreeChart jfreeChart = super.createBar3DChart(evaluation);
        CategoryPlot categoryPlot = (CategoryPlot)jfreeChart.getPlot();
        BarRenderer3D barRenderer3D = (BarRenderer3D)categoryPlot.getRenderer();
        barRenderer3D = new GradientBarRenderer3D(barRenderer3D);
        categoryPlot.setRenderer((CategoryItemRenderer)barRenderer3D);
        barRenderer3D.setItemMargin(0.0);
        barRenderer3D.setWallPaint((Paint)TRANSPARENT_PAINT);
        CategoryDataset categoryDataset = categoryPlot.getDataset();
        barRenderer3D.setItemMargin(0.0);
        for (int i = 0; i < categoryDataset.getRowCount(); ++i) {
            barRenderer3D.setSeriesPaint(i, (Paint)GRADIENT_PAINTS[i]);
        }
        this.calculateTickUnits((Axis)categoryPlot.getRangeAxis());
        return jfreeChart;
    }

    protected JFreeChart createStackedBar3DChart(byte evaluation) throws JRException {
        JFreeChart jfreeChart = super.createStackedBar3DChart(evaluation);
        CategoryPlot categoryPlot = (CategoryPlot)jfreeChart.getPlot();
        BarRenderer3D barRenderer3D = (BarRenderer3D)categoryPlot.getRenderer();
        barRenderer3D.setWallPaint((Paint)TRANSPARENT_PAINT);
        barRenderer3D.setItemMargin(0.0);
        this.calculateTickUnits((Axis)categoryPlot.getRangeAxis());
        return jfreeChart;
    }

    protected JFreeChart createBubbleChart(byte evaluation) throws JRException {
        JFreeChart jfreeChart = super.createBubbleChart(evaluation);
        XYPlot xyPlot = (XYPlot)jfreeChart.getPlot();
        XYDataset xyDataset = xyPlot.getDataset();
        XYBubbleRenderer bubbleRenderer = (XYBubbleRenderer)xyPlot.getRenderer();
        bubbleRenderer = new GradientXYBubbleRenderer(bubbleRenderer.getScaleType());
        xyPlot.setRenderer((XYItemRenderer)bubbleRenderer);
        for (int i = 0; i < xyDataset.getSeriesCount(); ++i) {
            bubbleRenderer.setSeriesOutlinePaint(i, (Paint)TRANSPARENT_PAINT);
            bubbleRenderer.setSeriesPaint(i, (Paint)GRADIENT_PAINTS[i]);
        }
        this.calculateTickUnits((Axis)xyPlot.getDomainAxis());
        this.calculateTickUnits((Axis)xyPlot.getRangeAxis());
        return jfreeChart;
    }

    protected JFreeChart createXYBarChart(byte evaluation) throws JRException {
        JFreeChart jfreeChart = super.createXYBarChart(evaluation);
        XYPlot xyPlot = (XYPlot)jfreeChart.getPlot();
        XYDataset xyDataset = xyPlot.getDataset();
        XYBarRenderer renderer = (XYBarRenderer)xyPlot.getRenderer();
        renderer.setMargin(0.1);
        renderer.setGradientPaintTransformer((GradientPaintTransformer)new StandardGradientPaintTransformer(GradientPaintTransformType.HORIZONTAL));
        for (int i = 0; i < xyDataset.getSeriesCount(); ++i) {
            renderer.setSeriesPaint(i, (Paint)GRADIENT_PAINTS[i]);
        }
        this.calculateTickUnits((Axis)xyPlot.getDomainAxis());
        this.calculateTickUnits((Axis)xyPlot.getRangeAxis());
        return jfreeChart;
    }

    protected JFreeChart createHighLowChart(byte evaluation) throws JRException {
        JFreeChart jfreeChart = super.createHighLowChart(evaluation);
        XYPlot xyPlot = (XYPlot)jfreeChart.getPlot();
        this.calculateTickUnits((Axis)xyPlot.getDomainAxis());
        this.calculateTickUnits((Axis)xyPlot.getRangeAxis());
        return jfreeChart;
    }

    protected JFreeChart createScatterChart(byte evaluation) throws JRException {
        JFreeChart jfreeChart = super.createScatterChart(evaluation);
        XYPlot xyPlot = (XYPlot)jfreeChart.getPlot();
        Color gridColor = new Color(196, 196, 196);
        xyPlot.setRangeGridlinePaint((Paint)gridColor);
        xyPlot.setRangeGridlineStroke((Stroke)new BasicStroke(0.75f));
        xyPlot.setDomainGridlinesVisible(true);
        xyPlot.setDomainGridlinePaint((Paint)gridColor);
        xyPlot.setDomainGridlineStroke((Stroke)new BasicStroke(0.75f));
        xyPlot.setRangeZeroBaselineVisible(true);
        XYDataset xyDataset = xyPlot.getDataset();
        XYLineAndShapeRenderer lineRenderer = (XYLineAndShapeRenderer)xyPlot.getRenderer();
        lineRenderer.setUseFillPaint(true);
        for (int i = 0; i < xyDataset.getSeriesCount(); ++i) {
            lineRenderer.setSeriesOutlinePaint(i, (Paint)TRANSPARENT_PAINT);
            lineRenderer.setSeriesFillPaint(i, (Paint)GRADIENT_PAINTS[i]);
            lineRenderer.setSeriesPaint(i, (Paint)COLORS[i]);
        }
        this.calculateTickUnits((Axis)xyPlot.getDomainAxis());
        this.calculateTickUnits((Axis)xyPlot.getRangeAxis());
        return jfreeChart;
    }

    protected JFreeChart createXyLineChart(byte evaluation) throws JRException {
        JFreeChart jfreeChart = super.createXyLineChart(evaluation);
        XYPlot xyPlot = (XYPlot)jfreeChart.getPlot();
        XYLineAndShapeRenderer lineRenderer = (XYLineAndShapeRenderer)jfreeChart.getXYPlot().getRenderer();
        XYLine3DRenderer line3DRenderer = new XYLine3DRenderer();
        line3DRenderer.setBaseToolTipGenerator(lineRenderer.getBaseToolTipGenerator());
        line3DRenderer.setURLGenerator(lineRenderer.getURLGenerator());
        line3DRenderer.setBaseStroke((Stroke)new BasicStroke(2.0f, 1, 1));
        line3DRenderer.setBaseLinesVisible(lineRenderer.getBaseLinesVisible());
        line3DRenderer.setBaseShapesVisible(lineRenderer.getBaseShapesVisible());
        XYDataset xyDataset = xyPlot.getDataset();
        for (int i = 0; i < xyDataset.getSeriesCount(); ++i) {
            line3DRenderer.setSeriesStroke(i, (Stroke)new BasicStroke(2.0f, 1, 1));
            line3DRenderer.setSeriesLinesVisible(i, lineRenderer.getBaseLinesVisible());
            line3DRenderer.setSeriesShapesVisible(i, lineRenderer.getBaseShapesVisible());
        }
        line3DRenderer.setXOffset(2.0);
        line3DRenderer.setYOffset(2.0);
        line3DRenderer.setWallPaint((Paint)GRIDLINE_COLOR);
        xyPlot.setRenderer((XYItemRenderer)line3DRenderer);
        this.calculateTickUnits((Axis)xyPlot.getDomainAxis());
        this.calculateTickUnits((Axis)xyPlot.getRangeAxis());
        return jfreeChart;
    }

    protected JFreeChart createLineChart(byte evaluation) throws JRException {
        JFreeChart jfreeChart = super.createLineChart(evaluation);
        CategoryPlot categoryPlot = (CategoryPlot)jfreeChart.getPlot();
        LineAndShapeRenderer lineRenderer = (LineAndShapeRenderer)categoryPlot.getRenderer();
        lineRenderer.setStroke((Stroke)new BasicStroke(2.0f, 1, 1));
        for (int i = 0; i < lineRenderer.getRowCount(); ++i) {
            lineRenderer.setSeriesOutlinePaint(i, (Paint)TRANSPARENT_PAINT);
            lineRenderer.setSeriesFillPaint(i, (Paint)GRADIENT_PAINTS[i]);
            lineRenderer.setSeriesPaint(i, (Paint)GRADIENT_PAINTS[i]);
            lineRenderer.setSeriesShapesVisible(i, true);
        }
        this.calculateTickUnits((Axis)categoryPlot.getRangeAxis());
        return jfreeChart;
    }

    protected JFreeChart createGanttChart(byte evaluation) throws JRException {
        JFreeChart jfreeChart = super.createGanttChart(evaluation);
        CategoryPlot categoryPlot = (CategoryPlot)jfreeChart.getPlot();
        categoryPlot.getDomainAxis().setCategoryLabelPositions(CategoryLabelPositions.STANDARD);
        categoryPlot.setDomainGridlinesVisible(true);
        categoryPlot.setDomainGridlinePosition(CategoryAnchor.END);
        categoryPlot.setDomainGridlineStroke((Stroke)new BasicStroke(0.5f, 0, 0, 50.0f, new float[]{1.0f}, 0.0f));
        categoryPlot.setDomainGridlinePaint((Paint)GRIDLINE_COLOR);
        categoryPlot.setRangeGridlinesVisible(true);
        categoryPlot.setRangeGridlineStroke((Stroke)new BasicStroke(0.5f, 0, 0, 50.0f, new float[]{1.0f}, 0.0f));
        categoryPlot.setRangeGridlinePaint((Paint)GRIDLINE_COLOR);
        categoryPlot.getDomainAxis().setTickLabelsVisible(true);
        CategoryDataset categoryDataset = categoryPlot.getDataset();
        CategoryItemRenderer categoryRenderer = categoryPlot.getRenderer();
        categoryRenderer.setBaseItemLabelsVisible(true);
        BarRenderer barRenderer = (BarRenderer)categoryRenderer;
        barRenderer.setSeriesPaint(0, (Paint)COLORS[3]);
        barRenderer.setSeriesPaint(1, (Paint)COLORS[0]);
        for (int i = 0; i < categoryDataset.getRowCount(); ++i) {
            barRenderer.setSeriesItemLabelFont(i, categoryPlot.getDomainAxis().getTickLabelFont());
            barRenderer.setSeriesItemLabelsVisible(i, true);
        }
        categoryPlot.setOutlinePaint((Paint)Color.DARK_GRAY);
        categoryPlot.setOutlineStroke((Stroke)new BasicStroke(1.5f));
        categoryPlot.setOutlineVisible(true);
        return jfreeChart;
    }

    protected JFreeChart createMeterChart(byte evaluation) throws JRException {
        return this.createDialChart(evaluation);
    }

    protected JFreeChart createThermometerChart(byte evaluation) throws JRException {
        JRFillThermometerPlot jrPlot = (JRFillThermometerPlot)this.getPlot();
        ThermometerPlot chartPlot = new ThermometerPlot((ValueDataset)this.getDataset().getDataset());
        JFreeChart jfreeChart = new JFreeChart((Plot)chartPlot);
        this.configureChart(jfreeChart, this.getPlot(), evaluation);
        jfreeChart.setBackgroundPaint((Paint)TRANSPARENT_PAINT);
        jfreeChart.setBorderVisible(false);
        Range range = this.convertRange(jrPlot.getDataRange(), evaluation);
        chartPlot.setLowerBound(range.getLowerBound());
        chartPlot.setUpperBound(range.getUpperBound());
        chartPlot.setGap(0);
        chartPlot.setShowValueLines(jrPlot.isShowValueLines());
        chartPlot.setUnits(0);
        Paint paint = jrPlot.getMercuryColor() != null ? jrPlot.getMercuryColor() : GRADIENT_PAINTS[0];
        chartPlot.setMercuryPaint(paint);
        chartPlot.setThermometerPaint((Paint)THERMOMETER_COLOR);
        chartPlot.setThermometerStroke((Stroke)new BasicStroke(2.0f));
        chartPlot.setOutlineVisible(false);
        chartPlot.setValueFont(chartPlot.getValueFont().deriveFont(1));
        JRValueDisplay display = jrPlot.getValueDisplay();
        if (display != null) {
            if (display.getColor() != null) {
                chartPlot.setValuePaint((Paint)display.getColor());
            }
            if (display.getMask() != null) {
                chartPlot.setValueFormat((NumberFormat)new DecimalFormat(display.getMask()));
            }
            if (display.getFont() != null) {
                chartPlot.setValueFont(new Font(JRFontUtil.getAttributes((JRFont)display.getFont())).deriveFont(1));
            }
        }
        switch (jrPlot.getValueLocation()) {
            case 0: {
                chartPlot.setValueLocation(0);
                break;
            }
            case 1: {
                chartPlot.setValueLocation(2);
                break;
            }
            case 2: {
                chartPlot.setValueLocation(1);
                break;
            }
            default: {
                chartPlot.setValueLocation(3);
            }
        }
        range = this.convertRange(jrPlot.getLowRange(), evaluation);
        if (range != null) {
            chartPlot.setSubrangeInfo(2, range.getLowerBound(), range.getUpperBound());
        }
        if ((range = this.convertRange(jrPlot.getMediumRange(), evaluation)) != null) {
            chartPlot.setSubrangeInfo(1, range.getLowerBound(), range.getUpperBound());
        }
        if ((range = this.convertRange(jrPlot.getHighRange(), evaluation)) != null) {
            chartPlot.setSubrangeInfo(0, range.getLowerBound(), range.getUpperBound());
        }
        return jfreeChart;
    }

    protected JFreeChart createDialChart(byte evaluation) throws JRException {
        String label;
        String displayVisibility;
        JRFillMeterPlot jrPlot = (JRFillMeterPlot)this.getPlot();
        GradientPaint gp = new GradientPaint(new Point(), Color.LIGHT_GRAY, new Point(), Color.BLACK, false);
        GradientPaint gp2 = new GradientPaint(new Point(), Color.GRAY, new Point(), Color.BLACK);
        DialPlot dialPlot = new DialPlot();
        dialPlot.setDataset((ValueDataset)this.getDataset().getDataset());
        StandardDialFrame dialFrame = new StandardDialFrame();
        dialFrame.setForegroundPaint((Paint)gp2);
        dialPlot.setDialFrame((DialFrame)dialFrame);
        DialBackground db = new DialBackground((Paint)gp);
        db.setGradientPaintTransformer((GradientPaintTransformer)new StandardGradientPaintTransformer(GradientPaintTransformType.VERTICAL));
        dialPlot.setBackground((DialLayer)db);
        JRValueDisplay display = jrPlot.getValueDisplay();
        JRBaseFont jrFont = display != null && display.getFont() != null ? display.getFont() : new JRBaseFont(null, null, (JRStyleContainer)this.getChart(), null);
        Range range = this.convertRange(jrPlot.getDataRange(), evaluation);
        double bound = Math.max(Math.abs(range.getUpperBound()), Math.abs(range.getLowerBound()));
        int dialUnitScale = EyeCandySixtiesUtilities.getScale(bound);
        double lowerBound = EyeCandySixtiesUtilities.getTruncatedValue(range.getLowerBound(), dialUnitScale);
        double upperBound = EyeCandySixtiesUtilities.getTruncatedValue(range.getUpperBound(), dialUnitScale);
        StandardDialScale scale = new StandardDialScale(lowerBound, upperBound, 225.0, -270.0, (upperBound - lowerBound) / 6.0, 15);
        scale.setTickRadius(0.9);
        scale.setTickLabelOffset(0.16);
        scale.setTickLabelFont(new Font(JRFontUtil.getAttributes((JRFont)jrFont)).deriveFont(8.0f).deriveFont(1));
        scale.setMajorTickStroke((Stroke)new BasicStroke(1.0f));
        scale.setMinorTickStroke((Stroke)new BasicStroke(0.3f));
        scale.setMajorTickPaint((Paint)Color.WHITE);
        scale.setMinorTickPaint((Paint)Color.WHITE);
        scale.setTickLabelsVisible(true);
        scale.setFirstTickLabelVisible(true);
        if (lowerBound == (double)((int)lowerBound) && upperBound == (double)((int)upperBound) && scale.getMajorTickIncrement() == (double)((int)scale.getMajorTickIncrement()) || dialUnitScale > 1) {
            scale.setTickLabelFormatter((NumberFormat)new DecimalFormat("#,##0"));
        } else if (dialUnitScale == 1) {
            scale.setTickLabelFormatter((NumberFormat)new DecimalFormat("#,##0.0"));
        } else if (dialUnitScale <= 0) {
            scale.setTickLabelFormatter((NumberFormat)new DecimalFormat("#,##0.00"));
        }
        dialPlot.addScale(0, (DialScale)scale);
        List intervals = jrPlot.getIntervals();
        if (intervals != null && intervals.size() > 0) {
            int colorStep = 255 / intervals.size();
            for (int i = 0; i < intervals.size(); ++i) {
                JRMeterInterval interval = (JRMeterInterval)intervals.get(i);
                Range intervalRange = this.convertRange(interval.getDataRange(), evaluation);
                double intervalLowerBound = EyeCandySixtiesUtilities.getTruncatedValue(intervalRange.getLowerBound(), dialUnitScale);
                double intervalUpperBound = EyeCandySixtiesUtilities.getTruncatedValue(intervalRange.getUpperBound(), dialUnitScale);
                StandardDialRange dialRange = new StandardDialRange(intervalLowerBound, intervalUpperBound, (Paint)(interval.getBackgroundColor() == null ? new Color(255 - colorStep * i, 0 + colorStep * i, 0) : interval.getBackgroundColor()));
                dialRange.setInnerRadius(0.41);
                dialRange.setOuterRadius(0.42);
                dialPlot.addLayer((DialLayer)dialRange);
            }
        }
        String string = displayVisibility = display != null && this.getChart().hasProperties() ? this.getChart().getPropertiesMap().getProperty("net.sf.jasperreports.chart.dial.value.display.visible") : "false";
        if (Boolean.parseBoolean(displayVisibility)) {
            String pattern;
            ScaledDialValueIndicator dvi = new ScaledDialValueIndicator(0, dialUnitScale);
            dvi.setBackgroundPaint(TRANSPARENT_PAINT);
            dvi.setFont(new Font(JRFontUtil.getAttributes((JRFont)jrFont)).deriveFont(10.0f).deriveFont(1));
            dvi.setOutlinePaint(TRANSPARENT_PAINT);
            dvi.setPaint(Color.WHITE);
            String string2 = pattern = display.getMask() != null ? display.getMask() : "#,##0.####";
            if (pattern != null) {
                dvi.setNumberFormat(new DecimalFormat(pattern));
            }
            dvi.setRadius(0.15);
            dvi.setValueAnchor(RectangleAnchor.CENTER);
            dvi.setTextAnchor(TextAnchor.CENTER);
            dialPlot.addLayer((DialLayer)dvi);
        }
        String string3 = label = this.getChart().hasProperties() ? this.getChart().getPropertiesMap().getProperty("net.sf.jasperreports.chart.dial.label") : null;
        if (label != null) {
            label = dialUnitScale < 0 ? new MessageFormat(label).format(new Object[]{String.valueOf(Math.pow(10.0, dialUnitScale))}) : (dialUnitScale < 3 ? new MessageFormat(label).format(new Object[]{"1"}) : new MessageFormat(label).format(new Object[]{String.valueOf((int)Math.pow(10.0, dialUnitScale - 2))}));
            String[] textLines = label.split("\\n");
            for (int i = 0; i < textLines.length; ++i) {
                DialTextAnnotation dialAnnotation = new DialTextAnnotation(textLines[i]);
                dialAnnotation.setFont(new Font(JRFontUtil.getAttributes((JRFont)jrFont)).deriveFont(1));
                dialAnnotation.setPaint((Paint)Color.WHITE);
                dialAnnotation.setRadius(Math.sin(0.7853981633974483) + (double)i / 10.0);
                dialAnnotation.setAnchor(TextAnchor.CENTER);
                dialPlot.addLayer((DialLayer)dialAnnotation);
            }
        }
        GradientPaintDialPointer needle = new GradientPaintDialPointer(dialUnitScale);
        needle.setVisible(true);
        needle.setRadius(0.91);
        dialPlot.addLayer((DialLayer)needle);
        DialCap cap = new DialCap();
        cap.setRadius(0.05);
        cap.setFillPaint((Paint)Color.DARK_GRAY);
        cap.setOutlinePaint((Paint)Color.GRAY);
        cap.setOutlineStroke((Stroke)new BasicStroke(0.5f));
        dialPlot.setCap((DialLayer)cap);
        JFreeChart jfreeChart = new JFreeChart((String)this.evaluateExpression(this.getChart().getTitleExpression(), evaluation), null, (Plot)dialPlot, this.getChart().isShowLegend());
        this.configureChart(jfreeChart, this.getPlot(), evaluation);
        jfreeChart.setBackgroundPaint((Paint)TRANSPARENT_PAINT);
        jfreeChart.setBorderVisible(false);
        return jfreeChart;
    }

    protected JFreeChart createCandlestickChart(byte evaluation) throws JRException {
        JFreeChart jfreeChart = super.createCandlestickChart(evaluation);
        XYPlot xyPlot = (XYPlot)jfreeChart.getPlot();
        CandlestickRenderer renderer = (CandlestickRenderer)xyPlot.getRenderer();
        DefaultHighLowDataset dataset = (DefaultHighLowDataset)xyPlot.getDataset();
        for (int i = 0; i < dataset.getSeriesCount(); ++i) {
            renderer.setSeriesFillPaint(i, (Paint)COLORS[i]);
            renderer.setSeriesPaint(i, (Paint)Color.DARK_GRAY);
        }
        this.calculateTickUnits((Axis)xyPlot.getDomainAxis());
        this.calculateTickUnits((Axis)xyPlot.getRangeAxis());
        return jfreeChart;
    }

    private void calculateTickUnits(Axis axis) {
        if (axis instanceof NumberAxis) {
            int newTickUnitSize;
            NumberAxis numberAxis = (NumberAxis)axis;
            int maxNumberOfTicks = 5;
            int axisRange = (int)numberAxis.getRange().getLength();
            int tickUnitSize = newTickUnitSize = axisRange / maxNumberOfTicks;
            int i = 1;
            while (tickUnitSize > 9) {
                tickUnitSize /= 10;
                i *= 10;
            }
            newTickUnitSize = (tickUnitSize *= i) + i / 2;
            if (axisRange / newTickUnitSize > maxNumberOfTicks) {
                newTickUnitSize += i / 2;
            }
            if (numberAxis.getNumberFormatOverride() != null) {
                numberAxis.setTickUnit(new NumberTickUnit((double)newTickUnitSize, numberAxis.getNumberFormatOverride()));
            } else {
                numberAxis.setTickUnit(new NumberTickUnit((double)newTickUnitSize));
            }
        }
    }
}

