/*
 * Decompiled with CFR 0.152.
 */
package rex.utils;

import org.apache.log4j.Logger;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class XMLDocumentWriter {
    static Logger logger;

    public XMLDocumentWriter() {
        logger = Logger.getLogger(XMLDocumentWriter.class);
    }

    public void close() {
    }

    public void write(Node node) {
        this.write(node, "");
    }

    public void write(Node node, String indent) {
        switch (node.getNodeType()) {
            case 9: {
                Document doc = (Document)node;
                logger.info(indent + "<?xml version='1.0'?>");
                for (Node child = doc.getFirstChild(); child != null; child = child.getNextSibling()) {
                    this.write(child, indent);
                }
                break;
            }
            case 10: {
                DocumentType doctype = (DocumentType)node;
                logger.info("<!DOCTYPE " + doctype.getName() + ">");
                break;
            }
            case 1: {
                Element elt = (Element)node;
                logger.info(indent + "<" + elt.getTagName());
                NamedNodeMap attrs = elt.getAttributes();
                for (int i = 0; i < attrs.getLength(); ++i) {
                    Node a = attrs.item(i);
                    logger.info(" " + a.getNodeName() + "='" + this.fixup(a.getNodeValue()) + "'");
                }
                logger.info(">");
                String newindent = indent + "    ";
                for (Node child = elt.getFirstChild(); child != null; child = child.getNextSibling()) {
                    this.write(child, newindent);
                }
                logger.info(indent + "</" + elt.getTagName() + ">");
                break;
            }
            case 3: {
                Text textNode = (Text)node;
                String text = textNode.getData().trim();
                if (text == null || text.length() <= 0) break;
                logger.info(indent + this.fixup(text));
                break;
            }
            case 7: {
                ProcessingInstruction pi = (ProcessingInstruction)node;
                logger.info(indent + "<?" + pi.getTarget() + " " + pi.getData() + "?>");
                break;
            }
            case 5: {
                logger.info(indent + "&" + node.getNodeName() + ";");
                break;
            }
            case 4: {
                CDATASection cdata = (CDATASection)node;
                logger.info(indent + "<" + "![CDATA[" + cdata.getData() + "]]" + ">");
                break;
            }
            case 8: {
                Comment c = (Comment)node;
                logger.info(indent + "<!--" + c.getData() + "-->");
                break;
            }
            default: {
                logger.error("Ignoring node: " + node.getClass().getName());
            }
        }
    }

    String fixup(String s) {
        StringBuffer sb = new StringBuffer();
        int len = s.length();
        block7: for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            switch (c) {
                default: {
                    sb.append(c);
                    continue block7;
                }
                case '<': {
                    sb.append("&lt;");
                    continue block7;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block7;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block7;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block7;
                }
                case '\'': {
                    sb.append("&apos;");
                }
            }
        }
        return sb.toString();
    }
}

