/*
 * Decompiled with CFR 0.152.
 */
package rex.graphics;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import rex.graphics.MDXViewer;
import rex.graphics.Viewer;
import rex.utils.I18n;
import rex.utils.S;

public class RexTabbedPane
extends JTabbedPane
implements ActionListener {
    private static ImageIcon mdxViewerIcon = S.getAppIcon("mdx_viewer.gif");
    private static ImageIcon spinIcon = S.getAppIcon("earth2.gif");
    private static ImageIcon dontSpinIcon = S.getAppIcon("earth.gif");
    private boolean animationOn;

    public RexTabbedPane() {
        this.addMouseListener(new RexTabbedPanePopupListener(this));
    }

    public void setIconAnimationOn() {
        this.setIconAt(0, spinIcon);
        this.animationOn = true;
    }

    public void setIconAnimationOff() {
        this.setIconAt(0, dontSpinIcon);
        this.animationOn = false;
    }

    public String[] getAnimationPopUpList() {
        if (this.animationOn) {
            return new String[]{I18n.getString("str.stopSpinning")};
        }
        return new String[]{I18n.getString("str.spinAway")};
    }

    public void addMDXViewer(MDXViewer viewerToAdd, String cubeName) {
        this.addTab(cubeName, mdxViewerIcon, viewerToAdd);
    }

    public void removeMDXViewer(MDXViewer viewerToRemove) {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            if (this.getComponentAt(i) != viewerToRemove) continue;
            this.remove(i);
            return;
        }
    }

    public void closeViewer(Viewer viewerToClose) {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            if (this.getComponentAt(i) != viewerToClose) continue;
            this.remove(i);
            return;
        }
    }

    public void actionPerformed(ActionEvent e) {
        boolean i = false;
        if (this.animationOn) {
            this.setIconAt(0, dontSpinIcon);
            this.animationOn = false;
        } else {
            this.setIconAt(0, spinIcon);
            this.animationOn = true;
        }
    }

    class RexTabbedPanePopupListener
    extends MouseAdapter {
        JTabbedPane jtp;
        JPopupMenu popup;

        RexTabbedPanePopupListener(JTabbedPane _jtp) {
            this.jtp = _jtp;
            this.popup = new JPopupMenu();
        }

        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        public void mouseClicked(MouseEvent e) {
        }

        private void maybeShowPopup(MouseEvent e) {
            if (this.jtp.getSelectedIndex() == 0 && e.isPopupTrigger()) {
                this.popup.removeAll();
                String[] al = ((RexTabbedPane)this.jtp).getAnimationPopUpList();
                for (int i = 0; al != null && i < al.length; ++i) {
                    JMenuItem menuItem = new JMenuItem(al[i]);
                    menuItem.addActionListener((RexTabbedPane)this.jtp);
                    this.popup.add(menuItem);
                }
                this.popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }
}

