/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import java.awt.Color;
import java.awt.GraphicsEnvironment;
import java.awt.font.TextAttribute;
import java.io.IOException;
import java.io.StringReader;
import java.lang.ref.SoftReference;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.fonts.FontBundle;
import net.sf.jasperreports.engine.fonts.FontFamily;
import net.sf.jasperreports.engine.util.JRColorUtil;
import net.sf.jasperreports.engine.util.JRStringUtil;
import net.sf.jasperreports.engine.util.JRStyledText;
import net.sf.jasperreports.engine.util.JRTextAttribute;
import net.sf.jasperreports.engine.xml.JRXmlConstants;
import net.sf.jasperreports.extensions.ExtensionsEnvironment;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class JRStyledTextParser
implements ErrorHandler {
    private static final Set AVAILABLE_FONT_FACE_NAMES = new HashSet();
    private static final String ROOT_START = "<st>";
    private static final String ROOT_END = "</st>";
    private static final String NODE_style = "style";
    private static final String NODE_bold = "b";
    private static final String NODE_italic = "i";
    private static final String NODE_underline = "u";
    private static final String NODE_sup = "sup";
    private static final String NODE_sub = "sub";
    private static final String NODE_font = "font";
    private static final String NODE_br = "br";
    private static final String NODE_li = "li";
    private static final String ATTRIBUTE_fontName = "fontName";
    private static final String ATTRIBUTE_fontFace = "face";
    private static final String ATTRIBUTE_color = "color";
    private static final String ATTRIBUTE_size = "size";
    private static final String ATTRIBUTE_isBold = "isBold";
    private static final String ATTRIBUTE_isItalic = "isItalic";
    private static final String ATTRIBUTE_isUnderline = "isUnderline";
    private static final String ATTRIBUTE_isStrikeThrough = "isStrikeThrough";
    private static final String ATTRIBUTE_forecolor = "forecolor";
    private static final String ATTRIBUTE_backcolor = "backcolor";
    private static final String ATTRIBUTE_pdfFontName = "pdfFontName";
    private static final String ATTRIBUTE_pdfEncoding = "pdfEncoding";
    private static final String ATTRIBUTE_isPdfEmbedded = "isPdfEmbedded";
    private static final String SPACE = " ";
    private static final String EQUAL_QUOTE = "=\"";
    private static final String QUOTE = "\"";
    private static final String SHARP = "#";
    private static final String LESS = "<";
    private static final String LESS_SLASH = "</";
    private static final String GREATER = ">";
    private static final ThreadLocal threadInstances;
    private static final ThreadLocal threadLocale;
    private DocumentBuilder documentBuilder = null;

    public static JRStyledTextParser getInstance() {
        JRStyledTextParser instance = null;
        SoftReference instanceRef = (SoftReference)threadInstances.get();
        if (instanceRef != null) {
            instance = (JRStyledTextParser)instanceRef.get();
        }
        if (instance == null) {
            instance = new JRStyledTextParser();
            threadInstances.set(new SoftReference<JRStyledTextParser>(instance));
        }
        return instance;
    }

    public static void setLocale(Locale locale) {
        threadLocale.set(locale);
    }

    public static Locale getLocale() {
        return (Locale)threadLocale.get();
    }

    public JRStyledTextParser() {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            this.documentBuilder = factory.newDocumentBuilder();
            this.documentBuilder.setErrorHandler(this);
        }
        catch (ParserConfigurationException e) {
            throw new JRRuntimeException(e);
        }
    }

    public JRStyledText parse(Map attributes, String text) throws SAXException {
        JRStyledText styledText = new JRStyledText();
        Document document = null;
        try {
            document = this.documentBuilder.parse(new InputSource(new StringReader(ROOT_START + text + ROOT_END)));
        }
        catch (IOException e) {
            throw new JRRuntimeException(e);
        }
        this.parseStyle(styledText, document.getDocumentElement());
        styledText.setGlobalAttributes(attributes);
        return styledText;
    }

    public JRStyledText getStyledText(Map parentAttributes, String text, boolean isStyledText) {
        JRStyledText styledText = null;
        if (isStyledText) {
            try {
                styledText = this.parse(parentAttributes, text);
            }
            catch (SAXException e) {
                // empty catch block
            }
        }
        if (styledText == null) {
            styledText = new JRStyledText();
            styledText.append(text);
            styledText.setGlobalAttributes(parentAttributes);
        }
        return styledText;
    }

    public String write(JRStyledText styledText) {
        return this.write(styledText.getGlobalAttributes(), styledText.getAttributedString().getIterator(), styledText.getText());
    }

    public String write(Map parentAttrs, AttributedCharacterIterator iterator, String text) {
        StringBuffer sbuffer = new StringBuffer();
        int runLimit = 0;
        while (runLimit < iterator.getEndIndex() && (runLimit = iterator.getRunLimit()) <= iterator.getEndIndex()) {
            String chunk = text.substring(iterator.getIndex(), runLimit);
            Map<AttributedCharacterIterator.Attribute, Object> attrs = iterator.getAttributes();
            StringBuffer styleBuffer = this.writeStyleAttributes(parentAttrs, attrs);
            if (styleBuffer.length() > 0) {
                sbuffer.append(LESS);
                sbuffer.append(NODE_style);
                sbuffer.append(styleBuffer.toString());
                sbuffer.append(GREATER);
                this.writeChunk(sbuffer, parentAttrs, attrs, chunk);
                sbuffer.append(LESS_SLASH);
                sbuffer.append(NODE_style);
                sbuffer.append(GREATER);
            } else {
                this.writeChunk(sbuffer, parentAttrs, attrs, chunk);
            }
            iterator.setIndex(runLimit);
        }
        return sbuffer.toString();
    }

    public String write(JRStyledText styledText, int startIndex, int endIndex) {
        AttributedCharacterIterator subIterator = new AttributedString(styledText.getAttributedString().getIterator(), startIndex, endIndex).getIterator();
        String subText = styledText.getText().substring(startIndex, endIndex);
        return this.write(styledText.getGlobalAttributes(), subIterator, subText);
    }

    public void writeChunk(StringBuffer sbuffer, Map parentAttrs, Map attrs, String chunk) {
        Object value = attrs.get(TextAttribute.SUPERSCRIPT);
        Object oldValue = parentAttrs.get(TextAttribute.SUPERSCRIPT);
        boolean isSuper = false;
        boolean isSub = false;
        if (value != null && !value.equals(oldValue)) {
            isSuper = TextAttribute.SUPERSCRIPT_SUPER.equals(value);
            isSub = TextAttribute.SUPERSCRIPT_SUB.equals(value);
        }
        if (isSuper || isSub) {
            String node = isSuper ? NODE_sup : NODE_sub;
            sbuffer.append(LESS);
            sbuffer.append(node);
            sbuffer.append(GREATER);
            sbuffer.append(JRStringUtil.xmlEncode(chunk));
            sbuffer.append(LESS_SLASH);
            sbuffer.append(node);
            sbuffer.append(GREATER);
        } else {
            sbuffer.append(JRStringUtil.xmlEncode(chunk));
        }
    }

    private void parseStyle(JRStyledText styledText, Node parentNode) throws SAXException {
        NodeList nodeList = parentNode.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() == 3) {
                styledText.append(node.getNodeValue());
                continue;
            }
            if (node.getNodeType() == 1 && NODE_style.equals(node.getNodeName())) {
                Color color;
                NamedNodeMap nodeAttrs = node.getAttributes();
                HashMap<AttributedCharacterIterator.Attribute, Object> styleAttrs = new HashMap<AttributedCharacterIterator.Attribute, Object>();
                if (nodeAttrs.getNamedItem(ATTRIBUTE_fontName) != null) {
                    styleAttrs.put(TextAttribute.FAMILY, nodeAttrs.getNamedItem(ATTRIBUTE_fontName).getNodeValue());
                }
                if (nodeAttrs.getNamedItem(ATTRIBUTE_isBold) != null) {
                    styleAttrs.put(TextAttribute.WEIGHT, Boolean.valueOf(nodeAttrs.getNamedItem(ATTRIBUTE_isBold).getNodeValue()) != false ? TextAttribute.WEIGHT_BOLD : TextAttribute.WEIGHT_REGULAR);
                }
                if (nodeAttrs.getNamedItem(ATTRIBUTE_isItalic) != null) {
                    styleAttrs.put(TextAttribute.POSTURE, Boolean.valueOf(nodeAttrs.getNamedItem(ATTRIBUTE_isItalic).getNodeValue()) != false ? TextAttribute.POSTURE_OBLIQUE : TextAttribute.POSTURE_REGULAR);
                }
                if (nodeAttrs.getNamedItem(ATTRIBUTE_isUnderline) != null) {
                    styleAttrs.put(TextAttribute.UNDERLINE, Boolean.valueOf(nodeAttrs.getNamedItem(ATTRIBUTE_isUnderline).getNodeValue()) != false ? TextAttribute.UNDERLINE_ON : null);
                }
                if (nodeAttrs.getNamedItem(ATTRIBUTE_isStrikeThrough) != null) {
                    styleAttrs.put(TextAttribute.STRIKETHROUGH, Boolean.valueOf(nodeAttrs.getNamedItem(ATTRIBUTE_isStrikeThrough).getNodeValue()) != false ? TextAttribute.STRIKETHROUGH_ON : null);
                }
                if (nodeAttrs.getNamedItem(ATTRIBUTE_size) != null) {
                    styleAttrs.put(TextAttribute.SIZE, new Float(nodeAttrs.getNamedItem(ATTRIBUTE_size).getNodeValue()));
                }
                if (nodeAttrs.getNamedItem(ATTRIBUTE_pdfFontName) != null) {
                    styleAttrs.put(JRTextAttribute.PDF_FONT_NAME, nodeAttrs.getNamedItem(ATTRIBUTE_pdfFontName).getNodeValue());
                }
                if (nodeAttrs.getNamedItem(ATTRIBUTE_pdfEncoding) != null) {
                    styleAttrs.put(JRTextAttribute.PDF_ENCODING, nodeAttrs.getNamedItem(ATTRIBUTE_pdfEncoding).getNodeValue());
                }
                if (nodeAttrs.getNamedItem(ATTRIBUTE_isPdfEmbedded) != null) {
                    styleAttrs.put(JRTextAttribute.IS_PDF_EMBEDDED, Boolean.valueOf(nodeAttrs.getNamedItem(ATTRIBUTE_isPdfEmbedded).getNodeValue()));
                }
                if (nodeAttrs.getNamedItem(ATTRIBUTE_forecolor) != null) {
                    color = JRXmlConstants.getColor(nodeAttrs.getNamedItem(ATTRIBUTE_forecolor).getNodeValue(), Color.black);
                    styleAttrs.put(TextAttribute.FOREGROUND, color);
                }
                if (nodeAttrs.getNamedItem(ATTRIBUTE_backcolor) != null) {
                    color = JRXmlConstants.getColor(nodeAttrs.getNamedItem(ATTRIBUTE_backcolor).getNodeValue(), Color.black);
                    styleAttrs.put(TextAttribute.BACKGROUND, color);
                }
                int startIndex = styledText.length();
                this.parseStyle(styledText, node);
                styledText.addRun(new JRStyledText.Run(styleAttrs, startIndex, styledText.length()));
                continue;
            }
            if (node.getNodeType() == 1 && NODE_bold.equalsIgnoreCase(node.getNodeName())) {
                HashMap<TextAttribute, Float> styleAttrs = new HashMap<TextAttribute, Float>();
                styleAttrs.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
                int startIndex = styledText.length();
                this.parseStyle(styledText, node);
                styledText.addRun(new JRStyledText.Run(styleAttrs, startIndex, styledText.length()));
                continue;
            }
            if (node.getNodeType() == 1 && NODE_italic.equalsIgnoreCase(node.getNodeName())) {
                HashMap<TextAttribute, Float> styleAttrs = new HashMap<TextAttribute, Float>();
                styleAttrs.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
                int startIndex = styledText.length();
                this.parseStyle(styledText, node);
                styledText.addRun(new JRStyledText.Run(styleAttrs, startIndex, styledText.length()));
                continue;
            }
            if (node.getNodeType() == 1 && NODE_underline.equalsIgnoreCase(node.getNodeName())) {
                HashMap<TextAttribute, Integer> styleAttrs = new HashMap<TextAttribute, Integer>();
                styleAttrs.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
                int startIndex = styledText.length();
                this.parseStyle(styledText, node);
                styledText.addRun(new JRStyledText.Run(styleAttrs, startIndex, styledText.length()));
                continue;
            }
            if (node.getNodeType() == 1 && NODE_sup.equalsIgnoreCase(node.getNodeName())) {
                HashMap<TextAttribute, Integer> styleAttrs = new HashMap<TextAttribute, Integer>();
                styleAttrs.put(TextAttribute.SUPERSCRIPT, TextAttribute.SUPERSCRIPT_SUPER);
                int startIndex = styledText.length();
                this.parseStyle(styledText, node);
                styledText.addRun(new JRStyledText.Run(styleAttrs, startIndex, styledText.length()));
                continue;
            }
            if (node.getNodeType() == 1 && NODE_sub.equalsIgnoreCase(node.getNodeName())) {
                HashMap<TextAttribute, Integer> styleAttrs = new HashMap<TextAttribute, Integer>();
                styleAttrs.put(TextAttribute.SUPERSCRIPT, TextAttribute.SUPERSCRIPT_SUB);
                int startIndex = styledText.length();
                this.parseStyle(styledText, node);
                styledText.addRun(new JRStyledText.Run(styleAttrs, startIndex, styledText.length()));
                continue;
            }
            if (node.getNodeType() == 1 && NODE_font.equalsIgnoreCase(node.getNodeName())) {
                NamedNodeMap nodeAttrs = node.getAttributes();
                HashMap<TextAttribute, Object> styleAttrs = new HashMap<TextAttribute, Object>();
                if (nodeAttrs.getNamedItem(ATTRIBUTE_size) != null) {
                    styleAttrs.put(TextAttribute.SIZE, new Float(nodeAttrs.getNamedItem(ATTRIBUTE_size).getNodeValue()));
                }
                if (nodeAttrs.getNamedItem(ATTRIBUTE_color) != null) {
                    Color color = JRXmlConstants.getColor(nodeAttrs.getNamedItem(ATTRIBUTE_color).getNodeValue(), Color.black);
                    styleAttrs.put(TextAttribute.FOREGROUND, color);
                }
                if (nodeAttrs.getNamedItem(ATTRIBUTE_fontFace) != null) {
                    String fontFaces = nodeAttrs.getNamedItem(ATTRIBUTE_fontFace).getNodeValue();
                    StringTokenizer t = new StringTokenizer(fontFaces, ",");
                    while (t.hasMoreTokens()) {
                        String face = t.nextToken().trim();
                        if (!AVAILABLE_FONT_FACE_NAMES.contains(face)) continue;
                        styleAttrs.put(TextAttribute.FAMILY, face);
                        break;
                    }
                }
                int startIndex = styledText.length();
                this.parseStyle(styledText, node);
                styledText.addRun(new JRStyledText.Run(styleAttrs, startIndex, styledText.length()));
                continue;
            }
            if (node.getNodeType() == 1 && NODE_br.equalsIgnoreCase(node.getNodeName())) {
                styledText.append("\n");
                int startIndex = styledText.length();
                this.resizeRuns(styledText.getRuns(), startIndex, 1);
                this.parseStyle(styledText, node);
                styledText.addRun(new JRStyledText.Run(new HashMap(), startIndex, styledText.length()));
                if (startIndex >= styledText.length()) continue;
                styledText.append("\n");
                this.resizeRuns(styledText.getRuns(), startIndex, 1);
                continue;
            }
            if (node.getNodeType() == 1 && NODE_li.equalsIgnoreCase(node.getNodeName())) {
                String tmpText = styledText.getText();
                if (tmpText.length() > 0 && !tmpText.endsWith("\n")) {
                    styledText.append("\n");
                }
                styledText.append(" \u2022 ");
                int startIndex = styledText.length();
                this.resizeRuns(styledText.getRuns(), startIndex, 1);
                this.parseStyle(styledText, node);
                styledText.addRun(new JRStyledText.Run(new HashMap(), startIndex, styledText.length()));
                Node nextNode = node.getNextSibling();
                String textContent = this.getFirstTextOccurence(nextNode);
                if (nextNode == null || nextNode.getNodeType() == 1 && NODE_li.equalsIgnoreCase(nextNode.getNodeName()) || textContent != null && textContent.startsWith("\n")) continue;
                styledText.append("\n");
                this.resizeRuns(styledText.getRuns(), startIndex, 1);
                continue;
            }
            if (node.getNodeType() != 1) continue;
            String nodeName = LESS + node.getNodeName() + GREATER;
            throw new SAXException("Tag " + nodeName + " is not a valid styled text tag.");
        }
    }

    private void resizeRuns(List runs, int startIndex, int count) {
        for (int j = 0; j < runs.size(); ++j) {
            JRStyledText.Run run = (JRStyledText.Run)runs.get(j);
            if (run.startIndex > startIndex || run.endIndex <= startIndex - count) continue;
            run.endIndex += count;
        }
    }

    private StringBuffer writeStyleAttributes(Map parentAttrs, Map attrs) {
        StringBuffer sbuffer = new StringBuffer();
        Object value = attrs.get(TextAttribute.FAMILY);
        Object oldValue = parentAttrs.get(TextAttribute.FAMILY);
        if (value != null && !value.equals(oldValue)) {
            sbuffer.append(SPACE);
            sbuffer.append(ATTRIBUTE_fontName);
            sbuffer.append(EQUAL_QUOTE);
            sbuffer.append(value);
            sbuffer.append(QUOTE);
        }
        value = attrs.get(TextAttribute.WEIGHT);
        oldValue = parentAttrs.get(TextAttribute.WEIGHT);
        if (value != null && !value.equals(oldValue)) {
            sbuffer.append(SPACE);
            sbuffer.append(ATTRIBUTE_isBold);
            sbuffer.append(EQUAL_QUOTE);
            sbuffer.append(value.equals(TextAttribute.WEIGHT_BOLD));
            sbuffer.append(QUOTE);
        }
        value = attrs.get(TextAttribute.POSTURE);
        oldValue = parentAttrs.get(TextAttribute.POSTURE);
        if (value != null && !value.equals(oldValue)) {
            sbuffer.append(SPACE);
            sbuffer.append(ATTRIBUTE_isItalic);
            sbuffer.append(EQUAL_QUOTE);
            sbuffer.append(value.equals(TextAttribute.POSTURE_OBLIQUE));
            sbuffer.append(QUOTE);
        }
        value = attrs.get(TextAttribute.UNDERLINE);
        oldValue = parentAttrs.get(TextAttribute.UNDERLINE);
        if (value == null && oldValue != null || value != null && !value.equals(oldValue)) {
            sbuffer.append(SPACE);
            sbuffer.append(ATTRIBUTE_isUnderline);
            sbuffer.append(EQUAL_QUOTE);
            sbuffer.append(value != null);
            sbuffer.append(QUOTE);
        }
        value = attrs.get(TextAttribute.STRIKETHROUGH);
        oldValue = parentAttrs.get(TextAttribute.STRIKETHROUGH);
        if (value == null && oldValue != null || value != null && !value.equals(oldValue)) {
            sbuffer.append(SPACE);
            sbuffer.append(ATTRIBUTE_isStrikeThrough);
            sbuffer.append(EQUAL_QUOTE);
            sbuffer.append(value != null);
            sbuffer.append(QUOTE);
        }
        value = attrs.get(TextAttribute.SIZE);
        oldValue = parentAttrs.get(TextAttribute.SIZE);
        if (value != null && !value.equals(oldValue)) {
            sbuffer.append(SPACE);
            sbuffer.append(ATTRIBUTE_size);
            sbuffer.append(EQUAL_QUOTE);
            sbuffer.append(((Float)value).intValue());
            sbuffer.append(QUOTE);
        }
        value = attrs.get(JRTextAttribute.PDF_FONT_NAME);
        oldValue = parentAttrs.get(JRTextAttribute.PDF_FONT_NAME);
        if (value != null && !value.equals(oldValue)) {
            sbuffer.append(SPACE);
            sbuffer.append(ATTRIBUTE_pdfFontName);
            sbuffer.append(EQUAL_QUOTE);
            sbuffer.append(value);
            sbuffer.append(QUOTE);
        }
        value = attrs.get(JRTextAttribute.PDF_ENCODING);
        oldValue = parentAttrs.get(JRTextAttribute.PDF_ENCODING);
        if (value != null && !value.equals(oldValue)) {
            sbuffer.append(SPACE);
            sbuffer.append(ATTRIBUTE_pdfEncoding);
            sbuffer.append(EQUAL_QUOTE);
            sbuffer.append(value);
            sbuffer.append(QUOTE);
        }
        value = attrs.get(JRTextAttribute.IS_PDF_EMBEDDED);
        oldValue = parentAttrs.get(JRTextAttribute.IS_PDF_EMBEDDED);
        if (value != null && !value.equals(oldValue)) {
            sbuffer.append(SPACE);
            sbuffer.append(ATTRIBUTE_isPdfEmbedded);
            sbuffer.append(EQUAL_QUOTE);
            sbuffer.append(value);
            sbuffer.append(QUOTE);
        }
        value = attrs.get(TextAttribute.FOREGROUND);
        oldValue = parentAttrs.get(TextAttribute.FOREGROUND);
        if (value != null && !value.equals(oldValue)) {
            sbuffer.append(SPACE);
            sbuffer.append(ATTRIBUTE_forecolor);
            sbuffer.append(EQUAL_QUOTE);
            sbuffer.append(SHARP);
            sbuffer.append(JRColorUtil.getColorHexa((Color)value));
            sbuffer.append(QUOTE);
        }
        value = attrs.get(TextAttribute.BACKGROUND);
        oldValue = parentAttrs.get(TextAttribute.BACKGROUND);
        if (value != null && !value.equals(oldValue)) {
            sbuffer.append(SPACE);
            sbuffer.append(ATTRIBUTE_backcolor);
            sbuffer.append(EQUAL_QUOTE);
            sbuffer.append(SHARP);
            sbuffer.append(JRColorUtil.getColorHexa((Color)value));
            sbuffer.append(QUOTE);
        }
        return sbuffer;
    }

    private String getFirstTextOccurence(Node node) {
        if (node != null) {
            if (node.getNodeValue() != null) {
                return node.getNodeValue();
            }
            NodeList nodeList = node.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                String firstOccurence = this.getFirstTextOccurence(nodeList.item(i));
                if (firstOccurence == null) continue;
                return firstOccurence;
            }
        }
        return null;
    }

    public void error(SAXParseException e) {
    }

    public void fatalError(SAXParseException e) {
    }

    public void warning(SAXParseException e) {
    }

    static {
        List bundles = ExtensionsEnvironment.getExtensionsRegistry().getExtensions(FontBundle.class);
        Iterator itb = bundles.iterator();
        while (itb.hasNext()) {
            FontBundle bundle = (FontBundle)itb.next();
            List families = bundle.getFontFamilies();
            Iterator itf = families.iterator();
            while (itf.hasNext()) {
                FontFamily family = (FontFamily)itf.next();
                AVAILABLE_FONT_FACE_NAMES.add(family.getName());
            }
        }
        AVAILABLE_FONT_FACE_NAMES.addAll(Arrays.asList(GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames()));
        threadInstances = new ThreadLocal();
        threadLocale = new ThreadLocal();
    }
}

