/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AnnotationUtils {
    public static <A extends Annotation> A findMethodAnnotation(Class<A> annotationClass, Method method, Class clazz) {
        if (!annotationClass.isAnnotation()) {
            throw new IllegalArgumentException(annotationClass + " is not an annotation");
        }
        A annotation = method.getAnnotation(annotationClass);
        Class cl = clazz;
        while (annotation == null && (cl = cl.getSuperclass()) != null && !cl.equals(Object.class)) {
            try {
                method = cl.getDeclaredMethod(method.getName(), method.getParameterTypes());
                annotation = method.getAnnotation(annotationClass);
            }
            catch (NoSuchMethodException ex) {}
        }
        return annotation;
    }
}

