/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.sheet.editors;

import com.jaspersoft.ireport.designer.sheet.editors.JRPenPropertyCustomEditor;
import com.jaspersoft.ireport.designer.sheet.editors.box.BoxBorderSelectionPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.beans.FeatureDescriptor;
import java.beans.PropertyEditorSupport;
import net.sf.jasperreports.engine.JRPen;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.nodes.Node;

public class JRPenPropertyEditor
extends PropertyEditorSupport
implements ExPropertyEditor {
    private boolean customEd = true;
    private PropertyEnv env;

    public boolean isEditable() {
        return false;
    }

    public boolean isPaintable() {
        return true;
    }

    public void paintValue(Graphics gfx, Rectangle box) {
        JRPen pen = (JRPen)this.getValue();
        if (pen == null) {
            super.paintValue(gfx, box);
        } else {
            gfx.clearRect(box.x, box.y, box.width, box.height);
            gfx.setColor(pen.getLineColor() == null ? Color.BLACK : pen.getLineColor());
            Stroke s = BoxBorderSelectionPanel.createStroke(pen);
            if (s != null) {
                ((Graphics2D)gfx).setStroke(s);
                gfx.drawLine(box.x + 4, box.y + box.height / 2, box.x + box.width - 4, box.y + box.height / 2);
            }
        }
    }

    public String getAsText() {
        return "";
    }

    public void setAsText(String s) {
    }

    public boolean supportsCustomEditor() {
        return this.customEd;
    }

    public Component getCustomEditor() {
        JRPen val = (JRPen)this.getValue();
        return new JRPenPropertyCustomEditor(val, false, null, this, this.env);
    }

    public void attachEnv(PropertyEnv env) {
        FeatureDescriptor desc = env.getFeatureDescriptor();
        if (desc instanceof Node.Property) {
            Node.Property prop = (Node.Property)desc;
            this.customEd = !Boolean.TRUE.equals(prop.getValue("suppressCustomEditor"));
        }
        this.env = env;
    }
}

