/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.outline.nodes;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.ModelUtils;
import com.jaspersoft.ireport.designer.actions.DeleteBandAction;
import com.jaspersoft.ireport.designer.actions.DeleteGroupAction;
import com.jaspersoft.ireport.designer.dnd.DnDUtilities;
import com.jaspersoft.ireport.designer.outline.nodes.ElementContainerChildren;
import com.jaspersoft.ireport.designer.outline.nodes.ElementGroupNode;
import com.jaspersoft.ireport.designer.outline.nodes.ElementPasteType;
import com.jaspersoft.ireport.designer.outline.nodes.IRIndexedNode;
import com.jaspersoft.ireport.designer.sheet.properties.BandPrintWhenExpressionProperty;
import com.jaspersoft.ireport.designer.sheet.properties.GroupExpressionProperty;
import com.jaspersoft.ireport.designer.undo.ObjectPropertyUndoableEdit;
import java.awt.datatransfer.Transferable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.design.JRDesignBand;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignElementGroup;
import net.sf.jasperreports.engine.design.JRDesignGroup;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.openide.ErrorManager;
import org.openide.actions.PasteAction;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeEvent;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeMemberEvent;
import org.openide.nodes.NodeReorderEvent;
import org.openide.nodes.NodeTransfer;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.actions.NodeAction;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.PasteType;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public class BandNode
extends IRIndexedNode
implements PropertyChangeListener {
    private final JasperDesign jd;
    private final JRDesignBand band;
    private final JRDesignGroup group;

    public BandNode(JasperDesign jd, JRDesignBand band, Lookup doLkp) {
        this(new ElementContainerChildren(jd, (JRDesignElementGroup)band, doLkp), jd, band, doLkp);
    }

    public BandNode(ElementContainerChildren pc, JasperDesign jd, JRDesignBand band, Lookup doLkp) {
        super((Children)pc, pc.getIndex(), (Lookup)new ProxyLookup(new Lookup[]{Lookups.fixed((Object[])new Object[]{jd, band}), doLkp}));
        this.jd = jd;
        this.band = band;
        if (ModelUtils.isGroupHeader((JRBand)band, jd)) {
            this.setIconBaseWithExtension("com/jaspersoft/ireport/designer/resources/groupheader-16.png");
        } else if (ModelUtils.isGroupFooter((JRBand)band, jd)) {
            this.setIconBaseWithExtension("com/jaspersoft/ireport/designer/resources/groupfooter-16.png");
        } else {
            this.setIconBaseWithExtension("com/jaspersoft/ireport/designer/resources/band-16.png");
        }
        this.band.getEventSupport().addPropertyChangeListener((PropertyChangeListener)this);
        this.group = ModelUtils.getGroupFromBand(jd, band);
        if (this.group != null) {
            this.group.getEventSupport().addPropertyChangeListener((PropertyChangeListener)this);
        }
        this.setDisplayName(ModelUtils.nameOf((JRBand)band, jd));
        this.addNodeListener(new NodeListener(){

            public void childrenAdded(NodeMemberEvent ev) {
            }

            public void childrenRemoved(NodeMemberEvent ev) {
            }

            public void nodeDestroyed(NodeEvent ev) {
            }

            public void propertyChange(PropertyChangeEvent evt) {
            }

            public void childrenReordered(NodeReorderEvent ev) {
                int i;
                List elements = BandNode.this.getBand().getChildren();
                int[] permutations = ev.getPermutation();
                Object[] elementsArray = new Object[elements.size()];
                for (i = 0; i < elementsArray.length; ++i) {
                    elementsArray[permutations[i]] = elements.get(i);
                }
                elements.clear();
                for (i = 0; i < elementsArray.length; ++i) {
                    elements.add(elementsArray[i]);
                }
                BandNode.this.getBand().getEventSupport().firePropertyChange("children", null, (Object)BandNode.this.getBand().getChildren());
            }
        });
    }

    public String getHtmlDisplayName() {
        return this.getDisplayName();
    }

    protected Sheet createSheet() {
        Sheet sheet = super.createSheet();
        Sheet.Set bandPropertiesSet = Sheet.createPropertiesSet();
        bandPropertiesSet.setName("BAND_PROPERTIES");
        bandPropertiesSet.setDisplayName("Band properties");
        bandPropertiesSet.put((Node.Property)new HeightProperty(this.band, this.jd));
        bandPropertiesSet.put((Node.Property)new BandPrintWhenExpressionProperty(this.band, this.jd.getMainDesignDataset()));
        bandPropertiesSet.put((Node.Property)new SplitAllowedProperty(this.band));
        sheet.put(bandPropertiesSet);
        if (this.group != null) {
            Sheet.Set groupPropertiesSet = Sheet.createPropertiesSet();
            groupPropertiesSet.setName("GROUP_PROPERTIES");
            groupPropertiesSet.setDisplayName("Group properties");
            groupPropertiesSet = BandNode.fillGroupPropertySet(groupPropertiesSet, this.jd.getMainDesignDataset(), this.group);
            sheet.put(groupPropertiesSet);
        }
        return sheet;
    }

    public static Sheet.Set fillGroupPropertySet(Sheet.Set groupPropertiesSet, JRDesignDataset dataset, JRDesignGroup group) {
        groupPropertiesSet.put((Node.Property)new GroupNameProperty(group, dataset));
        groupPropertiesSet.put((Node.Property)new GroupExpressionProperty(group, dataset));
        if (dataset.isMainDataset()) {
            groupPropertiesSet.put((Node.Property)new StartNewPageProperty(group));
            groupPropertiesSet.put((Node.Property)new StartNewColumnProperty(group));
            groupPropertiesSet.put((Node.Property)new ResetPageNumberProperty(group));
            groupPropertiesSet.put((Node.Property)new ReprintHeaderProperty(group));
            groupPropertiesSet.put((Node.Property)new MinHeightToStartNewPageProperty(group));
        }
        return groupPropertiesSet;
    }

    public JRDesignBand getBand() {
        return this.band;
    }

    public JasperDesign getJasperDesign() {
        return this.jd;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        IReportManager.getInstance().notifyReportChange();
        if (evt.getPropertyName() == null) {
            return;
        }
        if (ModelUtils.containsProperty(this.getPropertySets(), evt.getPropertyName())) {
            this.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
        }
        if (evt.getPropertyName().equals("name")) {
            String s = ModelUtils.nameOf((JRBand)this.band, this.jd);
            this.setDisplayName(s);
            this.fireNameChange(null, this.getDisplayName());
        }
    }

    protected void createPasteTypes(Transferable t, List s) {
        super.createPasteTypes(t, s);
        PasteType paste = this.getDropType(t, 2, -1);
        if (null != paste) {
            s.add(paste);
        }
    }

    public Action[] getActions(boolean popup) {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(SystemAction.get(PasteAction.class));
        list.add(SystemAction.get(RefreshNodes.class));
        if (this.group != null) {
            list.add(null);
            list.add((Object)DeleteGroupAction.getInstance());
        }
        list.add((Object)DeleteBandAction.getInstance());
        return list.toArray(new Action[list.size()]);
    }

    public boolean canDestroy() {
        return false;
    }

    public boolean hasCustomizer() {
        return true;
    }

    public PasteType getDropType(Transferable t, int action, int index) {
        Node dropNode = NodeTransfer.node((Transferable)t, (int)7);
        int dropAction = DnDUtilities.getTransferAction(t);
        if (null != dropNode) {
            JRDesignElement element = (JRDesignElement)dropNode.getLookup().lookup(JRDesignElement.class);
            if (null != element) {
                return new ElementPasteType(element.getElementGroup(), (JRElementGroup)this.getBand(), element, dropAction, (Node)this);
            }
            if (dropNode instanceof ElementGroupNode) {
                JRDesignElementGroup g = ((ElementGroupNode)dropNode).getElementGroup();
                return new ElementPasteType(g.getElementGroup(), (JRElementGroup)this.getBand(), g, dropAction, (Node)this);
            }
        }
        return null;
    }

    private static final class MinHeightToStartNewPageProperty
    extends PropertySupport {
        private final JRDesignGroup group;

        public MinHeightToStartNewPageProperty(JRDesignGroup group) {
            super("minHeightToStartNewPage", Integer.class, "Min Height To Start New Page", "If greater than zero, this value is considerd as minimum height required to keep the group on the current page", true, true);
            this.group = group;
        }

        public boolean isDefaultValue() {
            return this.group.getMinHeightToStartNewPage() == 0;
        }

        public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
            this.setPropertyValue(0);
        }

        public boolean supportsDefaultValue() {
            return true;
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.group.getMinHeightToStartNewPage();
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (val instanceof Integer) {
                this.setPropertyValue((Integer)val);
            }
        }

        private void setPropertyValue(int val) throws IllegalArgumentException {
            Integer oldValue = this.group.getMinHeightToStartNewPage();
            Integer newValue = val;
            if (newValue < 0) {
                IllegalArgumentException iae = this.annotateException("The value must be a positive number");
                throw iae;
            }
            this.group.setMinHeightToStartNewPage(newValue.intValue());
            ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.group, "MinHeightToStartNewPage", Integer.TYPE, oldValue, newValue);
            IReportManager.getInstance().addUndoableEdit(urob);
        }

        public IllegalArgumentException annotateException(String msg) {
            IllegalArgumentException iae = new IllegalArgumentException(msg);
            ErrorManager.getDefault().annotate((Throwable)iae, 4096, msg, msg, null, null);
            return iae;
        }
    }

    private static final class ReprintHeaderProperty
    extends PropertySupport {
        private final JRDesignGroup group;

        public ReprintHeaderProperty(JRDesignGroup group) {
            super("reprintHeaderOnEachPage", Boolean.class, "Reprint header", "Reprint the group header on each page.", true, true);
            this.group = group;
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.group.isReprintHeaderOnEachPage();
        }

        public boolean isDefaultValue() {
            return !this.group.isReprintHeaderOnEachPage();
        }

        public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
            this.setPropertyValue(false);
        }

        public boolean supportsDefaultValue() {
            return true;
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (val instanceof Boolean) {
                this.setPropertyValue((Boolean)val);
            }
        }

        private void setPropertyValue(boolean val) {
            Boolean oldValue = this.group.isReprintHeaderOnEachPage();
            Boolean newValue = val;
            this.group.setReprintHeaderOnEachPage(newValue.booleanValue());
            ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.group, "ReprintHeaderOnEachPage", Boolean.TYPE, oldValue, newValue);
            IReportManager.getInstance().addUndoableEdit(urob);
        }
    }

    private static final class ResetPageNumberProperty
    extends PropertySupport {
        private final JRDesignGroup group;

        public ResetPageNumberProperty(JRDesignGroup group) {
            super("resetPageNumber", Boolean.class, "Reset page number", "Reset the page number when the group changes.", true, true);
            this.group = group;
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.group.isResetPageNumber();
        }

        public boolean isDefaultValue() {
            return !this.group.isResetPageNumber();
        }

        public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
            this.setPropertyValue(false);
        }

        public boolean supportsDefaultValue() {
            return true;
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (val instanceof Boolean) {
                this.setPropertyValue((Boolean)val);
            }
        }

        private void setPropertyValue(boolean val) {
            Boolean oldValue = this.group.isResetPageNumber();
            Boolean newValue = val;
            this.group.setResetPageNumber(newValue.booleanValue());
            ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.group, "ResetPageNumber", Boolean.TYPE, oldValue, newValue);
            IReportManager.getInstance().addUndoableEdit(urob);
        }
    }

    private static final class StartNewColumnProperty
    extends PropertySupport {
        private final JRDesignGroup group;

        public StartNewColumnProperty(JRDesignGroup group) {
            super("startNewColumn", Boolean.class, "Start on a new column", "If checked, it forces the group to start on a new column", true, true);
            this.group = group;
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.group.isStartNewColumn();
        }

        public boolean isDefaultValue() {
            return !this.group.isStartNewColumn();
        }

        public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
            this.setPropertyValue(false);
        }

        public boolean supportsDefaultValue() {
            return true;
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (val instanceof Boolean) {
                this.setPropertyValue((Boolean)val);
            }
        }

        private void setPropertyValue(boolean val) {
            Boolean oldValue = this.group.isStartNewColumn();
            Boolean newValue = val;
            this.group.setStartNewColumn(newValue.booleanValue());
            ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.group, "StartNewColumn", Boolean.TYPE, oldValue, newValue);
            IReportManager.getInstance().addUndoableEdit(urob);
        }
    }

    private static final class StartNewPageProperty
    extends PropertySupport {
        private final JRDesignGroup group;

        public StartNewPageProperty(JRDesignGroup group) {
            super("startNewPage", Boolean.class, "Start on a new page", "If checked, it forces the group to start on a new page", true, true);
            this.group = group;
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.group.isStartNewPage();
        }

        public boolean isDefaultValue() {
            return !this.group.isStartNewPage();
        }

        public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
            this.setPropertyValue(false);
        }

        public boolean supportsDefaultValue() {
            return true;
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (val instanceof Boolean) {
                this.setPropertyValue((Boolean)val);
            }
        }

        private void setPropertyValue(boolean val) {
            Boolean oldValue = this.group.isStartNewPage();
            Boolean newValue = val;
            this.group.setStartNewPage(newValue.booleanValue());
            ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.group, "StartNewPage", Boolean.TYPE, oldValue, newValue);
            IReportManager.getInstance().addUndoableEdit(urob);
        }
    }

    public static final class GroupNameProperty
    extends PropertySupport.ReadWrite {
        private final JRDesignGroup group;
        private final JRDesignDataset dataset;

        public GroupNameProperty(JRDesignGroup group, JRDesignDataset dataset) {
            super("name", String.class, "Name", "Name of the group");
            this.group = group;
            this.dataset = dataset;
            this.setValue("oneline", Boolean.TRUE);
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.group.getName();
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (val == null || val.equals("")) {
                IllegalArgumentException iae = this.annotateException("Group name not valid.");
                throw iae;
            }
            String s = val + "";
            List currentGroups = null;
            currentGroups = this.dataset.getGroupsList();
            for (JRDesignGroup g : currentGroups) {
                if (g == this.group || !g.getName().equals(s)) continue;
                IllegalArgumentException iae = this.annotateException("Group name already in use.");
                throw iae;
            }
            String oldName = this.group.getName();
            this.group.setName(s);
            this.dataset.getGroupsMap().remove(oldName);
            this.dataset.getGroupsMap().put(s, this.group);
            ObjectPropertyUndoableEdit opue = new ObjectPropertyUndoableEdit(this.group, "Name", String.class, oldName, this.group.getName());
            IReportManager.getInstance().addUndoableEdit(opue);
        }

        public IllegalArgumentException annotateException(String msg) {
            IllegalArgumentException iae = new IllegalArgumentException(msg);
            ErrorManager.getDefault().annotate((Throwable)iae, 4096, msg, msg, null, null);
            return iae;
        }
    }

    private static final class SplitAllowedProperty
    extends PropertySupport {
        private final JRDesignBand band;

        public SplitAllowedProperty(JRDesignBand band) {
            super("splitAllowed", Boolean.class, "Split allowed", "Define if the band can be splitted or not", true, true);
            this.band = band;
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.band.isSplitAllowed();
        }

        public boolean isDefaultValue() {
            return this.band.isSplitAllowed();
        }

        public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
            this.setPropertyValue(true);
        }

        public boolean supportsDefaultValue() {
            return true;
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (val instanceof Boolean) {
                this.setPropertyValue((Boolean)val);
            }
        }

        private void setPropertyValue(boolean val) {
            Boolean oldValue = this.band.isSplitAllowed();
            Boolean newValue = val;
            this.band.setSplitAllowed(newValue.booleanValue());
            ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.band, "SplitAllowed", Boolean.TYPE, oldValue, newValue);
            IReportManager.getInstance().addUndoableEdit(urob);
        }
    }

    private static final class HeightProperty
    extends PropertySupport {
        private final JasperDesign jasperDesign;
        private final JRDesignBand band;

        public HeightProperty(JRDesignBand band, JasperDesign jd) {
            super("height", Integer.class, "Band height", "This is the band height", true, true);
            this.jasperDesign = jd;
            this.band = band;
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.band.getHeight();
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (val instanceof Integer) {
                Integer oldValue = this.band.getHeight();
                Integer newValue = (Integer)val;
                int maxBandHeight = ModelUtils.getMaxBandHeight(this.band, this.jasperDesign);
                if (newValue < 0 || newValue > maxBandHeight) {
                    IllegalArgumentException iae = this.annotateException("The specified band height is not valid.\nThe height must be between 0 and " + maxBandHeight + " pixels.");
                    throw iae;
                }
                this.band.setHeight(newValue.intValue());
                ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.band, "Height", Integer.TYPE, oldValue, newValue);
                IReportManager.getInstance().addUndoableEdit(urob);
            }
        }

        public IllegalArgumentException annotateException(String msg) {
            IllegalArgumentException iae = new IllegalArgumentException(msg);
            ErrorManager.getDefault().annotate((Throwable)iae, 4096, msg, msg, null, null);
            return iae;
        }
    }

    public static final class RefreshNodes
    extends NodeAction {
        public String getName() {
            return "Refresh nodes";
        }

        public HelpCtx getHelpCtx() {
            return null;
        }

        protected void performAction(Node[] activatedNodes) {
            ((ElementContainerChildren)activatedNodes[0].getChildren()).recalculateKeys();
        }

        protected boolean enable(Node[] activatedNodes) {
            return activatedNodes.length == 1 && activatedNodes[0] instanceof BandNode;
        }
    }
}

