/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.formatting.actions;

import com.jaspersoft.ireport.designer.formatting.actions.AbstractFormattingToolAction;
import java.awt.Rectangle;
import java.util.List;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.openide.nodes.Node;

public class EqualsVSpaceAction
extends AbstractFormattingToolAction {
    public EqualsVSpaceAction() {
        this.putValue("Name", this.getName());
    }

    protected String iconResource() {
        return "com/jaspersoft/ireport/designer/resources/formatting/elem_add_vspace.png";
    }

    protected void performAction(Node[] nodes) {
        if (nodes.length == 0) {
            return;
        }
        JasperDesign jd = (JasperDesign)nodes[0].getLookup().lookup(JasperDesign.class);
        if (jd == null) {
            return;
        }
        List<JRDesignElement> elements = this.getSelectedElements(nodes);
        boolean aggregate = false;
        List<JRDesignElement> sortedElements = this.sortYX(elements);
        int gap = 0;
        int usedSpace = 0;
        int minY = sortedElements.get(0).getY();
        int maxY = minY + sortedElements.get(0).getHeight();
        for (JRDesignElement element : sortedElements) {
            if (minY > element.getY()) {
                minY = element.getY();
            }
            if (maxY < element.getY() + element.getHeight()) {
                maxY = element.getY() + element.getHeight();
            }
            usedSpace += element.getHeight();
        }
        gap = (maxY - minY - usedSpace) / (elements.size() - 1);
        int actualY = minY;
        for (int i = 0; i < sortedElements.size(); ++i) {
            JRDesignElement element = sortedElements.get(i);
            if (i == 0) {
                actualY = element.getY() + element.getHeight() + gap;
                continue;
            }
            Rectangle oldBounds = this.getElementBounds(element);
            if (i == sortedElements.size() - 1) {
                element.setY(maxY - element.getHeight());
            } else {
                element.setY(actualY);
            }
            actualY = element.getY() + element.getHeight() + gap;
            aggregate = this.addTransformationUndo(element, oldBounds, aggregate);
        }
    }

    public String getName() {
        return "Equal Vert. Space";
    }

    public boolean requiresMultipleObjects() {
        return true;
    }
}

