/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.FileNotFoundException;
import java.io.IOException;
import org.hsqldb.DatabaseFile;

class ReverseDatabaseFile
extends DatabaseFile {
    private int size;
    private long max;

    ReverseDatabaseFile(String string, String string2, int n) throws FileNotFoundException, IOException {
        super(string, string2, n);
        this.pos = this.max = this.length();
        this.size = n;
    }

    public void readSeek(long l) throws IOException {
        if ((l = this.max - l) < 0L || this.in == null) {
            this.seek(l);
        } else if (l != this.pos) {
            this.index -= (int)(this.pos - l);
            this.pos = l;
            if (this.index < 0 || this.index > this.count) {
                this.count = 0;
                this.index = 0;
            }
        }
    }

    public int read() throws IOException {
        if (this.in == null) {
            return super.read();
        }
        if (this.index == 0) {
            long l = this.pos - (long)this.size;
            if (l < 0L) {
                this.realSeek(0L);
                this.count = (int)this.pos;
                this.readFully(this.in, 0, this.count);
            } else {
                this.realSeek(l);
                this.readFully(this.in);
                this.count = this.size;
            }
            this.index = this.count;
        }
        if (this.index == 0) {
            return -1;
        }
        --this.pos;
        return this.in[--this.index] & 0xFF;
    }

    public int readInteger() throws IOException {
        this.seek(this.pos);
        return this.readInt();
    }

    public long getFilePointer() throws IOException {
        return this.max - this.pos;
    }
}

