/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.sql.DataSource;
import mondrian.olap.CacheControl;
import mondrian.olap.Cube;
import mondrian.olap.Dimension;
import mondrian.olap.Member;
import mondrian.resource.MondrianResource;
import mondrian.rolap.RolapLevel;
import mondrian.rolap.RolapMember;
import mondrian.rolap.RolapSchema;
import mondrian.rolap.RolapStar;
import mondrian.rolap.RolapStoredMeasure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheControlImpl
implements CacheControl {
    @Override
    public CacheControl.CellRegion createMemberRegion(Member member, boolean descendants) {
        ArrayList<Member> list = new ArrayList<Member>();
        list.add(member);
        return new MemberCellRegion(list, descendants);
    }

    @Override
    public CacheControl.CellRegion createMemberRegion(boolean lowerInclusive, Member lowerMember, boolean upperInclusive, Member upperMember, boolean descendants) {
        if (lowerMember == null) {
            lowerInclusive = false;
        }
        if (upperMember == null) {
            upperInclusive = false;
        }
        return new MemberRangeCellRegion((RolapMember)lowerMember, lowerInclusive, (RolapMember)upperMember, upperInclusive, descendants);
    }

    @Override
    public CacheControl.CellRegion createCrossjoinRegion(CacheControl.CellRegion ... regions) {
        assert (regions != null);
        assert (regions.length >= 2);
        HashSet<Dimension> set = new HashSet<Dimension>();
        ArrayList<CellRegionImpl> list = new ArrayList<CellRegionImpl>();
        for (CacheControl.CellRegion region : regions) {
            int prevSize = set.size();
            List<Dimension> dimensionality = region.getDimensionality();
            set.addAll(dimensionality);
            if (set.size() < prevSize + dimensionality.size()) {
                throw MondrianResource.instance().CacheFlushCrossjoinDimensionsInCommon.ex(this.getDimensionalityList(regions));
            }
            this.flattenCrossjoin((CellRegionImpl)region, list);
        }
        return new CrossjoinCellRegion(list);
    }

    private String getDimensionalityList(CacheControl.CellRegion[] regions) {
        StringBuilder buf = new StringBuilder();
        int k = 0;
        for (CacheControl.CellRegion region : regions) {
            if (k++ > 0) {
                buf.append(", ");
            }
            buf.append("'");
            buf.append(region.getDimensionality().toString());
            buf.append("'");
        }
        return buf.toString();
    }

    @Override
    public CacheControl.CellRegion createUnionRegion(CacheControl.CellRegion ... regions) {
        if (regions == null) {
            throw new NullPointerException();
        }
        if (regions.length < 2) {
            throw new IllegalArgumentException();
        }
        ArrayList<CellRegionImpl> list = new ArrayList<CellRegionImpl>();
        for (CacheControl.CellRegion region : regions) {
            if (!((Object)region.getDimensionality()).equals(regions[0].getDimensionality())) {
                throw MondrianResource.instance().CacheFlushUnionDimensionalityMismatch.ex(regions[0].getDimensionality().toString(), region.getDimensionality().toString());
            }
            list.add((CellRegionImpl)region);
        }
        return new UnionCellRegion(list);
    }

    @Override
    public CacheControl.CellRegion createMeasuresRegion(Cube cube) {
        Dimension measuresDimension = cube.getDimensions()[0];
        Member[] measures = cube.getSchemaReader(null).getLevelMembers(measuresDimension.getHierarchy().getLevels()[0], false);
        return new MemberCellRegion(Arrays.asList(measures), false);
    }

    @Override
    public void flush(CacheControl.CellRegion region) {
        List<Dimension> dimensionality = region.getDimensionality();
        boolean found = false;
        for (Dimension dimension : dimensionality) {
            if (!dimension.isMeasures()) continue;
            found = true;
            break;
        }
        if (!found) {
            throw MondrianResource.instance().CacheFlushRegionMustContainMembers.ex();
        }
        UnionCellRegion union = this.normalize((CellRegionImpl)region);
        for (CellRegionImpl cellRegion : union.regions) {
            this.flushNonUnion(cellRegion);
        }
    }

    @Override
    public void trace(String message) {
    }

    @Override
    public void flushSchemaCache() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void flushSchema(String catalogUrl, String connectionKey, String jdbcUser, String dataSourceStr) {
        RolapSchema.Pool.instance().remove(catalogUrl, connectionKey, jdbcUser, dataSourceStr);
    }

    @Override
    public void flushSchema(String catalogUrl, DataSource dataSource) {
        RolapSchema.Pool.instance().remove(catalogUrl, dataSource);
    }

    protected void flushNonUnion(CacheControl.CellRegion region) {
        throw new UnsupportedOperationException();
    }

    UnionCellRegion normalize(CellRegionImpl region) {
        LinkedList<CellRegionImpl> nonUnionList = new LinkedList<CellRegionImpl>();
        this.flattenUnion(region, nonUnionList);
        for (int i = 0; i < nonUnionList.size(); ++i) {
            CellRegionImpl nonUnionRegion;
            UnionCellRegion firstUnion;
            while ((firstUnion = this.findFirstUnion(nonUnionRegion = (CellRegionImpl)nonUnionList.get(i))) != null) {
                ArrayList<CellRegionImpl> list = new ArrayList<CellRegionImpl>();
                for (CellRegionImpl unionComponent : firstUnion.regions) {
                    CellRegionImpl cj = this.copyReplacing(nonUnionRegion, firstUnion, unionComponent);
                    list.add(cj);
                }
                nonUnionList.remove(i);
                nonUnionList.addAll(i, list);
            }
        }
        return new UnionCellRegion(nonUnionList);
    }

    private CellRegionImpl copyReplacing(CellRegionImpl region, CellRegionImpl seek, CellRegionImpl replacement) {
        if (region == seek) {
            return replacement;
        }
        if (region instanceof UnionCellRegion) {
            UnionCellRegion union = (UnionCellRegion)region;
            ArrayList<CellRegionImpl> list = new ArrayList<CellRegionImpl>();
            for (CellRegionImpl child : union.regions) {
                list.add(this.copyReplacing(child, seek, replacement));
            }
            return new UnionCellRegion(list);
        }
        if (region instanceof CrossjoinCellRegion) {
            CrossjoinCellRegion crossjoin = (CrossjoinCellRegion)region;
            ArrayList<CellRegionImpl> list = new ArrayList<CellRegionImpl>();
            for (CellRegionImpl child : crossjoin.components) {
                list.add(this.copyReplacing(child, seek, replacement));
            }
            return new CrossjoinCellRegion(list);
        }
        return region;
    }

    private void flattenUnion(CellRegionImpl region, List<CellRegionImpl> list) {
        if (region instanceof UnionCellRegion) {
            UnionCellRegion union = (UnionCellRegion)region;
            for (CellRegionImpl region1 : union.regions) {
                this.flattenUnion(region1, list);
            }
        } else {
            list.add(region);
        }
    }

    private void flattenCrossjoin(CellRegionImpl region, List<CellRegionImpl> list) {
        if (region instanceof CrossjoinCellRegion) {
            CrossjoinCellRegion crossjoin = (CrossjoinCellRegion)region;
            for (CellRegionImpl component : crossjoin.components) {
                this.flattenCrossjoin(component, list);
            }
        } else {
            list.add(region);
        }
    }

    private UnionCellRegion findFirstUnion(CacheControl.CellRegion region) {
        CellRegionVisitorImpl visitor = new CellRegionVisitorImpl(){

            public void visit(UnionCellRegion region) {
                throw new FoundOne(region);
            }
        };
        try {
            ((CellRegionImpl)region).accept(visitor);
            return null;
        }
        catch (FoundOne foundOne) {
            return foundOne.region;
        }
    }

    static List<Member> findMeasures(CacheControl.CellRegion region) {
        final ArrayList<Member> list = new ArrayList<Member>();
        CellRegionVisitorImpl visitor = new CellRegionVisitorImpl(){

            public void visit(MemberCellRegion region) {
                if (region.dimension.isMeasures()) {
                    list.addAll(region.memberList);
                }
            }

            public void visit(MemberRangeCellRegion region) {
                if (region.level.getDimension().isMeasures()) assert (false) : "ranges on measures dimension";
            }
        };
        ((CellRegionImpl)region).accept(visitor);
        return list;
    }

    static List<RolapStar> getStarList(CacheControl.CellRegion region) {
        ArrayList<RolapStar> starList = new ArrayList<RolapStar>();
        List<Member> measuresList = CacheControlImpl.findMeasures(region);
        for (Member member : measuresList) {
            RolapStoredMeasure measure = (RolapStoredMeasure)member;
            RolapStar.Measure starMeasure = (RolapStar.Measure)measure.getStarMeasure();
            if (starList.contains(starMeasure.getStar())) continue;
            starList.add(starMeasure.getStar());
        }
        return starList;
    }

    @Override
    public void printCacheState(PrintWriter pw, CacheControl.CellRegion region) {
        List<RolapStar> starList = CacheControlImpl.getStarList(region);
        for (RolapStar star : starList) {
            star.print(pw, "", false);
        }
    }

    private static class CellRegionVisitorImpl
    implements CellRegionVisitor {
        private CellRegionVisitorImpl() {
        }

        public void visit(MemberCellRegion region) {
        }

        public void visit(MemberRangeCellRegion region) {
        }

        public void visit(UnionCellRegion region) {
        }

        public void visit(CrossjoinCellRegion region) {
        }
    }

    private static class FoundOne
    extends RuntimeException {
        private final UnionCellRegion region;

        public FoundOne(UnionCellRegion region) {
            this.region = region;
        }
    }

    static interface CellRegionVisitor {
        public void visit(MemberCellRegion var1);

        public void visit(MemberRangeCellRegion var1);

        public void visit(UnionCellRegion var1);

        public void visit(CrossjoinCellRegion var1);
    }

    static interface CellRegionImpl
    extends CacheControl.CellRegion {
        public void accept(CellRegionVisitor var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UnionCellRegion
    implements CellRegionImpl {
        private final List<CellRegionImpl> regions;

        UnionCellRegion(List<CellRegionImpl> regions) {
            this.regions = regions;
            assert (regions.size() >= 1);
            for (int i = 1; i < regions.size(); ++i) {
                CacheControl.CellRegion region0 = regions.get(0);
                CacheControl.CellRegion region = regions.get(i);
                assert (((Object)region0.getDimensionality()).equals(region.getDimensionality()));
            }
        }

        @Override
        public List<Dimension> getDimensionality() {
            return this.regions.get(0).getDimensionality();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("Union(");
            for (int i = 0; i < this.regions.size(); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                CacheControl.CellRegion component = this.regions.get(i);
                sb.append(component.toString());
            }
            sb.append(")");
            return sb.toString();
        }

        @Override
        public void accept(CellRegionVisitor visitor) {
            visitor.visit(this);
            for (CellRegionImpl cellRegion : this.regions) {
                cellRegion.accept(visitor);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class CrossjoinCellRegion
    implements CellRegionImpl {
        final List<Dimension> dimensions;
        private List<CellRegionImpl> components = new ArrayList<CellRegionImpl>();

        CrossjoinCellRegion(List<CellRegionImpl> regions) {
            ArrayList<Dimension> dimensionality = new ArrayList<Dimension>();
            CrossjoinCellRegion.compute(regions, this.components, dimensionality);
            this.dimensions = Collections.unmodifiableList(dimensionality);
        }

        private static void compute(List<CellRegionImpl> regions, List<CellRegionImpl> components, List<Dimension> dimensionality) {
            HashSet<Dimension> dimensionSet = new HashSet<Dimension>();
            for (CellRegionImpl region : regions) {
                CrossjoinCellRegion.addComponents(region, components);
                List<Dimension> regionDimensionality = region.getDimensionality();
                dimensionality.addAll(regionDimensionality);
                dimensionSet.addAll(regionDimensionality);
                assert (dimensionSet.size() == dimensionality.size()) : "dimensions in common";
            }
        }

        @Override
        public void accept(CellRegionVisitor visitor) {
            visitor.visit(this);
            Iterator<CellRegionImpl> i$ = this.components.iterator();
            while (i$.hasNext()) {
                CellRegionImpl component;
                CellRegionImpl cellRegion = component = i$.next();
                cellRegion.accept(visitor);
            }
        }

        private static void addComponents(CellRegionImpl region, List<CellRegionImpl> list) {
            if (region instanceof CrossjoinCellRegion) {
                CrossjoinCellRegion crossjoinRegion = (CrossjoinCellRegion)region;
                for (CellRegionImpl component : crossjoinRegion.components) {
                    list.add(component);
                }
            } else {
                list.add(region);
            }
        }

        @Override
        public List<Dimension> getDimensionality() {
            return this.dimensions;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("Crosssjoin(");
            for (int i = 0; i < this.components.size(); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                CacheControl.CellRegion component = this.components.get(i);
                sb.append(component.toString());
            }
            sb.append(")");
            return sb.toString();
        }

        public List<CacheControl.CellRegion> getComponents() {
            return this.components;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MemberRangeCellRegion
    implements CellRegionImpl {
        private final RolapMember lowerMember;
        private final boolean lowerInclusive;
        private final RolapMember upperMember;
        private final boolean upperInclusive;
        private final boolean descendants;
        private final RolapLevel level;

        MemberRangeCellRegion(RolapMember lowerMember, boolean lowerInclusive, RolapMember upperMember, boolean upperInclusive, boolean descendants) {
            assert (lowerMember != null || upperMember != null);
            assert (lowerMember == null || upperMember == null || lowerMember.getLevel() == upperMember.getLevel());
            assert (lowerMember != null || !lowerInclusive);
            assert (upperMember != null || !upperInclusive);
            this.lowerMember = lowerMember;
            this.lowerInclusive = lowerInclusive;
            this.upperMember = upperMember;
            this.upperInclusive = upperInclusive;
            this.descendants = descendants;
            this.level = lowerMember == null ? upperMember.getLevel() : lowerMember.getLevel();
        }

        @Override
        public List<Dimension> getDimensionality() {
            return Collections.singletonList(this.level.getDimension());
        }

        public RolapLevel getLevel() {
            return this.level;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("Range(");
            if (this.lowerMember == null) {
                sb.append("null");
            } else {
                sb.append(this.lowerMember);
                if (this.lowerInclusive) {
                    sb.append(" inclusive");
                } else {
                    sb.append(" exclusive");
                }
            }
            sb.append(" to ");
            if (this.upperMember == null) {
                sb.append("null");
            } else {
                sb.append(this.upperMember);
                if (this.upperInclusive) {
                    sb.append(" inclusive");
                } else {
                    sb.append(" exclusive");
                }
            }
            sb.append(")");
            return sb.toString();
        }

        @Override
        public void accept(CellRegionVisitor visitor) {
            visitor.visit(this);
        }

        public boolean getLowerInclusive() {
            return this.lowerInclusive;
        }

        public RolapMember getLowerBound() {
            return this.lowerMember;
        }

        public boolean getUpperInclusive() {
            return this.upperInclusive;
        }

        public RolapMember getUpperBound() {
            return this.upperMember;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MemberCellRegion
    implements CellRegionImpl {
        private final List<Member> memberList;
        private final Dimension dimension;
        private final boolean descendants;

        MemberCellRegion(List<Member> memberList, boolean descendants) {
            assert (memberList.size() > 0);
            this.memberList = memberList;
            this.dimension = memberList.get(0).getDimension();
            this.descendants = descendants;
        }

        @Override
        public List<Dimension> getDimensionality() {
            return Collections.singletonList(this.dimension);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("Member(");
            for (int i = 0; i < this.memberList.size(); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                Member member = this.memberList.get(i);
                sb.append(member.toString());
            }
            sb.append(")");
            return sb.toString();
        }

        @Override
        public void accept(CellRegionVisitor visitor) {
            visitor.visit(this);
        }

        public List<Member> getMemberList() {
            return this.memberList;
        }
    }
}

