/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.validation;

import org.springframework.beans.PropertyAccessException;
import org.springframework.context.support.DefaultMessageSourceResolvable;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingErrorProcessor;
import org.springframework.validation.FieldError;

public class DefaultBindingErrorProcessor
implements BindingErrorProcessor {
    public static final String MISSING_FIELD_ERROR_CODE = "required";

    public void processMissingFieldError(String missingField, BindException errors) {
        String[] codes = errors.resolveMessageCodes(MISSING_FIELD_ERROR_CODE, missingField);
        Object[] arguments = this.getArgumentsForBindError(errors.getObjectName(), missingField);
        errors.addError(new FieldError(errors.getObjectName(), missingField, "", true, codes, arguments, "Field '" + missingField + "' is required"));
    }

    public void processPropertyAccessException(PropertyAccessException ex, BindException errors) {
        String field = ex.getPropertyChangeEvent().getPropertyName();
        Object value = ex.getPropertyChangeEvent().getNewValue();
        String[] codes = errors.resolveMessageCodes(ex.getErrorCode(), field);
        Object[] arguments = this.getArgumentsForBindError(errors.getObjectName(), field);
        errors.addError(new FieldError(errors.getObjectName(), field, value, true, codes, arguments, ex.getLocalizedMessage()));
    }

    protected Object[] getArgumentsForBindError(String objectName, String field) {
        String[] codes = new String[]{objectName + "." + field, field};
        String defaultMessage = field;
        return new Object[]{new DefaultMessageSourceResolvable(codes, defaultMessage)};
    }
}

