/*
 * Decompiled with CFR 0.152.
 */
package mondrian.udf;

import java.util.Date;
import java.util.Locale;
import mondrian.olap.Evaluator;
import mondrian.olap.Syntax;
import mondrian.olap.type.StringType;
import mondrian.olap.type.Type;
import mondrian.spi.UserDefinedFunction;
import mondrian.util.Format;

public class CurrentDateStringUdf
implements UserDefinedFunction {
    public Object execute(Evaluator evaluator, UserDefinedFunction.Argument[] arguments) {
        Object arg = arguments[0].evaluateScalar(evaluator);
        Locale locale = Locale.getDefault();
        Format format = new Format(((String)arg).toString(), locale);
        Date currDate = new Date();
        return format.format(currDate);
    }

    public String getDescription() {
        return "Returns the current date formatted as specified by the format parameter.";
    }

    public String getName() {
        return "CurrentDateString";
    }

    public Type[] getParameterTypes() {
        return new Type[]{new StringType()};
    }

    public String[] getReservedWords() {
        return null;
    }

    public Type getReturnType(Type[] parameterTypes) {
        return new StringType();
    }

    public Syntax getSyntax() {
        return Syntax.Function;
    }
}

