/*
 * EJBQLConnectionEditor.java
 *
 * Created on March 27, 2007, 1:18 PM
 */

package com.jaspersoft.ireport.designer.connection.gui;

import com.jaspersoft.ireport.locale.I18n;
import com.jaspersoft.ireport.designer.IReportConnection;
import com.jaspersoft.ireport.designer.IReportConnectionEditor;
import com.jaspersoft.ireport.designer.connection.JREmptyDatasourceConnection;


/**
 *
 * @author  gtoffoli
 */
public class JREmptyDataSourceConnectionEditor extends javax.swing.JPanel implements IReportConnectionEditor {
    
    private IReportConnection iReportConnection = null;
    private boolean init = false;
    
    /** Creates new form EJBQLConnectionEditor */
    public JREmptyDataSourceConnectionEditor() {
        initComponents();
        //applyI18n();
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jPanelEmptyDataSource = new javax.swing.JPanel();
        jLabel24 = new javax.swing.JLabel();
        jSpinnerNumRecords = new javax.swing.JSpinner();

        setLayout(new java.awt.BorderLayout());

        jPanelEmptyDataSource.setLayout(new java.awt.GridBagLayout());

        jLabel24.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        jLabel24.setText(I18n.getString("JREmptyDataSourceConnectionEditor.Label.NumEmptyRec")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(16, 20, 0, 4);
        jPanelEmptyDataSource.add(jLabel24, gridBagConstraints);

        jSpinnerNumRecords.setPreferredSize(new java.awt.Dimension(70, 18));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(14, 0, 0, 20);
        jPanelEmptyDataSource.add(jSpinnerNumRecords, gridBagConstraints);

        add(jPanelEmptyDataSource, java.awt.BorderLayout.CENTER);
    }// </editor-fold>//GEN-END:initComponents
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel jLabel24;
    private javax.swing.JPanel jPanelEmptyDataSource;
    private javax.swing.JSpinner jSpinnerNumRecords;
    // End of variables declaration//GEN-END:variables
    
    
    public void setIReportConnection(IReportConnection c) {
        
        this.iReportConnection = c;
        if (iReportConnection instanceof JREmptyDatasourceConnection)
        {
            JREmptyDatasourceConnection con = (JREmptyDatasourceConnection)iReportConnection;
            jSpinnerNumRecords.getModel().setValue(new Integer(con.getRecords()));
        }
    }

    public IReportConnection getIReportConnection() {
        
        IReportConnection irConn = new JREmptyDatasourceConnection();

        ((JREmptyDatasourceConnection)irConn).setRecords( ((javax.swing.SpinnerNumberModel)jSpinnerNumRecords.getModel()).getNumber().intValue() );
        iReportConnection = irConn;
        return iReportConnection;
    }
    
    /*
    public void applyI18n(){
                // Start autogenerated code ----------------------
                jLabel24.setText(I18n.getString("connectionDialog.label24","Number of empty records"));
    }
    */
    
    
}
