/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.outline.nodes;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.ModelUtils;
import com.jaspersoft.ireport.designer.actions.AddDatasetAction;
import com.jaspersoft.ireport.designer.editor.ExpressionContext;
import com.jaspersoft.ireport.designer.menu.EditQueryAction;
import com.jaspersoft.ireport.designer.outline.nodes.DatasetNode;
import com.jaspersoft.ireport.designer.outline.nodes.ExpressionHolder;
import com.jaspersoft.ireport.designer.outline.nodes.IRAbstractNode;
import com.jaspersoft.ireport.designer.outline.nodes.ReportChildren;
import com.jaspersoft.ireport.designer.sheet.JRPropertiesMapProperty;
import com.jaspersoft.ireport.designer.sheet.Tag;
import com.jaspersoft.ireport.designer.sheet.editors.ComboBoxPropertyEditor;
import com.jaspersoft.ireport.designer.sheet.properties.LanguageProperty;
import com.jaspersoft.ireport.designer.sheet.properties.WhenNoDataTypeProperty;
import com.jaspersoft.ireport.designer.undo.ObjectPropertyUndoableEdit;
import com.jaspersoft.ireport.designer.wizards.ReportGroupWizardAction;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import javax.swing.Action;
import net.sf.jasperreports.engine.JRPropertiesHolder;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignGroup;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.openide.ErrorManager;
import org.openide.cookies.SaveCookie;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.actions.NodeAction;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportNode
extends IRAbstractNode
implements PropertyChangeListener,
ExpressionHolder {
    JasperDesign jd = null;
    public static final Action testPropertiesAction = new NodeAction(){

        protected void performAction(Node[] activatedNodes) {
            JasperDesign jd = (JasperDesign)activatedNodes[0].getLookup().lookup(JasperDesign.class);
            jd.setName("test name");
            jd.setPageWidth(700);
            jd.setPageHeight(400);
            jd.setOrientation((byte)2);
            jd.setTopMargin(10);
            jd.setBottomMargin(20);
            jd.setLeftMargin(35);
            jd.setRightMargin(5);
        }

        protected boolean enable(Node[] activatedNodes) {
            return activatedNodes.length > 0;
        }

        public String getName() {
            return "Test document properties changes";
        }

        public HelpCtx getHelpCtx() {
            return null;
        }
    };

    public ReportNode(JasperDesign jd, Lookup doLkp) {
        super((Children)new ReportChildren(jd, doLkp), (Lookup)new ProxyLookup(new Lookup[]{Lookups.singleton((Object)jd), doLkp}));
        this.jd = jd;
        jd.getEventSupport().addPropertyChangeListener((PropertyChangeListener)this);
        for (int i = 0; i < this.jd.getGroupsList().size(); ++i) {
            JRDesignGroup grp = (JRDesignGroup)this.jd.getGroupsList().get(i);
            grp.getEventSupport().addPropertyChangeListener((PropertyChangeListener)this);
        }
        this.setIconBaseWithExtension("com/jaspersoft/ireport/designer/resources/report-16.png");
    }

    public JasperDesign getJasperDesign() {
        return this.jd;
    }

    public String getDisplayName() {
        return "" + this.jd.getName();
    }

    protected Sheet createSheet() {
        Sheet sheet = super.createSheet();
        Sheet.Set reportPropertiesSet = Sheet.createPropertiesSet();
        reportPropertiesSet.setName("REPORT_PROPERTIES");
        reportPropertiesSet.setDisplayName("Report properties");
        reportPropertiesSet.put((Node.Property)new NameProperty(this.jd));
        sheet.put(reportPropertiesSet);
        Sheet.Set pageSizeSet = Sheet.createPropertiesSet();
        pageSizeSet.setName("PAGE_SIZE");
        pageSizeSet.setDisplayName("Page size");
        pageSizeSet.put((Node.Property)new PageWidthProperty(this.jd));
        pageSizeSet.put((Node.Property)new PageHeightProperty(this.jd));
        pageSizeSet.put((Node.Property)new OrientationProperty(this.jd));
        sheet.put(pageSizeSet);
        Sheet.Set marginsSet = Sheet.createPropertiesSet();
        marginsSet.setName("PAGE_MARGINS");
        marginsSet.setDisplayName("Margins");
        marginsSet.put((Node.Property)new LeftMarginProperty(this.jd));
        marginsSet.put((Node.Property)new RightMarginProperty(this.jd));
        marginsSet.put((Node.Property)new TopMarginProperty(this.jd));
        marginsSet.put((Node.Property)new BottomMarginProperty(this.jd));
        sheet.put(marginsSet);
        Sheet.Set columnsSet = Sheet.createPropertiesSet();
        columnsSet.setName("PAGE_COLUMNS");
        columnsSet.setDisplayName("Columns");
        columnsSet.put((Node.Property)new ColumnCountProperty(this.jd));
        columnsSet.put((Node.Property)new ColumnWidthProperty(this.jd));
        columnsSet.put((Node.Property)new ColumnSpacingProperty(this.jd));
        sheet.put(columnsSet);
        Sheet.Set moreSet = Sheet.createPropertiesSet();
        moreSet.setName("PAGE_MORE");
        moreSet.setDisplayName("More...");
        DatasetNode.fillDatasetPropertySet(moreSet, this.jd.getMainDesignDataset(), this.jd);
        moreSet.put((Node.Property)new JRPropertiesMapProperty((JRPropertiesHolder)this.jd));
        moreSet.put((Node.Property)new TitleNewPageProperty(this.jd));
        moreSet.put((Node.Property)new SummaryNewPageProperty(this.jd));
        moreSet.put((Node.Property)new FloatColumnFooterProperty(this.jd));
        moreSet.put((Node.Property)new IgnorePaginationProperty(this.jd));
        moreSet.put((Node.Property)new PrintOrderProperty(this.jd));
        moreSet.put((Node.Property)new WhenNoDataTypeProperty(this.jd));
        moreSet.put((Node.Property)new LanguageProperty(this.jd));
        moreSet.put((Node.Property)new FormatFactoryClassProperty(this.jd));
        sheet.put(moreSet);
        return sheet;
    }

    public Action[] getActions(boolean context) {
        Action[] actions = super.getActions(context);
        ArrayList<Action> myactions = new ArrayList<Action>();
        for (int i = 0; i < actions.length; ++i) {
            myactions.add(actions[i]);
        }
        myactions.add(null);
        myactions.add((Action)SystemAction.get(EditQueryAction.class));
        myactions.add(null);
        myactions.add((Action)SystemAction.get(ReportGroupWizardAction.class));
        myactions.add((Action)SystemAction.get(AddDatasetAction.class));
        return myactions.toArray(new Action[myactions.size()]);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        IReportManager.getInstance().notifyReportChange();
        if (evt.getPropertyName() == null) {
            return;
        }
        if (evt.getPropertyName().equals("background") || evt.getPropertyName().equals("title") || evt.getPropertyName().equals("pageHeader") || evt.getPropertyName().equals("columnHeader") || evt.getPropertyName().equals("detail") || evt.getPropertyName().equals("columnFooter") || evt.getPropertyName().equals("pageFooter") || evt.getPropertyName().equals("lastPageFooter") || evt.getPropertyName().equals("summary") || evt.getPropertyName().equals("noData") || evt.getPropertyName().equals("groups") || evt.getPropertyName().equals("groupHeader") || evt.getPropertyName().equals("groupFooter") || evt.getPropertyName().equals("datasets")) {
            ((ReportChildren)this.getChildren()).updateChildren();
        }
        if (evt.getPropertyName().equals("name")) {
            this.fireDisplayNameChange(null, this.jd.getName());
        }
        if (evt.getPropertyName().equals("columnCount") || evt.getPropertyName().equals("columnSpacing") || evt.getPropertyName().equals("columnWidth")) {
            this.firePropertyChange("columnCount", null, this.jd.getColumnCount());
            this.firePropertyChange("columnSpacing", null, this.jd.getColumnSpacing());
            this.firePropertyChange("columnWidth", null, this.jd.getColumnWidth());
        } else if (ModelUtils.containsProperty(this.getPropertySets(), evt.getPropertyName())) {
            this.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
        }
        if (evt.getPropertyName().equals("groups")) {
            for (int i = 0; i < this.jd.getGroupsList().size(); ++i) {
                JRDesignGroup grp = (JRDesignGroup)this.jd.getGroupsList().get(i);
                grp.getEventSupport().removePropertyChangeListener((PropertyChangeListener)this);
                grp.getEventSupport().addPropertyChangeListener((PropertyChangeListener)this);
            }
        }
    }

    public <T extends Node.Cookie> T getCookie(Class<T> type) {
        Object o = this.getLookup().lookup(type);
        if (o == null && SaveCookie.class.isAssignableFrom(type)) {
            o = IReportManager.getInstance().getActiveVisualView().getEditorSupport().getDataObject().getLookup().lookup(SaveCookie.class);
        }
        if (o == null && Node.Cookie.class.isAssignableFrom(type)) {
            o = super.getCookie(type);
        }
        return (T)(o instanceof Node.Cookie ? (Node.Cookie)o : null);
    }

    @Override
    public boolean hasExpression(JRDesignExpression ex) {
        return this.jd.getFilterExpression() == ex;
    }

    @Override
    public ExpressionContext getExpressionContext(JRDesignExpression ex) {
        return new ExpressionContext(this.jd.getMainDesignDataset());
    }

    private static final class FormatFactoryClassProperty
    extends PropertySupport {
        private final JasperDesign jasperDesign;

        public FormatFactoryClassProperty(JasperDesign jd) {
            super("formatFactoryClass", String.class, "Format Factory Class", "Name of an optional class to format numbers, dates, etc...", true, true);
            this.jasperDesign = jd;
            this.setValue("oneline", Boolean.TRUE);
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.jasperDesign.getFormatFactoryClass() == null ? "" : this.jasperDesign.getFormatFactoryClass();
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (val instanceof String) {
                String oldValue = this.jasperDesign.getFormatFactoryClass();
                String newValue = val == null || ((String)val).trim().length() == 0 ? null : ((String)val).trim();
                this.jasperDesign.setFormatFactoryClass(newValue);
                ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.jasperDesign, "FormatFactoryClass", String.class, oldValue, newValue);
                IReportManager.getInstance().addUndoableEdit(urob);
            }
        }
    }

    private static final class PrintOrderProperty
    extends PropertySupport {
        private final JasperDesign jasperDesign;
        private ComboBoxPropertyEditor editor;

        public PrintOrderProperty(JasperDesign jd) {
            super("printOrder", Byte.class, "Print order", "The way to print the records", true, true);
            this.jasperDesign = jd;
            this.setValue("suppressCustomEditor", Boolean.TRUE);
        }

        public PropertyEditor getPropertyEditor() {
            if (this.editor == null) {
                ArrayList<Tag> l = new ArrayList<Tag>();
                l.add(new Tag(new Byte(1), "Vertical"));
                l.add(new Tag(new Byte(2), "Horizontal"));
                this.editor = new ComboBoxPropertyEditor(false, l);
            }
            return this.editor;
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return new Byte(this.jasperDesign.getPrintOrder());
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (val instanceof Byte) {
                Byte oldValue = this.jasperDesign.getPrintOrder();
                Byte newValue = (Byte)val;
                this.jasperDesign.setPrintOrder(newValue.byteValue());
                ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.jasperDesign, "PrintOrder", Byte.TYPE, oldValue, newValue);
                IReportManager.getInstance().addUndoableEdit(urob);
            }
        }
    }

    private static final class IgnorePaginationProperty
    extends PropertySupport {
        private final JasperDesign jasperDesign;

        public IgnorePaginationProperty(JasperDesign jd) {
            super("ignorePagination", Boolean.class, "Ignore pagination", "Print the whole document as a single page", true, true);
            this.jasperDesign = jd;
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.jasperDesign.isIgnorePagination();
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (val instanceof Boolean) {
                Boolean oldValue = this.jasperDesign.isIgnorePagination();
                Boolean newValue = (Boolean)val;
                this.jasperDesign.setIgnorePagination(newValue.booleanValue());
                ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.jasperDesign, "IgnorePagination", Boolean.TYPE, oldValue, newValue);
                IReportManager.getInstance().addUndoableEdit(urob);
            }
        }
    }

    private static final class FloatColumnFooterProperty
    extends PropertySupport {
        private final JasperDesign jasperDesign;

        public FloatColumnFooterProperty(JasperDesign jd) {
            super("floatColumnFooter", Boolean.class, "Float column footer", "Let the column footer to float", true, true);
            this.jasperDesign = jd;
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.jasperDesign.isFloatColumnFooter();
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (val instanceof Boolean) {
                Boolean oldValue = this.jasperDesign.isFloatColumnFooter();
                Boolean newValue = (Boolean)val;
                this.jasperDesign.setFloatColumnFooter(newValue.booleanValue());
                ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.jasperDesign, "FloatColumnFooter", Boolean.TYPE, oldValue, newValue);
                IReportManager.getInstance().addUndoableEdit(urob);
            }
        }
    }

    private static final class SummaryNewPageProperty
    extends PropertySupport {
        private final JasperDesign jasperDesign;

        public SummaryNewPageProperty(JasperDesign jd) {
            super("summaryNewPage", Boolean.class, "Summary on a new page", "Print the summary band on a separate page", true, true);
            this.jasperDesign = jd;
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.jasperDesign.isSummaryNewPage();
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (val instanceof Boolean) {
                Boolean oldValue = this.jasperDesign.isSummaryNewPage();
                Boolean newValue = (Boolean)val;
                this.jasperDesign.setSummaryNewPage(newValue.booleanValue());
                ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.jasperDesign, "SummaryNewPage", Boolean.TYPE, oldValue, newValue);
                IReportManager.getInstance().addUndoableEdit(urob);
            }
        }
    }

    private static final class TitleNewPageProperty
    extends PropertySupport {
        private final JasperDesign jasperDesign;

        public TitleNewPageProperty(JasperDesign jd) {
            super("titleNewPage", Boolean.class, "Title on a new page", "Print the title band on a separate page", true, true);
            this.jasperDesign = jd;
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.jasperDesign.isTitleNewPage();
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (val instanceof Boolean) {
                Boolean oldValue = this.jasperDesign.isTitleNewPage();
                Boolean newValue = (Boolean)val;
                this.jasperDesign.setTitleNewPage(newValue.booleanValue());
                ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.jasperDesign, "TitleNewPage", Boolean.TYPE, oldValue, newValue);
                IReportManager.getInstance().addUndoableEdit(urob);
            }
        }
    }

    private static final class OrientationProperty
    extends PropertySupport {
        private final JasperDesign jasperDesign;
        private ComboBoxPropertyEditor editor;

        public OrientationProperty(JasperDesign jd) {
            super("orientation", Byte.class, "Orientation", "This is the page orientation", true, true);
            this.jasperDesign = jd;
            this.setValue("suppressCustomEditor", Boolean.TRUE);
        }

        public PropertyEditor getPropertyEditor() {
            if (this.editor == null) {
                ArrayList<Tag> l = new ArrayList<Tag>();
                l.add(new Tag(new Byte(1), "Portrait"));
                l.add(new Tag(new Byte(2), "Landscape"));
                this.editor = new ComboBoxPropertyEditor(false, l);
            }
            return this.editor;
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return new Byte(this.jasperDesign.getOrientation());
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (val instanceof Byte) {
                Byte oldValue = this.jasperDesign.getOrientation();
                Byte newValue = (Byte)val;
                this.jasperDesign.setOrientation(newValue.byteValue());
                ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.jasperDesign, "Orientation", Byte.TYPE, oldValue, newValue);
                IReportManager.getInstance().addUndoableEdit(urob);
            }
        }
    }

    private static final class ColumnSpacingProperty
    extends PropertySupport {
        private final JasperDesign jasperDesign;

        public ColumnSpacingProperty(JasperDesign jd) {
            super("columnSpacing", Integer.class, "Column Spacing", "The space between two columns", true, true);
            this.jasperDesign = jd;
        }

        public boolean canWrite() {
            return this.jasperDesign.getColumnCount() > 1;
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.jasperDesign.getColumnSpacing();
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (val instanceof Integer) {
                Integer oldValue = this.jasperDesign.getColumnSpacing();
                Integer newValue = (Integer)val;
                int available = this.jasperDesign.getPageWidth();
                available -= this.jasperDesign.getLeftMargin();
                available -= this.jasperDesign.getRightMargin();
                if (newValue > (available /= this.jasperDesign.getColumnCount() - 1)) {
                    IllegalArgumentException iae = this.annotateException("You don't have enought space (max available column space: " + available + " pixels)");
                    throw iae;
                }
                this.jasperDesign.setColumnSpacing(newValue.intValue());
                ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.jasperDesign, "ColumnSpacing", Integer.TYPE, oldValue, newValue);
                available = this.jasperDesign.getPageWidth();
                available -= this.jasperDesign.getLeftMargin();
                available -= this.jasperDesign.getRightMargin();
                available -= (this.jasperDesign.getColumnCount() - 1) * newValue;
                ObjectPropertyUndoableEdit urob2 = new ObjectPropertyUndoableEdit(this.jasperDesign, "ColumnWidth", Integer.TYPE, this.jasperDesign.getColumnWidth(), available /= this.jasperDesign.getColumnCount());
                this.jasperDesign.setColumnWidth(available);
                urob.concatenate(urob2);
                IReportManager.getInstance().addUndoableEdit(urob);
            }
        }

        public IllegalArgumentException annotateException(String msg) {
            IllegalArgumentException iae = new IllegalArgumentException(msg);
            ErrorManager.getDefault().annotate((Throwable)iae, 4096, msg, msg, null, null);
            return iae;
        }
    }

    private static final class ColumnWidthProperty
    extends PropertySupport {
        private final JasperDesign jasperDesign;

        public ColumnWidthProperty(JasperDesign jd) {
            super("columnWidth", Integer.class, "Column Width", "Width of each column", true, true);
            this.jasperDesign = jd;
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.jasperDesign.getColumnWidth();
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (val instanceof Integer) {
                Integer oldValue = this.jasperDesign.getColumnWidth();
                Integer newValue = (Integer)val;
                int available = this.jasperDesign.getPageWidth();
                available -= this.jasperDesign.getLeftMargin();
                available -= this.jasperDesign.getRightMargin();
                if (newValue > (available /= this.jasperDesign.getColumnCount())) {
                    IllegalArgumentException iae = this.annotateException("You don't have enought space (max column width: " + available + " pixels)");
                    throw iae;
                }
                this.jasperDesign.setColumnWidth(newValue.intValue());
                ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.jasperDesign, "ColumnWidth", Integer.TYPE, oldValue, newValue);
                if (this.jasperDesign.getColumnCount() > 1) {
                    available = this.jasperDesign.getPageWidth();
                    available -= this.jasperDesign.getLeftMargin();
                    available -= this.jasperDesign.getRightMargin();
                    available -= this.jasperDesign.getColumnCount() * newValue;
                    ObjectPropertyUndoableEdit urob2 = new ObjectPropertyUndoableEdit(this.jasperDesign, "ColumnWidth", Integer.TYPE, this.jasperDesign.getColumnSpacing(), available /= this.jasperDesign.getColumnCount() - 1);
                    this.jasperDesign.setColumnSpacing(available);
                    urob.concatenate(urob2);
                }
                IReportManager.getInstance().addUndoableEdit(urob);
            }
        }

        public IllegalArgumentException annotateException(String msg) {
            IllegalArgumentException iae = new IllegalArgumentException(msg);
            ErrorManager.getDefault().annotate((Throwable)iae, 4096, msg, msg, null, null);
            return iae;
        }
    }

    private static final class ColumnCountProperty
    extends PropertySupport {
        private final JasperDesign jasperDesign;

        public ColumnCountProperty(JasperDesign jd) {
            super("columnCount", Integer.class, "Columns", "Number of columns", true, true);
            this.jasperDesign = jd;
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.jasperDesign.getColumnCount();
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (val instanceof Integer) {
                Integer oldValue = this.jasperDesign.getColumnCount();
                Integer newValue = (Integer)val;
                if (newValue <= 0) {
                    IllegalArgumentException iae = this.annotateException("You need at least one column!");
                    throw iae;
                }
                this.jasperDesign.setColumnCount(newValue.intValue());
                ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.jasperDesign, "ColumnCount", Integer.TYPE, oldValue, newValue);
                int total = this.jasperDesign.getPageWidth();
                total -= this.jasperDesign.getLeftMargin();
                total -= this.jasperDesign.getRightMargin();
                if (this.jasperDesign.getColumnCount() > 1) {
                    total -= this.jasperDesign.getColumnSpacing() * this.jasperDesign.getColumnCount() - 1;
                }
                ObjectPropertyUndoableEdit urob2 = new ObjectPropertyUndoableEdit(this.jasperDesign, "ColumnWidth", Integer.TYPE, this.jasperDesign.getColumnWidth(), total /= this.jasperDesign.getColumnCount());
                this.jasperDesign.setColumnWidth(total);
                urob.concatenate(urob2);
                if (this.jasperDesign.getColumnCount() == 1 && this.jasperDesign.getColumnSpacing() != 0) {
                    ObjectPropertyUndoableEdit urob3 = new ObjectPropertyUndoableEdit(this.jasperDesign, "ColumnSpacing", Integer.TYPE, this.jasperDesign.getColumnSpacing(), 0);
                    this.jasperDesign.setColumnSpacing(0);
                    urob.concatenate(urob3);
                }
                IReportManager.getInstance().addUndoableEdit(urob);
            }
        }

        public IllegalArgumentException annotateException(String msg) {
            IllegalArgumentException iae = new IllegalArgumentException(msg);
            ErrorManager.getDefault().annotate((Throwable)iae, 4096, msg, msg, null, null);
            return iae;
        }
    }

    private static final class BottomMarginProperty
    extends PropertySupport {
        private final JasperDesign jasperDesign;

        public BottomMarginProperty(JasperDesign jd) {
            super("bottomMargin", Integer.class, "Bottom margin", "This is the bottom margin", true, true);
            this.jasperDesign = jd;
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.jasperDesign.getBottomMargin();
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (val instanceof Integer) {
                Integer oldValue = this.jasperDesign.getBottomMargin();
                Integer newValue = (Integer)val;
                this.jasperDesign.setBottomMargin(newValue.intValue());
                ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.jasperDesign, "BottomMargin", Integer.TYPE, oldValue, newValue);
                IReportManager.getInstance().addUndoableEdit(urob);
            }
        }
    }

    private static final class TopMarginProperty
    extends PropertySupport {
        private final JasperDesign jasperDesign;

        public TopMarginProperty(JasperDesign jd) {
            super("topMargin", Integer.class, "Top margin", "This is the top margin", true, true);
            this.jasperDesign = jd;
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.jasperDesign.getTopMargin();
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (val instanceof Integer) {
                Integer oldValue = this.jasperDesign.getTopMargin();
                Integer newValue = (Integer)val;
                this.jasperDesign.setTopMargin(newValue.intValue());
                ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.jasperDesign, "TopMargin", Integer.TYPE, oldValue, newValue);
                IReportManager.getInstance().addUndoableEdit(urob);
            }
        }
    }

    private static final class RightMarginProperty
    extends PropertySupport {
        private final JasperDesign jasperDesign;

        public RightMarginProperty(JasperDesign jd) {
            super("rightMargin", Integer.class, "Right margin", "This is the right margin", true, true);
            this.jasperDesign = jd;
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.jasperDesign.getRightMargin();
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (val instanceof Integer) {
                Integer oldValue = this.jasperDesign.getRightMargin();
                Integer newValue = (Integer)val;
                this.jasperDesign.setRightMargin(newValue.intValue());
                ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.jasperDesign, "RightMargin", Integer.TYPE, oldValue, newValue);
                IReportManager.getInstance().addUndoableEdit(urob);
            }
        }
    }

    private static final class LeftMarginProperty
    extends PropertySupport {
        private final JasperDesign jasperDesign;

        public LeftMarginProperty(JasperDesign jd) {
            super("leftMargin", Integer.class, "Left margin", "This is the left margin", true, true);
            this.jasperDesign = jd;
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.jasperDesign.getLeftMargin();
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (val instanceof Integer) {
                Integer oldValue = this.jasperDesign.getLeftMargin();
                Integer newValue = (Integer)val;
                this.jasperDesign.setLeftMargin(newValue.intValue());
                ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.jasperDesign, "LeftMargin", Integer.TYPE, oldValue, newValue);
                IReportManager.getInstance().addUndoableEdit(urob);
            }
        }
    }

    private static final class PageHeightProperty
    extends PropertySupport {
        private final JasperDesign jasperDesign;

        public PageHeightProperty(JasperDesign jd) {
            super("pageHeight", Integer.class, "Page height", "This is the page height", true, true);
            this.jasperDesign = jd;
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.jasperDesign.getPageHeight();
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (val instanceof Integer) {
                Integer oldValue = this.jasperDesign.getPageHeight();
                Integer newValue = (Integer)val;
                this.jasperDesign.setPageHeight(newValue.intValue());
                ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.jasperDesign, "PageHeight", Integer.TYPE, oldValue, newValue);
                IReportManager.getInstance().addUndoableEdit(urob);
            }
        }
    }

    private static final class PageWidthProperty
    extends PropertySupport {
        private final JasperDesign jasperDesign;

        public PageWidthProperty(JasperDesign jd) {
            super("pageWidth", Integer.class, "Page width", "This is the page width", true, true);
            this.jasperDesign = jd;
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.jasperDesign.getPageWidth();
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (val instanceof Integer) {
                Integer oldValue = this.jasperDesign.getPageWidth();
                Integer newValue = (Integer)val;
                this.jasperDesign.setPageWidth(newValue.intValue());
                ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.jasperDesign, "PageWidth", Integer.TYPE, oldValue, newValue);
                IReportManager.getInstance().addUndoableEdit(urob);
            }
        }
    }

    private static final class NameProperty
    extends PropertySupport {
        private final JasperDesign jasperDesign;

        public NameProperty(JasperDesign jd) {
            super("name", String.class, "Report name", "The name of this report", true, true);
            this.jasperDesign = jd;
            this.setValue("oneline", Boolean.TRUE);
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.jasperDesign.getName();
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (val instanceof String) {
                String oldValue = this.jasperDesign.getName();
                String newValue = (String)val;
                this.jasperDesign.setName(newValue);
                ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.jasperDesign, "Name", String.class, oldValue, newValue);
                IReportManager.getInstance().addUndoableEdit(urob);
            }
        }
    }
}

