/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.environment.ctrl.explorer;

import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import nickyb.sqleonardo.common.gui.BorderLayoutPanel;
import nickyb.sqleonardo.common.gui.Toolbar;
import nickyb.sqleonardo.common.jdbc.ConnectionAssistant;
import nickyb.sqleonardo.environment.Application;
import nickyb.sqleonardo.environment.ctrl.explorer.AbstractListTaskSource;
import nickyb.sqleonardo.environment.ctrl.explorer.UoDatasource;
import nickyb.sqleonardo.environment.ctrl.explorer.UoLinks;
import nickyb.sqleonardo.querybuilder.QueryBuilder;

public class ViewLinks
extends AbstractListTaskSource
implements ItemListener {
    private String keycah = null;
    private UoLinks uoLk = null;
    private JCheckBox cbxAll;
    private JComboBox groups;

    ViewLinks() {
        Toolbar bar = new Toolbar(0);
        this.cbxAll = new JCheckBox("all groups");
        bar.add(this.cbxAll);
        this.groups = new JComboBox();
        bar.add(this.groups);
        bar.addSeparator();
        bar.add(new ActionAddGroup());
        bar.add(new ActionRemoveGroup());
        this.cbxAll.addItemListener(this);
        this.groups.addItemListener(this);
        BorderLayoutPanel north = new BorderLayoutPanel();
        north.setBorder(new CompoundBorder(LineBorder.createGrayLineBorder(), new EmptyBorder(2, 2, 2, 2)));
        north.setComponentCenter(bar);
        this.setComponentNorth(north);
        this.addColumn("TABLE_SCHEM");
        this.addColumn("TABLE_NAME");
        this.addColumn("TABLE_TYPE");
    }

    protected String getHandlerKey() {
        if (ConnectionAssistant.hasHandler(this.keycah)) {
            QueryBuilder.identifierQuoteString = ConnectionAssistant.getHandler(this.keycah).getObject("$identifierQuoteString").toString();
            QueryBuilder.maxColumnNameLength = (Integer)ConnectionAssistant.getHandler(this.keycah).getObject("$maxColumnNameLength");
        }
        return this.keycah;
    }

    protected void list(DefaultMutableTreeNode node) {
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
        this.keycah = ((UoDatasource)parent.getUserObject()).getKey();
        this.uoLk = (UoLinks)node.getUserObject();
        this.groups.setModel(new DefaultComboBoxModel<Object>(this.uoLk.getGroups().toArray()));
        this.groups.setSelectedItem(null);
    }

    public void itemStateChanged(ItemEvent ie) {
        block4: {
            block3: {
                this.removeAllRows();
                this.groups.setEnabled(!this.cbxAll.isSelected());
                if (!this.cbxAll.isSelected()) break block3;
                for (int i = 0; i < this.groups.getItemCount(); ++i) {
                    Object group = this.groups.getItemAt(i);
                    ArrayList links = this.uoLk.getLinks(group.toString());
                    for (int j = 0; j < links.size(); ++j) {
                        this.addRow((String[])links.get(j));
                    }
                }
                break block4;
            }
            Object group = this.groups.getSelectedItem();
            if (group == null) break block4;
            ArrayList links = this.uoLk.getLinks(group.toString());
            for (int i = 0; i < links.size(); ++i) {
                this.addRow((String[])links.get(i));
            }
        }
    }

    public void mouseReleased(MouseEvent me) {
        if (SwingUtilities.isRightMouseButton(me)) {
            int row = this.getJavaComponent().rowAtPoint(me.getPoint());
            this.getJavaComponent().setRowSelectionInterval(row, row);
            JPopupMenu popup = new JPopupMenu();
            popup.add(new AbstractListTaskSource.ActionQuery()).setEnabled(ConnectionAssistant.hasHandler(this.keycah));
            popup.add(new ActionRemoveLink()).setEnabled(!this.cbxAll.isSelected());
            popup.addSeparator();
            popup.add(new AbstractListTaskSource.ActionCommand()).setEnabled(ConnectionAssistant.hasHandler(this.keycah));
            popup.addSeparator();
            popup.add(new AbstractListTaskSource.ActionDeleteContent()).setEnabled(ConnectionAssistant.hasHandler(this.keycah));
            popup.add(new AbstractListTaskSource.ActionDropObject()).setEnabled(ConnectionAssistant.hasHandler(this.keycah));
            popup.addSeparator();
            popup.add(new AbstractListTaskSource.ActionShowContent()).setEnabled(ConnectionAssistant.hasHandler(this.keycah));
            popup.add(new AbstractListTaskSource.ActionShowDefinition()).setEnabled(ConnectionAssistant.hasHandler(this.keycah));
            popup.show(this.getJavaComponent(), me.getX(), me.getY());
        }
    }

    protected class ActionRemoveLink
    extends AbstractAction {
        ActionRemoveLink() {
            super("remove from group");
        }

        public void actionPerformed(ActionEvent e) {
            Object group = ViewLinks.this.groups.getSelectedItem();
            if (group != null) {
                int row = ViewLinks.this.getSelectedRow();
                ViewLinks.this.uoLk.getLinks(group.toString()).remove(row);
                ViewLinks.this.removeRow(row);
            }
        }
    }

    private class ActionRemoveGroup
    extends AbstractAction {
        ActionRemoveGroup() {
            this.putValue("Name", "remove group");
            this.putValue("SmallIcon", Application.resources.getIcon("icon.108"));
        }

        public void actionPerformed(ActionEvent e) {
            Object group = ViewLinks.this.groups.getSelectedItem();
            if (group != null) {
                if (!Application.confirm("confirm delete", "deleting \"" + group + "\" continue?")) {
                    return;
                }
                ViewLinks.this.groups.removeItem(group);
                ViewLinks.this.uoLk.removeGroup(group.toString());
            }
        }
    }

    private class ActionAddGroup
    extends AbstractAction {
        ActionAddGroup() {
            this.putValue("Name", "add group");
            this.putValue("SmallIcon", Application.resources.getIcon("icon.107"));
        }

        public void actionPerformed(ActionEvent e) {
            String group = Application.input("SQLeonardo", "group name:");
            if (group != null) {
                if (((DefaultComboBoxModel)ViewLinks.this.groups.getModel()).getIndexOf(group) == -1) {
                    ViewLinks.this.groups.addItem(group);
                }
                ViewLinks.this.groups.setSelectedItem(group);
            }
        }
    }
}

