/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.ref.SoftReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.sql.DataSource;
import mondrian.olap.Access;
import mondrian.olap.Cube;
import mondrian.olap.Dimension;
import mondrian.olap.Exp;
import mondrian.olap.Formula;
import mondrian.olap.FunTable;
import mondrian.olap.Hierarchy;
import mondrian.olap.Level;
import mondrian.olap.Member;
import mondrian.olap.MondrianDef;
import mondrian.olap.MondrianProperties;
import mondrian.olap.NamedSet;
import mondrian.olap.Parameter;
import mondrian.olap.Role;
import mondrian.olap.Schema;
import mondrian.olap.SchemaReader;
import mondrian.olap.Syntax;
import mondrian.olap.Util;
import mondrian.olap.fun.FunInfo;
import mondrian.olap.fun.FunTableImpl;
import mondrian.olap.fun.GlobalFunTable;
import mondrian.olap.fun.Resolver;
import mondrian.olap.fun.UdfResolver;
import mondrian.olap.type.MemberType;
import mondrian.olap.type.NumericType;
import mondrian.olap.type.StringType;
import mondrian.olap.type.Type;
import mondrian.resource.MondrianResource;
import mondrian.rolap.CacheMemberReader;
import mondrian.rolap.DynamicSchemaProcessor;
import mondrian.rolap.MemberReader;
import mondrian.rolap.MemberSource;
import mondrian.rolap.RolapConnection;
import mondrian.rolap.RolapConnectionProperties;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapHierarchy;
import mondrian.rolap.RolapNativeRegistry;
import mondrian.rolap.RolapSchemaParameter;
import mondrian.rolap.RolapSchemaReader;
import mondrian.rolap.RolapStar;
import mondrian.rolap.SmartMemberReader;
import mondrian.rolap.SqlMemberSource;
import mondrian.rolap.aggmatcher.AggTableManager;
import mondrian.rolap.aggmatcher.JdbcSchema;
import mondrian.rolap.sql.SqlQuery;
import mondrian.spi.DataSourceChangeListener;
import mondrian.spi.UserDefinedFunction;
import org.apache.commons.vfs.FileContent;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemManager;
import org.apache.commons.vfs.VFS;
import org.apache.log4j.Logger;
import org.eigenbase.xom.DOMWrapper;
import org.eigenbase.xom.ElementDef;
import org.eigenbase.xom.Parser;
import org.eigenbase.xom.XOMException;
import org.eigenbase.xom.XOMUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RolapSchema
implements Schema {
    private static final Logger LOGGER = Logger.getLogger(RolapSchema.class);
    private static final Set<Access> schemaAllowed = Util.enumSetOf((Enum)Access.NONE, (Enum[])new Access[]{Access.ALL, Access.ALL_DIMENSIONS});
    private static final Set<Access> cubeAllowed = Util.enumSetOf((Enum)Access.NONE, (Enum[])new Access[]{Access.ALL});
    private static final Set<Access> dimensionAllowed = Util.enumSetOf((Enum)Access.NONE, (Enum[])new Access[]{Access.ALL});
    private static final Set<Access> hierarchyAllowed = Util.enumSetOf((Enum)Access.NONE, (Enum[])new Access[]{Access.ALL, Access.CUSTOM});
    private static final Set<Access> memberAllowed = Util.enumSetOf((Enum)Access.NONE, (Enum[])new Access[]{Access.ALL});
    private String name;
    private final RolapConnection internalConnection;
    private final Map<String, RolapCube> mapNameToCube;
    private final Map<String, MemberReader> mapSharedHierarchyToReader;
    private final Map<String, RolapHierarchy> mapSharedHierarchyNameToHierarchy;
    private Role defaultRole;
    private final String md5Bytes;
    private AggTableManager aggTableManager;
    private String key;
    private final Map<String, Role> mapNameToRole;
    private final Map<String, NamedSet> mapNameToSet = new HashMap<String, NamedSet>();
    private FunTable funTable;
    private MondrianDef.Schema xmlSchema;
    final List<RolapSchemaParameter> parameterList = new ArrayList<RolapSchemaParameter>();
    private Date schemaLoadDate;
    private DataSourceChangeListener dataSourceChangeListener;
    private RolapStarRegistry rolapStarRegistry = new RolapStarRegistry();
    final RolapNativeRegistry nativeRegistry = new RolapNativeRegistry();
    private int nextDimensionOrdinal = 1;

    private RolapSchema(String key, Util.PropertyList connectInfo, DataSource dataSource, String md5Bytes) {
        this.key = key;
        this.md5Bytes = md5Bytes;
        this.defaultRole = this.createDefaultRole();
        this.internalConnection = new RolapConnection(connectInfo, this, dataSource);
        this.mapSharedHierarchyNameToHierarchy = new HashMap<String, RolapHierarchy>();
        this.mapSharedHierarchyToReader = new HashMap<String, MemberReader>();
        this.mapNameToCube = new HashMap<String, RolapCube>();
        this.mapNameToRole = new HashMap<String, Role>();
        this.aggTableManager = new AggTableManager(this);
        this.dataSourceChangeListener = this.createDataSourceChangeListener(connectInfo);
    }

    private RolapSchema(String key, String md5Bytes, String catalogUrl, String catalogStr, Util.PropertyList connectInfo, DataSource dataSource) {
        this(key, connectInfo, dataSource, md5Bytes);
        this.load(catalogUrl, catalogStr);
    }

    private RolapSchema(String key, String catalogUrl, Util.PropertyList connectInfo, DataSource dataSource) {
        this(key, connectInfo, dataSource, null);
        this.load(catalogUrl, null);
    }

    protected void finalCleanUp() {
        if (this.aggTableManager != null) {
            this.aggTableManager.finalCleanUp();
            this.aggTableManager = null;
        }
    }

    protected void finalize() throws Throwable {
        this.finalCleanUp();
    }

    public boolean equals(Object o) {
        if (!(o instanceof RolapSchema)) {
            return false;
        }
        RolapSchema other = (RolapSchema)o;
        return other.key.equals(this.key);
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    protected Logger getLogger() {
        return LOGGER;
    }

    protected void load(String catalogUrl, String catalogStr) {
        try {
            DOMWrapper def;
            Parser xmlParser = XOMUtil.createDefaultParser();
            if (catalogStr == null) {
                File userDir;
                FileObject file;
                FileSystemManager fsManager = VFS.getManager();
                if (fsManager == null) {
                    throw Util.newError("Cannot get virtual file system manager");
                }
                if (catalogUrl.startsWith("file://localhost")) {
                    catalogUrl = catalogUrl.substring("file://localhost".length());
                }
                if (catalogUrl.startsWith("file:")) {
                    catalogUrl = catalogUrl.substring("file:".length());
                }
                if (!(file = fsManager.resolveFile(userDir = new File("").getAbsoluteFile(), catalogUrl)).isReadable()) {
                    throw Util.newError("Virtual file is not readable: " + catalogUrl);
                }
                FileContent fileContent = file.getContent();
                if (fileContent == null) {
                    throw Util.newError("Cannot get virtual file content: " + catalogUrl);
                }
                def = xmlParser.parse(fileContent.getInputStream());
            } else {
                def = xmlParser.parse(catalogStr);
            }
            this.xmlSchema = new MondrianDef.Schema(def);
            if (this.getLogger().isDebugEnabled()) {
                StringWriter sw = new StringWriter(4096);
                PrintWriter pw = new PrintWriter(sw);
                pw.println("RolapSchema.load: dump xmlschema");
                this.xmlSchema.display(pw, 2);
                pw.flush();
                this.getLogger().debug((Object)sw.toString());
            }
            this.load(this.xmlSchema);
        }
        catch (XOMException e) {
            throw Util.newError(e, "while parsing catalog " + catalogUrl);
        }
        catch (FileSystemException e) {
            throw Util.newError(e, "while parsing catalog " + catalogUrl);
        }
        this.aggTableManager.initialize();
        this.setSchemaLoadDate();
    }

    private void setSchemaLoadDate() {
        this.schemaLoadDate = new Date();
    }

    public Date getSchemaLoadDate() {
        return this.schemaLoadDate;
    }

    Role getDefaultRole() {
        return this.defaultRole;
    }

    MondrianDef.Schema getXMLSchema() {
        return this.xmlSchema;
    }

    @Override
    public String getName() {
        Util.assertPostcondition(this.name != null, "return != null");
        Util.assertPostcondition(this.name.length() > 0, "return.length() > 0");
        return this.name;
    }

    public SqlQuery.Dialect getDialect() {
        DataSource dataSource = this.getInternalConnection().getDataSource();
        return SqlQuery.Dialect.create(dataSource);
    }

    private void load(MondrianDef.Schema xmlSchema) {
        RolapCube cube;
        this.name = xmlSchema.name;
        if (this.name == null || this.name.equals("")) {
            throw Util.newError("<Schema> name must be set");
        }
        HashMap<String, UserDefinedFunction> mapNameToUdf = new HashMap<String, UserDefinedFunction>();
        for (MondrianDef.UserDefinedFunction udf : xmlSchema.userDefinedFunctions) {
            this.defineFunction(mapNameToUdf, udf.name, udf.className);
        }
        RolapSchemaFunctionTable funTable = new RolapSchemaFunctionTable(mapNameToUdf.values());
        funTable.init();
        this.funTable = funTable;
        for (MondrianDef.Dimension xmlDimension : xmlSchema.dimensions) {
            if (xmlDimension.foreignKey == null) continue;
            throw MondrianResource.instance().PublicDimensionMustNotHaveForeignKey.ex(xmlDimension.name);
        }
        HashSet<String> parameterNames = new HashSet<String>();
        for (MondrianDef.Parameter parameter : xmlSchema.parameters) {
            String name = parameter.name;
            if (!parameterNames.add(name)) {
                throw MondrianResource.instance().DuplicateSchemaParameter.ex(name);
            }
            Type type = parameter.type.equals("String") ? new StringType() : (parameter.type.equals("Numeric") ? new NumericType() : new MemberType(null, null, null, null));
            String description = parameter.description;
            boolean modifiable = parameter.modifiable;
            String defaultValue = parameter.defaultValue;
            RolapSchemaParameter param = new RolapSchemaParameter(this, name, defaultValue, description, type, modifiable);
            Util.discard((Object)param);
        }
        for (ElementDef elementDef : xmlSchema.cubes) {
            if (!elementDef.isEnabled()) continue;
            cube = new RolapCube(this, xmlSchema, (MondrianDef.Cube)elementDef, true);
            cube.validate();
        }
        for (ElementDef elementDef : xmlSchema.virtualCubes) {
            if (!elementDef.isEnabled()) continue;
            cube = new RolapCube(this, xmlSchema, (MondrianDef.VirtualCube)elementDef, true);
            Util.discard((Object)cube);
        }
        for (ElementDef elementDef : xmlSchema.namedSets) {
            this.mapNameToSet.put(elementDef.name, this.createNamedSet((MondrianDef.NamedSet)elementDef));
        }
        for (ElementDef elementDef : xmlSchema.roles) {
            Role role = this.createRole((MondrianDef.Role)elementDef);
            this.mapNameToRole.put(elementDef.name, role);
        }
        if (xmlSchema.defaultRole != null) {
            Role role = this.lookupRole(xmlSchema.defaultRole);
            if (role == null) {
                throw Util.newError("Role '" + xmlSchema.defaultRole + "' not found");
            }
            this.defaultRole = role;
        }
    }

    private NamedSet createNamedSet(MondrianDef.NamedSet xmlNamedSet) {
        Exp exp;
        String formulaString = xmlNamedSet.getFormula();
        try {
            exp = this.getInternalConnection().parseExpression(formulaString);
        }
        catch (Exception e) {
            throw MondrianResource.instance().NamedSetHasBadFormula.ex(xmlNamedSet.name, e);
        }
        Formula formula = new Formula(new String[]{xmlNamedSet.name}, exp);
        return formula.getNamedSet();
    }

    private Role createRole(MondrianDef.Role xmlRole) {
        Role role = new Role();
        for (MondrianDef.SchemaGrant schemaGrant : xmlRole.schemaGrants) {
            role.grant(this, this.getAccess(schemaGrant.access, schemaAllowed));
            for (MondrianDef.CubeGrant cubeGrant : schemaGrant.cubeGrants) {
                RolapCube cube = this.lookupCube(cubeGrant.cube);
                if (cube == null) {
                    throw Util.newError("Unknown cube '" + cube + "'");
                }
                role.grant(cube, this.getAccess(cubeGrant.access, cubeAllowed));
                SchemaReader schemaReader = cube.getSchemaReader(null);
                for (MondrianDef.DimensionGrant dimensionGrant : cubeGrant.dimensionGrants) {
                    Dimension dimension = (Dimension)schemaReader.lookupCompound(cube, Util.explode(dimensionGrant.dimension), true, 2);
                    role.grant(dimension, this.getAccess(dimensionGrant.access, dimensionAllowed));
                }
                for (MondrianDef.Grant grant : cubeGrant.hierarchyGrants) {
                    Hierarchy hierarchy = (Hierarchy)schemaReader.lookupCompound(cube, Util.explode(((MondrianDef.HierarchyGrant)grant).hierarchy), true, 3);
                    Access hierarchyAccess = this.getAccess(((MondrianDef.HierarchyGrant)grant).access, hierarchyAllowed);
                    Level topLevel = null;
                    if (((MondrianDef.HierarchyGrant)grant).topLevel != null) {
                        if (hierarchyAccess != Access.CUSTOM) {
                            throw Util.newError("You may only specify 'topLevel' if access='custom'");
                        }
                        topLevel = (Level)schemaReader.lookupCompound(cube, Util.explode(((MondrianDef.HierarchyGrant)grant).topLevel), true, 4);
                    }
                    Level bottomLevel = null;
                    if (((MondrianDef.HierarchyGrant)grant).bottomLevel != null) {
                        if (hierarchyAccess != Access.CUSTOM) {
                            throw Util.newError("You may only specify 'bottomLevel' if access='custom'");
                        }
                        bottomLevel = (Level)schemaReader.lookupCompound(cube, Util.explode(((MondrianDef.HierarchyGrant)grant).bottomLevel), true, 4);
                    }
                    role.grant(hierarchy, hierarchyAccess, topLevel, bottomLevel);
                    for (MondrianDef.MemberGrant memberGrant : ((MondrianDef.HierarchyGrant)grant).memberGrants) {
                        if (hierarchyAccess != Access.CUSTOM) {
                            throw Util.newError("You may only specify <MemberGrant> if <Hierarchy> has access='custom'");
                        }
                        Member member = schemaReader.getMemberByUniqueName(Util.explode(memberGrant.member), true);
                        if (member.getHierarchy() != hierarchy) {
                            throw Util.newError("Member '" + member + "' is not in hierarchy '" + hierarchy + "'");
                        }
                        role.grant(member, this.getAccess(memberGrant.access, memberAllowed));
                    }
                }
            }
        }
        role.makeImmutable();
        return role;
    }

    private Access getAccess(String accessString, Set<Access> allowed) {
        Access access = Access.valueOf(accessString.toUpperCase());
        if (allowed.contains((Object)access)) {
            return access;
        }
        throw Util.newError("Bad value access='" + accessString + "'");
    }

    @Override
    public Dimension createDimension(Cube cube, String xml) {
        MondrianDef.CubeDimension xmlDimension;
        block4: {
            try {
                Parser xmlParser = XOMUtil.createDefaultParser();
                DOMWrapper def = xmlParser.parse(xml);
                String tagName = def.getTagName();
                if (tagName.equals("Dimension")) {
                    xmlDimension = new MondrianDef.Dimension(def);
                    break block4;
                }
                if (tagName.equals("DimensionUsage")) {
                    xmlDimension = new MondrianDef.DimensionUsage(def);
                    break block4;
                }
                throw new XOMException("Got <" + tagName + "> when expecting <Dimension> or <DimensionUsage>");
            }
            catch (XOMException e) {
                throw Util.newError(e, "Error while adding dimension to cube '" + cube + "' from XML [" + xml + "]");
            }
        }
        return ((RolapCube)cube).createDimension(xmlDimension);
    }

    @Override
    public Cube createCube(String xml) {
        RolapCube cube;
        block4: {
            try {
                Parser xmlParser = XOMUtil.createDefaultParser();
                DOMWrapper def = xmlParser.parse(xml);
                String tagName = def.getTagName();
                if (tagName.equals("Cube")) {
                    MondrianDef.Schema xmlSchema = new MondrianDef.Schema();
                    MondrianDef.Cube xmlDimension = new MondrianDef.Cube(def);
                    cube = new RolapCube(this, xmlSchema, xmlDimension, false);
                    break block4;
                }
                if (tagName.equals("VirtualCube")) {
                    MondrianDef.Schema xmlSchema = this.getXMLSchema();
                    MondrianDef.VirtualCube xmlDimension = new MondrianDef.VirtualCube(def);
                    cube = new RolapCube(this, xmlSchema, xmlDimension, false);
                    break block4;
                }
                throw new XOMException("Got <" + tagName + "> when expecting <Cube>");
            }
            catch (XOMException e) {
                throw Util.newError(e, "Error while creating cube from XML [" + xml + "]");
            }
        }
        return cube;
    }

    public static void flushSchema(String catalogUrl, String connectionKey, String jdbcUser, String dataSourceStr) {
        Pool.instance().remove(catalogUrl, connectionKey, jdbcUser, dataSourceStr);
    }

    public static void flushSchema(String catalogUrl, DataSource dataSource) {
        Pool.instance().remove(catalogUrl, dataSource);
    }

    public static void clearCache() {
        Pool.instance().clear();
    }

    public static Iterator<RolapSchema> getRolapSchemas() {
        return Pool.instance().getRolapSchemas();
    }

    public static boolean cacheContains(RolapSchema rolapSchema) {
        return Pool.instance().contains(rolapSchema);
    }

    @Override
    public Cube lookupCube(String cube, boolean failIfNotFound) {
        RolapCube mdxCube = this.lookupCube(cube);
        if (mdxCube == null && failIfNotFound) {
            throw MondrianResource.instance().MdxCubeNotFound.ex(cube);
        }
        return mdxCube;
    }

    protected RolapCube lookupCube(String cubeName) {
        return this.mapNameToCube.get(Util.normalizeName(cubeName));
    }

    protected MondrianDef.CalculatedMember lookupXmlCalculatedMember(String calcMemberName, String cubeName) {
        String[] nameParts = Util.explode(calcMemberName);
        for (MondrianDef.Cube cube : this.xmlSchema.cubes) {
            if (!Util.equalName(cube.name, cubeName)) continue;
            for (MondrianDef.CalculatedMember calculatedMember : cube.calculatedMembers) {
                if (!Util.equalName(calculatedMember.dimension, nameParts[0]) || !Util.equalName(calculatedMember.name, nameParts[nameParts.length - 1])) continue;
                return calculatedMember;
            }
        }
        return null;
    }

    public List<RolapCube> getCubesWithStar(RolapStar star) {
        ArrayList<RolapCube> list = new ArrayList<RolapCube>();
        for (RolapCube cube : this.mapNameToCube.values()) {
            if (star != cube.getStar()) continue;
            list.add(cube);
        }
        return list;
    }

    protected void addCube(RolapCube cube) {
        this.mapNameToCube.put(Util.normalizeName(cube.getName()), cube);
    }

    @Override
    public boolean removeCube(String cubeName) {
        RolapCube cube = this.mapNameToCube.remove(Util.normalizeName(cubeName));
        return cube != null;
    }

    @Override
    public Cube[] getCubes() {
        Collection<RolapCube> cubes = this.mapNameToCube.values();
        return cubes.toArray(new RolapCube[cubes.size()]);
    }

    public List<RolapCube> getCubeList() {
        return new ArrayList<RolapCube>(this.mapNameToCube.values());
    }

    @Override
    public Hierarchy[] getSharedHierarchies() {
        Collection<RolapHierarchy> hierarchies = this.mapSharedHierarchyNameToHierarchy.values();
        return hierarchies.toArray(new RolapHierarchy[hierarchies.size()]);
    }

    RolapHierarchy getSharedHierarchy(String name) {
        return this.mapSharedHierarchyNameToHierarchy.get(name);
    }

    public NamedSet getNamedSet(String name) {
        return this.mapNameToSet.get(name);
    }

    @Override
    public Role lookupRole(String role) {
        return this.mapNameToRole.get(role);
    }

    public Set<String> roleNames() {
        return this.mapNameToRole.keySet();
    }

    @Override
    public FunTable getFunTable() {
        return this.funTable;
    }

    @Override
    public Parameter[] getParameters() {
        return this.parameterList.toArray(new Parameter[this.parameterList.size()]);
    }

    private void defineFunction(Map<String, UserDefinedFunction> mapNameToUdf, String name, String className) {
        UserDefinedFunction udf;
        Constructor<?> constructor;
        Class<?> klass;
        try {
            klass = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw MondrianResource.instance().UdfClassNotFound.ex(name, className);
        }
        Object[] args = new Object[]{};
        try {
            constructor = klass.getConstructor(String.class);
            if (Modifier.isPublic(constructor.getModifiers())) {
                args = new Object[]{name};
            } else {
                constructor = null;
            }
        }
        catch (NoSuchMethodException e) {
            constructor = null;
        }
        if (constructor == null) {
            try {
                constructor = klass.getConstructor(new Class[0]);
                if (Modifier.isPublic(constructor.getModifiers())) {
                    args = new Object[]{};
                } else {
                    constructor = null;
                }
            }
            catch (NoSuchMethodException e) {
                constructor = null;
            }
        }
        if (constructor == null) {
            throw MondrianResource.instance().UdfClassWrongIface.ex(name, className, UserDefinedFunction.class.getName());
        }
        try {
            udf = (UserDefinedFunction)constructor.newInstance(args);
        }
        catch (InstantiationException e) {
            throw MondrianResource.instance().UdfClassWrongIface.ex(name, className, UserDefinedFunction.class.getName());
        }
        catch (IllegalAccessException e) {
            throw MondrianResource.instance().UdfClassWrongIface.ex(name, className, UserDefinedFunction.class.getName());
        }
        catch (ClassCastException e) {
            throw MondrianResource.instance().UdfClassWrongIface.ex(name, className, UserDefinedFunction.class.getName());
        }
        catch (InvocationTargetException e) {
            throw MondrianResource.instance().UdfClassWrongIface.ex(name, className, UserDefinedFunction.class.getName());
        }
        this.validateFunction(udf);
        UserDefinedFunction existingUdf = mapNameToUdf.get(name);
        if (existingUdf != null) {
            throw MondrianResource.instance().UdfDuplicateName.ex(name);
        }
        mapNameToUdf.put(name, udf);
    }

    private void validateFunction(UserDefinedFunction udf) {
        String udfName = udf.getName();
        if (udfName == null || udfName.equals("")) {
            throw Util.newInternal("User-defined function defined by class '" + udf.getClass() + "' has empty name");
        }
        String description = udf.getDescription();
        Util.discard((Object)description);
        Type[] parameterTypes = udf.getParameterTypes();
        for (int i = 0; i < parameterTypes.length; ++i) {
            Type parameterType = parameterTypes[i];
            if (parameterType != null) continue;
            throw Util.newInternal("Invalid user-defined function '" + udfName + "': parameter type #" + i + " is null");
        }
        String[] reservedWords = udf.getReservedWords();
        Util.discard((Object)reservedWords);
        Type returnType = udf.getReturnType(parameterTypes);
        if (returnType == null) {
            throw Util.newInternal("Invalid user-defined function '" + udfName + "': return type is null");
        }
        Syntax syntax = udf.getSyntax();
        if (syntax == null) {
            throw Util.newInternal("Invalid user-defined function '" + udfName + "': syntax is null");
        }
    }

    synchronized MemberReader createMemberReader(String sharedName, RolapHierarchy hierarchy, String memberReaderClass) {
        MemberReader reader;
        if (sharedName != null) {
            reader = this.mapSharedHierarchyToReader.get(sharedName);
            if (reader == null) {
                reader = this.createMemberReader(hierarchy, memberReaderClass);
                if (!this.mapSharedHierarchyNameToHierarchy.containsKey(sharedName)) {
                    this.mapSharedHierarchyNameToHierarchy.put(sharedName, hierarchy);
                }
            }
        } else {
            reader = this.createMemberReader(hierarchy, memberReaderClass);
        }
        return reader;
    }

    private MemberReader createMemberReader(RolapHierarchy hierarchy, String memberReaderClass) {
        if (memberReaderClass != null) {
            ReflectiveOperationException e2;
            try {
                Object properties = null;
                Class<?> clazz = Class.forName(memberReaderClass);
                Constructor<?> constructor = clazz.getConstructor(RolapHierarchy.class, Properties.class);
                Object o = constructor.newInstance(hierarchy, properties);
                if (o instanceof MemberReader) {
                    return (MemberReader)o;
                }
                if (o instanceof MemberSource) {
                    return new CacheMemberReader((MemberSource)o);
                }
                throw Util.newInternal("member reader class " + clazz + " does not implement " + MemberSource.class);
            }
            catch (ClassNotFoundException e) {
                e2 = e;
            }
            catch (NoSuchMethodException e) {
                e2 = e;
            }
            catch (InstantiationException e) {
                e2 = e;
            }
            catch (IllegalAccessException e) {
                e2 = e;
            }
            catch (InvocationTargetException e) {
                e2 = e;
            }
            throw Util.newInternal(e2, "while instantiating member reader '" + memberReaderClass);
        }
        SqlMemberSource source = new SqlMemberSource(hierarchy);
        int memberCount = Integer.MAX_VALUE;
        int largeDimensionThreshold = MondrianProperties.instance().LargeDimensionThreshold.get();
        return memberCount > largeDimensionThreshold ? new SmartMemberReader(source) : new CacheMemberReader(source);
    }

    @Override
    public SchemaReader getSchemaReader() {
        return new RolapSchemaReader(this.defaultRole, this){

            public Cube getCube() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private DataSourceChangeListener createDataSourceChangeListener(Util.PropertyList connectInfo) {
        DataSourceChangeListener changeListener = null;
        String dataSourceChangeListenerStr = connectInfo.get(RolapConnectionProperties.DataSourceChangeListener.name());
        if (!Util.isEmpty(dataSourceChangeListenerStr)) {
            try {
                Class<?> clazz = Class.forName(dataSourceChangeListenerStr);
                Constructor<?> constructor = clazz.getConstructor(new Class[0]);
                changeListener = (DataSourceChangeListener)constructor.newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw Util.newError(e, "loading DataSourceChangeListener " + dataSourceChangeListenerStr);
            }
            if (LOGGER.isDebugEnabled()) {
                String msg = "RolapSchema.createDataSourceChangeListener: create datasource change listener \"" + dataSourceChangeListenerStr;
                LOGGER.debug((Object)msg);
            }
        }
        return changeListener;
    }

    public RolapConnection getInternalConnection() {
        return this.internalConnection;
    }

    private Role createDefaultRole() {
        Role role = new Role();
        role.grant(this, Access.ALL);
        role.makeImmutable();
        return role;
    }

    private RolapStar makeRolapStar(MondrianDef.Relation fact) {
        DataSource dataSource = this.getInternalConnection().getDataSource();
        return new RolapStar(this, dataSource, fact);
    }

    public RolapStarRegistry getRolapStarRegistry() {
        return this.rolapStarRegistry;
    }

    public RolapStar getStar(String factTableName) {
        return this.getRolapStarRegistry().getStar(factTableName);
    }

    public Collection<RolapStar> getStars() {
        return this.getRolapStarRegistry().getStars();
    }

    public void flushRolapStarCaches(boolean forced) {
        for (RolapStar star : this.getStars()) {
            star.clearCachedAggregations(forced);
        }
    }

    public void checkAggregateModifications() {
        for (RolapStar star : this.getStars()) {
            star.checkAggregateModifications();
        }
    }

    public void pushAggregateModificationsToGlobalCache() {
        for (RolapStar star : this.getStars()) {
            star.pushAggregateModificationsToGlobalCache();
        }
    }

    public static void flushAllRolapStarCachedAggregations() {
        Iterator<RolapSchema> itSchemas = RolapSchema.getRolapSchemas();
        while (itSchemas.hasNext()) {
            RolapSchema schema = itSchemas.next();
            schema.flushRolapStarCaches(true);
        }
    }

    RolapNativeRegistry getNativeRegistry() {
        return this.nativeRegistry;
    }

    @Override
    public synchronized int getNextDimensionOrdinal() {
        return this.nextDimensionOrdinal++;
    }

    public DataSourceChangeListener getDataSourceChangeListener() {
        return this.dataSourceChangeListener;
    }

    public void setDataSourceChangeListener(DataSourceChangeListener dataSourceChangeListener) {
        this.dataSourceChangeListener = dataSourceChangeListener;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class RolapSchemaFunctionTable
    extends FunTableImpl {
        private final List<UserDefinedFunction> udfList;

        RolapSchemaFunctionTable(Collection<UserDefinedFunction> udfs) {
            this.udfList = new ArrayList<UserDefinedFunction>(udfs);
        }

        @Override
        protected void defineFunctions() {
            GlobalFunTable globalFunTable = GlobalFunTable.instance();
            for (String reservedWord : globalFunTable.getReservedWords()) {
                this.defineReserved(reservedWord);
            }
            for (Resolver resolver : globalFunTable.getResolvers()) {
                this.define(resolver);
            }
            for (UserDefinedFunction udf : this.udfList) {
                this.define(new UdfResolver(udf));
            }
        }

        @Override
        public List<FunInfo> getFunInfoList() {
            return Collections.unmodifiableList(this.funInfoList);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class RolapStarRegistry {
        private final Map<String, RolapStar> stars = new HashMap<String, RolapStar>();

        RolapStarRegistry() {
        }

        synchronized RolapStar getOrCreateStar(MondrianDef.Relation fact) {
            String factTableName = fact.toString();
            RolapStar star = this.stars.get(factTableName);
            if (star == null) {
                star = RolapSchema.this.makeRolapStar(fact);
                this.stars.put(factTableName, star);
            }
            return star;
        }

        synchronized RolapStar getStar(String factTableName) {
            return this.stars.get(factTableName);
        }

        synchronized Collection<RolapStar> getStars() {
            return this.stars.values();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Pool {
        private final MessageDigest md;
        private static Pool pool = new Pool();
        private Map<String, SoftReference<RolapSchema>> mapUrlToSchema = new HashMap<String, SoftReference<RolapSchema>>();

        private Pool() {
            try {
                this.md = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
        }

        static Pool instance() {
            return pool;
        }

        private synchronized String encodeMD5(String value) {
            this.md.reset();
            byte[] bytes = this.md.digest(value.getBytes());
            return bytes != null ? new String(bytes) : null;
        }

        synchronized RolapSchema get(String catalogUrl, String connectionKey, String jdbcUser, String dataSourceStr, Util.PropertyList connectInfo) {
            return this.get(catalogUrl, connectionKey, jdbcUser, dataSourceStr, null, connectInfo);
        }

        synchronized RolapSchema get(String catalogUrl, DataSource dataSource, Util.PropertyList connectInfo) {
            return this.get(catalogUrl, null, null, null, dataSource, connectInfo);
        }

        private RolapSchema get(String catalogUrl, String connectionKey, String jdbcUser, String dataSourceStr, DataSource dataSource, Util.PropertyList connectInfo) {
            String msg;
            boolean useContentChecksum;
            String key = dataSource == null ? Pool.makeKey(catalogUrl, connectionKey, jdbcUser, dataSourceStr) : Pool.makeKey(catalogUrl, dataSource);
            RolapSchema schema = null;
            boolean hadDynProc = false;
            String dynProcName = connectInfo.get(RolapConnectionProperties.DynamicSchemaProcessor.name());
            String catalogStr = connectInfo.get(RolapConnectionProperties.CatalogContent.name());
            if (catalogStr != null) {
                dynProcName = null;
                key = catalogStr;
            }
            if (!Util.isEmpty(dynProcName)) {
                assert (catalogStr == null);
                try {
                    URL url = new URL(catalogUrl);
                    Class<?> clazz = Class.forName(dynProcName);
                    Constructor<?> ctor = clazz.getConstructor(new Class[0]);
                    DynamicSchemaProcessor dynProc = (DynamicSchemaProcessor)ctor.newInstance(new Object[0]);
                    catalogStr = dynProc.processSchema(url, connectInfo);
                    hadDynProc = true;
                }
                catch (Exception e) {
                    throw Util.newError(e, "loading DynamicSchemaProcessor " + dynProcName);
                }
                if (LOGGER.isDebugEnabled()) {
                    String msg2 = "Pool.get: create schema \"" + catalogUrl + "\" using dynamic processor";
                    LOGGER.debug((Object)msg2);
                }
            }
            if (useContentChecksum = Boolean.parseBoolean(connectInfo.get(RolapConnectionProperties.UseContentChecksum.name()))) {
                SoftReference<RolapSchema> ref;
                String md5Bytes = null;
                try {
                    if (catalogStr == null) {
                        catalogStr = Util.readURL(catalogUrl);
                    }
                    md5Bytes = this.encodeMD5(catalogStr);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                if (md5Bytes != null && (ref = this.mapUrlToSchema.get(md5Bytes)) != null && (schema = ref.get()) == null) {
                    this.mapUrlToSchema.remove(key);
                    this.mapUrlToSchema.remove(md5Bytes);
                }
                if (schema == null || md5Bytes == null || schema.md5Bytes == null || !schema.md5Bytes.equals(md5Bytes)) {
                    schema = new RolapSchema(key, md5Bytes, catalogUrl, catalogStr, connectInfo, dataSource);
                    ref = new SoftReference<RolapSchema>(schema);
                    if (md5Bytes != null) {
                        this.mapUrlToSchema.put(md5Bytes, ref);
                    }
                    this.mapUrlToSchema.put(key, ref);
                    if (LOGGER.isDebugEnabled()) {
                        String msg3 = "Pool.get: create schema \"" + catalogUrl + "\" with MD5";
                        LOGGER.debug((Object)msg3);
                    }
                } else if (LOGGER.isDebugEnabled()) {
                    msg = "Pool.get: schema \"" + catalogUrl + "\" exists already with MD5";
                    LOGGER.debug((Object)msg);
                }
            } else if (hadDynProc) {
                schema = new RolapSchema(key, null, catalogUrl, catalogStr, connectInfo, dataSource);
            } else {
                SoftReference<RolapSchema> ref = this.mapUrlToSchema.get(key);
                if (ref != null && (schema = ref.get()) == null) {
                    this.mapUrlToSchema.remove(key);
                }
                if (schema == null) {
                    schema = catalogStr == null ? new RolapSchema(key, catalogUrl, connectInfo, dataSource) : new RolapSchema(key, null, catalogUrl, catalogStr, connectInfo, dataSource);
                    this.mapUrlToSchema.put(key, new SoftReference<RolapSchema>(schema));
                    if (LOGGER.isDebugEnabled()) {
                        msg = "Pool.get: create schema \"" + catalogUrl + "\"";
                        LOGGER.debug((Object)msg);
                    }
                } else if (LOGGER.isDebugEnabled()) {
                    msg = "Pool.get: schema \"" + catalogUrl + "\" exists already ";
                    LOGGER.debug((Object)msg);
                }
            }
            return schema;
        }

        synchronized void remove(String catalogUrl, String connectionKey, String jdbcUser, String dataSourceStr) {
            String key = Pool.makeKey(catalogUrl, connectionKey, jdbcUser, dataSourceStr);
            if (LOGGER.isDebugEnabled()) {
                String msg = "Pool.remove: schema \"" + catalogUrl + "\" and datasource string \"" + dataSourceStr + "\"";
                LOGGER.debug((Object)msg);
            }
            this.remove(key);
        }

        synchronized void remove(String catalogUrl, DataSource dataSource) {
            String key = Pool.makeKey(catalogUrl, dataSource);
            if (LOGGER.isDebugEnabled()) {
                String msg = "Pool.remove: schema \"" + catalogUrl + "\" and datasource object";
                LOGGER.debug((Object)msg);
            }
            this.remove(key);
        }

        private void remove(String key) {
            RolapSchema schema;
            SoftReference<RolapSchema> ref = this.mapUrlToSchema.get(key);
            if (ref != null && (schema = ref.get()) != null) {
                if (schema.md5Bytes != null) {
                    this.mapUrlToSchema.remove(schema.md5Bytes);
                }
                schema.finalCleanUp();
            }
            this.mapUrlToSchema.remove(key);
        }

        synchronized void clear() {
            if (LOGGER.isDebugEnabled()) {
                String msg = "Pool.clear: clearing all RolapSchemas";
                LOGGER.debug((Object)msg);
            }
            for (SoftReference<RolapSchema> ref : this.mapUrlToSchema.values()) {
                RolapSchema schema;
                if (ref == null || (schema = ref.get()) == null) continue;
                schema.finalCleanUp();
            }
            this.mapUrlToSchema.clear();
            JdbcSchema.clearAllDBs();
        }

        synchronized Iterator<RolapSchema> getRolapSchemas() {
            ArrayList<RolapSchema> list = new ArrayList<RolapSchema>();
            Iterator<SoftReference<RolapSchema>> it = this.mapUrlToSchema.values().iterator();
            while (it.hasNext()) {
                SoftReference<RolapSchema> ref = it.next();
                RolapSchema schema = ref.get();
                if (schema != null) {
                    list.add(schema);
                    continue;
                }
                try {
                    it.remove();
                }
                catch (Exception ex) {
                    LOGGER.warn((Object)ex);
                }
            }
            return list.iterator();
        }

        synchronized boolean contains(RolapSchema rolapSchema) {
            return this.mapUrlToSchema.containsKey(rolapSchema.key);
        }

        private static String makeKey(String catalogUrl, String connectionKey, String jdbcUser, String dataSourceStr) {
            StringBuilder buf = new StringBuilder(100);
            Pool.appendIfNotNull(buf, catalogUrl);
            Pool.appendIfNotNull(buf, connectionKey);
            Pool.appendIfNotNull(buf, jdbcUser);
            Pool.appendIfNotNull(buf, dataSourceStr);
            String key = buf.toString();
            return key;
        }

        private static String makeKey(String catalogUrl, DataSource dataSource) {
            StringBuilder buf = new StringBuilder(100);
            Pool.appendIfNotNull(buf, catalogUrl);
            buf.append('.');
            buf.append("external#");
            buf.append(System.identityHashCode(dataSource));
            String key = buf.toString();
            return key;
        }

        private static void appendIfNotNull(StringBuilder buf, String s) {
            if (s != null) {
                if (buf.length() > 0) {
                    buf.append('.');
                }
                buf.append(s);
            }
        }
    }
}

