/*
 * JDBCConnectionEditor.java
 *
 * Created on March 27, 2007, 10:35 AM
 */

package com.jaspersoft.ireport.designer.connection.gui;

import com.jaspersoft.ireport.designer.IReportConnection;
import com.jaspersoft.ireport.designer.connection.JDBCNBConnection;
import com.jaspersoft.ireport.designer.IReportConnectionEditor;
import com.jaspersoft.ireport.designer.sheet.Tag;
import com.jaspersoft.ireport.designer.utils.Misc;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;

/**
 *
 * @author  gtoffoli
 */
public class JDBCNBConnectionEditor extends javax.swing.JPanel implements IReportConnectionEditor {
    
    private IReportConnection iReportConnection = null;
    /** Creates new form JDBCConnectionEditor */
    public JDBCNBConnectionEditor() {
        initComponents();
        //applyI18n();
         
        DatabaseConnection[] connections = ConnectionManager.getDefault().getConnections();
        
        Vector items = new Vector();
        for (int i=0; i<connections.length; ++i)
        {
            Tag tag = new Tag(connections[i].getName(), connections[i].getDisplayName());
            items.add(tag);
        }
        
        jComboBoxJDBCDriver.setModel(new DefaultComboBoxModel(items));
        if (items.size() > 0)
        {
            jComboBoxJDBCDriver.setSelectedIndex(0);
        }
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jPanelJDBC = new javax.swing.JPanel();
        jLabel2 = new javax.swing.JLabel();
        jComboBoxJDBCDriver = new javax.swing.JComboBox();

        setLayout(new java.awt.BorderLayout());

        jPanelJDBC.setLayout(new java.awt.GridBagLayout());

        jLabel2.setText("Connection");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(4, 6, 0, 0);
        jPanelJDBC.add(jLabel2, gridBagConstraints);

        jComboBoxJDBCDriver.setEditable(true);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(2, 6, 0, 6);
        jPanelJDBC.add(jComboBoxJDBCDriver, gridBagConstraints);

        add(jPanelJDBC, java.awt.BorderLayout.CENTER);
    }// </editor-fold>//GEN-END:initComponents

  
    /*
    public void applyI18n(){
                // Start autogenerated code ----------------------
                jCheckBoxSavePassword.setText(I18n.getString("connectionDialog.checkBoxSavePassword","Save password"));
                jButtonWizard.setText(I18n.getString("connectionDialog.buttonWizard","Wizard"));
                jLabel14.setText(I18n.getString("connectionDialog.label14","Server Address"));
                jLabel2.setText(I18n.getString("connectionDialog.label2","JDBC Driver"));
                jLabel3.setText(I18n.getString("connectionDialog.label3","JDBC URL"));
                jLabel5.setText(I18n.getString("connectionDialog.label5","Database"));
                jLabel6.setText(I18n.getString("connectionDialog.label6","Username"));
                jLabel7.setText(I18n.getString("connectionDialog.label7","Password"));
                
                ((javax.swing.border.TitledBorder)jPanel2.getBorder()).setTitle( it.businesslogic.ireport.util.I18n.getString("connectionDialog.panelBorder.jdbcUrlWizard","JDBC URL Wizard") );
                
                jLabel1.setText( "<html>" + I18n.getString("connectionDialog.textArea1","ATTENTION! Passwords are stored in clear text. If you dont specify a password now, iReport will ask you for one only when required and will not save it."));
                
    }
    */
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JComboBox jComboBoxJDBCDriver;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JPanel jPanelJDBC;
    // End of variables declaration//GEN-END:variables

    public void setIReportConnection(IReportConnection c) {
        
        if (c instanceof JDBCNBConnection)
        {
            Misc.setComboboxSelectedTagValue( jComboBoxJDBCDriver, ((JDBCNBConnection)c).getUrl() );
        }
        
    }

    public IReportConnection getIReportConnection() {
        
        if (jComboBoxJDBCDriver.getSelectedItem() == null) {
            javax.swing.JOptionPane.showMessageDialog(this,
                    "Please select a connection!", //"messages.connectionDialog.jdbc.invalidUrl"
                    "Invalid connection!", //"messages.connectionDialog.jdbc.invalidUrlCaption"
                    javax.swing.JOptionPane.WARNING_MESSAGE );
            return null;
        }
        
        if (jComboBoxJDBCDriver.getSelectedItem() != null &&
            jComboBoxJDBCDriver.getSelectedItem() instanceof Tag)
        {
            JDBCNBConnection c = new JDBCNBConnection();
            
            c.setUrl( ((Tag)jComboBoxJDBCDriver.getSelectedItem()).getValue()+"");
            
                    
            return c;
        }
        
        return null;
    }
    
}
