/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.oasis;

import java.io.IOException;
import java.io.Writer;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.export.oasis.Style;

public class ParagraphStyle
extends Style {
    protected static final String HORIZONTAL_ALIGN_LEFT = "start";
    protected static final String HORIZONTAL_ALIGN_RIGHT = "end";
    protected static final String HORIZONTAL_ALIGN_CENTER = "center";
    protected static final String HORIZONTAL_ALIGN_JUSTIFY = "justified";
    private static final String VERTICAL_ALIGN_TOP = "top";
    private static final String VERTICAL_ALIGN_MIDDLE = "middle";
    private static final String VERTICAL_ALIGN_BOTTOM = "bottom";
    protected static final String ROTATION_ALIGN_NONE = "none";
    protected static final String ROTATION_ALIGN_TOP = "top";
    protected static final String ROTATION_ALIGN_CENTER = "center";
    protected static final String ROTATION_ALIGN_BOTTOM = "bottom";
    private String verticalAlignment = null;
    private String horizontalAlignment = null;
    private String runDirection = null;
    private String textRotation = "0";

    public ParagraphStyle(Writer styleWriter, JRPrintText text) {
        super(styleWriter);
        switch (text.getRotation()) {
            case 1: {
                this.textRotation = "90";
                break;
            }
            case 2: {
                this.textRotation = "270";
                break;
            }
            default: {
                this.textRotation = "0";
            }
        }
        this.horizontalAlignment = HORIZONTAL_ALIGN_LEFT;
        this.verticalAlignment = "top";
        switch (text.getVerticalAlignment()) {
            case 3: {
                if ("270".equals(this.textRotation)) {
                    this.horizontalAlignment = HORIZONTAL_ALIGN_LEFT;
                    break;
                }
                if ("90".equals(this.textRotation)) {
                    this.horizontalAlignment = HORIZONTAL_ALIGN_RIGHT;
                    break;
                }
                this.verticalAlignment = "bottom";
                break;
            }
            case 2: {
                if ("270".equals(this.textRotation) || "90".equals(this.textRotation)) {
                    this.horizontalAlignment = "center";
                    break;
                }
                this.verticalAlignment = VERTICAL_ALIGN_MIDDLE;
                break;
            }
            default: {
                if ("270".equals(this.textRotation)) {
                    this.horizontalAlignment = HORIZONTAL_ALIGN_RIGHT;
                    break;
                }
                if ("90".equals(this.textRotation)) {
                    this.horizontalAlignment = HORIZONTAL_ALIGN_LEFT;
                    break;
                }
                this.verticalAlignment = "top";
            }
        }
        switch (text.getHorizontalAlignment()) {
            case 3: {
                if ("270".equals(this.textRotation)) {
                    this.verticalAlignment = "bottom";
                    break;
                }
                if ("90".equals(this.textRotation)) {
                    this.verticalAlignment = "top";
                    break;
                }
                this.horizontalAlignment = HORIZONTAL_ALIGN_RIGHT;
                break;
            }
            case 2: {
                if ("270".equals(this.textRotation) || "90".equals(this.textRotation)) {
                    this.verticalAlignment = VERTICAL_ALIGN_MIDDLE;
                    break;
                }
                this.horizontalAlignment = "center";
                break;
            }
            case 4: {
                this.horizontalAlignment = HORIZONTAL_ALIGN_JUSTIFY;
                break;
            }
            default: {
                if ("270".equals(this.textRotation)) {
                    this.verticalAlignment = "top";
                    break;
                }
                if ("90".equals(this.textRotation)) {
                    this.verticalAlignment = "bottom";
                    break;
                }
                this.horizontalAlignment = HORIZONTAL_ALIGN_LEFT;
            }
        }
        this.runDirection = null;
        if (text.getRunDirection() == 1) {
            this.runDirection = "rl";
        }
        switch (text.getRotation()) {
            case 1: {
                this.textRotation = "90";
                break;
            }
            case 2: {
                this.textRotation = "270";
            }
        }
    }

    public String getId() {
        return this.verticalAlignment + "|" + this.horizontalAlignment + "|" + this.runDirection + "|" + this.textRotation;
    }

    public void write(String paragraphStyleName) throws IOException {
        this.styleWriter.write("<style:style style:name=\"" + paragraphStyleName + "\"");
        this.styleWriter.write(" style:family=\"paragraph\">\n");
        this.styleWriter.write("<style:paragraph-properties");
        this.styleWriter.write(" fo:text-align=\"" + this.horizontalAlignment + "\"");
        this.styleWriter.write(" style:vertical-align=\"" + this.verticalAlignment + "\"");
        if (this.runDirection != null) {
            this.styleWriter.write(" style:writing-mode=\"" + this.runDirection + "\"");
        }
        this.styleWriter.write("> \r\n");
        this.styleWriter.write("</style:paragraph-properties>\n");
        this.styleWriter.write("<style:text-properties");
        this.styleWriter.write(" style:text-rotation-angle=\"" + this.textRotation + "\"");
        this.styleWriter.write("> \r\n");
        this.styleWriter.write("</style:text-properties>\n");
        this.styleWriter.write("</style:style>\n");
    }
}

