/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.design;

import [Ljava.lang.String;;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.design.JRAbstractMultiClassCompiler;
import net.sf.jasperreports.engine.util.JRClassLoader;

public class JRJdk12Compiler
extends JRAbstractMultiClassCompiler {
    public String compileClasses(File[] sourceFiles, String classpath) throws JRException {
        String[] source = new String[sourceFiles.length + 2];
        for (int i = 0; i < sourceFiles.length; ++i) {
            source[i] = sourceFiles[i].getPath();
        }
        source[sourceFiles.length] = "-classpath";
        source[sourceFiles.length + 1] = classpath;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            Class javacClass = JRClassLoader.loadClassForRealName("sun.tools.javac.Main");
            Constructor constructor = javacClass.getConstructor(OutputStream.class, String.class);
            Method compileMethod = javacClass.getMethod("compile", String;.class);
            Object javac = constructor.newInstance(baos, source[0]);
            compileMethod.invoke(javac, new Object[]{source});
        }
        catch (Exception e) {
            StringBuffer files = new StringBuffer();
            for (int i = 0; i < sourceFiles.length; ++i) {
                files.append(sourceFiles[i].getPath());
                files.append(' ');
            }
            throw new JRException("Error compiling report java source files : " + files, e);
        }
        if (baos.toString().indexOf("error") != -1) {
            return baos.toString();
        }
        return null;
    }
}

