/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.data;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import net.sf.jasperreports.engine.design.JRDesignField;
import net.sf.jasperreports.engine.util.JRDateLocaleConverter;
import net.sf.jasperreports.engine.util.JRXmlUtils;
import net.sf.jasperreports.engine.util.xml.JRXPathExecuter;
import net.sf.jasperreports.engine.util.xml.JRXPathExecuterUtils;
import org.apache.commons.beanutils.locale.LocaleConvertUtilsBean;
import org.apache.commons.beanutils.locale.LocaleConverter;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class JRXmlDataSource
implements JRRewindableDataSource {
    private Document document;
    private String selectExpression;
    private NodeList nodeList;
    private int nodeListLength;
    private Node currentNode;
    private int currentNodeIndex = -1;
    private final JRXPathExecuter xPathExecuter;
    private LocaleConvertUtilsBean convertBean = null;
    private Locale locale = null;
    private String datePattern = null;
    private String numberPattern = null;
    private TimeZone timeZone = null;

    public JRXmlDataSource(Document document) throws JRException {
        this(document, ".");
    }

    public JRXmlDataSource(Document document, String selectExpression) throws JRException {
        this.document = document;
        this.selectExpression = selectExpression;
        this.xPathExecuter = JRXPathExecuterUtils.getXPathExecuter();
        this.moveFirst();
    }

    public JRXmlDataSource(InputStream in) throws JRException {
        this(in, ".");
    }

    public JRXmlDataSource(InputStream in, String selectExpression) throws JRException {
        this(JRXmlUtils.parse(new InputSource(in)), selectExpression);
    }

    public JRXmlDataSource(String uri) throws JRException {
        this(uri, ".");
    }

    public JRXmlDataSource(String uri, String selectExpression) throws JRException {
        this(JRXmlUtils.parse(uri), selectExpression);
    }

    public JRXmlDataSource(File file) throws JRException {
        this(file, ".");
    }

    public JRXmlDataSource(File file, String selectExpression) throws JRException {
        this(JRXmlUtils.parse(file), selectExpression);
    }

    public void moveFirst() throws JRException {
        if (this.document == null) {
            throw new JRException("document cannot be null");
        }
        if (this.selectExpression == null) {
            throw new JRException("selectExpression cannot be null");
        }
        this.currentNode = null;
        this.currentNodeIndex = -1;
        this.nodeListLength = 0;
        this.nodeList = this.xPathExecuter.selectNodeList(this.document, this.selectExpression);
        this.nodeListLength = this.nodeList.getLength();
    }

    public boolean next() {
        if (this.currentNodeIndex == this.nodeListLength - 1) {
            return false;
        }
        this.currentNode = this.nodeList.item(++this.currentNodeIndex);
        return true;
    }

    public Object getFieldValue(JRField jrField) throws JRException {
        Object selectedObject;
        Class valueClass;
        if (this.currentNode == null) {
            return null;
        }
        String expression = jrField.getDescription();
        if (expression == null || expression.length() == 0) {
            return null;
        }
        Object value = null;
        if (Object.class != (valueClass = jrField.getValueClass()) && (selectedObject = this.xPathExecuter.selectObject(this.currentNode, expression)) != null) {
            if (selectedObject instanceof Node) {
                String text = this.getText((Node)selectedObject);
                value = this.convertStringValue(text, valueClass);
            } else if (selectedObject instanceof Boolean && valueClass.equals(Boolean.class)) {
                value = selectedObject;
            } else if (selectedObject instanceof Number && Number.class.isAssignableFrom(valueClass)) {
                value = this.convertNumber((Number)selectedObject, valueClass);
            } else {
                String text = selectedObject.toString();
                value = this.convertStringValue(text, valueClass);
            }
        }
        return value;
    }

    protected Object convertStringValue(String text, Class valueClass) {
        Object value = null;
        if (String.class.equals(valueClass)) {
            value = text;
        } else if (Number.class.isAssignableFrom(valueClass)) {
            value = this.getConvertBean().convert(text.trim(), valueClass, this.locale, this.numberPattern);
        } else if (Date.class.isAssignableFrom(valueClass)) {
            value = this.getConvertBean().convert(text.trim(), valueClass, this.locale, this.datePattern);
        } else if (Boolean.class.equals(valueClass)) {
            value = Boolean.valueOf(text);
        }
        return value;
    }

    protected Object convertNumber(Number number, Class valueClass) throws JRException {
        Number value = null;
        if (valueClass.equals(Byte.class)) {
            value = new Byte(number.byteValue());
        } else if (valueClass.equals(Short.class)) {
            value = new Short(number.shortValue());
        } else if (valueClass.equals(Integer.class)) {
            value = new Integer(number.intValue());
        } else if (valueClass.equals(Long.class)) {
            value = new Long(number.longValue());
        } else if (valueClass.equals(Float.class)) {
            value = new Float(number.floatValue());
        } else if (valueClass.equals(Double.class)) {
            value = new Double(number.doubleValue());
        } else if (valueClass.equals(BigInteger.class)) {
            value = BigInteger.valueOf(number.longValue());
        } else if (valueClass.equals(BigDecimal.class)) {
            value = new BigDecimal(Double.toString(number.doubleValue()));
        } else {
            throw new JRException("Unknown number class " + valueClass.getName());
        }
        return value;
    }

    public JRXmlDataSource subDataSource(String selectExpr) throws JRException {
        Document doc = this.subDocument();
        JRXmlDataSource subDataSource = new JRXmlDataSource(doc, selectExpr);
        subDataSource.setLocale(this.locale);
        subDataSource.setDatePattern(this.datePattern);
        subDataSource.setNumberPattern(this.numberPattern);
        subDataSource.setTimeZone(this.timeZone);
        return subDataSource;
    }

    public JRXmlDataSource subDataSource() throws JRException {
        return this.subDataSource(".");
    }

    public Document subDocument() throws JRException {
        if (this.currentNode == null) {
            throw new JRException("No node available. Iterate or rewind the data source.");
        }
        Document doc = JRXmlUtils.createDocument(this.currentNode);
        return doc;
    }

    public JRXmlDataSource dataSource(String selectExpr) throws JRException {
        JRXmlDataSource subDataSource = new JRXmlDataSource(this.document, selectExpr);
        subDataSource.setLocale(this.locale);
        subDataSource.setDatePattern(this.datePattern);
        subDataSource.setNumberPattern(this.numberPattern);
        subDataSource.setTimeZone(this.timeZone);
        return subDataSource;
    }

    public JRXmlDataSource dataSource() throws JRException {
        return this.dataSource(".");
    }

    public String getText(Node node) {
        if (!node.hasChildNodes()) {
            return node.getNodeValue();
        }
        StringBuffer result = new StringBuffer();
        NodeList list = node.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            String value;
            Node subnode = list.item(i);
            if (subnode.getNodeType() == 3) {
                value = subnode.getNodeValue();
                if (value == null) continue;
                result.append(value);
                continue;
            }
            if (subnode.getNodeType() == 4) {
                value = subnode.getNodeValue();
                if (value == null) continue;
                result.append(value);
                continue;
            }
            if (subnode.getNodeType() != 5 || (value = this.getText(subnode)) == null) continue;
            result.append(value);
        }
        return result.toString();
    }

    public static void main(String[] args) throws Exception {
        JRXmlDataSource ds = new JRXmlDataSource(new FileInputStream("northwind.xml"), "/Northwind/Customers");
        JRDesignField field = new JRDesignField();
        field.setDescription("CustomerID");
        field.setValueClass(String.class);
        ds.next();
        String v = (String)ds.getFieldValue(field);
        System.out.println(field.getDescription() + "=" + v);
        JRXmlDataSource subDs = ds.dataSource("/Northwind/Orders");
        JRDesignField field1 = new JRDesignField();
        field1.setDescription("OrderID");
        field1.setValueClass(String.class);
        subDs.next();
        String v1 = (String)subDs.getFieldValue(field1);
        System.out.println(field1.getDescription() + "=" + v1);
    }

    protected LocaleConvertUtilsBean getConvertBean() {
        if (this.convertBean == null) {
            this.convertBean = new LocaleConvertUtilsBean();
            if (this.locale != null) {
                this.convertBean.setDefaultLocale(this.locale);
                this.convertBean.deregister();
            }
            this.convertBean.register((LocaleConverter)new JRDateLocaleConverter(this.timeZone), Date.class, this.locale);
        }
        return this.convertBean;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
        this.convertBean = null;
    }

    public String getDatePattern() {
        return this.datePattern;
    }

    public void setDatePattern(String datePattern) {
        this.datePattern = datePattern;
        this.convertBean = null;
    }

    public String getNumberPattern() {
        return this.numberPattern;
    }

    public void setNumberPattern(String numberPattern) {
        this.numberPattern = numberPattern;
        this.convertBean = null;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
        this.convertBean = null;
    }
}

